/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTableModel;
import com.cognos.crconfig.ResourceIdentifiers;
import com.cognos.crconfig.State;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class MappingBaseModel {
    protected int m_tabCount;
    protected int m_paramTabCount;
    protected emTableModel[] m_tmPageModels;
    protected CnfgTableModel[] m_tmParamPageModels;
    private boolean m_bDirty = false;
    protected static final String XML_ROOT = "localeConfiguration";
    protected static final String XML_PRODUCT_LOCALE_MAP = "productLocaleMap";
    protected static final String XML_CONTENT_LOCALE_MAP = "contentLocaleMap";
    protected static final String XML_SUPPORTED_PRODUCT_LOCALES = "supportedProductLocales";
    protected static final String XML_SUPPORTED_CONTENT_LOCALES = "supportedContentLocales";
    protected static final String XML_SUPPORTED_CURRENCIES = "supportedCurrencies";
    protected static final String XML_SUPPORTED_FONTS = "supportedFonts";
    protected static final String XML_FONTS_MAP = "fontsMap";
    protected static final String XML_ALIAS_ROOTS = "aliasRoots";
    protected static final String XML_LOCALE = "locale";
    protected static final String XML_LOCALE_MAP = "localeMap";
    protected static final String XML_CURRENCY = "currency";
    protected static final String XML_FONT = "font";
    protected static final String XML_FONT_MAP = "fontMap";
    protected static final String XML_ALIAS_ROOT = "aliasRoot";

    public MappingBaseModel() throws DataManagerException {
        this.loadModel();
    }

    protected void setDirtyFlag(boolean bDirty) {
        this.m_bDirty = bDirty;
    }

    protected boolean isDirty() {
        return this.m_bDirty;
    }

    protected abstract void loadModel() throws DataManagerException;

    protected void loadData() throws DataManagerException {
        int i;
        Element rootElement = DataManager.getInstance().getLocaleMapsElement();
        for (i = 0; i < this.m_tabCount; ++i) {
            this.m_tmPageModels[i].load(rootElement);
        }
        for (i = 0; i < this.m_paramTabCount; ++i) {
            this.m_tmParamPageModels[i].load(rootElement);
        }
    }

    protected void cancelParamChanges() {
    }

    protected int getTabCount() {
        return this.m_tabCount;
    }

    protected int getParamTabCount() {
        return this.m_paramTabCount;
    }

    protected abstract class emTableModel
    extends AbstractTableModel {
        protected int m_count;
        protected List<Boolean> m_select = new ArrayList<Boolean>();
        protected List<String> m_key = null;
        protected List<Object> m_value = new ArrayList<Object>();
        protected List<State> m_valid = new ArrayList<State>();
        protected int m_lastErrorRow;
        private String m_tagName;
        private String m_tagEntry;
        protected int COL_SELECT;
        protected int COL_CUSTOM;
        protected int COL_KEY;
        protected int COL_VALUE;
        protected int COL_DESC;
        protected Class m_browser;

        public int getColValue() {
            return this.COL_VALUE;
        }

        public emTableModel(String tagName, String tagEntry) {
            this.m_tagName = tagName;
            this.m_tagEntry = tagEntry;
            this.COL_SELECT = 0;
            this.COL_CUSTOM = 1;
            this.COL_VALUE = 2;
            this.COL_KEY = -1;
            this.COL_DESC = -1;
        }

        @Override
        public int getColumnCount() {
            return 2 + (this.COL_KEY != -1 ? 1 : 0) + (this.COL_DESC != -1 ? 1 : 0) + (this.COL_CUSTOM != -1 ? 1 : 0);
        }

        @Override
        public int getRowCount() {
            return this.m_count;
        }

        private boolean isBrowseEnabled() {
            return this.m_browser != null;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == this.COL_SELECT) {
                return this.m_select.get(row);
            }
            if (col == this.COL_KEY) {
                return this.m_key.get(row);
            }
            if (col == this.COL_VALUE) {
                return this.m_value.get(row);
            }
            if (col == this.COL_CUSTOM) {
                return this.m_valid.get(row);
            }
            return null;
        }

        protected void scanDuplicates(String sValue, List<?> list) {
            boolean validentry = false;
            ArrayList<Integer> dupList = new ArrayList<Integer>();
            for (int i = 0; i < list.size(); ++i) {
                String curValue = list.get(i).toString();
                int errCode = this.m_valid.get(i).getCode();
                if (!curValue.equals(sValue) || errCode != 4 && errCode != 0) continue;
                if (errCode == 0) {
                    validentry = true;
                }
                dupList.add(new Integer(i));
            }
            if (dupList.size() > 0 && !validentry) {
                State state = this.m_valid.get((Integer)dupList.get(0));
                state.setValue(State.OK);
            }
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == this.COL_SELECT) {
                this.m_select.set(row, (Boolean)aValue);
            } else if (col == this.COL_KEY) {
                String sNewVal = (String)aValue;
                String sOldVal = this.m_key.get(row);
                if (sNewVal != null && (!sNewVal.equals(sOldVal) || sNewVal.length() == 0 && sOldVal.length() == 0)) {
                    this.m_key.set(row, sNewVal);
                    this.isRowValid(row);
                    MappingBaseModel.this.setDirtyFlag(true);
                    if (sOldVal.length() > 0) {
                        this.scanDuplicates(sOldVal, this.m_key);
                    }
                }
            } else if (col == this.COL_VALUE) {
                String sNewVal = aValue.toString();
                String sOldVal = this.m_value.get(row).toString();
                if (sNewVal != null && !sNewVal.equals(sOldVal)) {
                    this.m_value.set(row, aValue);
                    this.isRowValid(row);
                    this.fireTableCellUpdated(row, this.COL_DESC);
                    MappingBaseModel.this.setDirtyFlag(true);
                    if (sOldVal.length() > 0 && this.COL_KEY == -1) {
                        this.scanDuplicates(sOldVal, this.m_value);
                    }
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public String getColumnName(int col) {
            if (col == this.COL_KEY) {
                return CnfgResource.getMessage("Label.DialogGlobalConfig.hdrKey");
            }
            if (col == this.COL_DESC) {
                return CnfgResource.getMessage("Label.DialogGlobalConfig.hdrDescription");
            }
            return " ";
        }

        public Class getColumnClass(int col) {
            if (col == this.COL_SELECT) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != this.COL_DESC && col != this.COL_CUSTOM;
        }

        public String getCaption() {
            String[][] captions = new String[][]{{MappingBaseModel.XML_SUPPORTED_PRODUCT_LOCALES, "Label.DialogGlobalConfig.tabSupportedProductLocales"}, {MappingBaseModel.XML_SUPPORTED_CONTENT_LOCALES, "Label.DialogGlobalConfig.tabSupportedContentLocales"}, {MappingBaseModel.XML_PRODUCT_LOCALE_MAP, "Label.DialogGlobalConfig.tabProductLocaleMap"}, {MappingBaseModel.XML_CONTENT_LOCALE_MAP, "Label.DialogGlobalConfig.tabContentLocaleMap"}, {MappingBaseModel.XML_SUPPORTED_CURRENCIES, "Label.DialogGlobalConfig.tabSupportedCurrencies"}, {MappingBaseModel.XML_SUPPORTED_FONTS, "Label.DialogGlobalConfig.tabSupportedFonts"}, {MappingBaseModel.XML_FONTS_MAP, "Label.DialogFontsMapping.tabFontsMap"}, {MappingBaseModel.XML_ALIAS_ROOTS, "Label.DialogAliasRoots.tabAliasRoots"}};
            return CnfgResource.getMessage(ResourceIdentifiers.findID(captions, this.m_tagName));
        }

        public abstract int isRowValid(int var1);

        public boolean isValid() {
            this.m_lastErrorRow = -1;
            for (int i = 0; i < this.m_count; ++i) {
                State state = this.m_valid.get(i);
                if (state.getValue() != State.ERROR) continue;
                this.m_lastErrorRow = i;
                return false;
            }
            return true;
        }

        public String getErrorMessage(int row) {
            State state = this.m_valid.get(row);
            return state.getMessage();
        }

        public void getErrorMessages(List<String> lErrors) {
            for (int i = 0; i < this.m_count; ++i) {
                State state = this.m_valid.get(i);
                if (state.getCode() <= 0) continue;
                lErrors.add(state.getMessage());
            }
        }

        public Integer getErrorCode(int row) {
            State state = this.m_valid.get(row);
            return state.getCode();
        }

        public Object getEmptyValue() {
            return new String();
        }

        public int addEmpty() {
            this.m_select.add(new Boolean(false));
            if (this.m_key != null) {
                this.m_key.add(new String());
            }
            this.m_value.add(this.getEmptyValue());
            State state = new State();
            this.m_valid.add(state);
            int index = this.m_count++;
            this.fireTableRowsInserted(index, index);
            return index;
        }

        public boolean isSelected() {
            for (int i = 0; i < this.m_count; ++i) {
                if (!this.m_select.get(i).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public boolean removeSelected() {
            for (int i = this.m_count - 1; i >= 0; --i) {
                if (!this.m_select.get(i).booleanValue()) continue;
                this.m_select.remove(i);
                String sOldVal = null;
                if (this.m_key != null) {
                    sOldVal = this.m_key.get(i).toString();
                    this.m_key.remove(i);
                } else {
                    sOldVal = this.m_value.get(i).toString();
                }
                this.m_value.remove(i);
                this.m_valid.remove(i);
                --this.m_count;
                if (sOldVal != null && sOldVal.length() > 0) {
                    this.scanDuplicates(sOldVal, this.m_key != null ? this.m_key : this.m_value);
                }
                this.fireTableRowsDeleted(i, i);
            }
            return true;
        }

        public int getLastErrorRow() {
            return this.m_lastErrorRow;
        }

        protected int add(String key, String value) {
            this.m_select.add(new Boolean(false));
            if (this.m_key != null) {
                this.m_key.add(key);
            }
            this.m_value.add(value);
            int iRes = this.isRowValid(this.m_key.lastIndexOf(key));
            if (iRes > 0) {
                MappingBaseModel.this.setDirtyFlag(true);
            }
            this.fireTableRowsInserted(this.m_count, this.m_count);
            return this.m_count++;
        }

        protected int add(String value) {
            this.m_select.add(new Boolean(false));
            this.m_value.add(value);
            int iRes = this.isRowValid(this.m_value.lastIndexOf(value));
            if (iRes > 0) {
                MappingBaseModel.this.setDirtyFlag(true);
            }
            this.fireTableRowsInserted(this.m_count, this.m_count);
            return this.m_count++;
        }

        protected void load(Element parentElement) {
            Element tagElement = parentElement.element(this.m_tagName);
            if (null != tagElement) {
                for (Element entry : tagElement.elements(this.m_tagEntry)) {
                    if (this.m_key != null) {
                        String value = entry.attributeValue("value");
                        String key = entry.attributeValue("key");
                        this.add(key, value);
                        continue;
                    }
                    String id = entry.attributeValue("id");
                    this.add(id);
                }
            }
        }

        protected void save(Element parentElement) {
            Element tagElement = parentElement.element(this.m_tagName);
            if (null != tagElement) {
                parentElement.remove(tagElement);
            }
            tagElement = DocumentHelper.createElement((String)this.m_tagName);
            parentElement.add(tagElement);
            for (int i = 0; i < this.m_count; ++i) {
                Element newEntry = DocumentHelper.createElement((String)this.m_tagEntry);
                if (this.m_key != null) {
                    newEntry.addAttribute("key", this.m_key.get(i).toString());
                    newEntry.addAttribute("value", this.m_value.get(i).toString());
                } else {
                    newEntry.addAttribute("id", this.m_value.get(i).toString());
                }
                tagElement.add(newEntry);
            }
        }
    }
}

