/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgMenu;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgSwingAction;
import com.cognos.crconfig.CnfgTable;
import com.cognos.crconfig.CnfgTableModel;
import com.cognos.crconfig.CnfgTaskFeedback;
import com.cognos.crconfig.CnfgTree;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgAction;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgActionTest;
import com.cognos.crconfig.data.CnfgNodeDeletedEvent;
import com.cognos.crconfig.data.CnfgNodeDeletedListener;
import com.cognos.crconfig.data.CnfgNodeInsertedEvent;
import com.cognos.crconfig.data.CnfgNodeInsertedListener;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;
import com.cognos.crconfig.test.TestTaskManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class MenuToolbarLogicListener
implements ListSelectionListener,
TreeSelectionListener,
FocusListener,
CnfgNodeInsertedListener,
CnfgNodeDeletedListener {
    private CRConfigFrame m_parent;
    private CnfgTable m_table;
    private CnfgTableModel m_tableModel;
    Folder m_currentFolder = null;

    public MenuToolbarLogicListener(CRConfigFrame parent) {
        this.m_parent = parent;
        this.m_table = parent.cCnfgTable;
        this.m_tableModel = parent.cCnfgTableModel;
    }

    public MenuToolbarLogicListener(CRConfigFrame parent, CnfgTable table, CnfgTableModel tableModel) {
        this.m_parent = parent;
        this.m_table = table;
        this.m_tableModel = tableModel;
    }

    @Override
    public synchronized void valueChanged(TreeSelectionEvent e) {
        if (this.m_parent.cCnfgTree.getSelectionPath() != null) {
            DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)this.m_parent.cCnfgTree.getSelectionPath().getLastPathComponent();
            Folder f = (Folder)cNode.getUserObject();
            this.processLogic(f);
        }
    }

    private void processLogic(Folder f) {
        if (this.m_currentFolder != f) {
            if (f.getParent() == null) {
                this.setRootOptions();
            } else if (f.isInstanceFolder()) {
                this.setInstanceFolderOptions(f);
            } else {
                this.setFolderOptions(f);
            }
            this.m_currentFolder = f;
        } else {
            this.setActionTestOption(f, false);
            if (f.getParent() == null) {
                this.resetRootOptions();
            } else if (f.isInstanceFolder()) {
                boolean bIsServiceFolder = this.setUserDefinedActions(f, false);
                boolean hasResetableToDefault = f.hasResetableToDefault();
                this.resetInstanceFolderOptions(!bIsServiceFolder, hasResetableToDefault);
            } else {
                boolean bIsServiceFolder = this.setUserDefinedActions(f, false);
                boolean hasResetableToDefault = f.hasResetableToDefault();
                this.resetFolderOptions(!bIsServiceFolder, hasResetableToDefault);
            }
        }
    }

    private void resetRootOptions() {
        this.m_parent.m_actionFileSave.setEnabled(true);
        this.m_parent.m_actionEditRename.setEnabled(false);
        this.m_parent.m_actionEditDelete.setEnabled(false);
        this.m_parent.m_actionEditResetToDefault.setEnabled(true);
        this.m_parent.updateRunningActions();
    }

    private void resetInstanceFolderOptions(boolean bUpdateRunningOptions, boolean hasResetableToDefault) {
        this.m_parent.m_actionFileSave.setEnabled(true);
        this.m_parent.m_actionEditRename.setEnabled(true);
        this.m_parent.m_actionEditDelete.setEnabled(true);
        this.m_parent.m_actionEditResetToDefault.setEnabled(hasResetableToDefault);
        if (bUpdateRunningOptions) {
            this.m_parent.updateRunningActions();
        }
    }

    private void resetFolderOptions(boolean bUpdateRunningOptions, boolean hasResetableToDefault) {
        this.m_parent.m_actionFileSave.setEnabled(true);
        this.m_parent.m_actionEditRename.setEnabled(false);
        this.m_parent.m_actionEditDelete.setEnabled(false);
        this.m_parent.m_actionEditResetToDefault.setEnabled(hasResetableToDefault);
        if (bUpdateRunningOptions) {
            this.m_parent.updateRunningActions();
        }
    }

    private void setRootOptions() {
        this.m_parent.treePopupMenu.removeAll();
        if (DataManager.getInstance().isBTSVInstalled() || ServiceManager.hasOtherServicesInstalled()) {
            CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.actions.start.no.mnemonic"), false, this.m_parent.m_actionActionsStart);
            CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.actions.stop.no.mnemonic"), false, this.m_parent.m_actionActionsStop);
            CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.actions.restart.no.mnemonic"), false, this.m_parent.m_actionActionsRestart);
            this.m_parent.treePopupMenu.addSeparator();
        }
        CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.edit.resetToDefault.no.mnemonic"), false, this.m_parent.m_actionEditResetToDefault);
        Folder f = DataManager.getInstance().findFolder("root", false);
        this.setActionTestOption(f, true);
        this.resetRootOptions();
    }

    private void setInstanceFolderOptions(Folder f) {
        boolean isServiceFolder;
        this.m_parent.treePopupMenu.removeAll();
        boolean hasResetableToDefault = f.hasResetableToDefault();
        if (hasResetableToDefault) {
            CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.edit.resetToDefault.no.mnemonic"), false, this.m_parent.m_actionEditResetToDefault);
            this.m_parent.treePopupMenu.addSeparator();
        }
        if (!f.getAvailableTemplates().isEmpty()) {
            this.m_parent.treePopupMenu.add(this.m_parent.m_menuEditNew_popup);
        }
        CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.edit.rename.no.mnemonic"), false, this.m_parent.m_actionEditRename);
        CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.edit.delete.no.mnemonic"), false, this.m_parent.m_actionEditDelete);
        this.setActionTestOption(f, true);
        if (f.getActions().size() > 0) {
            this.m_parent.treePopupMenu.addSeparator();
        }
        this.resetInstanceFolderOptions(!(isServiceFolder = this.setUserDefinedActions(f, true)), hasResetableToDefault);
    }

    private void setFolderOptions(Folder f) {
        boolean bIsServiceFolder;
        boolean hasResetableToDefault = f.hasResetableToDefault();
        if (f.getOpaque()) {
            this.m_parent.treePopupMenu.removeAll();
            if (hasResetableToDefault && !f.getName().equals("CFS")) {
                CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.edit.resetToDefault.no.mnemonic"), false, this.m_parent.m_actionEditResetToDefault);
            }
            if (!f.getAvailableTemplates().isEmpty()) {
                if (hasResetableToDefault) {
                    this.m_parent.treePopupMenu.addSeparator();
                }
                this.m_parent.treePopupMenu.add(this.m_parent.m_menuEditNew_popup);
            }
            if (f.getName().equals("CFS")) {
                CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Label.DialogConfigServersParameter.Button.Retrieve"), true, this.m_parent.m_actionRetrieve);
                CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.actions.verify"), true, this.m_parent.m_actionActionsCheckFlipper);
            }
        } else {
            this.m_parent.treePopupMenu.removeAll();
            if (hasResetableToDefault) {
                CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Menu.edit.resetToDefault.no.mnemonic"), false, this.m_parent.m_actionEditResetToDefault);
            }
        }
        this.setActionTestOption(f, true);
        if (f.getActions().size() > 0) {
            this.m_parent.treePopupMenu.addSeparator();
        }
        this.resetFolderOptions(!(bIsServiceFolder = this.setUserDefinedActions(f, true)), hasResetableToDefault);
    }

    private boolean setUserDefinedActions(Folder f, boolean bAddMenuItem) {
        boolean bIsServiceFolder = f instanceof ServiceFolder;
        ArrayList<CnfgActionOld> alist = f.getActions();
        for (int i = 0; i < alist.size(); ++i) {
            final CnfgActionOld action = (CnfgActionOld)alist.get(i);
            if (action.isSilent()) continue;
            if (bIsServiceFolder) {
                String sLabel;
                boolean isEnabled;
                if (action.getName().equalsIgnoreCase("start")) {
                    boolean bl = isEnabled = !((ServiceFolder)f).isRunning();
                    if (bAddMenuItem) {
                        sLabel = "";
                        sLabel = action.getType().equalsIgnoreCase("cnfg") ? CnfgResource.getMessage("Menu.actions.start.no.mnemonic") : action.getLabel();
                        CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, sLabel, false, this.m_parent.m_actionActionsStart);
                    }
                    this.m_parent.m_actionActionsStart.setEnabled(isEnabled);
                    continue;
                }
                if (action.getName().equalsIgnoreCase("stop")) {
                    isEnabled = ((ServiceFolder)f).isRunning();
                    if (bAddMenuItem) {
                        sLabel = "";
                        sLabel = action.getType().equalsIgnoreCase("cnfg") ? CnfgResource.getMessage("Menu.actions.stop.no.mnemonic") : action.getLabel();
                        CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, sLabel, false, this.m_parent.m_actionActionsStop);
                    }
                    this.m_parent.m_actionActionsStop.setEnabled(isEnabled);
                    continue;
                }
                if (action.getName().equalsIgnoreCase("restart")) {
                    isEnabled = ((ServiceFolder)f).isRunning();
                    if (bAddMenuItem) {
                        sLabel = "";
                        sLabel = action.getType().equalsIgnoreCase("cnfg") ? CnfgResource.getMessage("Menu.actions.restart.no.mnemonic") : action.getLabel();
                        CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, sLabel, false, this.m_parent.m_actionActionsRestart);
                    }
                    this.m_parent.m_actionActionsRestart.setEnabled(isEnabled);
                    continue;
                }
            }
            if (!bAddMenuItem || !action.getVisibility()) continue;
            CnfgSwingAction swingAction = new CnfgSwingAction("action"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String sActionName = action.getName().toLowerCase();
                    if (sActionName.endsWith("wizard")) {
                        CnfgWizard.getInstance().action_Wizard(sActionName);
                    } else {
                        MenuToolbarLogicListener.this.m_parent.runAction(new CnfgAction(){

                            @Override
                            public ICnfgTask[] getTasks() {
                                return action.getTasks(null, new CnfgTaskFeedback());
                            }
                        });
                    }
                }
            };
            CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, action.getLabel(), true, swingAction);
        }
        return bIsServiceFolder;
    }

    private List<CnfgActionTest> refineTestActionList(List<CnfgActionTest> list) {
        ArrayList<CnfgActionTest> newList = new ArrayList<CnfgActionTest>();
        for (CnfgActionTest action : list) {
            if (!TestTaskManager.checkActionPrerequisites(action)) continue;
            newList.add(action);
        }
        return newList;
    }

    private void setActionTestOption(final Folder f, boolean bAdd) {
        List<CnfgActionTest> list = f.getTestActions();
        if (0 < list.size()) {
            List<CnfgActionTest> newList = this.refineTestActionList(list);
            if (bAdd) {
                CnfgSwingAction swingAction = new CnfgSwingAction("XXX"){
                    private static final long serialVersionUID = -1916357801197978044L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MenuToolbarLogicListener.this.m_parent.runTestAction(f);
                    }
                };
                if (!list.isEmpty()) {
                    if (newList.isEmpty()) {
                        CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Message.actiontest.actionlabel"), false, swingAction);
                    } else {
                        CnfgMenu.addMenuItem(this.m_parent.treePopupMenu, null, CnfgResource.getMessage("Message.actiontest.actionlabel"), true, swingAction);
                    }
                }
            }
            if (!newList.isEmpty()) {
                this.m_parent.m_actionActionsTest.setEnabled(true);
            } else {
                this.m_parent.m_actionActionsTest.setEnabled(false);
            }
        } else {
            this.m_parent.m_actionActionsTest.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Parameter parm;
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        int idx = lsm.getMinSelectionIndex();
        if (idx != -1 && (parm = this.m_tableModel.getItem(idx)) != null) {
            this.processLogic(parm);
        }
    }

    private void processLogic(Parameter parm) {
        this.m_parent.m_actionFileSave.setEnabled(true);
        this.m_parent.m_actionEditRename.setEnabled(false);
        this.m_parent.m_actionEditDelete.setEnabled(false);
        this.m_parent.m_actionActionsTest.setEnabled(false);
        if (parm.hasDefault()) {
            if (parm.isDefault()) {
                this.m_parent.m_actionEditResetToDefault.setEnabled(false);
            } else {
                this.m_parent.m_actionEditResetToDefault.setEnabled(true);
            }
        } else {
            this.m_parent.m_actionEditResetToDefault.setEnabled(false);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object obj = focusEvent.getSource();
        if (obj != null) {
            Parameter parm;
            int row;
            if (obj.getClass() == CnfgTree.class) {
                if (this.m_parent.cCnfgTree.getSelectionPath() != null) {
                    DefaultMutableTreeNode cNode = (DefaultMutableTreeNode)this.m_parent.cCnfgTree.getSelectionPath().getLastPathComponent();
                    Folder f = (Folder)cNode.getUserObject();
                    this.processLogic(f);
                }
            } else if (obj.getClass() == CnfgTable.class && (row = this.m_table.getSelectionModel().getMinSelectionIndex()) != -1 && (parm = this.m_tableModel.getItem(row)) != null) {
                this.processLogic(parm);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void nodeInserted(CnfgNodeInsertedEvent e) {
    }

    @Override
    public void nodeDeleted(CnfgNodeDeletedEvent e) {
    }
}

