/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.CnfgNodeRenamedEvent;
import com.cognos.crconfig.data.CnfgNodeRenamedListener;
import com.cognos.crconfig.data.CnfgSelectionEvent;
import com.cognos.crconfig.data.CnfgSelectionListener;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.TemplatedParameter;
import javax.swing.JLabel;

public class NavigationLabel
extends JLabel
implements CnfgSelectionListener,
CnfgNodeRenamedListener {
    public NavigationLabel(String szLabel) {
        super(szLabel);
    }

    public NavigationLabel(String szLabel, int nAlign) {
        super(szLabel, nAlign);
    }

    @Override
    public void selectionChanged(CnfgSelectionEvent e) {
        this.setText((Folder)e.getSource());
    }

    @Override
    public void nodeRenamed(CnfgNodeRenamedEvent e) {
        this.setText((Folder)e.getSource());
    }

    private void setText(Folder folder) {
        Object[] args;
        String sTypeProperty;
        String sTPName = null;
        if (folder.getParent() == null) {
            sTypeProperty = CnfgResource.getMessage("Label.navigationComputer.Properties");
        } else if (folder.isInstanceFolder()) {
            sTypeProperty = CnfgResource.getMessage("Label.navigationResource.Properties");
            TemplatedParameter tp = folder.getTemplatedParameter();
            if (tp != null) {
                sTPName = tp.getLabel();
            }
        } else {
            sTypeProperty = folder.getOpaque() ? CnfgResource.getMessage("Label.navigationComponent.Properties") : CnfgResource.getMessage("Label.navigationGroup.Properties");
        }
        if (sTPName == null) {
            args = new Object[]{folder.getLabel(), sTypeProperty};
            this.setText(CnfgResource.getMessage("Label.navigationPrefix", args));
        } else {
            args = new Object[]{folder.getLabel(), sTPName, sTypeProperty};
            this.setText(CnfgResource.getMessage("Label.navigationPrefixWithType", args));
        }
    }
}

