/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class RenderHeader
extends JButton
implements TableCellRenderer {
    private int m_iField;
    private static final EmptyBorder m_lineBorder = new EmptyBorder(new Insets(2, 3, 1, 3)){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(Color.white);
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 1);
            g.setColor(Color.gray);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        }
    };

    public RenderHeader(int iField) {
        super("");
        this.m_iField = iField;
        this.setBorder(m_lineBorder);
        this.setMargin(new Insets(0, 0, 0, 0));
        if (this.m_iField == 4) {
            this.setHorizontalTextPosition(4);
        } else {
            this.setHorizontalTextPosition(2);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object value, boolean hasFocus, boolean isSelected, int iRowIndex, int iColumnIndex) {
        String szColumnName = "";
        switch (iColumnIndex) {
            case 1: {
                szColumnName = CnfgResource.getMessage("Label.property");
                break;
            }
            case 0: 
            case 2: {
                szColumnName = "";
                break;
            }
            case 3: {
                szColumnName = CnfgResource.getMessage("Label.value");
            }
        }
        this.setHorizontalAlignment(this.m_iField);
        this.setText(szColumnName);
        if (iColumnIndex == 1 || iColumnIndex == 3) {
            FontMetrics fm = CRConfigFrame.getInstance().getGraphics().getFontMetrics(this.getFont());
            TableColumn tc = jTable.getColumnModel().getColumn(iColumnIndex);
            int stringWD = SwingUtilities.computeStringWidth(fm, szColumnName);
            if (stringWD >= tc.getWidth() - 2) {
                this.setToolTipText(szColumnName);
            } else {
                this.setToolTipText(null);
            }
        }
        return this;
    }
}

