/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgTree;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.Folder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class RenderTreeNode
extends JLabel
implements TreeCellRenderer {
    protected static Map<String, Icon> m_treeNodeIcons = new HashMap<String, Icon>();

    public RenderTreeNode() {
        if (m_treeNodeIcons.size() == 0) {
            m_treeNodeIcons.put("root", CnfgImageLoader.loadIcon("icon_computer.gif"));
            m_treeNodeIcons.put("root_start", CnfgImageLoader.loadIcon("icon_computer_start.gif"));
            m_treeNodeIcons.put("root_stop", CnfgImageLoader.loadIcon("icon_computer_stop.gif"));
            m_treeNodeIcons.put("root_mixed", CnfgImageLoader.loadIcon("icon_computer_mixed.gif"));
            m_treeNodeIcons.put("group", CnfgImageLoader.loadIcon("icon_group.gif"));
            m_treeNodeIcons.put("component", CnfgImageLoader.loadIcon("icon_component.gif"));
            m_treeNodeIcons.put("resource", CnfgImageLoader.loadIcon("icon_resource.gif"));
            m_treeNodeIcons.put("resource_start", CnfgImageLoader.loadIcon("icon_resource_start.gif"));
            m_treeNodeIcons.put("resource_stop", CnfgImageLoader.loadIcon("icon_resource_stop.gif"));
            m_treeNodeIcons.put("resource_mixed", CnfgImageLoader.loadIcon("icon_resource_mixed.gif"));
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree cTree, Object cValue, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)cValue;
        Folder folder = (Folder)node.getUserObject();
        this.setText(folder.getLabel());
        if (CnfgTree.m_hoverFolder != null && CnfgTree.m_hoverFolder == folder) {
            if (bSelected) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(SystemColor.inactiveCaption);
                this.setForeground(SystemColor.inactiveCaptionText);
            }
        } else if (bSelected) {
            if (bHasFocus) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(SystemColor.inactiveCaption);
                this.setForeground(SystemColor.inactiveCaptionText);
            }
        } else if (CnfgUtils.isWindowsPlatform()) {
            this.setBackground(SystemColor.window);
            this.setForeground(SystemColor.windowText);
        } else {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        }
        Icon tIcon = m_treeNodeIcons.get(folder.getIcon());
        if (tIcon != null) {
            this.setIcon(tIcon);
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Icon currentI = this.getIcon();
        Color bColor = this.getBackground();
        g.setColor(bColor);
        int iOffset = currentI.getIconWidth() + 2;
        g.fillRect(iOffset, 0, this.getWidth() - iOffset, this.getHeight());
        super.paint(g);
    }
}

