/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.Group;
import com.cognos.crconfig.data.Parameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class RendererParameterCustomize
extends JLabel
implements TableCellRenderer {
    protected boolean m_bIsSelected;
    protected boolean m_bIsGroup;
    private static Icon[] m_images;
    protected static Color m_borderColor;
    private final EmptyBorder m_lineBorder = new EmptyBorder(new Insets(0, 3, 0, 0)){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(m_borderColor);
            if (!RendererParameterCustomize.this.m_bIsGroup) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            }
            if (!RendererParameterCustomize.this.m_bIsSelected) {
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
        }
    };

    public RendererParameterCustomize(Color borderColor) {
        if (m_images == null) {
            m_images = new Icon[4];
            RendererParameterCustomize.m_images[0] = CnfgImageLoader.loadIcon("mnu_null.gif");
            RendererParameterCustomize.m_images[1] = CnfgImageLoader.loadIcon("parameter_customized.gif");
            RendererParameterCustomize.m_images[2] = CnfgImageLoader.loadIcon("parameter_error.gif");
            RendererParameterCustomize.m_images[3] = CnfgImageLoader.loadIcon("parameter_warning.gif");
        }
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(1);
        this.commonInit(borderColor);
    }

    protected void commonInit(Color borderColor) {
        m_borderColor = borderColor;
        this.setBorder(this.m_lineBorder);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.m_bIsSelected = isSelected;
        if (value == null) {
            return this;
        }
        Parameter p = (Parameter)value;
        boolean bl = this.m_bIsGroup = p.getClass() == Group.class;
        if (!p.isReadOnly()) {
            if (p.isBadValue()) {
                this.setIcon(m_images[2]);
            } else if (p.hasWarnings()) {
                this.setIcon(m_images[3]);
            } else if (p.hasDefault()) {
                if (p.isDefault()) {
                    this.setIcon(m_images[0]);
                } else {
                    this.setIcon(m_images[1]);
                }
            } else {
                this.setIcon(m_images[0]);
            }
        }
        if (this.m_bIsSelected) {
            if (table.hasFocus()) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(SystemColor.inactiveCaption);
                this.setForeground(SystemColor.inactiveCaptionText);
            }
        } else if (CnfgUtils.isWindowsPlatform()) {
            this.setBackground(SystemColor.window);
            this.setForeground(SystemColor.windowText);
        } else {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        }
        return this;
    }

    static {
        m_borderColor = Color.black;
    }
}

