/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgImageLoader;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.Group;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.TemplatedParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RendererParameterLabel
extends JLabel
implements TableCellRenderer {
    protected static Color m_borderColor = Color.black;
    protected boolean m_bIsSelected = false;
    protected boolean m_bIsGroup = false;
    private static Icon[] m_images;
    private int m_iNameColumn;
    private final EmptyBorder m_lineBorder = new EmptyBorder(new Insets(0, 3, 1, 0)){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(m_borderColor);
            if (!RendererParameterLabel.this.m_bIsGroup) {
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            }
            if (!RendererParameterLabel.this.m_bIsSelected) {
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
        }
    };

    public RendererParameterLabel(int iAlignment, Color borderColor, int iNameCol) {
        this.m_iNameColumn = iNameCol;
        this.commonInit(iAlignment, borderColor);
    }

    public RendererParameterLabel(int iAlignment, Color borderColor, String text) {
        super(text);
        this.commonInit(iAlignment, borderColor);
    }

    protected void commonInit(int iAlignment, Color borderColor) {
        m_borderColor = borderColor;
        this.setBorder(this.m_lineBorder);
        this.setHorizontalAlignment(iAlignment);
        this.setOpaque(true);
        if (m_images == null) {
            m_images = new Icon[1];
            RendererParameterLabel.m_images[0] = CnfgImageLoader.loadIcon("parameter_mandatory.gif");
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.m_bIsSelected = isSelected;
        if (value == null) {
            return this;
        }
        String str = "";
        if (Parameter.class.isInstance(value)) {
            Parameter p = (Parameter)value;
            if (column == this.m_iNameColumn) {
                if (p.getClass() == Group.class) {
                    this.setFont(table.getFont().deriveFont(1));
                }
                str = value.getClass() == TemplatedParameter.class ? ((TemplatedParameter)value).getFormattedLabel() : p.getLabel();
            } else if (column == 0 && p.isMandatory()) {
                this.setIcon(m_images[0]);
            }
            this.m_bIsGroup = p.getClass() == Group.class;
        } else {
            str = value.toString();
        }
        if (str != null && column == this.m_iNameColumn) {
            this.setText(str);
            TableColumn tc = table.getColumnModel().getColumn(column);
            FontMetrics fm = CRConfigFrame.getInstance().getGraphics().getFontMetrics(this.getFont());
            int stringWD = SwingUtilities.computeStringWidth(fm, str);
            if (stringWD >= tc.getWidth() - 2) {
                this.setToolTipText(str);
            } else {
                this.setToolTipText(null);
            }
        } else {
            this.setToolTipText(null);
        }
        if (this.m_bIsSelected) {
            if (table.hasFocus()) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(SystemColor.inactiveCaption);
                this.setForeground(SystemColor.inactiveCaptionText);
            }
        } else if (CnfgUtils.isWindowsPlatform()) {
            this.setBackground(SystemColor.window);
            this.setForeground(SystemColor.windowText);
        } else {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        }
        return this;
    }
}

