/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.Group;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.SystemPasswordParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class RendererParameterValue
extends JLabel
implements TableCellRenderer {
    protected boolean m_bIsSelected = false;
    protected boolean m_bIsGroup = false;
    protected static Color m_borderColor = Color.black;
    protected static Color m_readOnlyBColor = new Color(227, 227, 227);
    protected static Color m_readOnlyFColor = Color.black;
    private final EmptyBorder m_lineBorder = new EmptyBorder(new Insets(0, 3, 1, 0)){

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(m_borderColor);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            if (!RendererParameterValue.this.m_bIsSelected) {
                g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            }
        }
    };

    public RendererParameterValue(int iAlignment, Color borderColor) {
        this.commonInit(iAlignment, borderColor);
    }

    public RendererParameterValue(int iAlignment, Color borderColor, String text) {
        super(text);
        this.commonInit(iAlignment, borderColor);
    }

    protected void commonInit(int iAlignment, Color borderColor) {
        m_borderColor = borderColor;
        this.setBorder(this.m_lineBorder);
        this.setHorizontalAlignment(iAlignment);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.m_bIsSelected = isSelected;
        if (value == null) {
            return this;
        }
        Parameter p = (Parameter)value;
        if (p.isEncrypted() || p.getClass() == CredentialParameter.class || p.getClass() == SystemPasswordParameter.class) {
            this.setText("***************");
        } else {
            String str = p.getDisplayValue();
            this.setText(str);
            if (str != null) {
                TableColumn tc = table.getColumnModel().getColumn(column);
                FontMetrics fm = CRConfigFrame.getInstance().getGraphics().getFontMetrics(this.getFont());
                int stringWD = SwingUtilities.computeStringWidth(fm, str);
                if (stringWD >= tc.getWidth() - 2) {
                    this.setToolTipText(p.getDisplayValue());
                } else {
                    this.setToolTipText(null);
                }
            } else {
                this.setToolTipText(null);
            }
        }
        boolean bl = this.m_bIsGroup = p.getClass() == Group.class;
        if (!p.isReadOnly()) {
            if (this.m_bIsSelected) {
                if (table.hasFocus()) {
                    this.setBackground(SystemColor.textHighlight);
                    this.setForeground(SystemColor.textHighlightText);
                } else {
                    this.setBackground(SystemColor.inactiveCaption);
                    this.setForeground(SystemColor.inactiveCaptionText);
                }
            } else if (CnfgUtils.isWindowsPlatform()) {
                this.setBackground(SystemColor.window);
                this.setForeground(SystemColor.windowText);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
        } else if (this.m_bIsSelected) {
            if (table.hasFocus()) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(SystemColor.inactiveCaption);
                this.setForeground(SystemColor.inactiveCaptionText);
            }
        } else if (!this.m_bIsGroup) {
            if (CnfgUtils.isHighContrastWin()) {
                this.setBackground(SystemColor.window);
                this.setForeground(SystemColor.windowText);
            } else {
                this.setBackground(m_readOnlyBColor);
                this.setForeground(m_readOnlyFColor);
            }
        } else if (CnfgUtils.isWindowsPlatform()) {
            this.setBackground(SystemColor.window);
            this.setForeground(SystemColor.windowText);
        } else {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        }
        return this;
    }
}

