/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgTable;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;

class TablePopupListener
implements MouseListener {
    private JPopupMenu m_popup;
    private Container m_parent;
    private CnfgTable m_table;
    private boolean m_isPopup;

    public TablePopupListener(JPopupMenu popup, CRConfigFrame parent, CnfgTable table) {
        this.m_popup = popup;
        this.m_parent = parent;
        this.m_table = table;
    }

    public TablePopupListener(JPopupMenu popup, Dialog parent, CnfgTable table) {
        this.m_popup = popup;
        this.m_parent = parent;
        this.m_table = table;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.m_isPopup = e.isPopupTrigger();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || this.m_isPopup) {
            this.m_table.requestFocus();
            int row = this.m_table.rowAtPoint(e.getPoint());
            if (row != -1) {
                this.m_table.getSelectionModel().setSelectionInterval(row, row);
                Point p1 = this.m_parent.getLocationOnScreen();
                Point p2 = this.m_table.getLocationOnScreen();
                this.m_popup.show(this.m_parent, p2.x - p1.x + e.getX(), p2.y - p1.y + e.getY());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

