/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgTree;
import com.cognos.crconfig.data.Folder;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class TreePopupListener
implements MouseListener,
MouseMotionListener,
KeyListener {
    private JPopupMenu m_popup;
    private CRConfigFrame m_parent;
    private boolean m_isPopup;

    public TreePopupListener(JPopupMenu popup, CRConfigFrame parent) {
        this.m_popup = popup;
        this.m_parent = parent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o.getClass() == CnfgTree.class) {
            CnfgTree tree = (CnfgTree)o;
            tree.grabFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        CnfgTree tree;
        TreePath path;
        this.m_isPopup = e.isPopupTrigger();
        Object o = e.getSource();
        if (o.getClass() == CnfgTree.class && (path = (tree = (CnfgTree)o).getPathForLocation(e.getX(), e.getY())) != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            ((DefaultTreeModel)tree.getModel()).nodeChanged(node);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        CnfgTree tree;
        TreePath path;
        Object o;
        if ((e.isPopupTrigger() || this.m_isPopup) && (o = e.getSource()).getClass() == CnfgTree.class && (path = (tree = (CnfgTree)o).getPathForLocation(e.getX(), e.getY())) != null) {
            if (!tree.hasFocus()) {
                tree.grabFocus();
            }
            tree.setSelectionPath(path);
            Point p1 = this.m_parent.getLocationOnScreen();
            Point p2 = this.m_parent.cCnfgTree.getLocationOnScreen();
            this.m_popup.show(this.m_parent, p2.x - p1.x + e.getX(), p2.y - p1.y + e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (CnfgTree.m_hoverFolder != null) {
            Object o = e.getSource();
            CnfgTree.m_hoverFolder = null;
            CnfgTree tree = (CnfgTree)o;
            tree.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Object o = e.getSource();
        if (o.getClass() == CnfgTree.class) {
            CnfgTree tree = (CnfgTree)o;
            TreePath path = tree.getPathForLocation(e.getX(), e.getY());
            if (path != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Folder folder = (Folder)node.getUserObject();
                if (CnfgTree.m_hoverFolder == null || CnfgTree.m_hoverFolder != folder) {
                    CnfgTree.m_hoverFolder = folder;
                    tree.repaint();
                }
            } else if (CnfgTree.m_hoverFolder != null) {
                CnfgTree.m_hoverFolder = null;
                tree.repaint();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object o;
        if (e.getKeyCode() == 121 && (e.getModifiers() & 1) != 0 && (o = e.getSource()).getClass() == CnfgTree.class) {
            e.consume();
            CnfgTree tree = (CnfgTree)o;
            int rowHeight = tree.getRowHeight();
            int curRow = tree.getRowForPath(tree.m_selectedTreePath);
            Rectangle r_node = tree.getPathBounds(tree.m_selectedTreePath);
            Point p1 = tree.getLocationOnScreen();
            Point p2 = this.m_parent.getLocationOnScreen();
            int x = p1.x - p1.y + r_node.width;
            int y = p1.y - p2.y + rowHeight * curRow;
            this.m_popup.show(this.m_parent, x, y);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

