/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;

public class UnicodeReader
extends Reader {
    private InputStream m_inputStream;
    private String m_sDefaultEnc;
    private InputStreamReader m_internalInputReader;
    private static final int BOM_SIZE = 4;

    UnicodeReader(InputStream inputStream, String sDefaultEnc) {
        this.m_inputStream = inputStream;
        this.m_sDefaultEnc = sDefaultEnc;
    }

    @Override
    public int read(char[] arg0, int arg1, int arg2) throws IOException {
        this.init();
        return this.m_internalInputReader.read(arg0, arg1, arg2);
    }

    @Override
    public void close() throws IOException {
        this.init();
        this.m_internalInputReader.close();
    }

    private void init() throws IOException {
        int unread;
        String sEncoding;
        if (this.m_internalInputReader != null) {
            return;
        }
        PushbackInputStream newInputStream = new PushbackInputStream(this.m_inputStream, 4);
        byte[] bom = new byte[4];
        int readBytes = newInputStream.read(bom, 0, bom.length);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            sEncoding = "UTF-8";
            unread = readBytes - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            sEncoding = "UTF-16BE";
            unread = readBytes - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            sEncoding = "UTF-16LE";
            unread = readBytes - 2;
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            sEncoding = "UTF-32BE";
            unread = readBytes - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            sEncoding = "UTF-32LE";
            unread = readBytes - 4;
        } else {
            sEncoding = this.m_sDefaultEnc;
            unread = readBytes;
        }
        if (unread > 0) {
            newInputStream.unread(bom, readBytes - unread, unread);
        }
        this.m_internalInputReader = sEncoding == null ? new InputStreamReader(newInputStream) : new InputStreamReader((InputStream)newInputStream, sEncoding);
    }
}

