/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.DialogMessage;
import java.io.File;
import java.io.IOException;

public class WebBrowser {
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public static void displayURL(String sURL) {
        block19: {
            boolean windows = CnfgUtils.isWindowsPlatform();
            String sBrowserPath = (String)CnfgPreferences.getInstance().getProperty("BrowserPath", String.class);
            if (sBrowserPath != null) {
                char badSep = File.separatorChar == '/' ? (char)'\\' : '/';
                sBrowserPath = sBrowserPath.replace(badSep, File.separatorChar);
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Browser path is " + sBrowserPath);
            }
            String cmd = null;
            try {
                if (windows) {
                    if (sBrowserPath == null) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("Using system defined browser.");
                        }
                        cmd = "rundll32 url.dll,FileProtocolHandler " + sURL;
                    } else {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("User defined the browser path.");
                        }
                        String szDelimit = "\"";
                        cmd = sBrowserPath + " " + szDelimit + sURL + szDelimit;
                    }
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("The command is " + cmd);
                    }
                    Runtime.getRuntime().exec(cmd);
                    break block19;
                }
                if (sBrowserPath == null) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("Using system defined browser. Try to use an already opened browser.");
                    }
                    cmd = "netscape -remote openURL(" + sURL + ")";
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("The command is " + cmd);
                    }
                    Process p = Runtime.getRuntime().exec(cmd);
                    try {
                        int exitCode = p.waitFor();
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("Exit code is " + exitCode);
                        }
                        if (exitCode != 0) {
                            cmd = "netscape " + sURL;
                            if (CnfgLog.isDebugEnabled()) {
                                CnfgLog.debug("Trying to use an existing browser failed, start up a new browser. The command is " + cmd);
                            }
                            Runtime.getRuntime().exec(cmd);
                        }
                        break block19;
                    }
                    catch (InterruptedException e) {
                        Object[] args = new Object[]{cmd};
                        Object[] arrayOfObjects = new Object[]{CnfgResource.getMessage("Message.launchbrowser.failed.notification"), CnfgResource.getMessage("Message.launchbrowser.failed.explanation", args), CnfgResource.getMessage("Message.launchbrowser.failed.resolution")};
                        DialogMessage.showDialog(arrayOfObjects, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
                        CnfgLog.debug(e);
                    }
                    break block19;
                }
                cmd = sBrowserPath + " " + sURL;
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("User defined the browser path. The command is " + cmd);
                }
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                Object[] args = new Object[]{cmd};
                Object[] arrayOfObjects = new Object[]{CnfgResource.getMessage("Message.launchbrowser.failed.notification"), CnfgResource.getMessage("Message.launchbrowser.failed.explanation", args), CnfgResource.getMessage("Message.launchbrowser.failed.resolution")};
                DialogMessage.showDialog(arrayOfObjects, DialogMessage.DEFAULT_CAPTION, DialogMessage.ICON_ERROR, DialogMessage.OPTS_NOARGS, 0);
                CnfgLog.debug(e);
            }
        }
    }
}

