/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.SystemPasswordParameter;
import com.cognos.crconfig.data.crypto.IEncryptingSession;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ArrayParameter
extends Parameter
implements Cloneable {
    private static final Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
    private static final QName qnPARAMETER = new QName("parameter", nsCRN);
    private static final QName qnVALUE = new QName("value", nsCRN);
    private static final QName qnITEM = new QName("item", nsCRN);
    Set<Parameter> m_lCurrentValues = new TreeSet<Parameter>(new Parameter.MyOrderComparator(this));
    boolean m_bDirty = false;
    boolean m_bCanAddValues = false;
    private Element m_Elem;
    private ArrayList<String> predefinedParmNames = null;
    private Set<Parameter> m_defaultValues = null;

    public ArrayParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    @Override
    public Object clone() {
        ArrayParameter newAP = (ArrayParameter)super.clone();
        newAP.m_lCurrentValues = new TreeSet<Parameter>(new Parameter.MyOrderComparator(this));
        for (Parameter p : this.m_lCurrentValues) {
            Parameter newP = (Parameter)p.clone();
            newAP.m_lCurrentValues.add(newP);
        }
        return newAP;
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        String sMaxOccurs;
        String invokeDefaultMethodAttr;
        Element valueElement;
        Parameter p;
        boolean bRetValue;
        boolean bSuccess = super.load(parentFolder, elem);
        if (!bSuccess) {
            return false;
        }
        this.setMetaData(elem);
        String sDefaultValue = elem.attributeValue("default", "");
        if (sDefaultValue.length() != 0 && (bRetValue = (p = this.createParamElement(this.m_elemType)).load(null, elem)) && (bRetValue = p.setValue(sDefaultValue))) {
            this.m_defaultValue = sDefaultValue;
        }
        if ((valueElement = this.callInvokeMethod(invokeDefaultMethodAttr = elem.attributeValue("invokeDefaultMethod"), elem)) != null) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("ArrayParameter::load()=> after calling invokeDefaultMethod:  " + invokeDefaultMethodAttr + " , set to default list.");
            }
            this.setDefaultValueList(valueElement);
        }
        this.m_lCurrentValues = new TreeSet<Parameter>(new Parameter.MyOrderComparator(this));
        this.setToDefault();
        String validate = elem.attributeValue("needValidate", "false");
        if (validate.equals("true")) {
            this.setPredefinedParms(elem);
        }
        if ((sMaxOccurs = elem.attributeValue("maxOccurs", "")).length() != 0) {
            if (sMaxOccurs.compareTo("unbounded") == 0) {
                this.m_bCanAddValues = true;
            } else {
                Integer maxOccurs = null;
                boolean bMaxOccursInvalid = false;
                try {
                    maxOccurs = new Integer(sMaxOccurs);
                    if (maxOccurs < 0) {
                        bMaxOccursInvalid = true;
                    }
                }
                catch (NumberFormatException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                    bMaxOccursInvalid = true;
                }
                if (!bMaxOccursInvalid && maxOccurs > (this.getValues() == null ? 0 : this.getValues().size())) {
                    this.m_bCanAddValues = true;
                }
            }
        }
        return true;
    }

    protected void setDefaultValueList(Element valueElement) {
        Iterator itEnum = valueElement.elementIterator("enum");
        this.m_defaultValues = new TreeSet<Parameter>(new Parameter.MyOrderComparator(this));
        while (itEnum.hasNext()) {
            Element e = (Element)itEnum.next();
            String sValue = e.attributeValue("value");
            if (sValue == null) continue;
            Parameter p = this.createParamElement(this.m_elemType);
            p.setName(this.getName());
            p.setFireValueChanged(false);
            p.setValue(sValue);
            String sOrder = e.attributeValue("order");
            if (sOrder != null) {
                p.setOrder(new Integer(sOrder));
            }
            this.m_defaultValues.add(p);
        }
    }

    private void setPredefinedParms(Element elem) {
        this.predefinedParmNames = new ArrayList();
        List children = elem.elements();
        for (Element child : children) {
            if (!child.getName().equals("enum")) continue;
            this.predefinedParmNames.add(child.attributeValue("value"));
        }
    }

    public boolean isSupported(String childParmName) {
        return this.predefinedParmNames == null || this.predefinedParmNames.contains(childParmName);
    }

    private void setMetaData(Element elem) {
        this.m_Elem = (Element)elem.clone();
        Attribute tempAtt = this.m_Elem.attribute("name");
        if (null != tempAtt) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("dependency"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("viewList"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("mandatory"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("encrypted"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("units"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("minOccurs"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("maxOccurs"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("msgBase"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("arrayType"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("label"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("description"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("help"))) {
            this.m_Elem.remove(tempAtt);
        }
        if (null != (tempAtt = this.m_Elem.attribute("action"))) {
            this.m_Elem.remove(tempAtt);
        }
    }

    public Element getMetaData() {
        return this.m_Elem;
    }

    public boolean setParameterValue(Element value_elem) {
        boolean bNoErrors = true;
        List parameterList = value_elem.elements(qnPARAMETER);
        for (Element parameterElement : parameterList) {
            if (null == parameterElement) continue;
            String parameterName = parameterElement.attributeValue("name");
            if (null != parameterName && parameterName.length() > 0) {
                Parameter param;
                Element curValueElement = parameterElement.element(qnVALUE);
                String sParamType = "";
                String sPrefix = "";
                if (curValueElement != null) {
                    int idx;
                    sParamType = curValueElement.attributeValue("xsi:type", "");
                    sPrefix = "";
                    if (sParamType.length() > 0 && (idx = sParamType.indexOf(":")) >= 0) {
                        sPrefix = sParamType.substring(0, idx);
                    }
                }
                if (null != (param = this.createParamElement(sParamType, sPrefix))) {
                    param.setName(parameterName);
                    param.setLabel(parameterName);
                    if (curValueElement != null) {
                        param.setValue(curValueElement);
                    } else {
                        param.setValue("");
                        if (!this.getDisabled()) {
                            this.setDirtyFlag(true);
                        }
                    }
                    this.m_lCurrentValues.add(param);
                    continue;
                }
                bNoErrors = false;
                continue;
            }
            bNoErrors = false;
        }
        return bNoErrors;
    }

    public boolean setItemValue(Element value_elem) {
        String sEncrypted;
        this.m_lCurrentValues.clear();
        if (this.isEncrypted() && ((sEncrypted = value_elem.attributeValue("encrypted")) == null || sEncrypted.equals("false")) && !this.getDisabled()) {
            DataManager.getInstance().setConfigDirtyFlag(true, this.getRestartServicesList());
        }
        List lItemElements = value_elem.elements(qnITEM);
        boolean noError = true;
        for (int i = 0; i < lItemElements.size(); ++i) {
            String sValue;
            boolean bRet;
            Element e = (Element)lItemElements.get(i);
            Parameter p = this.createParamElement(this.m_elemType);
            p.load(null, this.m_Elem);
            String sOrder = e.attributeValue("order", "");
            if (sOrder.length() != 0) {
                p.setOrder(new Integer(sOrder));
            } else {
                p.setOrder(new Integer("-1"));
            }
            p.setEncrypted(this.isEncrypted());
            if (!this.getDisabled() && !(bRet = this.isUnique(sValue = e.getText()))) {
                DataManager.getInstance().setConfigDirtyFlag(true, this.getRestartServicesList());
                noError = false;
                continue;
            }
            if (this.getName().equals("cognosCryptoCiphersuite")) {
                p.m_currentValue = e.getText();
            } else {
                bRet = p.setValue(e.getText());
                if (!bRet) {
                    noError = false;
                    this.m_sBadValue = p.getBadValue();
                }
            }
            this.m_lCurrentValues.add(p);
        }
        if (this.isMandatory() && this.m_lCurrentValues.size() == 0 && this.getMinOccurs() > 0) {
            noError = false;
            this.m_sBadValue = new String();
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.mandatory.values"));
        }
        return noError;
    }

    @Override
    public boolean setValue(Element value_elem) {
        this.clearErrorMsg();
        if (this.isElementParameter()) {
            return this.setParameterValue(value_elem);
        }
        return this.setItemValue(value_elem);
    }

    public boolean canAddValues() {
        return this.m_bCanAddValues;
    }

    public boolean hasValues() {
        return this.m_values != null && !this.m_values.isEmpty();
    }

    public boolean isOrdered() {
        return this.getDataType().compareToIgnoreCase("sortedArray") == 0;
    }

    public boolean isElementParameter() {
        return this.m_bIsElementParameter;
    }

    public void setElementParameter(boolean isElementParameter) {
        this.m_bIsElementParameter = isElementParameter;
    }

    @Override
    public boolean setValue(Object value) {
        this.m_sBadValue = null;
        this.clearErrorMsg();
        this.setDirtyFlag(false);
        if (ArrayList.class.isInstance(value)) {
            ArrayList pList = (ArrayList)value;
            boolean noError = true;
            if (this.isMandatory() && pList.isEmpty() && this.getMinOccurs() > 0) {
                noError = false;
                this.m_sBadValue = CnfgResource.getMessage("Message.errorOnValidation.mandatory");
                this.m_lastErrorMsg = new ArrayList();
                this.m_lastErrorMsg.add(this.m_sBadValue);
            }
            this.m_lCurrentValues.clear();
            for (int i = 0; i < pList.size(); ++i) {
                Parameter p = (Parameter)pList.get(i);
                p.setOrder(new Integer(i));
                this.m_lCurrentValues.add(p);
            }
            if (this.m_bFireValueChanged) {
                CnfgValueChangedEvent vce = new CnfgValueChangedEvent(this);
                DataManager.getInstance().fireValueChanged(vce);
            }
            return noError;
        }
        this.m_sBadValue = CnfgResource.getMessage("Message.errorOnValidation.dataType");
        this.m_lastErrorMsg = new ArrayList();
        this.m_lastErrorMsg.add(this.m_sBadValue);
        if (this.m_bFireValueChanged) {
            CnfgValueChangedEvent vce = new CnfgValueChangedEvent(this);
            DataManager.getInstance().fireValueChanged(vce);
        }
        return false;
    }

    public void setDirtyFlag(boolean bIsDirty) {
        this.m_bDirty = bIsDirty;
    }

    @Override
    public boolean isEqual(Object value) {
        return !this.m_bDirty;
    }

    @Override
    public Object getValue() {
        StringBuffer appendedText = new StringBuffer();
        Iterator<Parameter> iter = this.m_lCurrentValues.iterator();
        while (iter.hasNext()) {
            Parameter p = iter.next();
            if (p.isEncrypted() || p.getClass() == CredentialParameter.class || p.getClass() == SystemPasswordParameter.class) {
                return "***************";
            }
            String currentText = this.isElementParameter() ? p.getName() : p.getDisplayValue();
            if (currentText == null || currentText.length() == 0) continue;
            appendedText.append(currentText);
            if (!iter.hasNext()) break;
            appendedText.append("...");
            break;
        }
        if (appendedText.length() == 0) {
            return CnfgResource.getMessage("Label.editButton");
        }
        return appendedText.toString();
    }

    public Set<Parameter> getCurrentValues() {
        return this.m_lCurrentValues;
    }

    @Override
    public List<String> getErrorMsg() {
        if (this.m_lastErrorMsg.size() == 0) {
            for (Parameter p : this.m_lCurrentValues) {
                if (p.getErrorMsg().size() == 0) continue;
                return p.getErrorMsg();
            }
        }
        return this.m_lastErrorMsg;
    }

    @Override
    public String getBadValue() {
        if (this.m_sBadValue != null) {
            return this.m_sBadValue;
        }
        for (Parameter p : this.m_lCurrentValues) {
            if (p.getBadValue() == null) continue;
            this.m_sBadValue = p.getBadValue();
            return this.m_sBadValue;
        }
        return null;
    }

    public void setBadValue() {
        this.m_sBadValue = null;
        for (Parameter p : this.m_lCurrentValues) {
            if (p.getBadValue() == null) continue;
            this.m_sBadValue = p.getBadValue();
        }
    }

    @Override
    public boolean hasDefault() {
        return this.m_values != null || this.m_defaultValue != null || this.m_defaultValues != null;
    }

    private boolean compareValueList(Set<Parameter> currentList, Set<Parameter> defaultList) {
        Iterator<Parameter> iter1 = defaultList.iterator();
        Iterator<Parameter> iter2 = currentList.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            Parameter p2;
            Parameter p1 = iter1.next();
            if (p1.isEqual((p2 = iter2.next()).getValue())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }

    @Override
    public boolean isDefault() {
        if (this.hasDefault()) {
            if (this.m_defaultValues != null && !this.m_defaultValues.isEmpty()) {
                return this.compareValueList(this.m_lCurrentValues, this.m_defaultValues);
            }
            if (this.m_sortedValues != null) {
                return this.compareValueList(this.m_lCurrentValues, this.m_sortedValues);
            }
            if (this.m_defaultValue != null) {
                int minOccurs = this.getMinOccurs();
                if (this.m_lCurrentValues.size() >= minOccurs) {
                    if (minOccurs > 0 && this.m_lCurrentValues.size() > minOccurs) {
                        return false;
                    }
                    if (minOccurs == 0 && this.m_lCurrentValues.size() > 1) {
                        return false;
                    }
                    Iterator<Parameter> iter = this.m_lCurrentValues.iterator();
                    if (iter.hasNext()) {
                        Parameter p = iter.next();
                        Object currentValue = p.getValue();
                        if (currentValue == null) {
                            return true;
                        }
                        return currentValue.toString().equals(this.m_defaultValue.toString());
                    }
                }
            }
        }
        return false;
    }

    private void setToDefault(Element elem) {
        if (this.getMinOccurs() == 0 && this.m_defaultValue == null && this.m_sortedValues == null) {
            ArrayList al = new ArrayList();
            this.setValue(al);
        } else if (this.getName() != null && this.getName().equals("SSLProtocols")) {
            this.resetSSLProtocols(elem);
        } else {
            this.resetArrayParm(elem);
        }
    }

    private void resetArrayParm(Element elem) {
        if (this.m_defaultValues != null && !this.m_defaultValues.isEmpty()) {
            this.setToAvailableList(this.m_defaultValues);
        } else if (this.m_sortedValues != null) {
            this.setToAvailableList(this.getAvailableValues());
        } else if (this.m_defaultValue != null) {
            this.setDefaultValue(elem);
        }
    }

    private void setToAvailableList(Set<Parameter> availableValues) {
        ArrayList<Parameter> al = new ArrayList<Parameter>(availableValues);
        this.setValue(al);
    }

    private void resetSSLProtocols(Element elem) {
        if (this.m_defaultValue != null) {
            this.setDefaultValue(elem);
        } else if (this.m_sortedValues != null) {
            this.setToAvailableList(this.getAvailableValues());
        }
    }

    @Override
    public void setToDefault() {
        this.setToDefault(this.m_Elem);
    }

    @Override
    public void write(Element value_elem, boolean bEncrypt, List<String> errors) throws DataManagerException {
        if (!this.getDisabled() && this.getVisibility() && this.isBadValue()) {
            Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
            if (errors != null) {
                String sMessage = CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args);
                errors.add(sMessage);
            } else {
                StringBuffer sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args));
                throw new DataManagerException(sMessage.toString());
            }
        }
        Element parent = value_elem.getParent();
        parent.addAttribute("opaque", "true");
        if (this.isElementParameter()) {
            for (Parameter param : this.m_lCurrentValues) {
                param.serialize(value_elem, bEncrypt, errors, true, false);
            }
            return;
        }
        String sValue = null;
        boolean bIsEncrypted = false;
        IEncryptingSession es = null;
        if (this.isEncrypted()) {
            DataManager.getInstance().initializeCAMFactoryFromDisk();
            es = DataManager.getInstance().getCryptoEncryptingSession(bEncrypt);
        }
        for (Parameter p : this.m_lCurrentValues) {
            Element text_value;
            byte[] utf8Buffer;
            if (p.getEncryptedValue() != null) {
                if (bEncrypt) {
                    sValue = p.getEncryptedValue();
                    bIsEncrypted = true;
                } else if (this.isEncrypted()) {
                    if (es != null) {
                        try {
                            byte[] decodedBuffer = es.decode(this.m_encryptedValue);
                            utf8Buffer = es.decryptData(decodedBuffer);
                            sValue = new String(utf8Buffer, "UTF-8");
                        }
                        catch (Throwable e) {
                            CharSequence sMessage;
                            CnfgLog.error(e);
                            this.m_sBadValue = new String();
                            Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
                            if (errors != null) {
                                sMessage = e.getLocalizedMessage() + "\n" + CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args);
                                errors.add((String)sMessage);
                            }
                            sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args));
                            throw new DataManagerException(((StringBuffer)sMessage).toString());
                        }
                    } else {
                        sValue = p.getEncryptedValue();
                        bIsEncrypted = true;
                    }
                }
            } else {
                Object oValue = p.getValue();
                String string = sValue = oValue == null ? "" : oValue.toString();
                if (bEncrypt && !this.getDisabled() && this.isEncrypted() && es != null) {
                    try {
                        utf8Buffer = sValue.getBytes("UTF-8");
                        byte[] buffer = es.encryptData(utf8Buffer);
                        sValue = es.encode(buffer);
                    }
                    catch (UnsupportedEncodingException e) {
                        CnfgLog.error(e);
                        if (errors != null) {
                            errors.add(e.getLocalizedMessage());
                        }
                        throw new DataManagerException(e.getLocalizedMessage());
                    }
                    catch (CAMCryptoException e) {
                        CnfgLog.error(e);
                        if (errors != null) {
                            errors.add(e.getLocalizedMessage());
                        }
                        throw new DataManagerException(e.getLocalizedMessage());
                    }
                    p.setEncryptedValue(sValue);
                    bIsEncrypted = true;
                }
            }
            Element text_elem = value_elem.addElement("crn:item");
            if (text_elem == null) {
                throw new DataManagerException(CnfgResource.getMessage("Message.errorOutOfMemory"));
            }
            text_elem.addAttribute("xsi:type", this.m_elemType);
            Integer order = p.getOrder();
            if (this.isOrdered() && order != null) {
                text_elem.addAttribute("order", order.toString());
            }
            if ((text_value = text_elem.addText(sValue)) != null) continue;
            throw new DataManagerException(CnfgResource.getMessage("Message.errorOutOfMemory"));
        }
        if (bIsEncrypted) {
            value_elem.addAttribute("encrypted", "true");
        }
    }

    public boolean isUnique(String sValue) {
        if (sValue == null) {
            return false;
        }
        boolean bRetVal = true;
        if (this.m_values != null) {
            if (this.getName().equals("cognosCryptoCiphersuite")) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("ArrayParameter::isUnique() - this is for cognosCryptoCiphersuite parameter, skip checking the available list. ");
                }
                bRetVal = true;
            } else {
                bRetVal = this.m_values.containsKey(sValue);
                if (!bRetVal) {
                    bRetVal = this.canAddValues();
                }
            }
            if (bRetVal) {
                for (Parameter p : this.m_lCurrentValues) {
                    String s = (String)p.getValue();
                    if (s == null || s.compareTo(sValue) != 0) continue;
                    bRetVal = false;
                    break;
                }
            }
        }
        return bRetVal;
    }

    public String getSupportedNames() {
        if (this.predefinedParmNames != null) {
            return this.predefinedParmNames.toString();
        }
        return null;
    }

    public boolean validateValues(ArrayList<Parameter> params) {
        return true;
    }

    public void setDefaultValue() {
        this.resetArrayParm(this.m_Elem);
    }

    public void setDefaultValue(Element elem) {
        if (this.m_defaultValue != null) {
            Parameter p = this.createParamElement(this.m_elemType);
            p.setName(this.getName());
            p.setValue((String)this.m_defaultValue);
            ArrayList<Parameter> al = new ArrayList<Parameter>();
            al.add(p);
            this.setValue(al);
        }
    }
}

