/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import java.util.HashMap;
import org.dom4j.Element;

public class BooleanParameter
extends Parameter {
    public BooleanParameter(String namespace, String dataType) {
        super(namespace, dataType);
        this.m_values = new HashMap();
        this.m_values.put(new Boolean(true), CnfgResource.getMessage("Label.BooleanTrue"));
        this.m_values.put(new Boolean(false), CnfgResource.getMessage("Label.BooleanFalse"));
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        boolean bSuccess = super.load(parentFolder, elem);
        if (!bSuccess) {
            return false;
        }
        String sDefaultValue = elem.attributeValue("default", "");
        if (this.validate(sDefaultValue) && (this.isMandatory() || sDefaultValue.length() != 0)) {
            this.m_defaultValue = sDefaultValue.compareToIgnoreCase("true") == 0 || sDefaultValue.compareTo("1") == 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return true;
    }

    @Override
    public boolean setValue(Object value) {
        this.clearErrorMsg();
        String sValue = value.toString();
        if (this.validate(sValue)) {
            this.m_currentValue = !this.isMandatory() && sValue.length() == 0 ? sValue : new Boolean(sValue);
            return super.setValue(this.m_currentValue);
        }
        this.m_sBadValue = sValue;
        return false;
    }

    @Override
    public boolean validate(String sValue) {
        boolean bRetVal = super.validate(sValue);
        if (!bRetVal) {
            return bRetVal;
        }
        if (!this.isMandatory() && sValue.length() == 0) {
            return true;
        }
        if (sValue.compareToIgnoreCase("true") == 0 || sValue.compareTo("1") == 0 || sValue.compareToIgnoreCase("false") == 0 || sValue.compareTo("0") == 0) {
            return true;
        }
        this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.notInList"));
        return false;
    }
}

