/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class CnfgActionCustomSave {
    public static final String ELEM_PROVIDER = "provider";
    public static final String ELEM_JAVACLASS = "javaclass";
    public static final String ELEM_LOCATION = "location";
    public static final String ELEM_INCLUDEWEBINF = "includeWebInf";
    public static final String ELEM_INCLUDEJARPATH = "includeJarPath";
    public static final String ELEM_INCLUDECLASSPATH = "includeClassPath";
    public static final String ELEM_PREREQUISITES = "prerequisites";
    public static final String ELEM_PARAM = "param";
    public static final String ELEM_SERVICE = "service";
    public static final String ATTRIB_REFID = "refID";
    public static final String ATTRIB_ID = "id";
    public static final String ATTRIB_NAME = "name";
    public static final String ATTRIB_VALUE = "value";
    public static final String ATTRIB_ISRUNNING = "isRunning";
    private String m_providerName;
    private String m_id;
    private String m_refID;
    private URL[] m_urls;
    private String m_className;
    private Map m_prereqParams;
    private Map m_prereqServices;

    public CnfgActionCustomSave(Element actionElem) {
        this.m_id = actionElem.attributeValue(ATTRIB_ID, "");
        this.m_refID = actionElem.attributeValue(ATTRIB_REFID);
        if (this.m_refID != null) {
            this.m_urls = null;
            return;
        }
        Element providerElem = actionElem.element(ELEM_PROVIDER);
        if (null != providerElem) {
            String javaClassName;
            this.m_providerName = providerElem.attributeValue(ATTRIB_NAME);
            Element javaClassElem = providerElem.element(ELEM_JAVACLASS);
            if (null != javaClassElem && null != (javaClassName = javaClassElem.getText())) {
                Element includeJarPathElem;
                Element includeClassPathElem;
                Element includeWebInfElem;
                Element locationElem = providerElem.element(ELEM_LOCATION);
                String location = null;
                if (null != locationElem) {
                    location = locationElem.getText();
                }
                ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
                ArrayList locationURLs = new ArrayList();
                if (null != location && location.length() > 0) {
                    StringTokenizer tokens = new StringTokenizer(location, " ");
                    while (tokens.hasMoreTokens()) {
                        String token = tokens.nextToken();
                        String path = cfg.resolveEffectivePath("../bin/" + token);
                        this.addFileURL(locationURLs, new File(path));
                    }
                }
                if (null != (includeWebInfElem = providerElem.element(ELEM_INCLUDEWEBINF))) {
                    boolean bIncludeWebInf;
                    String sWebInf = includeWebInfElem.getText();
                    boolean bl = bIncludeWebInf = sWebInf.length() > 0 && sWebInf.equalsIgnoreCase("true");
                    if (bIncludeWebInf) {
                        String sWebInfClasses = cfg.resolveEffectivePath("../webapps/p2pd/WEB-INF/classes");
                        this.addFileURL(locationURLs, new File(sWebInfClasses));
                        String sWebInfLib = cfg.resolveEffectivePath("../webapps/p2pd/WEB-INF/lib");
                        File libdir = new File(sWebInfLib);
                        File[] jarFiles = libdir.listFiles(new jarFileFilter());
                        if (null != jarFiles && jarFiles.length > 0) {
                            for (int iFile = 0; iFile < jarFiles.length; ++iFile) {
                                File file = jarFiles[iFile];
                                this.addFileURL(locationURLs, file);
                            }
                        }
                    }
                }
                if (null != (includeClassPathElem = providerElem.element(ELEM_INCLUDECLASSPATH))) {
                    String sPaths = includeClassPathElem.getText();
                    StringTokenizer tk = new StringTokenizer(sPaths);
                    while (tk.hasMoreTokens()) {
                        String pathToAdd = cfg.resolveEffectivePath(tk.nextToken());
                        this.addFileURL(locationURLs, new File(pathToAdd));
                    }
                }
                if (null != (includeJarPathElem = providerElem.element(ELEM_INCLUDEJARPATH))) {
                    String sPath = includeJarPathElem.getText();
                    StringTokenizer tk = new StringTokenizer(sPath);
                    while (tk.hasMoreTokens()) {
                        String pathToAdd = cfg.resolveEffectivePath(tk.nextToken());
                        File libdir = new File(pathToAdd);
                        File[] jarFiles = libdir.listFiles(new jarFileFilter());
                        if (null == jarFiles || jarFiles.length <= 0) continue;
                        for (int iFile = 0; iFile < jarFiles.length; ++iFile) {
                            File file = jarFiles[iFile];
                            this.addFileURL(locationURLs, file);
                        }
                    }
                }
                this.m_urls = new URL[locationURLs.size()];
                this.m_urls = locationURLs.toArray(this.m_urls);
                this.m_className = javaClassName;
                Element prereqElem = providerElem.element(ELEM_PREREQUISITES);
                if (null != prereqElem) {
                    List serviceElems;
                    List paramElems = prereqElem.elements(ELEM_PARAM);
                    if (paramElems != null && paramElems.size() > 0) {
                        this.m_prereqParams = new Hashtable(3);
                        for (int i = 0; i < paramElems.size(); ++i) {
                            Element paramElem = (Element)paramElems.get(i);
                            if (paramElem == null) continue;
                            Attribute paramNameAttr = paramElem.attribute(ATTRIB_NAME);
                            Attribute paramValueAttr = paramElem.attribute(ATTRIB_VALUE);
                            if (paramNameAttr == null || paramValueAttr == null) continue;
                            String paramName = paramNameAttr.getValue();
                            String paramValue = paramValueAttr.getValue();
                            this.m_prereqParams.put(paramName, paramValue);
                        }
                    }
                    if ((serviceElems = prereqElem.elements(ELEM_SERVICE)) != null && serviceElems.size() > 0) {
                        this.m_prereqServices = new Hashtable(2);
                        for (int i = 0; i < serviceElems.size(); ++i) {
                            Element serviceElem = (Element)serviceElems.get(i);
                            if (serviceElem == null) continue;
                            Attribute serviceNameAttr = serviceElem.attribute(ATTRIB_NAME);
                            Attribute serviceIsRunningAttr = serviceElem.attribute(ATTRIB_ISRUNNING);
                            if (serviceNameAttr == null || serviceIsRunningAttr == null) continue;
                            String serviceName = serviceNameAttr.getValue();
                            String serviceValue = serviceIsRunningAttr.getValue();
                            this.m_prereqServices.put(serviceName, serviceValue);
                        }
                    }
                }
            }
        }
    }

    public void addFileURL(ArrayList urlList, File f) {
        block3: {
            if (f == null) {
                return;
            }
            try {
                urlList.add(f.toURL());
            }
            catch (MalformedURLException e) {
                if (!CnfgLog.isDebugEnabled()) break block3;
                CnfgLog.debug("An invalid location token was specified for action 'test' with provider '" + this.m_providerName + "'.  Token: " + f.getName());
            }
        }
    }

    public URL[] getURLs() {
        return this.m_urls;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getProvider() {
        return this.m_providerName;
    }

    public String getID() {
        return this.m_id;
    }

    public String getRefID() {
        return this.m_refID;
    }

    public Map getPrerequisiteParams() {
        return this.m_prereqParams;
    }

    public Map getPrerequisiteServices() {
        return this.m_prereqServices;
    }

    public class jarFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip");
        }
    }
}

