/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.service.BootstrapServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;
import com.cognos.crconfig.data.service.ServiceManagerException;
import java.util.ArrayList;
import org.dom4j.Element;

public class CnfgActionDeleteCRN
extends CnfgActionOld {
    private Folder m_cbsFolder = null;
    private Folder m_cbsParentFolder = null;
    private String m_sServiceName = null;

    @Override
    public void load(Element elem) {
        this.loadCommon(elem);
    }

    @Override
    public void undo(ArrayList errorList) {
        if (this.m_cbsParentFolder != null && this.m_cbsFolder != null) {
            Folder cbsFolder;
            int beginIdx = errorList.size();
            this.m_cbsParentFolder.addFolder(this.m_cbsFolder);
            if (CRConfigFrame.getInstance().isVisible()) {
                DataManager.getInstance().newConfig();
            }
            if (null != (cbsFolder = DataManager.getInstance().getCBS())) {
                try {
                    if (this.m_sServiceName != null && !ServiceManager.isRegistered(this.m_sServiceName, (BootstrapServiceFolder)this.m_cbsFolder)) {
                        ServiceManager.setRegServiceName(this.m_sServiceName, (BootstrapServiceFolder)this.m_cbsFolder);
                        ServiceManager.install(true, (BootstrapServiceFolder)this.m_cbsFolder);
                    }
                }
                catch (ServiceManagerException e) {
                    CnfgLog.error(e);
                    errorList.add(e.getLocalizedMessage());
                }
            }
            if (errorList.size() > beginIdx) {
                errorList.add(beginIdx, new StringBuffer(CnfgResource.getMessage("Message.action.deletecrn.undo.failed.notification")).append("\n").toString());
            }
        }
    }

    @Override
    public ICnfgTask[] getTasks(ArrayList paramList, ICnfgFeedback feedback) {
        ArrayList<ICnfgTask> taskList = new ArrayList<ICnfgTask>();
        if (DataManager.getInstance().getCBS() != null) {
            taskList.add(new CnfgTask(){

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    Folder cbsFolder = DataManager.getInstance().getCBS();
                    if (cbsFolder != null) {
                        CnfgActionDeleteCRN.this.m_cbsFolder = cbsFolder;
                        CnfgActionDeleteCRN.this.m_cbsParentFolder = cbsFolder.getParent();
                        cbsFolder.getParent().remove(cbsFolder);
                        if (CRConfigFrame.getInstance().isVisible()) {
                            DataManager.getInstance().newConfig();
                        }
                    }
                    return true;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.actiondeletecrn.taskname");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Message.actiondeletecrn.tasktext");
                }
            });
            this.m_sServiceName = ServiceManager.getCBSRegName();
            if (this.m_sServiceName != null && ServiceManager.isRegistered(this.m_sServiceName, null)) {
                taskList.add(new CnfgTask(){

                    @Override
                    public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                        ServiceManager.uninstall(null);
                        CnfgActionDeleteCRN.this.m_sServiceName = ServiceManager.getCBSRegName();
                        ServiceManager.setRegServiceName(null, null);
                        return true;
                    }

                    @Override
                    public String getLabel() {
                        return CnfgResource.getMessage("Message.task.unregisterservice");
                    }

                    @Override
                    public String getDescription() {
                        Object[] args = new Object[]{ServiceManager.getCBSRegName()};
                        return CnfgResource.getMessage("Message.silent.unregistering", args);
                    }

                    @Override
                    public boolean isMandatory() {
                        return true;
                    }
                });
            } else {
                this.m_sServiceName = null;
            }
        }
        return CnfgTask.createTaskArray(taskList);
    }

    @Override
    public String getLabel() {
        String s = super.getLabel();
        if (s == null) {
            return CnfgResource.getMessage("Message.actiondeletecrn.actionlabel");
        }
        return s;
    }

    @Override
    public String getDesc() {
        String s = super.getDesc();
        if (s == null) {
            return CnfgResource.getMessage("Message.actiondeletecrn.actiondesc");
        }
        return s;
    }

    @Override
    public String getHelp() {
        String s = super.getHelp();
        if (s == null) {
            return CnfgResource.getMessage("Message.actiondeletecrn.actionhelp");
        }
        return s;
    }
}

