/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgActionClient;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.ICnfgAction;
import java.util.LinkedList;

public class CnfgActionEngine {
    public static final int TASK_STATUS_NONE = 0;
    public static final int TASK_STATUS_CURRENT = 1;
    public static final int TASK_STATUS_COMPLETED = 2;
    public static final int TASK_STATUS_FAILED = 3;
    public static final int TASK_STATUS_CANCELLED = 4;
    private CnfgActionThread m_thread;
    private boolean m_cancellable = true;

    public boolean run(ICnfgAction action, ICnfgActionClient client) {
        return this.run(action, client, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean run(ICnfgAction action, ICnfgActionClient client, boolean cancellable) {
        if (null != action && null != client) {
            this.m_cancellable = cancellable;
            client.setCancellable(cancellable);
            ICnfgTask[] tasks = action.getTasks();
            if (null != tasks && tasks.length > 0) {
                CnfgActionTask[] actionTasks = new CnfgActionTask[tasks.length];
                for (int iTask = 0; iTask < tasks.length; ++iTask) {
                    ICnfgTask task = tasks[iTask];
                    if (null == task) continue;
                    Object[] promptAnswers = null;
                    CnfgActionTask actionTask = new CnfgActionTask();
                    actionTask.m_task = task;
                    CnfgActionTask.access$202(actionTask, promptAnswers);
                    actionTasks[iTask] = actionTask;
                }
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgActionThread::run() - action.setStatus(running)");
                }
                action.setStatus(1);
                client.initialize(action, tasks);
                this.m_thread = new CnfgActionThread(client);
                this.m_thread.start(action, actionTasks);
                client.begin();
                try {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("CnfgActionThread::run() - m_thread.join()");
                    }
                    this.m_thread.join();
                }
                catch (InterruptedException interruptedException) {}
                return !this.m_thread.m_tasksFailed;
            }
        }
        return false;
    }

    public void cancel() {
        if (this.m_cancellable) {
            this.m_thread.m_keepRunning = false;
            this.m_thread.cancel();
            if (this.m_thread.isPaused()) {
                this.m_thread.unpause();
                this.m_thread.m_client.setEnginePaused(false);
                this.m_thread.m_action.setStatus(3);
                this.m_thread.m_action = null;
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgActionThread.cacel() - canceling a paused action");
                }
                this.m_thread.m_client.end();
            }
        }
    }

    public void pause() {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("CnfgActionThread::pause() - m_thread.join()");
        }
        this.m_thread.pause();
    }

    public void continueRunning() {
        this.m_thread.m_client.updateTaskStatus(this.m_thread.m_currentTask, 2);
        this.m_thread.unpause();
        this.m_thread.m_client.setEnginePaused(false);
        new Thread(this.m_thread).start();
        try {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgActionThread::continueRunning() - m_thread.join()");
            }
            this.m_thread.join();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    private class CnfgActionThread
    extends Thread {
        private LinkedList m_list = new LinkedList();
        private volatile boolean m_keepRunning = true;
        private volatile boolean m_isPaused = false;
        private volatile boolean m_tasksFailed;
        private volatile ICnfgTask m_currentTask;
        private Object m_lock = new Object();
        private ICnfgActionClient m_client;
        private ICnfgAction m_action;

        private CnfgActionThread(ICnfgActionClient client) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgActionThread()");
            }
            this.m_client = client;
        }

        private void pause() {
            this.m_isPaused = true;
        }

        private void unpause() {
            this.m_isPaused = false;
        }

        private boolean isPaused() {
            return this.m_isPaused;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgActionThread::cancel()");
            }
            Object object = this.m_lock;
            synchronized (object) {
                this.m_client.cancel();
                this.m_client.getFeedback().showWarning(CnfgResource.getMessage("Message.task.cancel"));
                if (null != this.m_currentTask) {
                    try {
                        this.m_currentTask.cancel(this.m_client.getFeedback());
                        this.m_client.updateTaskStatus(this.m_currentTask, 4);
                    }
                    catch (Exception e) {
                        this.m_client.getFeedback().showWarning(e.getMessage());
                    }
                }
            }
        }

        private void start(ICnfgAction action, CnfgActionTask[] actionTasks) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgActionThread::start()");
            }
            this.m_action = action;
            this.m_list.clear();
            for (int i = 0; i < actionTasks.length; ++i) {
                this.m_list.add(actionTasks[i]);
            }
            super.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int numOfTasks = 0;
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgActionThread.run()");
            }
            CnfgActionThread.yield();
            while (this.m_keepRunning) {
                CnfgActionTask actionTask = null;
                int whatsLeft = this.m_list.size();
                if (0 < whatsLeft) {
                    if (1 == whatsLeft) {
                        this.m_client.lastTaskDisabled();
                    }
                    actionTask = (CnfgActionTask)this.m_list.removeFirst();
                    ++numOfTasks;
                }
                if (null != actionTask) {
                    ICnfgTask task = actionTask.m_task;
                    Object[] args = actionTask.m_arguments;
                    try {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("CnfgActionThread::run() - m_client.updateTaskStatus(current)");
                        }
                        this.m_client.updateTaskStatus(task, 1);
                        Object object = this.m_lock;
                        synchronized (object) {
                            this.m_currentTask = task;
                            if (!this.m_keepRunning) {
                                break;
                            }
                        }
                        boolean result = task.run(args, this.m_client.getFeedback());
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("CnfgActionThread.run() - task.run(), result is " + result);
                        }
                        if (this.m_isPaused) {
                            if (CnfgLog.isDebugEnabled()) {
                                CnfgLog.debug("CnfgActionThread.run() - task.run(), the task is paused");
                            }
                            return;
                        }
                        Object object2 = this.m_lock;
                        synchronized (object2) {
                            this.m_currentTask = null;
                        }
                        this.m_client.setTasksLeft(whatsLeft);
                        if (result) {
                            this.m_client.updateTaskStatus(task, 2);
                            continue;
                        }
                        if (task.getStatus() == 0) {
                            this.m_client.updateTaskStatus(task, 4);
                        } else {
                            this.m_client.updateTaskStatus(task, 3);
                        }
                        if (this.m_action.getName().equals("test") && (!this.m_action.getName().equals("test") || numOfTasks != 1) || !task.isMandatory()) continue;
                        this.m_tasksFailed |= true;
                        this.m_keepRunning = false;
                    }
                    catch (Throwable e) {
                        Throwable th = e.getCause();
                        if (th != null) {
                            this.m_client.getFeedback().showError(th.toString());
                        } else {
                            this.m_client.getFeedback().showError(e.getMessage());
                        }
                        this.m_currentTask = null;
                        this.m_client.updateTaskStatus(task, 3);
                        if (this.m_action.getName().equals("test") && (!this.m_action.getName().equals("test") || numOfTasks != 1) || !task.isMandatory()) continue;
                        this.m_tasksFailed |= true;
                        this.m_keepRunning = false;
                    }
                    continue;
                }
                this.m_keepRunning = false;
            }
            if (((CnfgActionEngine)CnfgActionEngine.this).m_thread.m_tasksFailed) {
                this.m_action.setStatus(3);
            } else {
                this.m_action.setStatus(2);
            }
            this.m_action = null;
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("CnfgActionThread.run() - m_client.end()");
            }
            this.m_client.end();
        }
    }

    private class CnfgActionTask {
        private ICnfgTask m_task;
        private Object[] m_arguments;

        private CnfgActionTask() {
        }

        static /* synthetic */ Object[] access$202(CnfgActionTask x0, Object[] x1) {
            x0.m_arguments = x1;
            return x1;
        }
    }
}

