/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.ExternalProcess;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class CnfgActionExternalProcess
extends CnfgActionOld {
    private HashMap m_path = new HashMap();
    private HashMap m_arguments = new HashMap();
    private HashMap m_valueMap = new HashMap();
    private String m_sOutputFile;
    private ArrayList m_lAvailableParams = new ArrayList();
    private String m_sOutputErrorMsg;
    private String m_sOutputMsg;

    public CnfgActionExternalProcess() {
    }

    public CnfgActionExternalProcess(CnfgActionOld action) {
        this.m_sName = action.getName();
        this.m_sType = "externalprocess";
        this.m_bMandatory = action.isMandatory();
        this.m_bSilent = action.isSilent();
        this.m_sMsgBase = action.getMsgBase();
        this.m_sLabel = action.getLabel();
        this.m_sDesc = action.getDesc();
        this.m_sHelp = action.getHelp();
        this.m_sErrorMessage = action.getErrorMessage();
        this.m_sContext = action.getContext();
    }

    @Override
    public void load(Element elem) {
        Element outputElem;
        this.loadCommon(elem);
        List pathElems = elem.elements("path");
        for (int i = 0; i < pathElems.size(); ++i) {
            Element pathElem = (Element)pathElems.get(i);
            String sPlatform = pathElem.attributeValue("platform", "win");
            String sValue = pathElem.attributeValue("value", "");
            this.m_path.put(sPlatform, sValue);
        }
        Element argumentsElem = elem.element("arguments");
        if (argumentsElem != null) {
            List argumentElems = argumentsElem.elements("argument");
            for (int j = 0; j < argumentElems.size(); ++j) {
                Element argElem = (Element)argumentElems.get(j);
                Integer iIndex = new Integer(argElem.attributeValue("index", ""));
                Object[] arg = new Object[]{argElem.attributeValue("value", ""), argElem.attributeValue("reference", "")};
                this.m_arguments.put(iIndex, arg);
                HashMap<String, String> tempMap = null;
                List mapElems = argElem.elements("map");
                for (int k = 0; k < mapElems.size(); ++k) {
                    Element mapElem = (Element)mapElems.get(k);
                    if (tempMap == null) {
                        tempMap = new HashMap<String, String>();
                    }
                    tempMap.put(mapElem.attributeValue("from", ""), mapElem.attributeValue("to", ""));
                }
                this.m_valueMap.put(iIndex, tempMap);
            }
        }
        if ((outputElem = elem.element("output")) != null) {
            this.m_sOutputFile = outputElem.attributeValue("value", "");
        }
    }

    public void setArguments(HashMap path, HashMap arguments, String outputFile, String outputMsg) {
        this.m_path = path;
        this.m_arguments = arguments;
        this.m_sOutputFile = outputFile;
        this.m_sOutputMsg = outputMsg;
    }

    @Override
    public void undo(ArrayList errorList) {
    }

    public void setAvailableParams(ArrayList paramList) {
        this.m_lAvailableParams = paramList == null ? new ArrayList() : paramList;
    }

    @Override
    public ICnfgTask[] getTasks(ArrayList paramList, ICnfgFeedback feedback) {
        this.setAvailableParams(paramList);
        ICnfgTask[] tasks = new ICnfgTask[]{new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgActionExternalProcess.this.getLabel();
            }

            @Override
            public String getDescription() {
                String desc = CnfgActionExternalProcess.this.getDesc();
                if (desc == null || desc != null && desc.length() == 0) {
                    return CnfgActionExternalProcess.this.getLabel();
                }
                return desc;
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                int retVal = CnfgActionExternalProcess.this.execute();
                if (retVal != 0) {
                    if (CnfgActionExternalProcess.this.m_sOutputFile != null) {
                        int BUFFERSIZE = 4096;
                        StringWriter writer = new StringWriter(BUFFERSIZE);
                        File output = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(CnfgActionExternalProcess.this.m_sOutputFile));
                        FileInputStream is = new FileInputStream(output);
                        BufferedReader in = new BufferedReader(new InputStreamReader(is));
                        if (in == null) {
                            Object[] messageArgs = new String[]{CnfgActionExternalProcess.this.m_sOutputFile};
                            String sMessage = CnfgResource.getMessage("Message.actionextps.nullIStream.notification", messageArgs);
                            CnfgLog.error("CnfgActionExternalProcess::run() - error is " + sMessage);
                            throw new DataManagerException(sMessage);
                        }
                        char[] cbuf = new char[BUFFERSIZE];
                        int size = 0;
                        while ((size = in.read(cbuf, 0, BUFFERSIZE)) != -1) {
                            writer.write(cbuf, 0, size);
                        }
                        in.close();
                        writer.flush();
                        feedback.showError(writer.toString());
                    } else {
                        feedback.showError(CnfgActionExternalProcess.this.m_sOutputErrorMsg);
                    }
                } else if (CnfgActionExternalProcess.this.m_sOutputMsg != null) {
                    feedback.showInformational(CnfgActionExternalProcess.this.m_sOutputMsg);
                }
                return retVal == 0;
            }

            @Override
            public boolean isMandatory() {
                String actionName = CnfgActionExternalProcess.this.getName();
                if (actionName != null && actionName.equals("unregister")) {
                    return CnfgActionExternalProcess.this.isMandatory();
                }
                return true;
            }
        }};
        return tasks;
    }

    private String resolveProcessName(String sOrigPath) {
        if (sOrigPath == null || sOrigPath.length() == 0) {
            return "";
        }
        String sOrigProcessName = "";
        String sExeFolderPath = "";
        int idxOrig1 = sOrigPath.lastIndexOf(47);
        int idxOrig2 = sOrigPath.lastIndexOf(92);
        if (idxOrig1 == -1 && idxOrig2 == -1) {
            sOrigProcessName = sOrigPath;
        } else {
            int idxOrig = idxOrig1 > idxOrig2 ? idxOrig1 : idxOrig2;
            sOrigProcessName = sOrigPath.substring(idxOrig + 1, sOrigPath.length());
            sExeFolderPath = sOrigPath.substring(0, idxOrig);
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("The original path is '" + sOrigPath + "'.");
            CnfgLog.debug("The original process name is '" + sOrigProcessName + "'.");
            CnfgLog.debug("The original folder path is '" + sExeFolderPath + "'.");
        }
        String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sExeFolderPath);
        String sExePath = "";
        sExePath = sResolvedPath != null && sResolvedPath.length() > 0 ? sResolvedPath + "/" + sOrigProcessName : sOrigProcessName;
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("The resloved folder path is '" + sResolvedPath + "'.");
            CnfgLog.debug("The resolved executable path is '" + sExePath + "'.");
        }
        return sExePath;
    }

    private int execute() throws Exception {
        try {
            String sProcessName = this.resolveProcessName((String)this.m_path.get(CnfgUtils.getPlatform()));
            ExternalProcess ep = new ExternalProcess(sProcessName, ExternalProcess.resolveArguments(this.m_arguments, this.m_lAvailableParams, this.m_valueMap, this.m_sContext));
            int retVal = ep.executeExternalProcess();
            if (retVal != 0) {
                this.m_sOutputErrorMsg = ep.getErrorMsg();
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Process output: " + ep.getErrorMsg());
            }
            return retVal;
        }
        catch (InterruptedException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(e);
            }
            return -1;
        }
    }
}

