/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionExternalProcess;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgActionSave;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.StringParameter;
import com.cognos.crconfig.data.service.CnfgServiceUtils;
import com.cognos.crconfig.data.service.ServiceManager;
import java.io.File;
import java.util.ArrayList;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CnfgActionGenCrypto
extends CnfgActionOld {
    @Override
    public void undo(ArrayList errorList) {
    }

    @Override
    public ICnfgTask[] getTasks(ArrayList paramList, ICnfgFeedback feedback) {
        ArrayList<ICnfgTask> list = new ArrayList<ICnfgTask>();
        if (DataManager.getInstance().isBTSVInstalled() && ServiceManager.getCBSRegName() != null && ServiceManager.isRegistered() && ServiceManager.isRunning()) {
            CnfgServiceUtils.createStopTask(list, null);
        }
        DataManager.getInstance().getAllServiceFoldersActions("stop", list, false);
        String sLabel = "Message.actiondecryptconfig.taskname";
        String sCurrentBaseJH = (String)CnfgPreferences.getInstance().getProperty("JavaHome", String.class);
        if (sCurrentBaseJH == null) {
            CnfgLog.error("CnfgActionGetCrypto::getTasks()::Decrypt the config. Unable to find a JavaHome property in the prefs file.");
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.actiondecryptconfig.taskname");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Message.actiondecryptconfig.taskname");
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    String sMsg = CnfgResource.getMessage("Message.actiondecryptconfig.jhnotdefined");
                    feedback.showError(sMsg);
                    return false;
                }
            });
            return this.convertToArray(list);
        }
        StringBuffer sExecPathWin = new StringBuffer();
        StringBuffer sExecPathUNIX = new StringBuffer();
        if (!CnfgActionGenCrypto.findJavaExecPath(sCurrentBaseJH, sExecPathWin, sExecPathUNIX)) {
            CnfgLog.error("CnfgActionGetCrypto::getTasks()::Unable to find the Java executable path. sExecPathWin is '" + sExecPathWin + "'. sExecPathUNIX is '" + sExecPathUNIX + "'. ");
            return new ICnfgTask[0];
        }
        StringBuffer sb = new StringBuffer("<action mandatory=\"true\" label=\"").append(sLabel).append("\" msgBase=\"cogconfig\"><path platform=\"win\" value=\"").append(sExecPathWin.toString()).append("\"/><path platform=\"unix\" value=\"").append(sExecPathUNIX.toString()).append("\"/><arguments><argument index=\"0\" reference=\"CLASSPATH_FLAG\" /><argument index=\"1\" reference=\"CLASSPATH_VALUE\" /><argument index=\"2\" reference=\"CLASSNAME\" /><argument index=\"3\" reference=\"EXPORT_FLAG\" /><argument index=\"4\" reference=\"EXPORT_VALUE\" /><argument index=\"5\" reference=\"NOLOCK_FLAG\" /></arguments><output>../logs/cogconfig_response.csv</output></action>");
        StringParameter cpFlag = new StringParameter("xsd", "string");
        cpFlag.setName("CLASSPATH_FLAG");
        cpFlag.setValue("-cp");
        paramList.add(cpFlag);
        StringParameter cpValue = new StringParameter("xsd", "string");
        cpValue.setName("CLASSPATH_VALUE");
        cpValue.setValue("." + File.pathSeparatorChar + "cclcfgmcf_mcf.jar" + File.pathSeparatorChar + "cogconfig.jar" + File.pathSeparatorChar + "cogconfigi.jar" + File.pathSeparatorChar + "dom4j.jar" + File.pathSeparatorChar + "cclcfgmcf.jar" + File.pathSeparatorChar + "cclcfgapi.jar" + File.pathSeparatorChar + "jcam_crypto.jar" + File.pathSeparatorChar + "i18nj.jar" + File.pathSeparatorChar + "icu4j.jar" + File.pathSeparatorChar + "commons-httpclient.jar" + File.pathSeparatorChar + "CognosIPF.jar" + File.pathSeparatorChar + "log4j-over-slf4j-1.7.35.jar" + File.pathSeparatorChar + "jcam_jni.jar" + File.pathSeparatorChar + "jdxslt.jar" + File.pathSeparatorChar + "commons-logging.jar" + File.pathSeparatorChar + "jcam_config_test.jar");
        paramList.add(cpValue);
        StringParameter className = new StringParameter("xsd", "string");
        className.setName("CLASSNAME");
        className.setValue("CRConfig");
        paramList.add(className);
        StringParameter exportFlag = new StringParameter("xsd", "string");
        exportFlag.setName("EXPORT_FLAG");
        exportFlag.setValue("-e");
        paramList.add(exportFlag);
        StringParameter exportValue = new StringParameter("xsd", "string");
        exportValue.setName("EXPORT_VALUE");
        exportValue.setValue("../configuration/cogstartup.xml");
        paramList.add(exportValue);
        StringParameter noLockFlag = new StringParameter("xsd", "string");
        noLockFlag.setName("NOLOCK_FLAG");
        noLockFlag.setValue("-nolockcheck");
        paramList.add(noLockFlag);
        CnfgActionExternalProcess ep = new CnfgActionExternalProcess();
        try {
            ep.load(DocumentHelper.parseText((String)sb.toString()).getRootElement());
        }
        catch (DocumentException e) {
            CnfgLog.error("CnfgActionGetCrypto::getTasks()::Decrypt the config - e is " + e.getLocalizedMessage());
            return new ICnfgTask[0];
        }
        ICnfgTask[] epTasks = ep.getTasks(paramList, feedback);
        for (int i = 0; i < epTasks.length; ++i) {
            list.add(epTasks[i]);
        }
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.actionbackupcrypto.taskname");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.actionbackupcrypto.taskname");
            }

            @Override
            public boolean isMandatory() {
                return true;
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
                Parameter[] params = new Parameter[]{DataManager.getInstance().findParm("CSKPath"), DataManager.getInstance().findParm("signKeyFile"), DataManager.getInstance().findParm("encryptKeyFile")};
                for (int i = 0; i < params.length; ++i) {
                    Object[] messageArgs;
                    File oldfile;
                    if (params[i] == null || params[i].getDisabled() || !(oldfile = new File(cfg.resolveEffectivePath((String)params[i].getValue()))).exists()) continue;
                    boolean bSuccess = true;
                    String sMsgDetail = null;
                    File newfile = new File(oldfile.getCanonicalPath() + ".bkup");
                    String s = CnfgUtils.delete(newfile);
                    if (s != null) {
                        sMsgDetail = s;
                        bSuccess = false;
                    }
                    if (bSuccess && !oldfile.renameTo(newfile)) {
                        messageArgs = new Object[]{newfile};
                        sMsgDetail = CnfgResource.getMessage("Message.actionbackupcrypto.renameerrordetail", messageArgs);
                        bSuccess = false;
                    }
                    if (bSuccess) continue;
                    messageArgs = new Object[]{oldfile};
                    String sMsg = CnfgResource.getMessage("Message.actionbackupcrypto.renameerror", messageArgs);
                    feedback.showError(sMsg + sMsgDetail);
                    return false;
                }
                File oldfile = new File(cfg.resolveEffectivePath("../configuration/caSerial"));
                if (oldfile.exists()) {
                    Object[] messageArgs;
                    boolean bSuccess = true;
                    String sMsgDetail = null;
                    File newfile = new File(oldfile.getCanonicalPath() + ".bkup");
                    String s = CnfgUtils.delete(newfile);
                    if (s != null) {
                        sMsgDetail = s;
                        bSuccess = false;
                    }
                    if (bSuccess && !oldfile.renameTo(newfile)) {
                        messageArgs = new Object[]{newfile};
                        sMsgDetail = CnfgResource.getMessage("Message.actionbackupcrypto.renameerrordetail", messageArgs);
                        bSuccess = false;
                    }
                    if (!bSuccess) {
                        messageArgs = new Object[]{oldfile};
                        String sMsg = CnfgResource.getMessage("Message.actionbackupcrypto.renameerror", messageArgs);
                        feedback.showError(sMsg + sMsgDetail);
                        return false;
                    }
                }
                DataManager.getInstance().resetCryptoHandles();
                DataManager.getInstance().reloadConfig();
                return true;
            }
        });
        String s2 = "<action mandatory=\"true\"><arguments><argument value=\"regenkeys\"/></arguments></action>";
        DataManager.getInstance().setConfigDirtyFlag(true, DataManager.getInstance().getAllServices());
        CnfgActionSave as = new CnfgActionSave();
        try {
            as.load(DocumentHelper.parseText((String)s2).getRootElement());
        }
        catch (DocumentException e) {
            CnfgLog.error("CnfgActionGetCrypto::getTasks()::Generate new crypto and encrypt the config - e is " + e.getLocalizedMessage());
            return new ICnfgTask[0];
        }
        ICnfgTask[] asTasks = as.getTasks(paramList, feedback);
        for (int i = 0; i < asTasks.length; ++i) {
            list.add(asTasks[i]);
        }
        return this.convertToArray(list);
    }

    ICnfgTask[] convertToArray(ArrayList list) {
        ICnfgTask[] tasks = new ICnfgTask[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tasks[i] = (ICnfgTask)list.get(i);
        }
        return tasks;
    }

    @Override
    public void load(Element elem) {
    }
}

