/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.dom4j.Element;

public class CnfgActionGenDB2DDL
extends CnfgActionOld {
    private static final String CREATEDB_SQL = "../configuration/schemas/content/db2/createDb.sql";
    private static final String CREATEDB_TEMPLATE = "../configuration/schemas/content/db2/createDb.sql.template";
    private static final String DBUSERID_TOKEN = "@DBUSERID@";
    private static final String DBNAME_TOKEN = "@DBNAME@";

    @Override
    public ICnfgTask[] getTasks(ArrayList paramList, ICnfgFeedback feedback) {
        Parameter p;
        ArrayList<ICnfgTask> taskList = new ArrayList<ICnfgTask>();
        DataManager dm = DataManager.getInstance();
        Folder f = dm.findComplexFolder("CM", true);
        String sValue = "";
        if (f != null) {
            Parameter p2 = f.findParm("name");
            sValue = (String)p2.getValue();
        }
        final String sDbName = sValue;
        sValue = "";
        if (f != null && (p = f.findParm("user")) != null && p.getClass().equals(CredentialParameter.class)) {
            sValue = ((CredentialParameter)p).getPart(true);
        }
        final String sDbUserID = sValue;
        taskList.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.gendb2ddl");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.gendb2ddl");
            }

            @Override
            public boolean isMandatory() {
                return true;
            }

            @Override
            public boolean run(Object[] arg0, ICnfgFeedback feedback) throws Exception {
                File backupFile;
                Thread.sleep(1000L);
                if (sDbName.length() == 0 || sDbUserID.length() == 0) {
                    feedback.showError(CnfgResource.getMessage("Message.gendb2ddl.error.infonotavailable"));
                    return false;
                }
                String sTemplateFile = CCLConfigurationFactory.getInstance().resolveEffectivePath(CnfgActionGenDB2DDL.CREATEDB_TEMPLATE);
                File templateFile = new File(sTemplateFile);
                if (!templateFile.exists()) {
                    Object[] args = new Object[]{sTemplateFile};
                    feedback.showError(CnfgResource.getMessage("Message.gendb2ddl.error.missingtemplate", args));
                    return false;
                }
                String sOutputFile = CCLConfigurationFactory.getInstance().resolveEffectivePath(CnfgActionGenDB2DDL.CREATEDB_SQL);
                File outputFile = new File(sOutputFile);
                File tempFile = File.createTempFile("cnfg", null, new File("../temp"));
                tempFile.deleteOnExit();
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(templateFile));
                    PrintWriter out = new PrintWriter(tempFile);
                    while ((line = in.readLine()) != null) {
                        String newValue = line;
                        int idx = newValue.indexOf(CnfgActionGenDB2DDL.DBNAME_TOKEN);
                        while (idx != -1) {
                            newValue = newValue.substring(0, idx) + sDbName + newValue.substring(idx + CnfgActionGenDB2DDL.DBNAME_TOKEN.length());
                            idx = newValue.indexOf(CnfgActionGenDB2DDL.DBNAME_TOKEN);
                        }
                        idx = newValue.indexOf(CnfgActionGenDB2DDL.DBUSERID_TOKEN);
                        while (idx != -1) {
                            newValue = newValue.substring(0, idx) + sDbUserID + newValue.substring(idx + CnfgActionGenDB2DDL.DBUSERID_TOKEN.length());
                            idx = newValue.indexOf(CnfgActionGenDB2DDL.DBUSERID_TOKEN);
                        }
                        out.println(newValue);
                    }
                    in.close();
                    out.flush();
                    out.close();
                    backupFile = new File(outputFile.getPath() + ".backup");
                    backupFile.delete();
                    outputFile.renameTo(backupFile);
                    if (!tempFile.renameTo(outputFile)) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("File.renameTo() failed to rename the temp file to the final output file (" + outputFile + ")");
                        }
                        feedback.showError(CnfgResource.getMessage("Message.gendb2ddl.error.unabletocreateddl"));
                        return false;
                    }
                }
                catch (Exception e) {
                    feedback.showError(CnfgResource.getMessage("Message.gendb2ddl.error.unabletocreateddl"));
                    throw e;
                }
                Object[] args1 = new Object[]{sOutputFile};
                feedback.showInformational(CnfgResource.getMessage("Message.gendb2ddl.success", args1));
                feedback.showInformational("\n");
                Object[] args2 = new Object[]{backupFile};
                feedback.showInformational(CnfgResource.getMessage("Message.gendb2ddl.info.bkupcreated", args2));
                return true;
            }
        });
        return CnfgTask.createTaskArray(taskList);
    }

    @Override
    public void load(Element elem) {
        this.loadCommon(elem);
    }

    @Override
    public void undo(ArrayList errorList) {
    }
}

