/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.ExternalProcess;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.websphere.WebSphereAdmin;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dom4j.Element;

public class CnfgActionInstallEAR
extends CnfgActionOld {
    static boolean gReinstall = false;

    @Override
    public ICnfgTask[] getTasks(ArrayList paramList, ICnfgFeedback feedback) {
        ArrayList<ICnfgTask> taskList = new ArrayList<ICnfgTask>();
        File earFileLocation = null;
        Hashtable<String, Parameter> paramMap = new Hashtable<String, Parameter>();
        for (int idx = 0; idx < paramList.size(); ++idx) {
            Parameter param = (Parameter)paramList.get(idx);
            paramMap.put(param.getName(), param);
        }
        ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
        earFileLocation = new File(cfg.resolveEffectivePath((String)((Parameter)paramMap.get("disp_location")).getValue()));
        if (earFileLocation == null || !earFileLocation.exists()) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("The application file '" + earFileLocation.getPath() + "' does not exist.");
            }
            return new ICnfgTask[0];
        }
        String tmpEarPath = new String(earFileLocation.getAbsolutePath());
        final String earPath = tmpEarPath.replace('\\', '/');
        Parameter wasPathParam = (Parameter)paramMap.get("WAS_path");
        final String wasPath = (String)wasPathParam.getValue();
        final String profile = (String)((Parameter)paramMap.get("WAS_serverProfile")).getValue();
        final String server = (String)((Parameter)paramMap.get("WAS_serverInstance")).getValue();
        final int maxMemory = ((BigInteger)((Parameter)paramMap.get("was_JVMHeapMaxMemory")).getValue()).intValue();
        taskList.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.install.check");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.install.check");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                WebSphereAdmin wasAdmin = new WebSphereAdmin(wasPath);
                String[] pArgs = wasAdmin.isAppInstalled(profile, "IBM Cognos");
                ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                p.executeExternalProcess();
                String output = p.getErrorMsg();
                if (output.indexOf("IBM Cognos") >= 0) {
                    Object[] msgArgs = new Object[]{"IBM Cognos"};
                    String sPromptSpec = "<prompt><caption>" + CnfgResource.getMessage("Message.was.install.check.prompt.title") + "</caption>" + "<default>1</default>" + "<paragraph addBlankLine=\"true\">" + CnfgResource.getMessage("Message.was.install.check.prompt.text", msgArgs) + "</paragraph>" + "<confirmation>" + CnfgResource.getMessage("Message.was.install.check.prompt.question") + "</confirmation>" + "<type>information</type><dialogType>yesno</dialogType></prompt>";
                    if (feedback.prompt(sPromptSpec).equals("0")) {
                        gReinstall = true;
                    } else {
                        feedback.showInformational(CnfgResource.getMessage("Message.was.abort.install"));
                        return false;
                    }
                }
                return true;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
        taskList.add(new CnfgTask(){

            @Override
            public String getLabel() {
                Object[] msgArgs = new Object[]{"IBM Cognos"};
                return CnfgResource.getMessage("Message.was.install.install", msgArgs);
            }

            @Override
            public String getDescription() {
                Object[] msgArgs = new Object[]{"IBM Cognos"};
                return CnfgResource.getMessage("Message.was.install.install", msgArgs);
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                Object[] msgArgs = new Object[]{earPath, server};
                feedback.showInformational(CnfgResource.getMessage("Message.was.install.install.info", msgArgs));
                WebSphereAdmin wasAdmin = new WebSphereAdmin(wasPath);
                String warFileName = null;
                Enumeration<? extends ZipEntry> entries = new ZipFile(earPath).entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    String zipEntryName = zipEntry.getName();
                    if (!zipEntryName.endsWith(".WAR") && !zipEntryName.endsWith(".war")) continue;
                    warFileName = zipEntryName;
                    break;
                }
                if (warFileName == null) {
                    Object[] msgArgs2 = new Object[]{earPath};
                    feedback.showError(CnfgResource.getMessage("Message.was.install.install.error.invalidear", msgArgs2));
                    return false;
                }
                String[] pArgs = wasAdmin.install(profile, server, "IBM Cognos", earPath, warFileName, gReinstall);
                ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                p.executeExternalProcess();
                String output = p.getErrorMsg();
                feedback.showInformational(output);
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug(output);
                }
                if (output.indexOf("ADMA5013I") >= 0) {
                    return true;
                }
                feedback.showError(CnfgResource.getMessage("Message.was.install.install.error"));
                return false;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
        taskList.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.install.update");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.install.update");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                WebSphereAdmin wasAdmin = new WebSphereAdmin(wasPath);
                String variableName = CnfgActionInstallEAR.getLibPathEnvVarName();
                String pathToCogInstall = DataManager.getPathToBinDir();
                String[] pArgs = wasAdmin.updateEnvForCognos(profile, server, variableName, pathToCogInstall, maxMemory);
                ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                p.executeExternalProcess();
                String output = p.getErrorMsg();
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug(output);
                }
                if (output.indexOf("Status Success") >= 0) {
                    Object[] msgArgs1 = new Object[]{variableName, pathToCogInstall};
                    Object[] msgArgs2 = new Object[]{maxMemory};
                    feedback.showInformational(CnfgResource.getMessage("Message.was.install.info1", msgArgs1));
                    feedback.showInformational(CnfgResource.getMessage("Message.was.install.info2", msgArgs2));
                    return true;
                }
                feedback.showError(CnfgResource.getMessage("Message.was.install.error"));
                feedback.showError(output);
                return false;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
        return CnfgTask.createTaskArray(taskList);
    }

    @Override
    public void load(Element elem) {
        this.loadCommon(elem);
    }

    @Override
    public void undo(ArrayList errorList) {
    }

    public static String getLibPathEnvVarName() {
        String varName = "PATH";
        String platfName = System.getProperty("os.name");
        if (platfName.equals("win")) {
            return varName;
        }
        if (platfName.equals("Linux") || platfName.equals("SunOS")) {
            varName = "LD_LIBRARY_PATH";
            return varName;
        }
        if (platfName.equals("AIX") || platfName.equals("z/OS")) {
            varName = "LIBPATH";
            return varName;
        }
        if (platfName.equals("HP-UX")) {
            varName = "SHLIB_PATH";
        }
        return varName;
    }
}

