/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class CnfgActionSave
extends CnfgActionOld {
    private String m_sArgument = "";

    @Override
    public void load(Element elem) {
        List argumentElems;
        this.loadCommon(elem);
        Element argumentsElem = elem.element("arguments");
        if (argumentsElem != null && (argumentElems = argumentsElem.elements("argument")).size() > 0) {
            Element argElem = (Element)argumentElems.get(0);
            this.m_sArgument = argElem.attributeValue("value", "");
        }
    }

    @Override
    public void undo(ArrayList errorList) {
        int beginIdx = errorList.size();
        Hashtable backedFileMap = DataManager.getInstance().getBackedupFilesMap();
        Set backedFiles = backedFileMap.keySet();
        for (String configFileName : backedFiles) {
            String fileName = (String)backedFileMap.get(configFileName);
            if (fileName.length() <= 0) continue;
            try {
                int len;
                File backedupFile = DataManager.getInstance().resolveEffectiveFilePath(fileName);
                if (!backedupFile.exists()) continue;
                FileInputStream in = new FileInputStream(backedupFile);
                FileOutputStream out = new FileOutputStream(configFileName.toString());
                byte[] buffer = new byte[16384];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                out.flush();
                out.close();
                in.close();
            }
            catch (Exception e) {
                CnfgLog.error(e);
                String sMessage = new StringBuffer("[").append(fileName).append("] ").append(e.getLocalizedMessage()).toString();
                errorList.add(sMessage);
            }
        }
        if (errorList.size() > beginIdx) {
            errorList.add(beginIdx, new StringBuffer(CnfgResource.getMessage("Message.action.save.undo.failed.notification")).append("\n").toString());
        }
    }

    private void createExportTask(ArrayList taskList) {
        File exportFile = new File("../configuration/cogstartup.xml");
        DataManager.getInstance().createValidationTask(taskList);
        DataManager.getInstance().createBackupTask(taskList);
        DataManager.getInstance().createExportConfigTask(taskList, exportFile);
    }

    private void createSaveTask(ArrayList taskList) {
        DataManager.getInstance().createValidationTask(taskList);
        DataManager.getInstance().createCryptoTask(taskList);
        DataManager.getInstance().createCheckEncryptedDataTask(taskList);
        DataManager.getInstance().createBackupTask(taskList);
        DataManager.getInstance().createSaveConfigTask(taskList);
        DataManager.getInstance().createSaveLocaleTask(taskList);
        DataManager.getInstance().createSaveAppSvrConfigTask(taskList);
    }

    private void createCustomSaveTask(ArrayList taskList, ICnfgFeedback feedback) {
        DataManager.getInstance().getCustomSaveTasks(taskList, feedback);
    }

    private void createGenCryptoActionTask(ArrayList taskList) {
        DataManager.getInstance().createValidationTask(taskList);
        DataManager.getInstance().createCryptoTask(taskList);
        DataManager.getInstance().createBackupTask(taskList);
        DataManager.getInstance().createSaveConfigTask(taskList);
    }

    @Override
    public ICnfgTask[] getTasks(ArrayList paramList, ICnfgFeedback feedback) {
        ArrayList<ICnfgTask> taskList = new ArrayList<ICnfgTask>();
        if (this.m_sArgument.length() == 0) {
            this.createSaveTask(taskList);
            this.createCustomSaveTask(taskList, feedback);
        } else if (this.m_sArgument.equalsIgnoreCase("export")) {
            this.createExportTask(taskList);
        } else if (this.m_sArgument.equalsIgnoreCase("regenkeys")) {
            this.createGenCryptoActionTask(taskList);
        }
        return CnfgTask.createTaskArray(taskList);
    }

    @Override
    public String getLabel() {
        String s = super.getLabel();
        if (s == null || s.length() == 0) {
            return CnfgResource.getMessage("Message.actionsave.actionlabel");
        }
        return s;
    }

    @Override
    public String getDesc() {
        String s = super.getDesc();
        if (s == null || s.length() == 0) {
            return CnfgResource.getMessage("Message.actionsave.actiondesc");
        }
        return s;
    }

    @Override
    public String getHelp() {
        String s = super.getHelp();
        if (s == null || s.length() == 0) {
            return CnfgResource.getMessage("Message.actionsave.actionhelp");
        }
        return s;
    }
}

