/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class CnfgActionTest {
    public static final String ELEM_PROVIDER = "provider";
    public static final String ELEM_JAVACLASS = "javaclass";
    public static final String ELEM_LOCATION = "location";
    public static final String ELEM_INCLUDEWEBINF = "includeWebInf";
    public static final String ELEM_INCLUDEJARPATH = "includeJarPath";
    public static final String ELEM_INCLUDECLASSPATH = "includeClassPath";
    public static final String ELEM_PREREQUISITES = "prerequisites";
    public static final String ELEM_PARAM = "param";
    public static final String ELEM_SERVICE = "service";
    public static final String ATTRIB_REFID = "refID";
    public static final String ATTRIB_ID = "id";
    public static final String ATTRIB_NAME = "name";
    public static final String ATTRIB_VALUE = "value";
    public static final String ATTRIB_ISRUNNING = "isRunning";
    public static final String ELEM_SAVEDCRYPTOREQUIREDBY = "savedCryptoRequiredBy";
    public static final String WILDCARD = "/*";
    private String m_providerName;
    private String m_id;
    private String m_refID;
    private URL[] m_urls;
    private String m_className;
    private Map<String, String> m_prereqParams;
    private Map<String, String> m_prereqServices;
    private String savedCryptoRequiredBy;
    private String parameterPath;

    public CnfgActionTest(Element actionElem, String parameterPath) {
        this(actionElem);
        this.parameterPath = parameterPath;
    }

    public CnfgActionTest(Element actionElem) {
        this.m_id = actionElem.attributeValue(ATTRIB_ID, "");
        this.m_refID = actionElem.attributeValue(ATTRIB_REFID);
        if (this.m_refID != null) {
            this.m_urls = null;
            return;
        }
        Element providerElem = actionElem.element(ELEM_PROVIDER);
        if (null != providerElem) {
            this.extractProviderConfiguration(providerElem);
        }
    }

    private void extractProviderConfiguration(Element providerElem) {
        this.m_className = this.extractJavaClassName(providerElem);
        if (null != this.m_className) {
            List<URL> locations = this.extractLocation(providerElem);
            this.includeDriversFolder(locations);
            this.extractIncludeWebInf(providerElem, locations);
            this.extractIncludeClassPath(providerElem, locations);
            this.extractIncludeJarPath(providerElem, locations);
            this.m_urls = new URL[locations.size()];
            locations.toArray(this.m_urls);
            this.extractPrerequisites(providerElem);
        }
    }

    private String extractJavaClassName(Element providerElem) {
        Element javaClassElem = providerElem.element(ELEM_JAVACLASS);
        String javaClassName = null;
        if (null != javaClassElem) {
            javaClassName = javaClassElem.getText();
        }
        return javaClassName;
    }

    private List<URL> extractLocation(Element providerElem) {
        Element locationElem = providerElem.element(ELEM_LOCATION);
        String location = null;
        if (null != locationElem) {
            location = locationElem.getText();
        }
        ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
        ArrayList<URL> locationURLs = new ArrayList<URL>();
        if (null != location && location.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(location, " ");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                String path = cfg.resolveEffectivePath("../bin/" + token);
                this.addFileURL(locationURLs, new File(path));
            }
        }
        return locationURLs;
    }

    private void includeDriversFolder(List<URL> locationURLs) {
        String sDriversFolder = CCLConfigurationUtils.resolveEffectivePath((String)"../drivers");
        File libdir = new File(sDriversFolder);
        File[] jarFiles = libdir.listFiles(new jarFileFilter());
        if (null != jarFiles && jarFiles.length > 0) {
            for (int iFile = 0; iFile < jarFiles.length; ++iFile) {
                File file = jarFiles[iFile];
                this.addFileURL(locationURLs, file);
            }
        }
    }

    private void extractIncludeWebInf(Element providerElem, List<URL> locationURLs) {
        Element includeWebInfElem = providerElem.element(ELEM_INCLUDEWEBINF);
        if (null != includeWebInfElem) {
            boolean bIncludeWebInf;
            String sWebInf = includeWebInfElem.getText();
            boolean bl = bIncludeWebInf = sWebInf.length() > 0 && sWebInf.equalsIgnoreCase("true");
            if (bIncludeWebInf) {
                String sWebInfClasses = CCLConfigurationUtils.resolveEffectivePath((String)"../webapps/p2pd/WEB-INF/classes");
                this.addFileURL(locationURLs, new File(sWebInfClasses));
                String sWebInfLib = CCLConfigurationUtils.resolveEffectivePath((String)"../webapps/p2pd/WEB-INF/lib");
                File libdir = new File(sWebInfLib);
                File[] jarFiles = libdir.listFiles(new jarFileFilter());
                if (null != jarFiles && jarFiles.length > 0) {
                    for (int iFile = 0; iFile < jarFiles.length; ++iFile) {
                        File file = jarFiles[iFile];
                        this.addFileURL(locationURLs, file);
                    }
                }
            }
        }
    }

    private void extractIncludeClassPath(Element providerElem, List<URL> locationURLs) {
        Element includeClassPathElem = providerElem.element(ELEM_INCLUDECLASSPATH);
        if (null != includeClassPathElem) {
            String sPaths = includeClassPathElem.getText();
            StringTokenizer tk = new StringTokenizer(sPaths);
            while (tk.hasMoreTokens()) {
                String pathToAdd = CCLConfigurationUtils.resolveEffectivePath((String)tk.nextToken());
                this.addFileURL(locationURLs, new File(pathToAdd));
            }
        }
    }

    private void extractIncludeJarPath(Element providerElem, List<URL> locationURLs) {
        Element includeJarPathElem = providerElem.element(ELEM_INCLUDEJARPATH);
        if (null != includeJarPathElem) {
            String sPath = includeJarPathElem.getText();
            StringTokenizer tk = new StringTokenizer(sPath);
            while (tk.hasMoreTokens()) {
                String pathToAdd = CCLConfigurationUtils.resolveEffectivePath((String)tk.nextToken());
                File libdir = new File(pathToAdd);
                File[] jarFiles = libdir.listFiles(new jarFileFilter());
                if (null == jarFiles || jarFiles.length <= 0) continue;
                for (int iFile = 0; iFile < jarFiles.length; ++iFile) {
                    File file = jarFiles[iFile];
                    this.addFileURL(locationURLs, file);
                }
            }
        }
    }

    private void extractPrerequisites(Element providerElem) {
        Element prereqElem = providerElem.element(ELEM_PREREQUISITES);
        if (null != prereqElem) {
            this.extractParamPrereq(prereqElem);
            this.extractServicePrereq(prereqElem);
            this.extractSavedCryptoRequired(prereqElem);
        }
    }

    private void extractParamPrereq(Element prereqElem) {
        List paramElems = prereqElem.elements(ELEM_PARAM);
        if (paramElems != null && paramElems.size() > 0) {
            this.m_prereqParams = new HashMap<String, String>(3);
            for (Element paramElem : paramElems) {
                Attribute paramNameAttr = paramElem.attribute(ATTRIB_NAME);
                Attribute paramValueAttr = paramElem.attribute(ATTRIB_VALUE);
                if (paramNameAttr == null || paramValueAttr == null) continue;
                String paramName = paramNameAttr.getValue();
                String paramValue = paramValueAttr.getValue();
                this.m_prereqParams.put(paramName, paramValue);
            }
        }
    }

    private void extractServicePrereq(Element prereqElem) {
        List serviceElems = prereqElem.elements(ELEM_SERVICE);
        if (serviceElems != null && serviceElems.size() > 0) {
            this.m_prereqServices = new HashMap<String, String>(2);
            for (Element serviceElem : serviceElems) {
                Attribute serviceNameAttr = serviceElem.attribute(ATTRIB_NAME);
                Attribute serviceIsRunningAttr = serviceElem.attribute(ATTRIB_ISRUNNING);
                if (serviceNameAttr == null || serviceIsRunningAttr == null) continue;
                String serviceName = serviceNameAttr.getValue();
                String serviceValue = serviceIsRunningAttr.getValue();
                this.m_prereqServices.put(serviceName, serviceValue);
            }
        }
    }

    private void extractSavedCryptoRequired(Element prereqElem) {
        Element savedCrypto = prereqElem.element(ELEM_SAVEDCRYPTOREQUIREDBY);
        if (savedCrypto != null) {
            this.savedCryptoRequiredBy = savedCrypto.getText();
        }
    }

    public String getParameterPath() {
        return this.parameterPath;
    }

    public void addFileURL(List<URL> urlList, File f) {
        block3: {
            if (f == null) {
                return;
            }
            try {
                urlList.add(f.toURL());
            }
            catch (MalformedURLException e) {
                if (!CnfgLog.isDebugEnabled()) break block3;
                CnfgLog.debug("An invalid location token was specified for action 'test' with provider '" + this.m_providerName + "'.  Token: " + f.getName());
            }
        }
    }

    public URL[] getURLs() {
        return this.m_urls;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getProvider() {
        return this.m_providerName;
    }

    public String getID() {
        return this.m_id;
    }

    public String getRefID() {
        return this.m_refID;
    }

    public Map<String, String> getPrerequisiteParams() {
        return this.m_prereqParams;
    }

    public Map<String, String> getPrerequisiteServices() {
        return this.m_prereqServices;
    }

    public boolean matchSavedCryptoRequiredBy(String paramFolderPath) {
        if (this.savedCryptoRequiredBy.endsWith(WILDCARD)) {
            int indOfWildcard = this.savedCryptoRequiredBy.indexOf(WILDCARD);
            return paramFolderPath.startsWith(this.savedCryptoRequiredBy.substring(0, indOfWildcard));
        }
        return this.savedCryptoRequiredBy.equals(paramFolderPath);
    }

    public boolean isSavedCryptoRequired() {
        return this.savedCryptoRequiredBy != null;
    }

    public class jarFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            if (new File(dir, name).isDirectory()) {
                return false;
            }
            return (name = name.toLowerCase()).endsWith(".jar") || name.endsWith(".zip");
        }
    }
}

