/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.ExternalProcess;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.websphere.WebSphereAdmin;
import java.util.ArrayList;
import org.dom4j.Element;

public class CnfgActionUninstallCognos
extends CnfgActionOld {
    private static boolean bAbortUninstall = false;

    @Override
    public void load(Element elem) {
        this.loadCommon(elem);
    }

    @Override
    public ICnfgTask[] getTasks(ArrayList paramList, ICnfgFeedback feedback) {
        String value;
        bAbortUninstall = false;
        ArrayList<ICnfgTask> taskList = new ArrayList<ICnfgTask>();
        DataManager dm = DataManager.getInstance();
        Parameter p = dm.findParm("WAS_path");
        final String sWASPath = value = (String)p.getValue();
        p = dm.findParm("WAS_serverProfile");
        final String sWASProfile = value = (String)p.getValue();
        taskList.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.uninstall.confirm.label");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.uninstall.confirm.label");
            }

            @Override
            public boolean run(Object[] arg0, ICnfgFeedback feedback) throws Exception {
                Object[] args = new String[]{sWASProfile};
                boolean bResponse = feedback.promptForConfirmation(CnfgResource.getMessage("Message.was.uninstall.confirm.question", args));
                if (!bResponse) {
                    feedback.showWarning(CnfgResource.getMessage("Message.was.uninstall.confirm.info"));
                    bAbortUninstall = true;
                }
                return true;
            }
        });
        taskList.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.was.uninstall.uninstall");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Message.was.uninstall.uninstall");
            }

            @Override
            public boolean run(Object[] arg0, ICnfgFeedback feedback) throws Exception {
                if (bAbortUninstall) {
                    feedback.showWarning(CnfgResource.getMessage("Message.was.uninstall.uninstall.info"));
                    return false;
                }
                WebSphereAdmin wasAdmin = new WebSphereAdmin(sWASPath);
                String[] pArgs = wasAdmin.uninstall(sWASProfile, "IBM Cognos");
                ExternalProcess p = new ExternalProcess(pArgs[0], pArgs, wasAdmin.getWaitInterval(), wasAdmin.getMaxTries());
                p.executeExternalProcess();
                String output = p.getErrorMsg();
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug(output);
                }
                if (output.indexOf("ADMA5106I") != -1) {
                    feedback.showInformational(CnfgResource.getMessage("Message.was.uninstall.uninstall.success"));
                    return true;
                }
                feedback.showError(CnfgResource.getMessage("Message.was.uninstall.uninstall.failure"));
                feedback.showInformational(output);
                return false;
            }
        });
        return CnfgTask.createTaskArray(taskList);
    }

    @Override
    public void undo(ArrayList errorList) {
    }
}

