/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CRConfigFrame;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgActionWizJRE;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.test.TestTaskManager;
import com.ibm.cognos.conformance.CNFMCheckResult;
import com.ibm.cognos.conformance.CNFMOSChecking;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class CnfgActionVerifyCNFM
extends CnfgActionOld {
    private String m_sArgument;

    @Override
    public ICnfgTask[] getTasks(ArrayList paramList, ICnfgFeedback feedback) {
        ArrayList<ICnfgTask> tasklist = new ArrayList<ICnfgTask>();
        for (int idx = 0; idx < paramList.size(); ++idx) {
            boolean bCheckWAS;
            boolean bCheckDB;
            Object oValue;
            Parameter param = (Parameter)paramList.get(idx);
            if (this.m_sArgument.equalsIgnoreCase("os") && param.getName().equalsIgnoreCase("os")) {
                boolean bCheckOS;
                oValue = param.getValue();
                if (oValue == null || !(bCheckOS = ((Boolean)oValue).booleanValue())) continue;
                tasklist.add(this.getOSCheckingTask());
                continue;
            }
            if (this.m_sArgument.equalsIgnoreCase("jre") && param.getName().equalsIgnoreCase("jre")) {
                boolean bCheckJRE;
                oValue = param.getValue();
                if (oValue == null || !(bCheckJRE = ((Boolean)oValue).booleanValue())) continue;
                this.getJRECheckingTask(tasklist, feedback);
                continue;
            }
            if (this.m_sArgument.equalsIgnoreCase("auditdb") && param.getName().equalsIgnoreCase("auditdb")) {
                oValue = param.getValue();
                if (oValue == null || !(bCheckDB = ((Boolean)oValue).booleanValue())) continue;
                this.getAuditDBCheckingTask(tasklist, feedback);
                continue;
            }
            if (this.m_sArgument.equalsIgnoreCase("authprovider") && param.getName().equalsIgnoreCase("authprovider")) {
                oValue = param.getValue();
                if (oValue == null || !(bCheckDB = ((Boolean)oValue).booleanValue())) continue;
                this.getAuthProviderCheckingTask(tasklist, feedback);
                continue;
            }
            if (this.m_sArgument.equalsIgnoreCase("cmdb") && param.getName().equalsIgnoreCase("cmdb")) {
                oValue = param.getValue();
                if (oValue == null || !(bCheckDB = ((Boolean)oValue).booleanValue())) continue;
                this.getCMDBCheckingTask(tasklist, feedback);
                continue;
            }
            if (!this.m_sArgument.equalsIgnoreCase("appwas") || !param.getName().equalsIgnoreCase("appwas") || (oValue = param.getValue()) == null || !(bCheckWAS = ((Boolean)oValue).booleanValue())) continue;
            this.getWASCheckingTask(tasklist, feedback);
        }
        return CnfgTask.createTaskArray(tasklist);
    }

    private void getJRECheckingTask(ArrayList<ICnfgTask> tasklist, ICnfgFeedback feedback) {
        CnfgActionWizJRE action = new CnfgActionWizJRE();
        ICnfgTask[] tasks = ((CnfgActionOld)action).getTasks(null, null);
        if (tasks != null) {
            for (int i = 0; i < tasks.length; ++i) {
                CnfgTask t = new CnfgTask(tasks[i]);
                tasklist.add(t);
            }
        }
    }

    private void getCNFMCheckingTask(ArrayList<ICnfgTask> tasklist, ICnfgFeedback feedback, Object obj) {
        DataManager.getInstance().setIsCNFMCheckingViaTestActionEnabled(true);
        try {
            Map<String, ICnfgTest> map = TestTaskManager.getTestTasks(CRConfigFrame.getInstance(), obj, tasklist, false, false, false, feedback, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DataManager.getInstance().setIsCNFMCheckingViaTestActionEnabled(false);
    }

    private void getAuditDBCheckingTask(ArrayList<ICnfgTask> tasklist, ICnfgFeedback feedback) {
        Folder ipfFolder = DataManager.getInstance().findFolder("IPF", true);
        this.getCNFMCheckingTask(tasklist, feedback, ipfFolder);
    }

    private void getCMDBCheckingTask(ArrayList<ICnfgTask> tasklist, ICnfgFeedback feedback) {
        Folder cmFolder = DataManager.getInstance().findFolder("CM", true);
        this.getCNFMCheckingTask(tasklist, feedback, cmFolder);
    }

    private void getAuthProviderCheckingTask(ArrayList<ICnfgTask> tasklist, ICnfgFeedback feedback) {
        Folder aaaFolder = DataManager.getInstance().findFolder("AAA", true);
        this.getCNFMCheckingTask(tasklist, feedback, aaaFolder);
    }

    private void getWASCheckingTask(ArrayList<ICnfgTask> tasklist, ICnfgFeedback feedback) {
        Folder wasFolder = DataManager.getInstance().findFolder("CBS", true);
        this.getCNFMCheckingTask(tasklist, feedback, wasFolder);
    }

    private CnfgTask getOSCheckingTask() {
        CnfgTask task = new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgActionVerifyCNFM.this.getLabel();
            }

            @Override
            public String getDescription() {
                String desc = CnfgActionVerifyCNFM.this.getDesc();
                if (desc == null || desc != null && desc.length() == 0) {
                    return CnfgActionVerifyCNFM.this.getLabel();
                }
                return desc;
            }

            @Override
            public boolean isMandatory() {
                return false;
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                boolean result = false;
                try {
                    CNFMOSChecking osChecking = new CNFMOSChecking();
                    CNFMCheckResult checkResult = osChecking.validate();
                    if (checkResult != null) {
                        result = checkResult.isCheckingOk();
                        if (result) {
                            feedback.showInformational(checkResult.buildOutput());
                        } else {
                            feedback.showWarning(checkResult.buildOutput());
                        }
                    } else {
                        feedback.showWarning("Unable to verify the operating system.");
                        result = false;
                    }
                }
                catch (Exception e) {
                    feedback.showError("Unable to verify the operating system.");
                    result = false;
                }
                return result;
            }
        };
        return task;
    }

    @Override
    public void load(Element elem) {
        this.loadCommon(elem);
        Element argumentsElem = elem.element("arguments");
        if (argumentsElem != null) {
            List argumentElems = argumentsElem.elements("argument");
            for (int i = 0; i < argumentElems.size(); ++i) {
                Element argElem = (Element)argumentElems.get(i);
                String argName = argElem.attributeValue("name", "");
                if (argName.length() != 0) continue;
                this.m_sArgument = argElem.attributeValue("value", "");
            }
        }
    }

    @Override
    public void undo(ArrayList errorList) {
    }
}

