/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ElementObject;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.ibm.bi.configutil.ConfigUtilHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class CnfgDataUtils {
    public static boolean isLocal(String hostnameOrIP) throws UnknownHostException, SocketException {
        if (hostnameOrIP.equals("localhost") || hostnameOrIP.equals("127.0.0.1")) {
            return true;
        }
        InetAddress serverAddress = null;
        serverAddress = InetAddress.getByName(hostnameOrIP);
        if (serverAddress.isLoopbackAddress()) {
            return true;
        }
        InetAddress localhost = null;
        String sHostname = serverAddress.getHostName();
        InetAddress[] potentialMatch = InetAddress.getAllByName(sHostname);
        localhost = InetAddress.getLocalHost();
        for (int i = 0; i < potentialMatch.length; ++i) {
            if (!localhost.equals(potentialMatch[i])) continue;
            return true;
        }
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) {
            Enumeration<InetAddress> interfaceAddresses = null;
            NetworkInterface networkInterface = null;
            InetAddress interfaceAddress = null;
            while (interfaces.hasMoreElements()) {
                networkInterface = interfaces.nextElement();
                interfaceAddresses = networkInterface.getInetAddresses();
                if (interfaceAddresses == null) continue;
                while (interfaceAddresses.hasMoreElements()) {
                    interfaceAddress = interfaceAddresses.nextElement();
                    if (serverAddress.equals(interfaceAddress)) {
                        return true;
                    }
                    String numericAddress = interfaceAddress.getHostAddress();
                    if (!serverAddress.equals(interfaceAddress = numericAddress.indexOf(46) > 0 ? InetAddress.getByName("[::" + numericAddress + "]") : InetAddress.getByName("[" + numericAddress + "]"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean validateServerNameAsLocal(String sServer) {
        boolean valid = false;
        try {
            valid = CnfgDataUtils.isLocal(sServer);
        }
        catch (Exception e) {
            CnfgLog.error("CnfgDataUtils::validateServerName(" + sServer + ") exception - '" + e.getClass() + "' message is '" + e.getMessage() + "'.");
        }
        return valid;
    }

    public static int getBasePortNumber(String sDispParam) {
        if (sDispParam != null) {
            Folder rootFolder = DataManager.getInstance().getRootFolder();
            Parameter p = rootFolder.findParm(sDispParam);
            return CnfgDataUtils.extractPortFromLocalURL(p);
        }
        return -1;
    }

    public static int extractPortFromLocalURL(Parameter p) {
        StringTokenizer tokens;
        String dispURI;
        if (null != p && !p.getDisabled() && p.getVisibility() && null != (dispURI = (String)p.getValue()) && (tokens = new StringTokenizer(dispURI, ":")).countTokens() >= 3) {
            tokens.nextToken();
            String hostName = tokens.nextToken().substring(2);
            if (hostName.startsWith("[")) {
                hostName = hostName + tokens.nextToken("]") + "]";
            }
            boolean local = false;
            try {
                local = CnfgDataUtils.isLocal(hostName);
            }
            catch (Exception e) {
                CnfgLog.error(e);
            }
            if (local) {
                StringTokenizer tokens2;
                String portAndRest = tokens.nextToken(":");
                if (hostName.startsWith("[")) {
                    portAndRest = tokens.nextToken();
                }
                if ((tokens2 = new StringTokenizer(portAndRest, "/")).countTokens() > 0) {
                    return Integer.parseInt(tokens2.nextToken());
                }
            }
        }
        return -1;
    }

    public static int getStandalonePortNumber() {
        Parameter portParam = DataManager.getInstance().findParam("webServicePort");
        int iPort = -1;
        if (portParam != null && !portParam.getDisabled() && portParam.getVisibility()) {
            iPort = ((BigInteger)portParam.getValue()).intValue();
        }
        return iPort;
    }

    public static ElementObject buildCredentialValueElem(String username, String password) {
        if (username != null && password != null) {
            Element value_elem = DocumentHelper.createElement((QName)DataManager.getInstance().m_qnValue);
            Element credential_elem = CredentialParameter.buildCredentials(username, password);
            value_elem.add(credential_elem);
            return new ElementObject(value_elem);
        }
        return null;
    }

    public static boolean removeElement(Document webXMLDoc, String parentTag, String Tag2, String value) throws DataManagerException {
        if (webXMLDoc != null) {
            Element rootElem = webXMLDoc.getRootElement();
            List servlets = rootElem.elements(parentTag);
            for (Element elem : servlets) {
                Element name = elem.element(Tag2);
                if (name == null || !name.getText().equals(value)) continue;
                rootElem.remove(elem);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupNUpdateFile(String xmlContent, String fileName) throws DataManagerException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddkkmmss");
        String timeStamp = formatter.format(new Date());
        OutputStream os = null;
        try {
            CnfgDataUtils.backupFile(timeStamp, fileName, ".xml");
            File webXMLFile = DataManager.getInstance().resolveEffectiveFilePath(fileName);
            os = new FileOutputStream(webXMLFile);
            os.write(xmlContent.getBytes());
            os.flush();
        }
        catch (FileNotFoundException e1) {
            CnfgLog.error(e1);
        }
        catch (IOException e2) {
            CnfgLog.error(e2);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    CnfgLog.error(e);
                }
            }
        }
    }

    public static String backupFile(String timeStamp, String fileName, String fileExt) throws DataManagerException {
        try {
            File originalFile = DataManager.getInstance().resolveEffectiveFilePath(fileName);
            if (originalFile.exists()) {
                int len;
                String originalFileName = originalFile.getName();
                StringBuffer backupFileName = new StringBuffer(fileName.length() + 15);
                backupFileName.append(originalFile.getParent());
                backupFileName.append(File.separator);
                backupFileName.append(originalFileName.substring(0, originalFileName.lastIndexOf(fileExt)));
                backupFileName.append('_');
                backupFileName.append(timeStamp);
                backupFileName.append(fileExt);
                FileInputStream in = new FileInputStream(originalFile);
                FileOutputStream out = new FileOutputStream(backupFileName.toString());
                byte[] buffer = new byte[16384];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                out.flush();
                out.close();
                in.close();
                return backupFileName.toString();
            }
        }
        catch (IOException e) {
            CnfgLog.error(e);
            String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).toString();
            throw new DataManagerException(sMessage);
        }
        return fileName;
    }

    public static void setHostName(Parameter pHostName, String[] hostValues) {
        Object value;
        if (!(null == pHostName || pHostName.getDisabled() || (value = pHostName.getValue()) != null && value.toString().length() != 0)) {
            if (hostValues == null) {
                hostValues = new String[]{"", "", ""};
                try {
                    hostValues = ConfigUtilHelper.getFQDNHost();
                }
                catch (Exception e) {
                    CnfgLog.error("Exception when try to getFQDNHost - " + e.toString());
                }
            }
            try {
                if (!hostValues[1].isEmpty()) {
                    pHostName.setValue(hostValues[1]);
                } else if (!hostValues[0].isEmpty()) {
                    pHostName.setValue(hostValues[0]);
                } else if (!hostValues[2].equalsIgnoreCase("localhost")) {
                    pHostName.setValue(hostValues[2]);
                }
            }
            catch (Exception e) {
                CnfgLog.error("Exception when try to populateHostName - " + e.toString());
            }
        }
    }

    public static void setLocalHostName(Parameter pHostName, boolean bOverwrite) {
        if (pHostName != null && !pHostName.getDisabled()) {
            String host = (String)pHostName.getValue();
            if (!bOverwrite && host != null && !host.isEmpty()) {
                return;
            }
            String sHostName = "localhost";
            try {
                sHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                CnfgLog.error("populateHostNameParameter() - exception to get local host name. " + e);
                sHostName = "localhost";
            }
            pHostName.setValue(sHostName);
        }
    }

    public static ArrayList<URL> getURIListOfCM() {
        ArrayList<URL> cmurlList = new ArrayList<URL>();
        Parameter cmsParm = DataManager.getInstance().findParm("contentManagers");
        if (cmsParm != null) {
            ArrayParameter arrayParm = (ArrayParameter)cmsParm;
            Set<Parameter> values = arrayParm.getCurrentValues();
            for (Parameter parm : values) {
                URL baseurl;
                String value = (String)parm.getValue();
                if (value == null || value.length() <= 0 || (baseurl = CnfgDataUtils.getHostPortFromURL(value)) == null) continue;
                cmurlList.add(baseurl);
            }
        }
        return cmurlList;
    }

    public static URL getHostPortFromURL(String urlstr) {
        try {
            URL url = new URL(urlstr);
            String hoststr = url.getHost();
            int port = url.getPort();
            String protocol = url.getProtocol();
            if (StringUtils.isEmpty((String)hoststr) || port <= 0 || StringUtils.isEmpty((String)protocol)) {
                CnfgLog.error("getHostPortFromURL() - the url '" + urlstr + "' is not a valid base url.");
                return null;
            }
            return new URL(protocol + "://" + hoststr + ":" + port);
        }
        catch (MalformedURLException e) {
            CnfgLog.error("getHostPortFromURL() - MalformedURLException when get baseurl from '" + urlstr + "'. - " + e);
            return null;
        }
    }

    public static URL getURLParamValue(String paramName) {
        String value;
        Parameter urlParm = DataManager.getInstance().findParm(paramName);
        if (urlParm != null && (value = (String)urlParm.getValue()) != null && value.length() > 0) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                CnfgLog.error("getURLParamValue() - MalformedURLException when get baseurl from '" + value + "'. - " + e);
            }
        }
        return null;
    }

    public static String getWebXMLDescVersion(Document webXMLDoc) {
        Element descElem;
        Element rootElem;
        String descString = "";
        if (webXMLDoc != null && (rootElem = webXMLDoc.getRootElement()) != null && (descElem = rootElem.element("description")) != null) {
            descString = descElem.getText();
        }
        return descString;
    }

    protected static Element createWebXMLElem(String elemName) {
        Namespace webxmlns = DocumentHelper.createNamespace((String)"", (String)"http://java.sun.com/xml/ns/javaee");
        QName qname = DocumentHelper.createQName((String)elemName, (Namespace)webxmlns);
        return DocumentHelper.createElement((QName)qname);
    }

    protected static void updateWebXMLDesc(Element rootElem) {
        String newdesc = CnfgDataUtils.buildWEBXMLDesc();
        Element descElem = rootElem.element("description");
        if (descElem != null) {
            descElem.setText(newdesc);
        } else {
            Element desc_elem = CnfgDataUtils.createWebXMLElem("description");
            desc_elem.addText(newdesc);
            rootElem.add(desc_elem);
        }
    }

    public static void upgradeWebXML(Document webXMLDoc) {
        if (webXMLDoc != null) {
            Element rootElem = webXMLDoc.getRootElement();
            CnfgDataUtils.upgradeWebXMLClassLoader(rootElem);
            CnfgDataUtils.upgradeWebXMLCAMServlet(rootElem);
            CnfgDataUtils.updateWebXMLDesc(rootElem);
        }
    }

    public static void upgradeWebXMLClassLoader(Element rootElem) {
        List servlets = rootElem.elements("servlet");
        for (Element servletElem : servlets) {
            String servletCls;
            Node servletClsNode = servletElem.selectSingleNode("./*[local-name() = 'servlet-class'][text()[contains(.,'ServletWrapper')]]");
            if (servletClsNode == null) continue;
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("found servlet to to updated: " + servletClsNode.getText());
            }
            if ((servletCls = CnfgDataUtils.upgradeServletClass(servletElem)) == null) continue;
            Element servletClsElem = (Element)servletClsNode;
            servletClsElem.setText(servletCls);
        }
    }

    public static String buildWEBXMLDesc() {
        return "IBM Cognos ver_11.1.6.0";
    }

    public static void upgradeWebXMLCAMServlet(Element rootElem) {
        CnfgLog.error("upgradeWebXMLCAMServlet -  start upgrade");
        CnfgDataUtils.addCAMServletElem(rootElem);
        CnfgDataUtils.addCAMServletMappingElem(rootElem);
    }

    protected static void addCAMServletElem(Element rootElem) {
        Node servletCAMNode = rootElem.selectSingleNode("//servlet/servlet-name[text()='CAM']");
        if (servletCAMNode == null) {
            CnfgLog.error("addCAMServletElem -  start upgrade");
            Element servlet_elem = CnfgDataUtils.createWebXMLElem("servlet");
            Element servletname_elem = CnfgDataUtils.createWebXMLElem("servlet-name");
            servletname_elem.addText("CAM");
            servlet_elem.add(servletname_elem);
            Element servletcls_elem = CnfgDataUtils.createWebXMLElem("servlet-class");
            servletcls_elem.addText("com.ibm.cognos.camaaa.internal.common.service.CAMStandAloneServlet");
            servlet_elem.add(servletcls_elem);
            Element loadon_elem = CnfgDataUtils.createWebXMLElem("load-on-startup");
            loadon_elem.addText("150");
            servlet_elem.add(loadon_elem);
            rootElem.add(servlet_elem);
        }
    }

    protected static void addCAMServletMappingElem(Element rootElem) {
        Node servletMappingCAMNode = rootElem.selectSingleNode("//servlet-mapping/servlet-name[text()='CAM']");
        if (servletMappingCAMNode == null) {
            CnfgLog.error("addCAMServletMappingElem -  start upgrade");
            Element servletmapping_elem = CnfgDataUtils.createWebXMLElem("servlet-mapping");
            Element servletname_elem = CnfgDataUtils.createWebXMLElem("servlet-name");
            servletname_elem.addText("CAM");
            servletmapping_elem.add(servletname_elem);
            Element urlpattern_elem = CnfgDataUtils.createWebXMLElem("url-pattern");
            urlpattern_elem.addText("/cam/v1/*");
            servletmapping_elem.add(urlpattern_elem);
            rootElem.add(servletmapping_elem);
        }
    }

    protected static String upgradeServletClass(Element servletElem) {
        String servletClsValue = null;
        String initParamServletCls = CnfgDataUtils.getXPath("servlet-class");
        Element initParamElem = (Element)servletElem.selectSingleNode(initParamServletCls);
        if (initParamElem != null) {
            Element valueElem = (Element)initParamElem.selectSingleNode("./*[local-name() = 'param-value']");
            servletClsValue = valueElem.getText();
        }
        servletElem.remove(initParamElem);
        CnfgDataUtils.removeElement(servletElem, "classLoaderName");
        CnfgDataUtils.removeElement(servletElem, "classLoaderExclude");
        return servletClsValue;
    }

    private static void removeElement(Element servletElem, String name) {
        String xPath = CnfgDataUtils.getXPath(name);
        Node initParamElem = servletElem.selectSingleNode(xPath);
        if (initParamElem != null) {
            servletElem.remove(initParamElem);
        }
    }

    private static String getXPath(String name) {
        return "./*[local-name() = 'init-param'][descendant::*[local-name() = 'param-name'][contains(text(), '" + name + "')]]";
    }
}

