/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.AliasRoot;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.State;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ComplexFileURIParameter
extends Parameter {
    AliasRoot aliasRoot = new AliasRoot();
    State validationState = new State(State.OK);

    public ComplexFileURIParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    @Override
    public Object getValue() {
        return this.aliasRoot;
    }

    @Override
    public boolean setValue(Object value) {
        boolean validationResult = true;
        this.m_sBadValue = null;
        this.clearErrorMsg();
        this.aliasRoot = (AliasRoot)value;
        validationResult = this.validate(this.aliasRoot);
        if (!validationResult) {
            this.m_sBadValue = this.aliasRoot.toString();
        }
        if (this.m_bFireValueChanged) {
            CnfgValueChangedEvent vce = new CnfgValueChangedEvent(this);
            DataManager.getInstance().fireValueChanged(vce);
        }
        return validationResult;
    }

    @Override
    public boolean hasWarnings() {
        return this.validationState.isWarning();
    }

    @Override
    public boolean setValue(Element value_elem) {
        Namespace nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
        QName qnITEM = new QName("item", nsCRN);
        List itemElements = value_elem.elements(qnITEM);
        AliasRoot aliasRoot = new AliasRoot();
        for (Element itemElem : itemElements) {
            String name = itemElem.attributeValue("name");
            String text = itemElem.getText();
            if (name == null || text == null || name.isEmpty()) {
                return false;
            }
            if (name.equals("unixURI")) {
                aliasRoot.setUnixURI(text);
            }
            if (!name.equals("winURI")) continue;
            aliasRoot.setWindowsURI(text);
        }
        this.setValue(aliasRoot);
        return true;
    }

    @Override
    public boolean hasDefault() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return this.aliasRoot.isEmpty();
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        boolean success = super.load(parentFolder, elem);
        return success;
    }

    @Override
    public void write(Element value_elem, boolean bEncrypt, List<String> errors) throws DataManagerException {
        if (this.isBadValue()) {
            this.recordBadValue(errors);
        }
        Element parent = value_elem.getParent();
        parent.addAttribute("opaque", "true");
        if (this.aliasRoot.hasWindowsURI()) {
            this.addItemElement(value_elem, "winURI", this.aliasRoot.getWindowsURI());
        }
        if (this.aliasRoot.hasUnixURI()) {
            this.addItemElement(value_elem, "unixURI", this.aliasRoot.getUnixURI());
        }
    }

    public boolean validate(AliasRoot aliasRoot) {
        this.validationState = aliasRoot.validate();
        if (this.validationState.isError()) {
            this.addErrorMsg(this.validationState.getMessage());
            return false;
        }
        if (this.validationState.isWarning()) {
            this.addErrorMsg(this.validationState.getMessage());
        }
        return true;
    }

    void addItemElement(Element valueElement, String name, String uri) throws DataManagerException {
        Element itemElem = valueElement.addElement("crn:item");
        if (itemElem == null) {
            throw new DataManagerException(CnfgResource.getMessage("Message.errorOutOfMemory"));
        }
        itemElem.addAttribute("name", name);
        itemElem.addAttribute("xsi:type", "cfg:fileURI");
        Element value = itemElem.addText(uri);
        if (value == null) {
            throw new DataManagerException(CnfgResource.getMessage("Message.errorOutOfMemory"));
        }
    }

    List<String> recordBadValue(List<String> errors) throws DataManagerException {
        Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
        if (errors != null) {
            String sMessage = CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args);
            errors.add(sMessage);
            return errors;
        }
        StringBuffer sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args));
        throw new DataManagerException(sMessage.toString());
    }
}

