/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.data.AbstractData;
import com.cognos.crconfig.data.CnfgActionCustomSave;
import com.cognos.crconfig.data.CnfgActionExternalProcess;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgActionTest;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Group;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.TemplatedParameter;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public abstract class Container
extends AbstractData {
    protected List<CnfgActionTest> m_testActions = new ArrayList<CnfgActionTest>();
    protected List<CnfgActionCustomSave> m_customSaveActions = new ArrayList<CnfgActionCustomSave>();
    protected List<Folder> m_lFolders = new ArrayList<Folder>();
    protected List<Parameter> m_lParms = new ArrayList<Parameter>();
    protected ArrayList<TemplatedParameter> m_lTParms = new ArrayList();

    public final List<CnfgActionTest> getTestActions() {
        ArrayList<CnfgActionTest> tests = new ArrayList<CnfgActionTest>();
        if (this.getDisabled()) {
            return tests;
        }
        tests.addAll(this.m_testActions);
        for (Folder f : this.m_lFolders) {
            tests.addAll(f.getTestActions());
        }
        for (Parameter p : this.m_lParms) {
            tests.addAll(p.getTestActions());
        }
        return tests;
    }

    public final List<CnfgActionTest> getTestActions(String refID) {
        int i;
        ArrayList<CnfgActionTest> tests = new ArrayList<CnfgActionTest>();
        for (CnfgActionTest element : this.m_testActions) {
            if (!element.getID().equals(refID)) continue;
            tests.add(element);
        }
        for (i = 0; i < this.m_lFolders.size(); ++i) {
            Folder f = this.m_lFolders.get(i);
            tests.addAll(f.getTestActions(refID));
        }
        for (i = 0; i < this.m_lTParms.size(); ++i) {
            TemplatedParameter tp = this.m_lTParms.get(i);
            tests.addAll(tp.getTestActions(refID));
        }
        for (i = 0; i < this.m_lParms.size(); ++i) {
            Parameter p = this.m_lParms.get(i);
            tests.addAll(p.getParamTestActions(refID));
        }
        return tests;
    }

    public final List<CnfgActionCustomSave> getCustomSaveActions(String refID) {
        int i;
        ArrayList<CnfgActionCustomSave> saveActions = new ArrayList<CnfgActionCustomSave>();
        for (CnfgActionCustomSave element : this.m_customSaveActions) {
            if (!element.getID().equals(refID)) continue;
            saveActions.add(element);
        }
        for (i = 0; i < this.m_lFolders.size(); ++i) {
            Folder f = this.m_lFolders.get(i);
            saveActions.addAll(f.getCustomSaveActions(refID));
        }
        for (i = 0; i < this.m_lTParms.size(); ++i) {
            TemplatedParameter tp = this.m_lTParms.get(i);
            saveActions.addAll(tp.getCustomSaveActions(refID));
        }
        for (i = 0; i < this.m_lParms.size(); ++i) {
            Parameter p = this.m_lParms.get(i);
            saveActions.addAll(p.getParamCustomSaveActions(refID));
        }
        return saveActions;
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        this.m_parentFolder = parentFolder;
        this.m_sDocLink = elem.attributeValue("doclink", "");
        String sDependencies = elem.attributeValue("dependency", "");
        boolean disabled = !DataManager.getInstance().isInstalled(sDependencies) || null != this.m_parentFolder && this.m_parentFolder.getDisabled();
        this.setDisabled(disabled);
        Element parent = elem.getParent();
        if (parent != null && parent.getName() == "parameter") {
            this.m_sName = elem.getParent().attributeValue("name", "");
        }
        List actionElems = elem.elements("action");
        for (int i = 0; i < actionElems.size(); ++i) {
            Element actionElem = (Element)actionElems.get(i);
            CnfgActionOld action = null;
            String sType = actionElem.attributeValue("type", "externalprocess");
            String sDepends = actionElem.attributeValue("dependency", "");
            if (DataManager.getInstance().isInstalled(sDepends)) {
                if (sType.compareToIgnoreCase("externalprocess") == 0) {
                    action = new CnfgActionExternalProcess();
                    ((CnfgActionOld)action).load(actionElem);
                } else {
                    if (sType.compareToIgnoreCase("cnfg") != 0) continue;
                    String sName = actionElem.attributeValue("name");
                    if (null != sName && sName.equalsIgnoreCase("test")) {
                        this.m_testActions.add(new CnfgActionTest(actionElem, DataManager.buildPath(this)));
                    } else if (null != sName && sName.equalsIgnoreCase("save")) {
                        this.m_customSaveActions.add(new CnfgActionCustomSave(actionElem));
                    } else {
                        action = DataManager.getInstance().getBuiltinAction(sName, actionElem);
                    }
                }
            }
            if (action == null) continue;
            this.m_lActions.add(action);
        }
        boolean bIsVisible = true;
        String sViewList = elem.attributeValue("viewList", "");
        if (sViewList.length() == 0) {
            if (this.m_parentFolder != null) {
                bIsVisible = this.m_parentFolder.getVisibility();
            }
        } else {
            bIsVisible = DataManager.getInstance().isInCurrentView(sViewList);
        }
        this.setVisibility(bIsVisible);
        this.m_sMsgBase = elem.attributeValue("msgBase", "");
        if (this.m_sMsgBase.length() == 0 && this.m_parentFolder != null && this.m_parentFolder.m_sMsgBase != null && this.m_parentFolder.m_sMsgBase.length() != 0) {
            this.m_sMsgBase = this.m_parentFolder.m_sMsgBase;
        }
        CnfgUIDocResource.setResourceBundle(this.m_sMsgBase);
        this.m_sLabel = CnfgUIDocResource.getMessage(elem.attributeValue("label", ""), this.m_sMsgBase);
        this.m_sDesc = CnfgUIDocResource.getMessage(elem.attributeValue("description", ""), this.m_sMsgBase);
        this.m_sHelp = CnfgUIDocResource.getMessage(elem.attributeValue("help", ""), this.m_sMsgBase);
        String sRestartOnChange = elem.attributeValue("restartOnChange", "CBS");
        this.setRestartServicesList(DataManager.getInstance().getRestartServicesList(sRestartOnChange));
        return true;
    }

    protected void loadCommon(Folder aFolder, Element elem) {
        List lParamElems = elem.elements();
        for (int i = 0; i < lParamElems.size(); ++i) {
            boolean bSuccess;
            Element child_p_elem = (Element)lParamElems.get(i);
            if (child_p_elem.getQName().getName().equals("group")) {
                Group g = new Group();
                if (!g.load(this.m_parentFolder, child_p_elem)) continue;
                this.m_lParms.add(g);
                continue;
            }
            Parameter p = DataManager.getInstance().createParameter(child_p_elem, "", "");
            if (p == null) continue;
            if (child_p_elem.attributeValue("mode", "").equalsIgnoreCase("local")) {
                p.setLocal(true);
                DataManager.getInstance().addToRootFolder(p);
            }
            if (!(bSuccess = p.load(aFolder, child_p_elem))) continue;
            Element option_elem = child_p_elem.element("option");
            if (option_elem == null) {
                this.m_lParms.add(p);
                continue;
            }
            p.setIsTemplate(true);
            TemplatedParameter tparam = new TemplatedParameter(p);
            if (!tparam.load(aFolder, child_p_elem)) continue;
            this.m_lTParms.add(tparam);
        }
    }

    public void setDesc(String s) {
        this.m_sDesc = s;
    }

    public void setHelp(String s) {
        this.m_sHelp = s;
    }

    @Override
    public void setLabel(String s) {
        this.m_sLabel = s;
    }

    @Override
    public void setName(String s) {
        this.m_sName = s;
    }

    public void setDoclink(String s) {
        this.m_sDocLink = s;
    }

    public int countFolders(boolean excludeDisabledAndInvisible) {
        int result = 0;
        if (excludeDisabledAndInvisible) {
            for (int i = 0; i < this.m_lFolders.size(); ++i) {
                Folder f = this.m_lFolders.get(i);
                if ((null == f || f.getDisabled()) && !f.getVisibility()) continue;
                ++result;
            }
        } else {
            result = this.m_lFolders.size();
        }
        return result;
    }

    public int countParameters(boolean excludeDisabledAndInvisible) {
        int result = 0;
        if (excludeDisabledAndInvisible) {
            for (int i = 0; i < this.m_lParms.size(); ++i) {
                Parameter p = this.m_lParms.get(i);
                if (null == p || p.getDisabled() || !p.getVisibility()) continue;
                ++result;
            }
        } else {
            result = this.m_lParms.size();
        }
        return result;
    }

    public int countTemplatedParameters(boolean excludeDisabledAndInvisible) {
        int result = 0;
        if (excludeDisabledAndInvisible) {
            for (int i = 0; i < this.m_lTParms.size(); ++i) {
                TemplatedParameter tp = this.m_lTParms.get(i);
                if (null == tp || tp.getDisabled() || !tp.getVisibility()) continue;
                ++result;
            }
        } else {
            result = this.m_lTParms.size();
        }
        return result;
    }

    public List<Folder> getFolders() {
        return this.m_lFolders;
    }

    public List<Parameter> getParameters() {
        return this.m_lParms;
    }

    public ArrayList<TemplatedParameter> getTParameters() {
        return this.m_lTParms;
    }
}

