/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.ElementObject;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.crypto.IEncryptingSession;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CredentialParameter
extends Parameter {
    public CredentialParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(Element value_elem, boolean bEncrypt, List errors) throws DataManagerException {
        if (this.m_currentValue != null || this.m_encryptedValue == null) {
            if (this.m_currentValue == null) {
                this.m_currentValue = CredentialParameter.buildCredentials("", "");
            }
            if (Element.class.isInstance(this.m_currentValue)) {
                if (bEncrypt && !this.getDisabled()) {
                    DataManager.getInstance().initializeCAMFactoryFromDisk();
                    IEncryptingSession es = DataManager.getInstance().getCryptoEncryptingSession(bEncrypt);
                    if (es == null) {
                        value_elem.add(((Element)this.m_currentValue).createCopy());
                        return;
                    }
                    String cr = ((Element)this.m_currentValue).asXML();
                    try {
                        byte[] utf8Buffer = cr.getBytes("UTF-8");
                        byte[] buffer = es.encryptData(utf8Buffer);
                        this.m_encryptedValue = es.encode(buffer);
                        this.m_currentValue = null;
                    }
                    catch (Throwable e) {
                        CnfgLog.error(e);
                        Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
                        if (errors != null) {
                            String sMessage = new StringBuffer(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args)).toString();
                            errors.add(sMessage);
                            value_elem.add(((Element)this.m_currentValue).createCopy());
                            return;
                        }
                        String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args)).toString();
                        throw new DataManagerException(sMessage);
                    }
                } else {
                    value_elem.add(((Element)this.m_currentValue).createCopy());
                    return;
                }
            }
            Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
            this.m_sBadValue = new String();
            if (errors == null) {
                String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args)).toString();
                throw new DataManagerException(sMessage);
            }
            errors.add(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args));
        } else if (!bEncrypt) {
            DataManager.getInstance().initializeCAMFactoryFromDisk();
            IEncryptingSession es = DataManager.getInstance().getCryptoEncryptingSession(bEncrypt);
            if (null != es && this.m_encryptedValue.length() > 0) {
                try {
                    if (!DataManager.getInstance().doNotNeedDecryptCredentials()) {
                        byte[] decodedBuffer = es.decode(this.m_encryptedValue);
                        byte[] sDecryptedValue = es.decryptData(decodedBuffer);
                        String strXML = new String(sDecryptedValue, "UTF-8");
                        Document docFragment = DocumentHelper.parseText((String)strXML);
                        Element fragElement = docFragment.getRootElement();
                        fragElement.detach();
                        value_elem.add(fragElement);
                    }
                    return;
                }
                catch (Throwable e) {
                    CnfgLog.error(e);
                    this.m_sBadValue = new String();
                    Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
                    if (errors != null) {
                        String sMessage = new StringBuffer(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args)).toString();
                        errors.add(sMessage);
                        return;
                    }
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args)).toString();
                    throw new DataManagerException(sMessage);
                }
            }
        }
        super.write(value_elem, bEncrypt, errors);
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public boolean setValue(Element value_elem) {
        this.clearErrorMsg();
        String sEncrypted = value_elem.attributeValue("encrypted");
        if (sEncrypted != null && sEncrypted.compareTo("true") == 0) {
            this.m_encryptedValue = value_elem.getText();
            this.m_currentValue = null;
        } else {
            Namespace ns;
            QName qnCred;
            Element cred_elem;
            if (!this.getDisabled()) {
                DataManager.getInstance().setConfigDirtyFlag(true, this.getRestartServicesList());
            }
            if ((cred_elem = value_elem.element(qnCred = DocumentHelper.createQName((String)"credential", (Namespace)(ns = DocumentHelper.createNamespace((String)"", (String)""))))) != null) {
                this.m_currentValue = cred_elem.createCopy();
                this.m_encryptedValue = null;
            } else {
                qnCred = DocumentHelper.createQName((String)"credential", (Namespace)DataManager.getInstance().m_nsCfg);
                cred_elem = value_elem.element(qnCred);
                if (cred_elem != null) {
                    QName qnUsername = DocumentHelper.createQName((String)"username", (Namespace)DataManager.getInstance().m_nsCfg);
                    String username = cred_elem.element(qnUsername).getText();
                    QName qnPassword = DocumentHelper.createQName((String)"password", (Namespace)DataManager.getInstance().m_nsCfg);
                    String password = cred_elem.element(qnPassword).getText();
                    this.m_currentValue = CredentialParameter.buildCredentials(username, password);
                    this.m_encryptedValue = null;
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean setValue(Object value) {
        this.clearErrorMsg();
        if (value.getClass() == ElementObject.class && this.setValue(((ElementObject)value).getElement())) {
            return super.setValue(value);
        }
        this.m_sBadValue = new String();
        return false;
    }

    public static Element buildCredentials(String username, String password) {
        Namespace nsCred = DocumentHelper.createNamespace((String)"", (String)"");
        QName qnCred = DocumentHelper.createQName((String)"credential", (Namespace)nsCred);
        Element credential_elem = DocumentHelper.createElement((QName)qnCred);
        QName qnUsername = DocumentHelper.createQName((String)"username", (Namespace)nsCred);
        Element username_elem = DocumentHelper.createElement((QName)qnUsername);
        QName qnPassword = DocumentHelper.createQName((String)"password", (Namespace)nsCred);
        Element password_elem = DocumentHelper.createElement((QName)qnPassword);
        username_elem.addText(username);
        credential_elem.add(username_elem);
        password_elem.addText(password);
        credential_elem.add(password_elem);
        return credential_elem;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    public String getPart(boolean getUsername) {
        try {
            Element temp_elem = DocumentHelper.createElement((String)"TEMP");
            ArrayList errors = new ArrayList();
            this.write(temp_elem, false, (List)errors);
            if (errors.size() == 0) {
                Namespace nsCred = DocumentHelper.createNamespace((String)"", (String)"");
                QName qnCred = DocumentHelper.createQName((String)"credential", (Namespace)nsCred);
                QName qnUsername = DocumentHelper.createQName((String)"username", (Namespace)nsCred);
                QName qnPassword = DocumentHelper.createQName((String)"password", (Namespace)nsCred);
                Element credential_elem = temp_elem.element(qnCred);
                if (credential_elem != null) {
                    if (getUsername) {
                        Element username_elem = credential_elem.element(qnUsername);
                        if (username_elem != null) {
                            return username_elem.getText();
                        }
                    } else {
                        Element password_elem = credential_elem.element(qnPassword);
                        if (password_elem != null) {
                            return password_elem.getText();
                        }
                    }
                }
            }
        }
        catch (DataManagerException e) {
            CnfgLog.error(e.getMessage());
        }
        return null;
    }

    private static String getNewUserName(Element newValue) {
        Element userNameElement;
        Element credentialElement = newValue.element("credential");
        if (credentialElement != null && (userNameElement = credentialElement.element("username")) != null) {
            return userNameElement.getText();
        }
        return null;
    }

    private static String getNewPassword(Element newValue) {
        Element passwordElement;
        Element credentialElement = newValue.element("credential");
        if (credentialElement != null && (passwordElement = credentialElement.element("password")) != null) {
            return passwordElement.getText();
        }
        return null;
    }

    @Override
    public boolean isEqual(Object value) {
        if (ElementObject.class.isInstance(value)) {
            ElementObject newValue = (ElementObject)value;
            String oldUserName = this.getPart(true);
            String oldPassword = this.getPart(false);
            if (oldUserName != null && oldPassword != null) {
                String newUserName = CredentialParameter.getNewUserName(newValue.getElement());
                String newPassword = CredentialParameter.getNewPassword(newValue.getElement());
                if (newUserName.equals(oldUserName) && newPassword.equals(oldPassword)) {
                    return true;
                }
            }
        }
        return false;
    }
}

