/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMCryptoKeyException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgInstallDataProcessor;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgTestInitializationFeedback;
import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.CnfgWizard;
import com.cognos.crconfig.FontsMappingModel;
import com.cognos.crconfig.GlobalConfigModel;
import com.cognos.crconfig.ICnfgFeedback;
import com.cognos.crconfig.ICnfgTask;
import com.cognos.crconfig.ICnfgTest;
import com.cognos.crconfig.TaskCollectorException;
import com.cognos.crconfig.data.AliasRootsParameter;
import com.cognos.crconfig.data.AnyURIParameter;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.BooleanParameter;
import com.cognos.crconfig.data.CnfgActionCheckService;
import com.cognos.crconfig.data.CnfgActionCustomSave;
import com.cognos.crconfig.data.CnfgActionDeleteCRN;
import com.cognos.crconfig.data.CnfgActionGenDB2DDL;
import com.cognos.crconfig.data.CnfgActionInstallEAR;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgActionSave;
import com.cognos.crconfig.data.CnfgActionService;
import com.cognos.crconfig.data.CnfgActionTest;
import com.cognos.crconfig.data.CnfgActionUninstallCognos;
import com.cognos.crconfig.data.CnfgActionVerifyCNFM;
import com.cognos.crconfig.data.CnfgActionWizGenCrypto;
import com.cognos.crconfig.data.CnfgActionWizJRE;
import com.cognos.crconfig.data.CnfgDataEvent;
import com.cognos.crconfig.data.CnfgDataListener;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.CnfgNodeDeletedEvent;
import com.cognos.crconfig.data.CnfgNodeDeletedListener;
import com.cognos.crconfig.data.CnfgNodeInsertedEvent;
import com.cognos.crconfig.data.CnfgNodeInsertedListener;
import com.cognos.crconfig.data.CnfgNodeRenamedEvent;
import com.cognos.crconfig.data.CnfgNodeRenamedListener;
import com.cognos.crconfig.data.CnfgNodeSwitchEvent;
import com.cognos.crconfig.data.CnfgNodeSwitchListener;
import com.cognos.crconfig.data.CnfgSelectionEvent;
import com.cognos.crconfig.data.CnfgSelectionListener;
import com.cognos.crconfig.data.CnfgTask;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.CnfgValueChangedListener;
import com.cognos.crconfig.data.ComplexFileURIParameter;
import com.cognos.crconfig.data.ConfigFileNotFoundException;
import com.cognos.crconfig.data.Constants;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.DecimalParameter;
import com.cognos.crconfig.data.EnvVarArrayParameter;
import com.cognos.crconfig.data.FileURIParameter;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.FontsEmbedParameter;
import com.cognos.crconfig.data.FontsMapParameter;
import com.cognos.crconfig.data.HostOnlyParameter;
import com.cognos.crconfig.data.HostPortInstanceParameter;
import com.cognos.crconfig.data.HostPortParameter;
import com.cognos.crconfig.data.IntegerParameter;
import com.cognos.crconfig.data.LanguageParameter;
import com.cognos.crconfig.data.LocalHostOnlyParameter;
import com.cognos.crconfig.data.LocalURLParameter;
import com.cognos.crconfig.data.NumConst;
import com.cognos.crconfig.data.Option;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.PathParameter;
import com.cognos.crconfig.data.RelativeOrAbsoluteURIParameter;
import com.cognos.crconfig.data.RootFolder;
import com.cognos.crconfig.data.StartupFileException;
import com.cognos.crconfig.data.StartupProcessor;
import com.cognos.crconfig.data.StringParameter;
import com.cognos.crconfig.data.SuperParameter;
import com.cognos.crconfig.data.SystemPasswordParameter;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.TimeZoneParameter;
import com.cognos.crconfig.data.URLParameter;
import com.cognos.crconfig.data.URLPathParameter;
import com.cognos.crconfig.data.WizardComplexPageData;
import com.cognos.crconfig.data.WizardData;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.XSLTransform;
import com.cognos.crconfig.data.crypto.Creator;
import com.cognos.crconfig.data.crypto.ICAMFactory;
import com.cognos.crconfig.data.crypto.IConfiguringSession;
import com.cognos.crconfig.data.crypto.IEncryptingSession;
import com.cognos.crconfig.data.crypto.ISystemProtectionSession;
import com.cognos.crconfig.data.service.BootstrapServiceFolder;
import com.cognos.crconfig.data.service.CnfgServiceFolderChangedEvent;
import com.cognos.crconfig.data.service.CnfgServiceFolderChangedListener;
import com.cognos.crconfig.data.service.CnfgServiceUtils;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;
import com.cognos.crconfig.data.tenancy.TenancyInfoProviderParameter;
import com.cognos.crconfig.data.verification.VerifyConfiguration;
import com.cognos.crconfig.data.wlpconfig.WLPConfiguration;
import com.cognos.i18n.ToolkitResources;
import com.ibm.bi.configutil.ConfigUtilHelper;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.cognos.conformance.CNFMConfiguration;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DataManager
extends Constants
implements CnfgValueChangedListener,
CnfgNodeInsertedListener,
CnfgNodeDeletedListener,
CnfgNodeRenamedListener,
CnfgNodeSwitchListener {
    private static final DataManager INSTANCE = new DataManager();
    private Folder m_rootFolder;
    private Folder m_currentSelection;
    private List<CnfgDataListener> m_lDataListeners = new ArrayList<CnfgDataListener>();
    private List<CnfgNodeInsertedListener> m_lNodeInsertedListeners = new ArrayList<CnfgNodeInsertedListener>();
    private List<CnfgNodeDeletedListener> m_lNodeDeletedListeners = new ArrayList<CnfgNodeDeletedListener>();
    private List<CnfgNodeSwitchListener> m_lNodeSwitchListeners = new ArrayList<CnfgNodeSwitchListener>();
    private List<CnfgNodeRenamedListener> m_lNodeRenamedListeners = new ArrayList<CnfgNodeRenamedListener>();
    private List<CnfgSelectionListener> m_lSelectionListeners = new ArrayList<CnfgSelectionListener>();
    private List<CnfgValueChangedListener> m_lValueChangedListeners = new ArrayList<CnfgValueChangedListener>();
    private List<CnfgServiceFolderChangedListener> m_lServiceFolderChangedListeners = new ArrayList<CnfgServiceFolderChangedListener>();
    private List<ServiceFolder> m_lServiceFolders = null;
    private List<WizardData> m_lWizardContent = new ArrayList<WizardData>();
    private Hashtable m_wizardMap = new Hashtable();
    public static Hashtable nsToPrefixMap = new Hashtable();
    private HashMap<String, String> m_lCmpLst = new HashMap();
    private ArrayList<String> m_lViewList = new ArrayList();
    private boolean m_bConfigDirty;
    private boolean m_bForceSave;
    private boolean m_bLocaleDocDirty;
    private boolean m_bWLPServerDocDirty;
    private ArrayList m_lRestartServices;
    protected boolean m_cryptoDirty;
    protected boolean m_bAAADirty;
    private boolean m_useCrypto = true;
    private boolean m_bUseJCAM = false;
    private boolean m_decryptCryptoPasswords;
    private String m_sVersion;
    private ICAMFactory m_cf;
    private IEncryptingSession m_es;
    private ISystemProtectionSession m_sps;
    private Document m_localeMaps;
    private Document m_tomcatDoc;
    private WLPConfiguration m_wlp = new WLPConfiguration();
    private VerifyConfiguration m_verifyConfig = new VerifyConfiguration();
    private CCLConfigurationException m_lastCfgApiInitError;
    private ICCLConfiguration m_cfgapi;
    boolean m_useDefaultEncoding = true;
    private boolean m_bSaveOnDefaultEncoding = true;
    private String m_defaultEncoding;
    private boolean m_bStartupConfigUpgradeDone = false;
    private static String m_sBinDirPath;
    private static String m_sInstallDirPath;
    private static boolean m_uiDocsLoaded;
    private static Document m_uiDocDocument;
    private boolean m_bBTSVIsInstalled;
    private Hashtable<String, String> m_backedupFiles = new Hashtable();
    private Document m_upgradedStartupDoc;
    private Document m_upgradedLocaleDoc;
    private String m_sStartupVer;
    private String m_sLocaleVer;
    boolean needUpgradeWebXML = false;
    public static final String WEBXML_DESC_VERSION_PREFIX = "ver_";
    public static final String WEBXMLVersion = "11.1.6.0";
    public static final String WEBXML_DESC_STRING = "IBM Cognos";
    public static final String WEBXML_ELEM_NAME_DESC = "description";
    public static final String WEBXML_JAVAEE_NS = "http://java.sun.com/xml/ns/javaee";
    private static String FileName_WEBXML;
    private static boolean m_respectEnv;
    private List<Folder> m_lGlobalConfigFolders = new ArrayList<Folder>();
    public Namespace m_nsCfg = DocumentHelper.createNamespace((String)"crn", (String)"http://developer.cognos.com/schemas/crconfig/1/");
    public QName m_qnParams = DocumentHelper.createQName((String)"parameters", (Namespace)this.m_nsCfg);
    public QName m_qnParam = DocumentHelper.createQName((String)"parameter", (Namespace)this.m_nsCfg);
    public QName m_qnValue = DocumentHelper.createQName((String)"value", (Namespace)this.m_nsCfg);
    public QName m_qnInstances = DocumentHelper.createQName((String)"instances", (Namespace)this.m_nsCfg);
    public QName m_qnInstance = DocumentHelper.createQName((String)"instance", (Namespace)this.m_nsCfg);
    public static final int SERVICE_START = 1;
    public static final int SERVICE_STOP = 2;
    public static final int SERVICE_RESTART = 3;
    public static final int SERVICE_SAVE_START = 4;
    public static final int SERVICE_SAVE_RESTART = 5;
    private static String m_sCRNServiceName;
    private Boolean m_bDoPromptForCMUpgrade = new Boolean(true);
    private Boolean m_bDoPromptForIPFUpgrade = new Boolean(true);
    private Boolean m_bDoReportSpecUpgrade = new Boolean(false);
    private TestClassLoader m_testClassLoader = null;
    private byte[] m_bCogStartupXML = null;
    private Method m_theUpgradeMethod = null;
    private Method m_theIPFUpgradeMethod = null;
    private Boolean fetchedAdditionalViews = Boolean.FALSE;
    private Boolean m_bIsCNFMCheckingDisabled = new Boolean(false);
    private boolean m_bDoNotDecryptCredentials = false;
    private boolean m_bSkipBackup = false;
    private boolean m_bIsCNFMCheckingViaTestActionEnabled = false;
    boolean m_isManifestInstall = false;

    public VerifyConfiguration getVerifyConfig() {
        return this.m_verifyConfig;
    }

    public Class getSaveClass(CnfgActionCustomSave action) {
        URL[] urls = action.getURLs();
        String className = action.getClassName();
        if (urls == null || className == null) {
            return null;
        }
        Class<?> testClass = null;
        TestClassLoader classLoader = this.getClassLoader(urls);
        try {
            testClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            StringBuffer msg = new StringBuffer();
            msg.append("The Java class name specified for action '");
            msg.append("test");
            msg.append("' with provider '");
            msg.append(action.getProvider());
            msg.append("' could not be found in the specified locations:\n");
            URL[] clurls = classLoader.getURLs();
            for (int i = 0; i < clurls.length; ++i) {
                msg.append("\t").append(clurls[i].toString()).append("\n");
            }
            CnfgLog.error(msg.toString());
        }
        return testClass;
    }

    private DataManager() {
        this.loadInstallList();
        this.m_bBTSVIsInstalled = this.isInstalled("BTSV", false) || this.isInstalled("BTSVSA", false);
        Locale locale = CnfgResource.getLocale();
        try {
            ResourceBundle rb = ResourceBundle.getBundle("config", locale);
            CnfgUIDocResource.setResourceBundle(rb, "config");
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::DataManager() - Found 'config' property file for locale '" + rb.getLocale() + "'");
            }
        }
        catch (MissingResourceException mre) {
            CnfgLog.error(mre);
            CnfgLog.error("DataManager::DataManager()-'config' property file for locale '" + locale.getDisplayName(Locale.ENGLISH) + "' not found. As well, unable to find default property file.");
        }
    }

    public static DataManager getInstance() {
        return INSTANCE;
    }

    public boolean isBTSVInstalled() {
        return this.m_bBTSVIsInstalled;
    }

    public void useDefaultEncoding(boolean bUseDefaultEnc) {
        this.setDefaultEncoding(bUseDefaultEnc);
        if (this.m_bSaveOnDefaultEncoding != bUseDefaultEnc) {
            this.m_bSaveOnDefaultEncoding = bUseDefaultEnc;
            this.setConfigDirtyFlag(true, this.getAllServices());
            this.setLocaleDocDirtyFlag(true, this.getAllServices());
        }
    }

    public void setDefaultEncoding(boolean bUseDefaultEnc) {
        this.m_useDefaultEncoding = bUseDefaultEnc;
    }

    public String getEncoding() {
        if (this.m_useDefaultEncoding) {
            if (null == this.m_defaultEncoding) {
                this.m_defaultEncoding = ToolkitResources.getDefaultEncoding();
            }
            return this.m_defaultEncoding;
        }
        return "UTF8";
    }

    public static String getSystemInfo() {
        return new StringBuffer().append(DataManager.getJavaProperties()).append(DataManager.getLocalHostProperties()).toString();
    }

    public HashMap getCmpLst() {
        return this.m_lCmpLst;
    }

    public static String getJavaProperties() {
        return new StringBuffer().append(CnfgResource.getMessage("Label.DialogProperties.JavaVersion")).append(" ").append(System.getProperty("java.version")).append("\n").append(CnfgResource.getMessage("Label.DialogProperties.JavaVendor")).append(" ").append(System.getProperty("java.vendor")).append("\n").append(CnfgResource.getMessage("Label.DialogProperties.JavaInstallPath")).append(" ").append(System.getProperty("java.home")).append("\n").toString();
    }

    public static String getLocalHostProperties() {
        String IPaddress;
        String machineName;
        try {
            InetAddress current = InetAddress.getLocalHost();
            machineName = current.getHostName();
            IPaddress = current.getHostAddress();
        }
        catch (UnknownHostException eee) {
            machineName = CnfgResource.getMessage("Label.DialogProperties.HostError");
            IPaddress = CnfgResource.getMessage("Label.DialogProperties.HostError");
        }
        return new StringBuffer().append(CnfgResource.getMessage("Label.DialogProperties.LocalHostName")).append(" ").append(machineName).append("\n").append(CnfgResource.getMessage("Label.DialogProperties.LocalHostIP")).append(" ").append(IPaddress).append("\n").append(CnfgResource.getMessage("Label.DialogProperties.CognosInstallPath")).append(" ").append(DataManager.getPathToInstallDir()).toString();
    }

    public void getConfigFileFromJar(File outputFile, String fileName) throws DataManagerException {
        try {
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is == null) {
                String message = new StringBuffer(CnfgResource.getMessage("Message.defaultConfig.failed.notification")).toString();
                throw new DataManagerException(message);
            }
            FileOutputStream os = new FileOutputStream(outputFile);
            byte[] buffer = new byte[4096];
            int size = 0;
            while ((size = is.read(buffer, 0, 4096)) != -1) {
                ((OutputStream)os).write(buffer, 0, size);
            }
            is.close();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            String message = new StringBuffer(CnfgResource.getMessage("Message.defaultConfig.failed.notification")).toString();
            throw new DataManagerException(message);
        }
        catch (Exception e) {
            CnfgLog.error(e);
            String message = new StringBuffer(CnfgResource.getMessage("Message.defaultConfig.failed.notification")).toString();
            throw new DataManagerException(message);
        }
    }

    public Document getUpgradedStartupDoc() {
        return this.m_upgradedStartupDoc;
    }

    public Document getUpgradedLocaleDoc() {
        return this.m_upgradedLocaleDoc;
    }

    public boolean checkUpgrade() throws DataManagerException {
        String sReportReg;
        File reportRegFile;
        String sCrnLocale;
        File crnLocaleFile;
        this.m_sStartupVer = "";
        this.m_sLocaleVer = "";
        String sCrnStartup = "../configuration/crnstartup.xml";
        File crnStartupFile = this.resolveEffectiveFilePath(sCrnStartup);
        if (crnStartupFile.exists()) {
            String sCogStartup = "../configuration/cogstartup.xml";
            File cogStartupFile = this.resolveEffectiveFilePath(sCogStartup);
            if (cogStartupFile.exists()) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddkkmmss");
                String timeStamp = formatter.format(new Date());
                String sCogStartupBak = "../configuration/cogstartup_" + timeStamp + "_backup.xml";
                if (!cogStartupFile.renameTo(this.resolveEffectiveFilePath(sCogStartupBak))) {
                    Object[] arg = new Object[]{sCogStartup, sCogStartupBak};
                    CnfgLog.error(CnfgResource.getMessage("Message.error.copy.file", arg));
                    throw new DataManagerException(CnfgResource.getMessage("Message.error.copy.file", arg));
                }
            } else if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("cogstartup.xml was not found...");
            }
            if (!crnStartupFile.renameTo(this.resolveEffectiveFilePath("../configuration/cogstartup.xml"))) {
                Object[] arg = new Object[]{sCrnStartup, "../configuration/cogstartup.xml"};
                CnfgLog.error(CnfgResource.getMessage("Message.error.copy.file", arg));
                throw new DataManagerException(CnfgResource.getMessage("Message.error.copy.file", arg));
            }
        } else if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("crnstartup.xml was not found...");
        }
        if ((crnLocaleFile = this.resolveEffectiveFilePath(sCrnLocale = "../configuration/crnlocale.xml")).exists()) {
            String sCogLocale = "../configuration/coglocale.xml";
            File cogLocaleFile = this.resolveEffectiveFilePath(sCogLocale);
            if (cogLocaleFile.exists()) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddkkmmss");
                String timeStamp = formatter.format(new Date());
                String sCogStartupBak = "../configuration/coglocale_" + timeStamp + "_backup.xml";
                if (!cogLocaleFile.renameTo(this.resolveEffectiveFilePath(sCogStartupBak))) {
                    Object[] arg = new Object[]{sCogLocale, sCogStartupBak};
                    CnfgLog.error(CnfgResource.getMessage("Message.error.copy.file", arg));
                    throw new DataManagerException(CnfgResource.getMessage("Message.error.copy.file", arg));
                }
            } else if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("crnlocale.xml was not found...");
            }
            if (!crnLocaleFile.renameTo(this.resolveEffectiveFilePath("../configuration/coglocale.xml"))) {
                Object[] arg = new Object[]{sCrnLocale, "../configuration/coglocale.xml"};
                CnfgLog.error(CnfgResource.getMessage("Message.error.copy.file", arg));
                throw new DataManagerException(CnfgResource.getMessage("Message.error.copy.file", arg));
            }
        } else if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("crnlocale.xml was not found...");
        }
        if ((reportRegFile = this.resolveEffectiveFilePath(sReportReg = "../configuration/reportnet_reg.txt")).exists()) {
            String sCogConfigReg = "../configuration/cogconfig_reg.txt";
            if (!reportRegFile.renameTo(this.resolveEffectiveFilePath(sCogConfigReg))) {
                Object[] arg = new Object[]{sReportReg, sCogConfigReg};
                CnfgLog.error(CnfgResource.getMessage("Message.error.copy.file", arg));
                throw new DataManagerException(CnfgResource.getMessage("Message.error.copy.file", arg));
            }
        } else if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("reportnet_reg.txt was not found...");
        }
        String startupVer = this.getConfigFileVersion("../configuration/cogstartup.xml", false, CnfgResource.getMessage("Message.loadConfig.invalidFormatStartup.explanation"), CnfgResource.getMessage("Message.loadConfig.invalidFormatStartup.explanation"));
        String localeVer = this.getConfigFileVersion("../configuration/coglocale.xml", false, CnfgResource.getMessage("Message.loadLocale.failed.explanation.fileformat"), CnfgResource.getMessage("Message.loadLocale.failed.explanation.parsing"));
        String uiDocVersion = this.getUIDocVersion();
        String curLocaleVer = this.getConfigFileVersion("/config/coglocale.xml", true, CnfgResource.getMessage("Message.loadLocale.failed.explanation.fileformat"), CnfgResource.getMessage("Message.loadLocale.failed.explanation.parsing"));
        if (CnfgUtils.compareVersions(startupVer, uiDocVersion) < 0) {
            this.m_sStartupVer = startupVer;
        }
        if (CnfgUtils.compareVersions(localeVer, curLocaleVer) < 0) {
            this.m_sLocaleVer = localeVer;
        }
        if (this.isBTSVInstalled()) {
            this.m_bWLPServerDocDirty = this.m_wlp.checkWLPServerUpgrade();
            this.needUpgradeWebXML = DataManager.needUpgradeWebXML(null);
            this.m_bWLPServerDocDirty = this.m_bWLPServerDocDirty || this.needUpgradeWebXML;
        }
        return this.m_sStartupVer.length() != 0 || this.m_sLocaleVer.length() != 0 || this.needUpgradeWebXML;
    }

    protected static boolean needUpgradeWebXML(InputStream is) {
        Document webXMLDoc = null;
        try {
            webXMLDoc = DataManager.getWebXMLDoc(is);
        }
        catch (DataManagerException e) {
            e.printStackTrace();
            return false;
        }
        String versionDesc = CnfgDataUtils.getWebXMLDescVersion(webXMLDoc);
        String version = StringUtils.substringAfter((String)versionDesc, (String)WEBXML_DESC_VERSION_PREFIX);
        int i = CnfgUtils.compareVersions(WEBXMLVersion, version);
        return i > 0;
    }

    protected static boolean updateAndCheckUpgradeWebXML(File finalSrc, File finalDst, boolean bIsCMPresentNow) throws Exception {
        FileUtils.copyFile((File)finalSrc, (File)finalDst, (boolean)true);
        CnfgLog.error("web.xml is updated as CM is" + (bIsCMPresentNow ? "" : " NOT") + " installed in current env.");
        return DataManager.needUpgradeWebXML(null);
    }

    public boolean upgradeConfigFile() throws DataManagerException {
        if (this.m_bStartupConfigUpgradeDone) {
            return false;
        }
        this.m_upgradedStartupDoc = null;
        this.m_upgradedLocaleDoc = null;
        this.m_bStartupConfigUpgradeDone = true;
        try {
            if (this.m_sStartupVer.length() != 0) {
                Set startupStyleSheetz = this.getAvailableStyleSheets(this.m_sStartupVer, "startup");
                this.m_upgradedStartupDoc = this.transformFiles(startupStyleSheetz, this.getStartupInputStream(), CnfgResource.getMessage("Message.loadConfig.invalidFormatStartup.explanation"), CnfgResource.getMessage("Message.upgradeConfig.startupFailedTransform.explanation"));
            }
            if (this.m_sLocaleVer.length() != 0) {
                Set localeStyleSheetz = this.getAvailableStyleSheets(this.m_sLocaleVer, "locale");
                this.m_upgradedLocaleDoc = this.transformFiles(localeStyleSheetz, new FileInputStream("../configuration/coglocale.xml"), CnfgResource.getMessage("Message.loadLocale.failed.explanation.parsing"), CnfgResource.getMessage("Message.upgradeConfig.localeFailedTransform.explanation"));
            }
        }
        catch (DataManagerException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new DataManagerException(e.getMessage());
        }
        boolean isUpgraded = false;
        if (this.m_upgradedStartupDoc != null) {
            this.setConfigDirtyFlag(true, new ArrayList());
            isUpgraded = true;
        }
        if (this.m_upgradedLocaleDoc != null) {
            this.setLocaleDocDirtyFlag(true, new ArrayList());
            isUpgraded = true;
        }
        return isUpgraded;
    }

    public boolean hasSuperConfig() {
        return m_respectEnv;
    }

    public void customizedUpgrade() {
        this.upgradeForSANParameters(this.m_sStartupVer);
        this.upgradeForWebXml();
        this.upgradeForconfigGroupMemberHost(this.m_sStartupVer);
        this.upgradeForCryptoCiphersuite();
    }

    private void upgradeForCryptoCiphersuite() {
        if (CnfgUtils.compareVersions(this.m_sStartupVer, "175.0") < 0) {
            CnfgLog.info("upgradeForCryptoCiphersuite(" + this.m_sStartupVer + ")- start upgrade.");
            try {
                ArrayParameter ciphersuiteParam = (ArrayParameter)DataManager.getInstance().findParam("cognosCryptoCiphersuite");
                if (ciphersuiteParam != null) {
                    Element valueElement;
                    ArrayList<String> curlist = this.getCurrentCipherList(ciphersuiteParam);
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("upgradeForCryptoCiphersuite() - cur list: " + curlist.toString());
                    }
                    if ((valueElement = CAMFactory.getDefaultCiphersuiteConfiguration(curlist, (Locale)CnfgResource.getLocale())) != null) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("upgradeForCryptoCiphersuite()=> CAMFactory.getDefaultCiphersuiteConfiguration() returns:  " + valueElement.asXML());
                        }
                        ciphersuiteParam.setDefaultValueList(valueElement);
                        ciphersuiteParam.setToDefault();
                    }
                }
            }
            catch (Exception e) {
                CnfgLog.error("upgradeForCryptoCiphersuite() - failed with exception: " + e.getMessage());
            }
        }
    }

    private ArrayList<String> getCurrentCipherList(ArrayParameter ciphersuiteParam) {
        ArrayList<String> curList = new ArrayList<String>();
        Set<Parameter> curCipherList = ciphersuiteParam.getCurrentValues();
        if (curCipherList != null && curCipherList.size() > 0) {
            for (Parameter p : curCipherList) {
                String sVal = (String)p.getValue();
                if (StringUtils.isBlank((String)sVal)) continue;
                curList.add(sVal);
            }
        }
        return curList;
    }

    private void upgradeForWebXml() {
        block4: {
            Document webXMLDoc = null;
            if (CnfgUtils.compareVersions(this.m_sStartupVer, "168.0") < 0) {
                try {
                    webXMLDoc = DataManager.getWebXMLDoc(null);
                    if (webXMLDoc != null && CnfgDataUtils.removeElement(webXMLDoc, "servlet", "servlet-name", "AccountServlet")) {
                        CnfgDataUtils.backupNUpdateFile(webXMLDoc.asXML(), FileName_WEBXML);
                    }
                }
                catch (DataManagerException e) {
                    if (!CnfgLog.isDebugEnabled()) break block4;
                    CnfgLog.debug("An exception occurred. Skipping the web.xml update task. Exception is: " + e.getMessage());
                }
            }
        }
    }

    private static Document getWebXMLDoc(InputStream webxmlStream) throws DataManagerException {
        Document webDoc = null;
        SAXReader reader = new SAXReader();
        if (webxmlStream == null) {
            File webXMLFile = DataManager.getInstance().resolveEffectiveFilePath(FileName_WEBXML);
            if (webXMLFile.exists()) {
                try {
                    webDoc = reader.read(webXMLFile);
                }
                catch (DocumentException e) {
                    throw new DataManagerException((Exception)((Object)e));
                }
            }
        } else {
            try {
                webDoc = reader.read(webxmlStream);
            }
            catch (DocumentException e) {
                throw new DataManagerException((Exception)((Object)e));
            }
        }
        return webDoc;
    }

    public void upgradeForconfigGroupMemberHost(String startupVer) {
        if (CnfgUtils.compareVersions(startupVer, "171.0") < 0) {
            CnfgLog.info("upgradeForconfigGroupMemberHost(" + startupVer + ")- start upgrade.");
            Parameter configGroupHostParam = DataManager.getInstance().findParam("configGroupMemberHost");
            if (configGroupHostParam != null) {
                String value = (String)configGroupHostParam.getValue();
                if (value == null || value.equals("localhost")) {
                    String disphost;
                    URL exterDispURL = CnfgDataUtils.getURLParamValue("externalDispatcher");
                    if (exterDispURL != null && !StringUtils.isEmpty((String)(disphost = exterDispURL.getHost()))) {
                        configGroupHostParam.setValue(disphost);
                        CnfgLog.info("upgradeForconfigGroupMemberHost(" + startupVer + ")- upgrade configGroupMemberHost to '" + disphost + "'.");
                        return;
                    }
                    CnfgLog.error("upgradeForconfigGroupMemberHost(" + startupVer + ") - failed to get external dispatcher url. No change for configGroupMemberHost with value '" + value + "'.");
                } else {
                    CnfgLog.info("upgradeForconfigGroupMemberHost(" + startupVer + ")- The configGroupMemberHost has been set to '" + value + "', no need to upgrade.");
                }
            }
        }
    }

    public void upgradeForSANParameters(String startupVer) {
        if (CnfgUtils.compareVersions(startupVer, "168.0") < 0) {
            String[] hostValues = new String[]{"", "", ""};
            Parameter param_serverCommonName = DataManager.getInstance().findParam("serverCommonName");
            if (param_serverCommonName != null) {
                String value_serverCommonName = (String)param_serverCommonName.getValue();
                if (value_serverCommonName != null && !value_serverCommonName.isEmpty() && !value_serverCommonName.equalsIgnoreCase("CAMUSER")) {
                    hostValues = CnfgUtils.parseHostName(value_serverCommonName);
                } else {
                    try {
                        hostValues = ConfigUtilHelper.getFQDNHost();
                    }
                    catch (Exception e) {
                        CnfgLog.error("Exception when try to getFQDNHost() - " + e.toString());
                    }
                }
            }
            this.populateParamValue("sanIPAddress", hostValues[0]);
            if (!hostValues[1].isEmpty()) {
                this.populateParamValue("sanDNSName", hostValues[1]);
            } else {
                this.populateParamValue("sanDNSName", hostValues[2]);
            }
        }
    }

    private void populateParamValue(String paramName, String paramValue) {
        String valueParam;
        Parameter param = DataManager.getInstance().findParam(paramName);
        if (param != null && (valueParam = (String)param.getValue()) != null && valueParam.isEmpty()) {
            param.setValue(paramValue);
        }
    }

    private String getConfigFileVersion(InputStream in, String invalidFormatErrorMessage, String failedParseErrorMessage) throws DataManagerException {
        SAXReader saxReader = new SAXReader();
        Document doc = null;
        try {
            doc = saxReader.read(in);
        }
        catch (DocumentException e) {
            CnfgLog.error(e);
            throw new DataManagerException(failedParseErrorMessage);
        }
        Element rootElem = doc.getRootElement();
        if (rootElem == null) {
            CnfgLog.error(invalidFormatErrorMessage + "\nCould not get the root element of the document.");
            throw new DataManagerException(invalidFormatErrorMessage);
        }
        Attribute versionAttribute = rootElem.attribute("version");
        if (versionAttribute == null) {
            CnfgLog.error("Could not get the version attribute of the root element.");
            throw new DataManagerException(invalidFormatErrorMessage);
        }
        return versionAttribute.getValue();
    }

    private String getConfigFileVersion(String fileName, boolean isFromJar, String invalidFormatErrorMessage, String failedParseErrorMessage) throws DataManagerException {
        if (fileName.contains("/cogstartup.xml") && this.m_bCogStartupXML != null) {
            return this.getConfigFileVersion(this.getStartupInputStream(), invalidFormatErrorMessage, failedParseErrorMessage);
        }
        if (isFromJar) {
            return this.getConfigFileVersion(this.getClass().getResourceAsStream(fileName), invalidFormatErrorMessage, failedParseErrorMessage);
        }
        ICCLConfiguration CCLCFGAPI = CCLConfigurationFactory.getInstance();
        try {
            return this.getConfigFileVersion(new FileInputStream(new File(CCLCFGAPI.resolveEffectivePath(fileName))), invalidFormatErrorMessage, failedParseErrorMessage);
        }
        catch (FileNotFoundException e) {
            CnfgLog.error(e);
            throw new DataManagerException(e.getMessage());
        }
    }

    private String getUIDocVersion() throws DataManagerException {
        this.loadUIDocs();
        Element rootElem = m_uiDocDocument.getRootElement();
        if (rootElem == null) {
            CnfgLog.error("Could not get the root element of the document.");
            throw new DataManagerException(CnfgResource.getMessage("Message.loadConfig.invalidFormatUIDoc.explanation"));
        }
        Attribute versionAttribute = rootElem.attribute("version");
        if (versionAttribute == null) {
            CnfgLog.error("Could not get the version attribute of the root element.");
            throw new DataManagerException(CnfgResource.getMessage("Message.loadConfig.invalidFormatUIDoc.explanation"));
        }
        return versionAttribute.getValue();
    }

    private Set getAvailableStyleSheets(String oldVersion, String filePrefix) throws DataManagerException {
        Enumeration<JarEntry> unsortedEntries = null;
        try {
            JarFile thisJar = new JarFile("../bin/cclcfgmcf_mcf.jar");
            unsortedEntries = thisJar.entries();
        }
        catch (IOException e) {
            CnfgLog.error(CnfgResource.getMessage("Message.loadConfig.ioexception.explanation") + "\n" + e.getMessage());
            throw new DataManagerException(CnfgResource.getMessage("Message.loadConfig.ioexception.explanation"));
        }
        catch (IllegalStateException e) {
            CnfgLog.error(CnfgResource.getMessage("Message.loadConfig.ioexception.explanation") + "\n" + e.getMessage());
            throw new DataManagerException(CnfgResource.getMessage("Message.loadConfig.ioexception.explanation"));
        }
        class StyleSheetComparator
        implements Comparator {
            String m_sPrefix = "";

            public StyleSheetComparator(String prefix) {
                this.m_sPrefix = prefix;
            }

            public int compare(Object obj1, Object obj2) {
                String strObj1 = (String)obj1;
                String strObj2 = (String)obj2;
                int startVer1 = strObj1.indexOf(this.m_sPrefix);
                int endVer1 = strObj1.indexOf(".xslt");
                int startVer2 = strObj2.indexOf(this.m_sPrefix);
                int endVer2 = strObj2.indexOf(".xslt");
                if (startVer1 == -1 || startVer2 == -1 || endVer1 == -1 || endVer2 == -1) {
                    return 0;
                }
                return CnfgUtils.compareVersions(strObj1.substring(startVer1 + this.m_sPrefix.length() + 1, endVer1).replace('_', '.'), strObj2.substring(startVer2 + this.m_sPrefix.length() + 1, endVer2).replace('_', '.'));
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof StyleSheetComparator;
            }
        }
        TreeSet<String> entries = new TreeSet<String>(new StyleSheetComparator(filePrefix));
        while (unsortedEntries.hasMoreElements()) {
            int startInd;
            JarEntry entry = unsortedEntries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith("config") || !entryName.endsWith(".xslt") || (startInd = entryName.indexOf(filePrefix)) == -1) continue;
            int endInd = entryName.indexOf(".xslt");
            String verStr = entryName.substring(startInd + filePrefix.length() + 1, endInd).replace('_', '.');
            if (CnfgUtils.compareVersions(verStr, oldVersion) <= 0) continue;
            entries.add(entryName);
        }
        return entries;
    }

    private Document transformFiles(Set styleSheetz, InputStream inputStream, String parseErrorMessage, String transformErrorMessage) throws DataManagerException {
        ICCLConfiguration CCLCFGAPI = CCLConfigurationFactory.getInstance();
        if (styleSheetz.isEmpty()) {
            return null;
        }
        Iterator it = styleSheetz.iterator();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            SAXReader reader = new SAXReader();
            Document transformedDoc = reader.read(inputStream);
            while (it.hasNext()) {
                String sheetName = (String)it.next();
                InputStream styleSheet = this.getClass().getClassLoader().getResourceAsStream(sheetName);
                Transformer transformer = tFactory.newTransformer(new StreamSource(styleSheet));
                DocumentSource source = new DocumentSource(transformedDoc);
                DocumentResult result = new DocumentResult();
                transformer.transform((Source)source, (Result)result);
                transformedDoc = result.getDocument();
            }
            return transformedDoc;
        }
        catch (TransformerException e) {
            CnfgLog.error(e);
            throw new DataManagerException(transformErrorMessage);
        }
        catch (DocumentException e) {
            CnfgLog.error(e);
            throw new DataManagerException(parseErrorMessage);
        }
    }

    public static String getPathToInstallDir() {
        if (m_sInstallDirPath == null) {
            block4: {
                try {
                    m_sInstallDirPath = new File(DataManager.getPathToBinDir() + "..").getCanonicalPath();
                }
                catch (IOException e) {
                    if (!CnfgLog.isDebugEnabled()) break block4;
                    CnfgLog.debug("getPathToInstallDir - io exception " + e.getMessage());
                }
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("getPathToInstallDir - Path to install dir is " + m_sInstallDirPath);
            }
        }
        return m_sInstallDirPath;
    }

    public static String getPathToBinDir() {
        if (m_sBinDirPath == null) {
            String sPath = System.getProperty("user.dir");
            if (sPath != null) {
                try {
                    sPath = new File(sPath).getCanonicalPath();
                    sPath = sPath.replace('\\', '/');
                    if (!sPath.endsWith("/")) {
                        sPath = sPath + "/";
                    }
                }
                catch (IOException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("getPathToBinDir - io exception " + e.getMessage());
                    }
                    sPath = null;
                }
            }
            if (sPath == null) {
                sPath = "";
            }
            m_sBinDirPath = sPath;
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("getPathToBinDir - Path to bin dir is " + m_sBinDirPath);
            }
        }
        return m_sBinDirPath;
    }

    public boolean checkConfigurationFiles() throws ConfigFileNotFoundException {
        File localeFile;
        File startupFile;
        boolean extractStartupFile = false;
        boolean extractLocaleFile = false;
        String binPath = DataManager.getPathToBinDir();
        if (this.m_bCogStartupXML == null && !(startupFile = new File(binPath + "../configuration/cogstartup.xml")).exists()) {
            try {
                this.getConfigFileFromJar(startupFile, "/config/cogstartup.xml");
            }
            catch (DataManagerException e) {
                throw new ConfigFileNotFoundException(e.getMessage());
            }
            extractStartupFile = true;
        }
        if (!(localeFile = new File(binPath + "../configuration/coglocale.xml")).exists()) {
            try {
                this.getConfigFileFromJar(localeFile, "/config/coglocale.xml");
            }
            catch (DataManagerException e) {
                throw new ConfigFileNotFoundException(e.getMessage());
            }
            extractLocaleFile = true;
        }
        return extractStartupFile || extractLocaleFile;
    }

    public ICCLConfiguration getCfgApi() {
        if (this.m_cfgapi == null) {
            this.m_cfgapi = CCLConfigurationFactory.getInstance();
        }
        try {
            this.m_cfgapi.init();
        }
        catch (CCLConfigurationException e) {
            this.m_lastCfgApiInitError = e;
        }
        return this.m_cfgapi;
    }

    CCLConfigurationException getLastCfgApiError() {
        return this.m_lastCfgApiInitError;
    }

    public boolean isInstalled(String sDependencies) {
        return this.isInstalled(sDependencies, true);
    }

    public boolean isCMInstalled() {
        return this.isInstalled("CM");
    }

    public boolean isCMEnabled() {
        if (this.isCMInstalled()) {
            return this.getCMIsEnabled();
        }
        return false;
    }

    public boolean getCMIsEnabled() {
        Parameter cmenableParm = this.findParm("cmIsEnabled");
        if (cmenableParm != null && !cmenableParm.getDisabled()) {
            return (Boolean)cmenableParm.getValue();
        }
        return false;
    }

    private boolean isInstalled(String sDependencies, boolean bCheckPreferenceFile) {
        String token = null;
        if (sDependencies.length() != 0 && this.m_lCmpLst.size() != 0) {
            StringTokenizer st = new StringTokenizer(sDependencies);
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                if (this.m_lCmpLst.get(token) == null) continue;
                return true;
            }
            return CnfgUtils.isWindowsPlatform() && sDependencies.equalsIgnoreCase("win");
        }
        if (bCheckPreferenceFile && this.m_lCmpLst.size() == 0 && sDependencies.length() > 0 && !sDependencies.equalsIgnoreCase("win")) {
            String excludeCmps = (String)CnfgPreferences.getInstance().getProperty("DebugExcludeInstalledCmpLst", String.class);
            if (excludeCmps == null) {
                return true;
            }
            ArrayList<String> excludeCmpLst = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(excludeCmps);
            while (tokens.hasMoreTokens()) {
                excludeCmpLst.add(tokens.nextToken());
            }
            StringTokenizer st = new StringTokenizer(sDependencies);
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                if (excludeCmpLst.contains(token)) continue;
                return true;
            }
            return false;
        }
        if (!sDependencies.equalsIgnoreCase("win")) {
            return true;
        }
        return CnfgUtils.isWindowsPlatform();
    }

    public ArrayList<String> getRestartServicesList(String sServices) {
        ArrayList<String> lRestartServies = new ArrayList<String>();
        if (sServices.length() != 0) {
            StringTokenizer st = new StringTokenizer(sServices);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equalsIgnoreCase("NONE")) {
                    return null;
                }
                lRestartServies.add(token.toString());
            }
        }
        return lRestartServies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInCurrentView(String sViewList) {
        if (sViewList.length() != 0 && this.m_lViewList.size() != 0) {
            Boolean bl = this.fetchedAdditionalViews;
            synchronized (bl) {
                if (!this.fetchedAdditionalViews.booleanValue()) {
                    String addToView = (String)CnfgPreferences.getInstance().getProperty("AddToViewList", String.class);
                    if (addToView != null) {
                        StringTokenizer tokens = new StringTokenizer(addToView);
                        while (tokens.hasMoreTokens()) {
                            this.m_lViewList.add(tokens.nextToken());
                        }
                    }
                    this.fetchedAdditionalViews = Boolean.TRUE;
                }
            }
            StringTokenizer st = new StringTokenizer(sViewList);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!this.m_lViewList.contains(token)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void setVersion(String sVersion) {
        this.m_sVersion = sVersion;
    }

    private String getVersion() {
        return this.m_sVersion;
    }

    public boolean isContextualWizard(String wizardName) {
        WizardContent wiz;
        if (wizardName != null && (wiz = (WizardContent)this.m_wizardMap.get(wizardName.toLowerCase())) != null) {
            return wiz.isContextualWizard();
        }
        return false;
    }

    public List<WizardData> getWizardContent() {
        return this.m_lWizardContent;
    }

    public void setWizardContent(String wizardName) {
        this.m_lWizardContent = this.getWizard(wizardName);
    }

    public Hashtable getWizardMap() {
        return this.m_wizardMap;
    }

    public List<WizardData> getWizard(String wizardName) {
        if (wizardName == null) {
            return null;
        }
        WizardContent wizard = (WizardContent)this.m_wizardMap.get(wizardName.toLowerCase());
        if (wizard == null) {
            return null;
        }
        return wizard.getWizardList();
    }

    public String getWizardLabel(String wizardName) {
        if (wizardName == null) {
            return null;
        }
        WizardContent wizard = (WizardContent)this.m_wizardMap.get(wizardName.toLowerCase());
        if (wizard == null) {
            return "";
        }
        return wizard.getWizardLabel();
    }

    public String getWizardHelpFileName(String wizardName) {
        if (wizardName == null) {
            return null;
        }
        WizardContent wizard = (WizardContent)this.m_wizardMap.get(wizardName.toLowerCase());
        if (wizard == null) {
            return "";
        }
        return wizard.getWizardHelpFileName();
    }

    public String getWizardStyle(String wizardName) {
        if (wizardName == null) {
            return null;
        }
        WizardContent wizard = (WizardContent)this.m_wizardMap.get(wizardName.toLowerCase());
        if (wizard == null) {
            return null;
        }
        return wizard.getWizardStyle();
    }

    public String getWizardPanelClassName(String wizardName) {
        if (wizardName == null) {
            return null;
        }
        WizardContent wizard = (WizardContent)this.m_wizardMap.get(wizardName.toLowerCase());
        if (wizard == null) {
            return null;
        }
        return wizard.getPanelClass();
    }

    public void setWizard(String wizardName, WizardContent wizard) {
        this.m_wizardMap.put(wizardName, wizard);
    }

    public String getBackedupFileName(String fileType) {
        return this.m_backedupFiles.get(fileType);
    }

    public Hashtable getBackedupFilesMap() {
        return this.m_backedupFiles;
    }

    public boolean globalWizardsAvailable() {
        boolean bFound = false;
        Set wizards = this.m_wizardMap.keySet();
        for (String wizName : wizards) {
            WizardContent wiz = (WizardContent)this.m_wizardMap.get(wizName);
            if (wiz.isContextualWizard()) continue;
            bFound = true;
            break;
        }
        return bFound;
    }

    public Folder getCBS() {
        return this.getCBS(CBS_TYPES, "CBS");
    }

    public Folder getCBS(String[] appSvrTypes, String classType) {
        if (appSvrTypes == null) {
            return null;
        }
        Folder cbsFolder = this.m_rootFolder.findFolder(classType, true);
        if (null != cbsFolder && !cbsFolder.getDisabled() && cbsFolder.getVisibility() && 1 == cbsFolder.countFolders(true)) {
            Folder f = cbsFolder.getFolders().get(0);
            Object type = f.getTemplatedParameter().getValue();
            for (int i = 0; i < appSvrTypes.length; ++i) {
                if (!type.equals(appSvrTypes[i])) continue;
                return f;
            }
        }
        return null;
    }

    public boolean isTomcat() {
        String[] cbsTomcat = new String[]{"Tomcat"};
        return this.getCBS(cbsTomcat, "CBS") != null;
    }

    public boolean isWLP() {
        String[] cbsWLP = new String[]{"WebSphereLiberty"};
        return this.getCBS(cbsWLP, "CBS") != null;
    }

    public boolean isServletGateway() {
        return this.getSGFolder() != null;
    }

    public Folder getSGFolder() {
        String[] cbsSG = new String[]{"ServletGateway"};
        return this.getCBS(cbsSG, "SGW");
    }

    public boolean isDirty() {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("isDirty() - m_bConfigDirty=" + this.m_bConfigDirty + ", m_bLocaleDocDirty=" + this.m_bLocaleDocDirty + ", m_bWLPServerDocDirty=" + this.m_bWLPServerDocDirty);
        }
        return this.m_bConfigDirty || this.m_bLocaleDocDirty || this.m_bWLPServerDocDirty;
    }

    public boolean isConfigDirty() {
        return this.m_bConfigDirty;
    }

    public boolean isForceSave() {
        return this.m_bForceSave;
    }

    public boolean isLocaleDocDirty() {
        return this.m_bLocaleDocDirty;
    }

    public boolean isRestartServicesDirty() {
        return this.m_lRestartServices != null && this.m_lRestartServices.size() > 0;
    }

    public ArrayList getRestartServices() {
        return this.m_lRestartServices;
    }

    public void setConfigDirtyFlag(boolean bDirty) {
        this.setConfigDirtyFlag(bDirty, null);
    }

    public void setConfigDirtyFlag(boolean bDirty, ArrayList lRestartServices) {
        if (bDirty && CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("setConfigDirtyFlag - set m_bConfigDirty to true.");
            try {
                throw new Exception("Print stack trace: ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_bConfigDirty = bDirty;
        this.mergeServicesList(lRestartServices);
    }

    public void setForceSaveFlag(boolean bValue) {
        this.m_bForceSave = bValue;
    }

    private void setLocaleDocDirtyFlag(boolean bDirty, ArrayList lRestartServices) {
        this.m_bLocaleDocDirty = bDirty;
        this.mergeServicesList(lRestartServices);
    }

    public void setWLPServerDirtyFlag(boolean bDirty) {
        this.m_bWLPServerDocDirty = bDirty;
    }

    public void mergeServicesList(ArrayList lNewServicesList) {
        if (lNewServicesList != null && lNewServicesList.size() > 0) {
            if (this.m_lRestartServices == null) {
                this.m_lRestartServices = new ArrayList();
            }
            for (int i = 0; i < lNewServicesList.size(); ++i) {
                String sService = (String)lNewServicesList.get(i);
                if (this.m_lRestartServices.indexOf(sService) >= 0) continue;
                this.m_lRestartServices.add(sService);
            }
        }
    }

    private void resetRestartServicesDirtyFlag() {
        this.m_lRestartServices = null;
    }

    public ArrayList getAllServices() {
        ArrayList<String> lServiceNames = new ArrayList<String>();
        ArrayList lServiceFolders = (ArrayList)DataManager.getInstance().getServiceFolders(true);
        for (int i = 0; i < lServiceFolders.size(); ++i) {
            ServiceFolder f = (ServiceFolder)lServiceFolders.get(i);
            if (f.getParent() != null && f.getParent().getName().equals("CBS")) {
                lServiceNames.add("CBS");
                continue;
            }
            lServiceNames.add(f.getName());
        }
        return lServiceNames;
    }

    protected void loadInstallList() {
        this.loadInstallListImpl(null);
    }

    public void loadInstallListTest(String testStr) {
        this.m_lCmpLst.clear();
        this.m_isManifestInstall = false;
        this.loadInstallListImpl(testStr);
    }

    protected void loadInstallListImpl(String testStr) {
        try {
            BufferedReader br;
            if (testStr == null) {
                File componentListFile = new File(DataManager.getPathToBinDir() + "../cmplst.txt");
                br = new BufferedReader(new FileReader(componentListFile.getCanonicalFile()));
            } else {
                br = new BufferedReader(new StringReader(testStr));
            }
            String sLine = br.readLine();
            while (sLine != null) {
                this.addCmpListToMap(sLine);
                sLine = br.readLine();
            }
            if (this.m_isManifestInstall && !this.m_lCmpLst.containsKey("C8RS")) {
                this.m_lCmpLst.remove("XQE");
            }
        }
        catch (FileNotFoundException e) {
            CnfgLog.error(e);
        }
        catch (IOException e) {
            CnfgLog.error(e);
        }
    }

    private void addCmpListToMap(String sLine) {
        int index;
        String sLookingFor = "_version=";
        if (this.m_isManifestInstall) {
            sLookingFor = ",version=";
        }
        if ((index = sLine.indexOf(sLookingFor)) != -1) {
            String old;
            String version = sLine.substring(index + sLookingFor.length(), sLine.length());
            String component = sLine.substring(0, index);
            if (this.m_isManifestInstall) {
                component = DataManager.getComponetName(sLine, index);
            }
            if (version == null) {
                version = "";
            }
            if ((old = this.m_lCmpLst.put(component, version)) != null) {
                StringBuffer buff = new StringBuffer();
                buff.append(version).append(", ").append(old);
                this.m_lCmpLst.put(component, buff.toString());
            }
        }
    }

    protected static String getComponetName(String sLine, int end) {
        int pos1 = sLine.indexOf(44);
        if (pos1 == -1) {
            return "";
        }
        String compName = sLine.substring(0, pos1);
        if (pos1 < end) {
            String manifest = sLine.substring(pos1, end);
            if (manifest.endsWith("GATE-INST")) {
                compName = compName + "GATE";
            } else if (manifest.endsWith("CM-INST") && compName.equals("SECURITY-INSTALL")) {
                compName = "SECURITY_CM";
            }
        }
        return compName;
    }

    private boolean isManifestInstall(String sLine) {
        return false;
    }

    public void addView(String sViewName) {
        if (sViewName != null && sViewName.length() != 0) {
            this.m_lViewList.add(sViewName);
        }
    }

    public void setDoNotDecryptCredentials(boolean donotdecrypt) {
        this.m_bDoNotDecryptCredentials = donotdecrypt;
    }

    public boolean doNotNeedDecryptCredentials() {
        return this.m_bDoNotDecryptCredentials;
    }

    private void loadWizardUI() {
        SAXReader saxReader = new SAXReader();
        Document wizardUIDoc = null;
        try {
            InputStream wizIs = this.getClass().getResourceAsStream("/config/wizard_ui_doc.xml");
            wizardUIDoc = wizIs == null ? null : saxReader.read(wizIs);
        }
        catch (DocumentException e) {
            CnfgLog.error(e);
            wizardUIDoc = null;
        }
        if (wizardUIDoc == null) {
            return;
        }
        Locale locale = CnfgResource.getLocale();
        try {
            ResourceBundle rb = ResourceBundle.getBundle("config_wizard", locale);
            CnfgUIDocResource.setResourceBundle(rb, "config_wizard");
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::loadWizardUI() - Found 'config_wizard' property for locale '" + rb.getLocale() + "'");
            }
        }
        catch (MissingResourceException mre) {
            CnfgLog.error(mre);
            CnfgLog.error("DataManager::loadWizardUI() - config_wizard property for locale '" + locale.getDisplayName(Locale.ENGLISH) + "' not found. As well, unable to find the default property file.");
            return;
        }
        Element rootElem = wizardUIDoc.getRootElement();
        List lWizardElems = rootElem.elements("wizard");
        if (lWizardElems.size() == 0) {
            return;
        }
        for (int j = 0; j < lWizardElems.size(); ++j) {
            String sWizardStyle;
            Element wizardElem = (Element)lWizardElems.get(j);
            String sWizardName = wizardElem.attributeValue("name", "").toLowerCase();
            String sWizardMode = wizardElem.attributeValue("mode", "").toLowerCase();
            String sWizardPanelClass = wizardElem.attributeValue("panelClass", "");
            if (CnfgWizard.getInstance().isWizardMode() ? !sWizardName.equals(CnfgWizard.getInstance().getWizardModeName()) : !sWizardMode.startsWith("config")) continue;
            String sWizardLabel = wizardElem.attributeValue("label", "");
            String sWizMaxParamPerPage = wizardElem.attributeValue("maxParamPerPage", "");
            int wizMaxParam = 5;
            if (sWizMaxParamPerPage.length() != 0) {
                wizMaxParam = new Integer(sWizMaxParamPerPage);
            }
            if ((sWizardStyle = wizardElem.attributeValue("style", "")).length() == 0) {
                sWizardStyle = "straight";
            }
            String sWizardHelpFile = wizardElem.attributeValue("helpFile", "");
            ArrayList<WizardData> lWizardContent = new ArrayList<WizardData>();
            List lWizardPageElems = wizardElem.elements();
            boolean isLastPage = false;
            boolean bHasWizParams = false;
            for (int i = 0; i < lWizardPageElems.size(); ++i) {
                Element pageElem = (Element)lWizardPageElems.get(i);
                if (pageElem.getQName().getName().equals("wizardPage")) {
                    String sComplexPageName = pageElem.attributeValue("complexPage", "");
                    String sGroupName = pageElem.attributeValue("group", "");
                    String sName = pageElem.attributeValue("name", "");
                    String sLabel = CnfgUIDocResource.getMessage(pageElem.attributeValue("label", ""), "config_wizard");
                    String sIsLast = pageElem.attributeValue("isLast", "");
                    String sHelpFile = pageElem.attributeValue("helpFile", "");
                    String sTransitWizardName = pageElem.attributeValue("transitWizName", "");
                    isLastPage = sIsLast.equals("true");
                    int maxParam = wizMaxParam;
                    String sMaxParamPerPage = pageElem.attributeValue("maxParamPerPage", "");
                    if (sMaxParamPerPage.length() != 0) {
                        maxParam = new Integer(sMaxParamPerPage);
                    }
                    WizardPageData wPage = new WizardPageData(sComplexPageName, sGroupName, sName, sLabel, isLastPage, maxParam);
                    wPage.setHelpFile(sHelpFile);
                    wPage.setTransitWizardName(sTransitWizardName);
                    wPage.loadChildren(pageElem);
                    lWizardContent.add(wPage);
                    if (!bHasWizParams) {
                        bHasWizParams = wPage.hasWizParams();
                    }
                }
                if (!pageElem.getQName().getName().equals("complexWizardPage")) continue;
                String sName = pageElem.attributeValue("name", "");
                String sLabel = CnfgUIDocResource.getMessage(pageElem.attributeValue("label", ""), "config_wizard");
                WizardComplexPageData cwPage = new WizardComplexPageData(sName, sLabel);
                cwPage.loadChildren(pageElem);
                lWizardContent.add(cwPage);
                if (bHasWizParams) continue;
                bHasWizParams = cwPage.hasWizParams();
            }
            if (bHasWizParams) {
                WizardContent wizard = new WizardContent(sWizardName, sWizardLabel, sWizardStyle, lWizardContent, bHasWizParams, sWizardHelpFile);
                wizard.setWizMode(sWizardMode);
                wizard.setPanelClass(sWizardPanelClass);
                this.setWizard(sWizardName, wizard);
            }
            if (CnfgWizard.getInstance().isWizardMode()) break;
        }
    }

    public WizardPageData findWizardPage(String complexPageName, String groupName, String name) {
        List<WizardData> curWizard = this.getWizardContent();
        if (curWizard == null) {
            return null;
        }
        for (int i = 0; i < curWizard.size(); ++i) {
            WizardComplexPageData cwPage;
            WizardPageData wPage;
            WizardPageData wPage2;
            WizardData page = curWizard.get(i);
            if (WizardPageData.class.isInstance(page) && (wPage2 = (WizardPageData)page).checkWizardPage(complexPageName, groupName, name)) {
                return wPage2;
            }
            if (!WizardComplexPageData.class.isInstance(page) || (wPage = (cwPage = (WizardComplexPageData)page).checkWizardPage(complexPageName, groupName, name)) == null) continue;
            return wPage;
        }
        return null;
    }

    private static Element getElementByTagName(Element element, String sLocalName, String sIdentifier) {
        String sAttributeName;
        String sId;
        ArrayList<Element> list = new ArrayList<Element>();
        if (element.getName().equals(sLocalName) && (sId = element.attributeValue(sAttributeName = sLocalName.compareToIgnoreCase("option") == 0 ? "value" : "name")).compareTo(sIdentifier) == 0) {
            list.add(element);
        }
        DataManager.getElementByTagNameHelper(list, element, sLocalName, sIdentifier);
        return list.isEmpty() ? null : (Element)list.get(0);
    }

    private static void getElementByTagNameHelper(List list, Element element, String sLocalName, String sIdentifier) {
        int size = element.nodeCount();
        for (int i = 0; i < size; ++i) {
            String sAttributeName;
            String sId;
            Node node = element.node(i);
            if (!(node instanceof Element)) continue;
            Element tempElem = (Element)node;
            if (tempElem.getName().equals(sLocalName) && (sId = tempElem.attributeValue(sAttributeName = sLocalName.compareToIgnoreCase("option") == 0 ? "value" : "name", "")).compareTo(sIdentifier) == 0) {
                list.add(tempElem);
            }
            DataManager.getElementByTagNameHelper(list, tempElem, sLocalName, sIdentifier);
        }
    }

    private void mergeUIDocs(Element target, Element source) {
        String sAttributeName = source.getName().compareToIgnoreCase("option") == 0 ? "value" : "name";
        String sId = source.attributeValue(sAttributeName, "");
        Element matchInTarget = DataManager.getElementByTagName(target, source.getName(), sId);
        if (matchInTarget == null) {
            source.detach();
            target.add(source);
            return;
        }
        List sourceList = source.elements();
        for (int i = 0; i < sourceList.size(); ++i) {
            Element sourceChild = (Element)sourceList.get(i);
            this.mergeUIDocs(matchInTarget, sourceChild);
        }
    }

    private void loadUIDocs() throws DataManagerException {
        if (!m_uiDocsLoaded) {
            Element baseRoot = null;
            try {
                m_uiDocDocument = DocumentHelper.parseText((String)this.getUIDoc("/config/config_su_ui.xml", true));
                baseRoot = m_uiDocDocument.getRootElement();
            }
            catch (DocumentException e) {
                CnfgLog.error(e);
                throw new DataManagerException(CnfgResource.getMessage("Message.loadConfig.invalidFormatUIDoc.explanation"));
            }
            Boolean bLoadExts = (Boolean)CnfgPreferences.getInstance().getProperty("LoadExtensions", "true", Boolean.class);
            if (bLoadExts.booleanValue()) {
                int count = 1;
                String sExtDir = (String)CnfgPreferences.getInstance().getProperty("ExtensionDir." + new Integer(count).toString(), String.class);
                if (sExtDir == null) {
                    sExtDir = "../configuration/cnfg";
                }
                while (sExtDir != null) {
                    File extDir = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(sExtDir));
                    if (extDir.exists()) {
                        FileFilter cnfgFilter = new FileFilter(){

                            @Override
                            public boolean accept(File f) {
                                String extension;
                                return f != null && f.isFile() && (extension = CnfgUtils.getFileExtension(f)) != null && extension.compareTo("xml") == 0;
                            }
                        };
                        ArrayList<File> extFiles = new ArrayList<File>(Arrays.asList(extDir.listFiles(cnfgFilter)));
                        for (int i = 0; i < extFiles.size(); ++i) {
                            File sExtFile = extFiles.get(i);
                            try {
                                Document extensionUIDoc = DocumentHelper.parseText((String)this.getUIDoc(sExtFile.getCanonicalPath(), false));
                                Element rootElem = extensionUIDoc.getRootElement();
                                this.mergeUIDocs(baseRoot, rootElem);
                                continue;
                            }
                            catch (IOException e) {
                                if (!CnfgLog.isDebugEnabled()) continue;
                                CnfgLog.debug("The extension UI doc ( " + sExtFile + " ) failed to load, continue processing. Exception :" + e.getMessage());
                                continue;
                            }
                            catch (DocumentException e) {
                                if (!CnfgLog.isDebugEnabled()) continue;
                                CnfgLog.debug("The extension UI doc ( " + sExtFile + " ) failed to load, continue processing. Exception :" + e.getMessage());
                            }
                        }
                    }
                    sExtDir = (String)CnfgPreferences.getInstance().getProperty("ExtensionDir." + new Integer(++count).toString(), String.class);
                }
            }
            boolean cmIsPresent = false;
            boolean rsIsPresent = false;
            boolean cmmIsPresent = false;
            boolean planningIsPresent = false;
            if (this.m_lCmpLst.get("CM") != null) {
                cmIsPresent = true;
            }
            if (this.m_lCmpLst.get("C8RS") != null) {
                rsIsPresent = true;
            }
            if (this.m_lCmpLst.get("CMMAPPLICATION") != null) {
                cmmIsPresent = true;
            }
            if (this.m_lCmpLst.get("PLANNING8") != null || this.m_lCmpLst.get("PLANNINGANALYSTNETWORK8") != null || this.m_lCmpLst.get("PLANNINGANALYST8") != null) {
                planningIsPresent = true;
            }
            if (cmIsPresent && !rsIsPresent && !cmmIsPresent && !planningIsPresent) {
                Element dispIsEnabledElem = (Element)m_uiDocDocument.selectSingleNode("//parameter[@name='dispIsEnabled']");
                dispIsEnabledElem.addAttribute("default", "false");
                Element xtscrnIsEnabledElem = (Element)m_uiDocDocument.selectSingleNode("//parameter[@name='xtscrnIsEnabled']");
                xtscrnIsEnabledElem.addAttribute("default", "false");
            }
            boolean migIsPresent = false;
            if (this.m_lCmpLst.get("MIGDEPLOY") != null) {
                migIsPresent = true;
            }
            if (migIsPresent && !cmIsPresent) {
                Element migsrvIsEnabledElem = (Element)m_uiDocDocument.selectSingleNode("//parameter[@name='migsrvIsEnabled']");
                migsrvIsEnabledElem.addAttribute("default", "false");
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Base UI doc + extension docs loaded.");
            }
            m_uiDocsLoaded = true;
        }
    }

    public void reloadConfig() throws DataManagerException, StartupFileException {
        ServiceManager.removeListeners();
        this.m_upgradedStartupDoc = null;
        this.m_upgradedLocaleDoc = null;
        boolean bIsUpgraded = false;
        if (this.checkUpgrade()) {
            this.m_bStartupConfigUpgradeDone = false;
            bIsUpgraded = this.upgradeConfigFile();
        }
        m_uiDocsLoaded = false;
        this.getConfig();
        this.resetServiceFolders();
        if (bIsUpgraded) {
            this.mergeServicesList(this.getAllServices());
            this.customizedUpgrade();
        }
        ServiceManager.resetIsRunning();
        this.newConfig();
    }

    public void getConfig() throws DataManagerException, StartupFileException {
        this.loadUIDocs();
        Element root_elem = m_uiDocDocument.getRootElement();
        this.setVersion(root_elem.attributeValue("version"));
        this.m_rootFolder = new RootFolder();
        ServiceManager.addListener((RootFolder)this.m_rootFolder);
        if (this.m_rootFolder.load(null, root_elem)) {
            this.m_wlp.setRootFolder(this.m_rootFolder);
            this.m_wlp.setDispInstalled(this.isInstalled("DISP"));
            this.m_wlp.setStandAloneInstalled(this.isInstalled("STANDALONECOMMON"));
            this.m_wlp.setFlipperInstalled(this.isInstalled("FLIPPER") || this.isInstalled("FLIPPERSTANDALONE"));
            this.addCnfgValueChangedListener(this.m_wlp);
            StartupProcessor.getStartupParameters();
            this.m_wlp.populateFromProperties();
            if (DataManager.getInstance().hasSuperConfig()) {
                this.replaceParameters();
            }
            this.m_verifyConfig.populateParameters();
            this.addCnfgValueChangedListener(this.m_verifyConfig);
            this.setBTSVServicesName();
            boolean bIsCMInstalled = this.isInstalled("CM");
            boolean bIsJSMInstalled = this.isInstalled("JSM");
            boolean bIsPLAInstalled = this.isInstalled("PLANNING8");
            if (!bIsCMInstalled && bIsJSMInstalled) {
                this.makeDBMandatory("NC");
            }
            if (!bIsCMInstalled && bIsPLAInstalled) {
                this.makeDBMandatory("PLANNING");
            }
            if (!this.m_bUseJCAM) {
                this.m_bUseJCAM = this.isInstalled("C8BISRVRCCD C8BISRVRCM C8BISRVRRS C8BISRVRGATE") ? this.isInstalled("C8BISRVRCM C8BISRVRRS C8BISRVRGATE") : (this.isInstalled("CRNSRVRCCD CRNSRVRCM CRNSRVRRS CRNSRVRGATE") ? this.isInstalled("CRNSRVRCM CRNSRVRRS CRNSRVRGATE") : true);
            }
            Creator.useJCAM(this.m_bUseJCAM);
            if (!this.m_bUseJCAM) {
                Parameter p;
                Folder crypto = this.m_rootFolder.findComplexFolder("CRYPTO", true);
                if (crypto != null) {
                    crypto.setDisabled(true);
                    crypto.setVisibility(false);
                    Folder parentOfCrypto = crypto.getParent();
                    if (parentOfCrypto != null && 0 == parentOfCrypto.countFolders(true) + parentOfCrypto.countParameters(true) + parentOfCrypto.countTemplatedParameters(true)) {
                        parentOfCrypto.setVisibility(false);
                    }
                    parentOfCrypto.remove(crypto);
                }
                if ((p = this.m_rootFolder.findParm("temp")) != null) {
                    p.setDisabled(true);
                    p.setVisibility(false);
                }
                if ((p = this.m_rootFolder.findParm("data")) != null) {
                    p.setDisabled(true);
                    p.setVisibility(false);
                }
                if ((p = this.m_rootFolder.findParm("encryptTemporaryFiles")) != null) {
                    p.setDisabled(true);
                    p.setVisibility(false);
                }
            }
        }
        this.loadWizardUI();
        this.loadCNFMData();
        if (this.isTomcat() && this.m_bWLPServerDocDirty) {
            this.setWLPServerDirtyFlag(false);
        }
    }

    private void replaceParameters() {
        Parameter envVarParam;
        SuperParameter superP = new SuperParameter();
        superP.setup();
        Map<String, String> envList = superP.getEnvConfiguredParms();
        Set<String> parmNames = envList.keySet();
        DataManager dataInstance = DataManager.getInstance();
        for (String name : parmNames) {
            Parameter p = dataInstance.m_rootFolder.findParm(name);
            if (p == null) continue;
            if (StringParameter.class.isInstance(p) || BooleanParameter.class.isInstance(p) || IntegerParameter.class.isInstance(p) || URLParameter.class.isInstance(p)) {
                p.setValue(superP.getValue(name, p.getValue()));
                continue;
            }
            if (!ArrayParameter.class.isInstance(p)) continue;
            ((ArrayParameter)p).setValue(superP.getValue(name, p.getValue()));
        }
        if (!superP.getEnvVarsProperties().isEmpty() && (envVarParam = dataInstance.findParam("cbsEnvVar")) != null) {
            EnvVarArrayParameter envVarsParam = (EnvVarArrayParameter)envVarParam;
            envVarsParam.loadEnvVars(superP.getEnvVarsProperties());
            envVarsParam.setDirtyFlag(true);
            this.m_wlp.setEnvVarsChanged(true);
        }
    }

    private void loadCNFMData() {
        CNFMConfiguration cnfmInst = CNFMConfiguration.getInstance();
        this.getProductInfo(cnfmInst);
        this.m_bIsCNFMCheckingDisabled = this.retrieveCNFMCheckingDisabled();
        cnfmInst.setCNFMCheckingDisabled(this.m_bIsCNFMCheckingDisabled.booleanValue());
    }

    private void getProductInfo(CNFMConfiguration cnfmInst) {
        if (this.isInstalled("C8BISRVR")) {
            cnfmInst.setProductName("BI");
            String ver = (String)this.getCmpLst().get("C8BISRVR");
            if (ver == null || ver.length() == 0) {
                return;
            }
            StringTokenizer tokens = new StringTokenizer(ver, "-");
            for (int number = 0; tokens.hasMoreTokens() && number < 4; ++number) {
                tokens.nextToken();
            }
            if (tokens.hasMoreTokens()) {
                String vertoken = tokens.nextToken();
                tokens = new StringTokenizer(vertoken, ".");
                StringBuffer biVer = new StringBuffer();
                int idx = 0;
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    biVer.append(token);
                    if (idx >= true) break;
                    biVer.append(".");
                    ++idx;
                }
                cnfmInst.setProductVersion(biVer.toString());
            }
        }
    }

    public Boolean retrieveCNFMCheckingDisabled() {
        Boolean bDisabled = (Boolean)CnfgPreferences.getInstance().getProperty("ConformanceCheckingIsDisabled", "false", Boolean.class);
        if (bDisabled != null) {
            return bDisabled;
        }
        return this.m_bIsCNFMCheckingDisabled;
    }

    public void foundEncryptable(Parameter encryptable, Folder parentFolder) {
        if (!encryptable.getDisabled() && !this.m_bUseJCAM) {
            boolean bInCryptoSection = false;
            while (parentFolder != null && parentFolder.getParent() != null) {
                if (parentFolder.getName().equals("CRYPTO")) {
                    bInCryptoSection = true;
                    break;
                }
                parentFolder = parentFolder.getParent();
            }
            if (!bInCryptoSection) {
                this.m_bUseJCAM = true;
            }
        }
    }

    public boolean useJCAM() {
        return this.m_bUseJCAM;
    }

    private void makeDBMandatory(String paramName) {
        Folder f = this.findFolder(paramName, true);
        if (f != null && !f.getDisabled() && f.getVisibility()) {
            for (int i = 0; i < f.getTParameters().size(); ++i) {
                Parameter p;
                TemplatedParameter tp = f.getTParameters().get(i);
                if (null == tp || tp.getDisabled() || !tp.getVisibility() || !tp.getName().equals("database") || (p = tp.getParameter()) == null) continue;
                p.setMinOccurs(1);
            }
        }
    }

    public static String getLocalJavaHome() {
        try {
            ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
            String str = cfg.resolveEffectivePath("../ibm-jre/jre");
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("getLocalJavaHome() - return '" + str + "'.");
            }
            return str;
        }
        catch (Exception e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("getLocalJavaHome() - exception - return null. " + e);
            }
            return null;
        }
    }

    public static String getCurrentJavaHome() {
        String str = System.getProperty("java.home");
        ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
        String path = cfg.resolveEffectivePath(str);
        return path;
    }

    public int heavyCurrentJavaValidation(int javaStatus, List errors) {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("heavyCurrentJavaValidation() - Enter method.");
        }
        int ret = 0;
        if (javaStatus == 1) {
            ret = DataManager.isCurrentJavaUsable(errors);
        } else if (javaStatus == 2) {
            ret = DataManager.isCurrentJavaCompatible(errors);
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("heavyCurrentJavaValidation() - Exit method, return value is " + ret);
        }
        return ret;
    }

    public int lightCurrentJavaValidation() {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("lightCurrentJavaValidation() - Enter method.");
        }
        String sJavaVersion = (String)CnfgPreferences.getInstance().getProperty("JavaVersion", String.class);
        String sJavaHome = (String)CnfgPreferences.getInstance().getProperty("JavaHome", String.class);
        String sJavaVendor = (String)CnfgPreferences.getInstance().getProperty("JavaVendor", String.class);
        if (sJavaVersion != null && sJavaHome != null && sJavaVendor != null) {
            if (sJavaVersion.equals(CnfgUtils.getCurrentJavaVersion()) && sJavaHome.equals(DataManager.getCurrentJavaHome()) && sJavaVendor.equals(CnfgUtils.getCurrentJavaVendor())) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("Java info matches. Skipping Java test. Returning 0");
                }
                return 0;
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Java info doesn't match. Check to see if the keys are present or not.");
            }
        }
        ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
        Parameter p = this.m_rootFolder.findParm("CSKPath");
        if (p != null && !p.getDisabled()) {
            String sKeysPath = (String)p.getValue();
            String str = cfg.resolveEffectivePath(sKeysPath + File.separator + "jCSKKeystore");
            File myfile = new File(str);
            if (!myfile.exists()) {
                String sCurrentHome = DataManager.getCurrentJavaHome();
                String sLocalHome = DataManager.getLocalJavaHome();
                if (sLocalHome != null && sLocalHome.equals(sCurrentHome)) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("We are using the local distribution. Java local and current matches. Keys are not generated yet. Returning 0");
                    }
                    return 0;
                }
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("The keys are not generated and the java home is either different from our local distribution or we are on Unix platforms. Returning 1");
                    CnfgLog.debug("Current Java_Home: " + sCurrentHome + "\n");
                    CnfgLog.debug("Local Java_Home: " + sLocalHome + "\n");
                }
                return 1;
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("The keys exist. Returning 2");
            }
            return 2;
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("Error getting CSKPath, parameter doesn't exist. Returning 1");
        }
        return 1;
    }

    private static int exception(Throwable e, int retValue, String debugText, List errors) {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug(debugText + "'" + e.getClass() + "' message is '" + e.getMessage() + "'. Returning " + retValue);
            CnfgLog.debug(e);
        }
        errors.add(e.getMessage());
        return retValue;
    }

    protected static int isCurrentJavaUsable(List errors) {
        ICAMFactory cf;
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("isCurrentJavaUsable() - Enter method.");
        }
        try {
            cf = Creator.createCAMFactory();
            cf.initialize("<initializeDocument><serviceID>CNFG</serviceID></initializeDocument>".getBytes());
        }
        catch (CAMCryptoKeyException e) {
            return DataManager.exception(e, 999, "Initializing CAMFactory failed.", errors);
        }
        catch (CAMCryptoException e) {
            return DataManager.exception(e, 1, "Initializing CAMFactory failed.", errors);
        }
        catch (Throwable e) {
            return DataManager.exception(e, 2, "Initializing CAMFactory failed.", errors);
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("Initializing CAMFactory succeeded.");
        }
        try {
            cf.createEncryptingSession();
        }
        catch (CAMCryptoKeyException e) {
            return DataManager.exception(e, 999, "Creating Encrypting Session failed.", errors);
        }
        catch (CAMCryptoException e) {
            return DataManager.exception(e, 3, "Creating Encrypting Session failed.", errors);
        }
        catch (Throwable e) {
            return DataManager.exception(e, 3, "Creating Encrypting Session failed.", errors);
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("Creating Encrypting Session succeeded.");
        }
        return 0;
    }

    protected static int isCurrentJavaCompatible(List errors) {
        ICAMFactory cf;
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("isCurrentJavaCompatible() - Enter method.");
        }
        try {
            cf = Creator.createCAMFactory();
            cf.initialize("<initializeDocument><serviceID>CNFG</serviceID></initializeDocument>".getBytes());
        }
        catch (CAMCryptoKeyException e) {
            return DataManager.exception(e, 999, "Initializing CAMFactory failed.", errors);
        }
        catch (CAMCryptoException e) {
            return DataManager.exception(e, 1, "Initializing CAMFactory failed.", errors);
        }
        catch (Throwable e) {
            return DataManager.exception(e, 2, "Initializing CAMFactory failed.", errors);
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("Initializing CAMFactory succeeded.");
        }
        IEncryptingSession es = null;
        try {
            es = cf.createEncryptingSession();
        }
        catch (CAMCryptoKeyException e) {
            return DataManager.exception(e, 999, "Creating Encrypting Session failed.", errors);
        }
        catch (CAMCryptoException e) {
            return DataManager.exception(e, 3, "Creating Encrypting Session failed.", errors);
        }
        catch (Throwable e) {
            return DataManager.exception(e, 3, "Creating Encrypting Session failed.", errors);
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("Creating Encrypting Session succeeded.");
        }
        byte[] plaintext = "line1\nline2\nline3\n\n\nline5\n".getBytes();
        try {
            int retValue = 0;
            byte[] ciphertext = es.encryptData(plaintext);
            byte[] plaintext2 = es.decryptData(ciphertext);
            String a = new String(plaintext);
            String b = new String(plaintext2);
            if (!a.equals(b)) {
                retValue = 4;
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("Symmetric Encrypting/Decrypting failed. Returning " + retValue);
                }
                errors.add(CnfgResource.getMessage("Message.errorOnValidation.Cryptography.Symetric"));
            } else {
                retValue = 0;
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("Symmetric Encrypting/Decrypting succeeded. Returning " + retValue);
                }
            }
            return retValue;
        }
        catch (CAMCryptoKeyException e) {
            return DataManager.exception(e, 999, "Symmetric Encrypting/Decrypting failed.", errors);
        }
        catch (CAMCryptoException e) {
            return DataManager.exception(e, 5, "Symmetric Encrypting/Decrypting failed.", errors);
        }
        catch (Throwable e) {
            return DataManager.exception(e, 6, "Symmetric Encrypting/Decrypting failed.", errors);
        }
    }

    public static String getJavaErrorMessage(int ret) {
        StringBuffer sBuf = new StringBuffer();
        if (ret == 1 || ret == 2 || ret == 3) {
            if (CnfgUtils.isWindowsPlatform()) {
                String sLocal;
                String sCurrent = DataManager.getCurrentJavaHome();
                if (sCurrent.equalsIgnoreCase(sLocal = DataManager.getLocalJavaHome())) {
                    Object[] args1 = new Object[]{sLocal};
                    sBuf.append(CnfgResource.getMessage("Message.task.validate.cryptograhy", args1)).append("\n\n").append(CnfgResource.getMessage("Message.task.error.cryptokeys.resolve.win32.2"));
                } else {
                    Object[] args1 = new Object[]{sCurrent};
                    Object[] args2 = new Object[]{sLocal};
                    sBuf.append(CnfgResource.getMessage("Message.task.validate.cryptograhy", args1)).append("\n\n").append(CnfgResource.getMessage("Message.task.error.cryptokeys.resolve.win32.1", args2));
                }
            } else {
                Object[] args1 = new Object[]{DataManager.getCurrentJavaHome()};
                sBuf.append(CnfgResource.getMessage("Message.task.validate.cryptograhy", args1)).append("\n\n").append(CnfgResource.getMessage("Message.task.error.cryptokeys.resolve.unix"));
            }
        } else if (ret == 999) {
            String sCurJVM = DataManager.getCurrentJavaHome();
            Object[] args1 = new Object[]{sCurJVM};
            String sOldJVM = (String)CnfgPreferences.getInstance().getProperty("JavaHome", String.class);
            if (sOldJVM != null) {
                Object[] args2 = new Object[]{sOldJVM, sCurJVM};
                sBuf.append(CnfgResource.getMessage("Message.task.error.cryptokeys.mismatch.regenkey.notification.one", args2));
            } else {
                sBuf.append(CnfgResource.getMessage("Message.task.error.cryptokeys.mismatch.regenkey.notification.two", args1));
            }
        } else if (ret != 0) {
            Object[] args1 = new Object[]{DataManager.getCurrentJavaHome()};
            sBuf.append(CnfgResource.getMessage("Message.task.validate.cryptograhy", args1));
            String sJavaHome = (String)CnfgPreferences.getInstance().getProperty("JavaHome", String.class);
            if (sJavaHome != null) {
                Object[] args2 = new Object[]{sJavaHome};
                sBuf.append("\n\n").append(CnfgResource.getMessage("Message.task.error.cryptokeys.mismatch.resolve.one", args2));
            } else {
                sBuf.append("\n\n").append(CnfgResource.getMessage("Message.task.error.cryptokeys.mismatch.resolve.two"));
            }
        } else {
            return null;
        }
        return sBuf.toString();
    }

    public void newConfig() {
        this.notifyDataListeners();
    }

    private void notifyDataListeners() {
        CnfgDataEvent e = new CnfgDataEvent(this.m_rootFolder);
        this.fireDataLoaded(e);
        this.setCurrentSelection(this.m_rootFolder);
    }

    private String getUIDoc(String sPath, boolean bFromJar) throws DataManagerException {
        String sMessage;
        StringWriter writer = new StringWriter(4096);
        BufferedReader in = null;
        try {
            InputStream is = null;
            if (bFromJar) {
                is = this.getClass().getResourceAsStream(sPath);
            } else {
                File uidocFile = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath(sPath));
                try {
                    is = new FileInputStream(uidocFile);
                }
                catch (IOException e) {
                    CnfgLog.error(e);
                    String sMessage2 = new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.ioexception.explanation")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage2);
                }
            }
            if (is == null) {
                sMessage = new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.missingUIDoc.explanation")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                CnfgLog.error("DataManager::getUIDoc()- error is " + sMessage);
                throw new DataManagerException(sMessage);
            }
            in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            CnfgLog.error(e);
            String sMessage3 = new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.invalidEncoding.explanation")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
            throw new DataManagerException(sMessage3);
        }
        try {
            char[] cbuf = new char[4096];
            int size = 0;
            while ((size = in.read(cbuf, 0, 4096)) != -1) {
                writer.write(cbuf, 0, size);
            }
            in.close();
            writer.flush();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            sMessage = new StringBuffer(CnfgResource.getMessage("Message.loadConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.ioexception.explanation")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
            throw new DataManagerException(sMessage);
        }
        return writer.toString();
    }

    public File resolveEffectiveFilePath(String sPath) throws DataManagerException {
        String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sPath);
        File file = new File(sResolvedPath);
        File parent = new File(file.getParent());
        if (!parent.isDirectory() && !parent.mkdirs()) {
            Object[] args = new Object[]{sResolvedPath};
            String sMessage = CnfgResource.getMessage("Message.saveConfig.failed.unableToMkdir.explanation", args);
            throw new DataManagerException(sMessage);
        }
        return file;
    }

    public File resolveEffectiveFolderPath(String sPath) throws DataManagerException {
        String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sPath);
        File file = new File(sResolvedPath);
        if (!file.isDirectory() && !file.mkdirs()) {
            Object[] args = new Object[]{sResolvedPath};
            String sMessage = CnfgResource.getMessage("Message.saveConfig.failed.unableToMkdir.explanation", args);
            throw new DataManagerException(sMessage);
        }
        return file;
    }

    public Parameter createParameter(Element elem, String sParamType, String sTypePrefix) {
        String sType = "";
        String sPrefix = "";
        if (elem != null) {
            sType = elem.attributeValue("type", "");
            int idx = sType.indexOf(":");
            if (idx == -1) {
                return null;
            }
            sPrefix = sType.substring(0, idx);
            Namespace ns = elem.getNamespaceForPrefix(sPrefix);
            if (ns == null) {
                return null;
            }
            if (!ns.getURI().equals("http://www.w3.org/2001/XMLSchema") && !ns.getURI().equals("http://developer.cognos.com/schemas/configparams/XMLSchema/1/")) {
                return null;
            }
        } else {
            sType = sParamType;
            sPrefix = sTypePrefix;
        }
        Parameter p = null;
        if (sType.equals(sPrefix + ":" + "string")) {
            p = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
        } else if (sType.equals(sPrefix + ":" + "boolean")) {
            p = new BooleanParameter("http://www.w3.org/2001/XMLSchema", "boolean");
        } else if (sType.equals(sPrefix + ":" + "long")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "long", NumConst.MN_LONG, NumConst.MX_LONG);
        } else if (sType.equals(sPrefix + ":" + "int")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "int", NumConst.MN_INT, NumConst.MX_INT);
        } else if (sType.equals(sPrefix + ":" + "short")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "short", NumConst.MN_SHORT, NumConst.MX_SHORT);
        } else if (sType.equals(sPrefix + ":" + "byte")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "byte", NumConst.MN_BYTE, NumConst.MX_BYTE);
        } else if (sType.equals(sPrefix + ":" + "unsignedLong")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "unsignedLong", NumConst.MN_ULONG, NumConst.MX_ULONG);
        } else if (sType.equals(sPrefix + ":" + "unsignedInt")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "unsignedInt", NumConst.MN_UINT, NumConst.MX_UINT);
        } else if (sType.equals(sPrefix + ":" + "unsignedShort")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "unsignedShort", NumConst.MN_USHORT, NumConst.MX_USHORT);
        } else if (sType.equals(sPrefix + ":" + "unsignedByte")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "unsignedByte", NumConst.MN_UBYTE, NumConst.MX_UBYTE);
        } else if (sType.equals(sPrefix + ":" + "float")) {
            p = new DecimalParameter("http://www.w3.org/2001/XMLSchema", "float", NumConst.MN_FLOAT, NumConst.MX_FLOAT);
        } else if (sType.equals(sPrefix + ":" + "double")) {
            p = new DecimalParameter("http://www.w3.org/2001/XMLSchema", "double", NumConst.MN_DOUBLE, NumConst.MX_DOUBLE);
        } else if (sType.equals(sPrefix + ":" + "decimal")) {
            p = new DecimalParameter("http://www.w3.org/2001/XMLSchema", "decimal", null, null);
        } else if (sType.equals(sPrefix + ":" + "integer")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "integer", null, null);
        } else if (sType.equals(sPrefix + ":" + "nonPositiveInteger")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger", null, new BigInteger("0"));
        } else if (sType.equals(sPrefix + ":" + "negativeInteger")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "negativeInteger", null, new BigInteger("-1"));
        } else if (sType.equals(sPrefix + ":" + "nonNegativeInteger")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger", new BigInteger("0"), null);
        } else if (sType.equals(sPrefix + ":" + "positiveInteger")) {
            p = new IntegerParameter("http://www.w3.org/2001/XMLSchema", "positiveInteger", new BigInteger("1"), null);
        } else if (sType.equals(sPrefix + ":" + "anyPathURI")) {
            p = new AnyURIParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "anyPathURI");
        } else if (sType.equals(sPrefix + ":" + "anyURI")) {
            p = new URLPathParameter("http://www.w3.org/2001/XMLSchema", "anyURI");
        } else if (sType.equals(sPrefix + ":" + "hostportURI")) {
            p = new URLParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "hostportURI");
        } else if (sType.equals(sPrefix + ":" + "localURI")) {
            p = new LocalURLParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "localURI");
        } else if (sType.equals(sPrefix + ":" + "language")) {
            p = new LanguageParameter("http://www.w3.org/2001/XMLSchema", "language");
        } else {
            if (sType.equals(sPrefix + ":" + "anyType")) {
                return null;
            }
            if (sType.equals(sPrefix + ":" + "credential")) {
                p = new CredentialParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "credential");
            } else if (sType.equals(sPrefix + ":" + "filePath")) {
                p = new PathParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "filePath");
            } else if (sType.equals(sPrefix + ":" + "folderPath")) {
                p = new PathParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "folderPath");
            } else if (sType.equals(sPrefix + ":" + "systemPassword")) {
                p = new SystemPasswordParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "systemPassword");
            } else if (sType.equals(sPrefix + ":" + "timeZone")) {
                p = new TimeZoneParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "timeZone");
            } else if (sType.equals(sPrefix + ":" + "hostOnly")) {
                p = new HostOnlyParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "hostOnly");
            } else if (sType.equals(sPrefix + ":" + "localHostOnly")) {
                p = new LocalHostOnlyParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "localHostOnly");
            } else if (sType.equals(sPrefix + ":" + "hostPort")) {
                p = new HostPortParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "hostPort");
            } else if (sType.equals(sPrefix + ":" + "hostPortInstance")) {
                p = new HostPortInstanceParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "hostPortInstance");
            } else if (sType.equals(sPrefix + ":" + "fileURI")) {
                p = new FileURIParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "fileURI");
            } else if (sType.equals(sPrefix + ":" + "relativeOrAbsoluteURI")) {
                p = new RelativeOrAbsoluteURIParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "relativeOrAbsoluteURI");
            } else if (sType.equals(sPrefix + ":" + "fontsMap")) {
                p = new FontsMapParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "fontsMap");
            } else if (sType.equals(sPrefix + ":" + "fontsEmbed")) {
                p = new FontsEmbedParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "fontsEmbed");
            } else if (sType.equals(sPrefix + ":" + "complexFileURI")) {
                p = new ComplexFileURIParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "complexFileURI");
            } else if (sType.equals(sPrefix + ":" + "tenancyInfo")) {
                p = new TenancyInfoProviderParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "tenancyInfo");
            } else if (sType.equals(sPrefix + ":" + "array") || sType.equals(sPrefix + ":" + "sortedArray")) {
                String sDataType = sType.equals(sPrefix + ":" + "array") ? "array" : "sortedArray";
                if (elem != null) {
                    if (elem.attributeValue("name") != null && elem.attributeValue("name").equals("aliasRoots")) {
                        p = new AliasRootsParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "aliasRoots");
                        return p;
                    }
                    String sItemType = elem.attributeValue("arrayType", "");
                    int idx = sItemType.indexOf(":");
                    if (idx == -1) {
                        return null;
                    }
                    String sItemPrefix = sItemType.substring(0, idx);
                    Namespace ns = elem.getNamespaceForPrefix(sItemPrefix);
                    if (ns == null) {
                        return null;
                    }
                    if (!ns.getURI().equals("http://www.w3.org/2001/XMLSchema") && !ns.getURI().equals("http://developer.cognos.com/schemas/configparams/XMLSchema/1/")) {
                        return null;
                    }
                    if (sItemType.equals(sItemPrefix + ":" + "anyType")) {
                        return null;
                    }
                    if (elem.attributeValue("name") != null && elem.attributeValue("name").equals("cbsEnvVar")) {
                        p = new EnvVarArrayParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", sDataType);
                        return p;
                    }
                }
                p = new ArrayParameter("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", sDataType);
            } else {
                p = new StringParameter("http://www.w3.org/2001/XMLSchema", "string");
            }
        }
        return p;
    }

    private void writeDoc(Document doc, File startupFile, String bHeaderComment) throws DataManagerException {
        block24: {
            if (doc != null) {
                FileOutputStream fos = null;
                SmartXMLWriter writer = null;
                OutputStreamWriter osw = null;
                try {
                    fos = new FileOutputStream(startupFile);
                    String javaEncoding = this.getEncoding();
                    String mimeEncoding = ToolkitResources.normalizeEncoding((String)javaEncoding);
                    if (mimeEncoding == null || mimeEncoding.length() == 0) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("Unable to map the Java encoding " + javaEncoding + " to a mime encoding. Defaulting to UTF-8.");
                        }
                        javaEncoding = "UTF8";
                        mimeEncoding = "UTF-8";
                    }
                    if (this.isJapaneseEncoding(mimeEncoding)) {
                        javaEncoding = "UTF8";
                        mimeEncoding = "UTF-8";
                    }
                    Charset charset = Charset.forName(javaEncoding);
                    CharsetEncoder encoder = charset.newEncoder();
                    if (charset.compareTo(Charset.forName("UTF8")) != 0) {
                        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    }
                    osw = new OutputStreamWriter((OutputStream)fos, encoder);
                    OutputFormat prettyformat = OutputFormat.createPrettyPrint();
                    prettyformat.setEncoding(mimeEncoding);
                    writer = new SmartXMLWriter(osw, prettyformat, true, bHeaderComment);
                    writer.write(doc);
                    writer.close();
                    osw.close();
                }
                catch (FileNotFoundException e) {
                    CnfgLog.error(e);
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage);
                }
                catch (UnsupportedEncodingException e) {
                    CnfgLog.error(e);
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage);
                }
                catch (UnmappableCharacterException e) {
                    if (Charset.forName(this.getEncoding()).compareTo(Charset.forName("UTF8")) != 0) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug(e);
                            CnfgLog.debug("Saving the configuration in the native encoding failed, trying re-save in UTF-8");
                        }
                        this.setDefaultEncoding(false);
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            CnfgLog.error(ioe);
                            String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(ioe.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                            throw new DataManagerException(sMessage);
                        }
                        this.writeDoc(doc, startupFile, bHeaderComment);
                        break block24;
                    }
                    CnfgLog.error(e);
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage);
                }
                catch (IOException e) {
                    CnfgLog.error(e);
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage);
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {
                        CnfgLog.error(ioe);
                        String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(ioe.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                        throw new DataManagerException(sMessage);
                    }
                }
            }
        }
    }

    private Element serialize(boolean bEncrypt, List errors, boolean bIncludeDoc, boolean excludeDisabled) throws DataManagerException {
        Element root_elem = DocumentHelper.createElement((QName)this.m_qnParams);
        Attribute att_version = DocumentHelper.createAttribute((Element)root_elem, (String)"version", (String)this.getVersion());
        root_elem.add(att_version);
        root_elem.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        Namespace schemaInstNS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root_elem.add(schemaInstNS);
        root_elem.addNamespace("cfg", "http://developer.cognos.com/schemas/configparams/XMLSchema/1/");
        String sSchemaLocation = "http://developer.cognos.com/schemas/crconfig/1/ cogstartup.xsd";
        QName schemaLocationQName = new QName("schemaLocation", schemaInstNS);
        Attribute att_schemaLocation = DocumentHelper.createAttribute((Element)root_elem, (QName)schemaLocationQName, (String)sSchemaLocation);
        root_elem.add(att_schemaLocation);
        this.m_rootFolder.serialize(root_elem, bEncrypt, errors, bIncludeDoc, excludeDisabled);
        return root_elem;
    }

    String getCryptoConfig(boolean bEncrypt) throws DataManagerException {
        Element root_elem = this.serialize(bEncrypt, null, false, true);
        StringWriter sw = new StringWriter(4096);
        XMLWriter writer = new XMLWriter((Writer)sw);
        try {
            writer.write(root_elem);
            writer.close();
            return sw.toString();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            throw new DataManagerException(e.getLocalizedMessage());
        }
    }

    public synchronized void generateCryptoKeys(ICnfgFeedback feedback) throws DataManagerException {
        try {
            this.initializeCAMFactory();
            IConfiguringSession cs = this.m_cf.createConfiguringSession();
            if (!cs.configure(feedback)) {
                this.m_cf = null;
                this.m_es = null;
                CnfgLog.error("Failed to generate the cryptography information. cs.configure(feedback) returned false.");
                throw new DataManagerException(CnfgResource.getMessage("Message.errorOnGenCrypto"));
            }
            this.m_cryptoDirty = false;
        }
        catch (CAMCryptoException e) {
            CnfgLog.error(e);
            this.m_cf = null;
            this.m_es = null;
            throw new DataManagerException(e.getLocalizedMessage());
        }
        catch (NoClassDefFoundError e) {
            CnfgLog.error(e);
            this.m_cf = null;
            this.m_es = null;
            throw new DataManagerException(e.toString());
        }
        catch (NullPointerException e) {
            CnfgLog.error(e);
            this.m_cf = null;
            this.m_es = null;
            throw new DataManagerException(e);
        }
    }

    public HttpClient getHttpClient(URL url) throws DataManagerException {
        HttpClient hc = null;
        try {
            this.initializeCAMFactory();
            hc = this.m_cf.createHttpClient(url);
        }
        catch (CAMCryptoException e) {
            CnfgLog.error(e);
            this.m_cf = null;
            this.m_es = null;
            throw new DataManagerException(e.getLocalizedMessage());
        }
        catch (NoClassDefFoundError e) {
            CnfgLog.error(e);
            this.m_cf = null;
            this.m_es = null;
            throw new DataManagerException(e.toString());
        }
        catch (NullPointerException e) {
            CnfgLog.error(e);
            this.m_cf = null;
            this.m_es = null;
            throw new DataManagerException(e.toString());
        }
        return hc;
    }

    public synchronized void resetCryptoHandles() {
        this.m_cf = null;
        this.m_es = null;
    }

    public void backupFile(String timeStamp, String fileName) throws DataManagerException {
        this.backupFile(timeStamp, fileName, ".xml");
    }

    public void backupFile(String timeStamp, String fileName, String fileExt) throws DataManagerException {
        String backupFileName = CnfgDataUtils.backupFile(timeStamp, fileName, fileExt);
        this.m_backedupFiles.put(fileName, backupFileName);
    }

    private void backupConfigurationFiles() throws DataManagerException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddkkmmss");
        String timeStamp = formatter.format(new Date());
        if (this.isConfigDirty() && !this.shouldSkipBackup()) {
            this.backupFile(timeStamp, "../configuration/cogstartup.xml");
        }
        if (this.isLocaleDocDirty()) {
            this.backupFile(timeStamp, "../configuration/coglocale.xml");
        }
        if (this.appSvrIsDirty()) {
            this.backupAppSvrConfigFiles(timeStamp);
        }
    }

    private void backupWLPConfigurationFiles(WLPConfiguration wlpConf) throws DataManagerException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddkkmmss");
        String timeStamp = formatter.format(new Date());
        wlpConf.backWLPConfigurationFiles(timeStamp);
        if (wlpConf.envVarsChanged()) {
            this.backupFile(timeStamp, wlpConf.getEnvVarsFilePath(), ".ini");
        }
    }

    private void backupAppSvrConfigFiles(String timeStamp) throws DataManagerException {
        if (this.isTomcat()) {
            this.backupFile(timeStamp, "../tomcat/conf/server.xml");
        }
    }

    private void saveStartupParameters(boolean encrypt) throws DataManagerException {
        this.saveStartupParametersFile(DataManager.getInstance().resolveEffectiveFilePath("../configuration/cogstartup.xml"), encrypt);
        if (encrypt && this.shouldSkipBackup()) {
            this.setSkipBackup(false);
        }
        this.setConfigDirtyFlag(false);
        this.setAAADirtyFlag(false);
        if (this.isRestartServicesDirty()) {
            ServiceManager.setDirty(this.getRestartServices());
            this.resetRestartServicesDirtyFlag();
        }
    }

    private void saveStartupParametersFile(File file, boolean encrypt) throws DataManagerException {
        Element root_elem = this.serialize(encrypt, null, true, false);
        Document doc = DocumentHelper.createDocument();
        doc.setRootElement(root_elem);
        this.writeDoc(doc, file, "\n===============================================================================================\n\tLicensed Materials - Property of IBM\n\tIBM Cognos Products: cnfg\n\t(C) Copyright IBM Corp. 2017\n\tUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n\nMaster configuration file for all IBM Cognos components.\n===============================================================================================\n");
    }

    public void saveFeedBackPort(int iNewPort) throws DataManagerException {
        try {
            File file = DataManager.getInstance().resolveEffectiveFilePath("../configuration/cogstartup.xml");
            BufferedInputStream startupFileStream = new BufferedInputStream(new FileInputStream(file));
            Document dom = new SAXReader().read((InputStream)startupFileStream);
            Element rootElement = dom.getRootElement();
            boolean bFoundIt = false;
            if (null != rootElement && rootElement.getName().equals("parameters") && rootElement.getNamespace().equals((Object)StartupProcessor.nsCRN)) {
                List parameterList = rootElement.elements(StartupProcessor.qnPARAMETER);
                for (Element parameterElement : parameterList) {
                    Element valueElement;
                    String parameterName;
                    if (null == parameterElement || !parameterElement.getName().equals("parameter") || !parameterElement.getNamespace().equals((Object)StartupProcessor.nsCRN) || null == (parameterName = parameterElement.attributeValue("name")) || !parameterName.equals("feedbackPort") || null == (valueElement = parameterElement.element(StartupProcessor.qnVALUE))) continue;
                    valueElement.setText(Integer.toString(iNewPort));
                    bFoundIt = true;
                    break;
                }
                if (!bFoundIt) {
                    Element parameter_elem = DocumentHelper.createElement((QName)DataManager.getInstance().m_qnParam);
                    Attribute name_attrib = DocumentHelper.createAttribute((Element)parameter_elem, (String)"name", (String)"feedbackPort");
                    parameter_elem.add(name_attrib);
                    Element value_elem = DocumentHelper.createElement((QName)DataManager.getInstance().m_qnValue);
                    Namespace schemaInstNS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    QName qName = new QName("type", schemaInstNS);
                    String qDataType = (String)nsToPrefixMap.get("http://www.w3.org/2001/XMLSchema") + ":" + "unsignedShort";
                    Attribute type_attrib = DocumentHelper.createAttribute((Element)value_elem, (QName)qName, (String)qDataType);
                    value_elem.add(type_attrib);
                    value_elem.setText(Integer.toString(iNewPort));
                    parameter_elem.add(value_elem);
                    rootElement.add(parameter_elem);
                }
            } else {
                throw new DataManagerException("cogstartup.xml is not well-formed");
            }
            this.writeDoc(dom.getDocument(), file, null);
        }
        catch (FileNotFoundException e) {
            throw new DataManagerException(e.getLocalizedMessage());
        }
        catch (DocumentException e) {
            throw new DataManagerException(e.getLocalizedMessage());
        }
    }

    private void validateConfiguration(List<String> errors) throws DataManagerException {
        Object val;
        Parameter crypto = this.m_rootFolder.findParm("localCSK");
        if (crypto != null && !crypto.getDisabled() && !crypto.isBadValue() && (this.m_cf == null || this.isConfigDirty()) && (val = crypto.m_currentValue) != null && val.toString().equalsIgnoreCase("false")) {
            try {
                this.m_cf = null;
                this.m_es = null;
                this.initializeCAMFactory();
            }
            catch (Exception e) {
                CnfgLog.error(e);
                throw new DataManagerException(e.getMessage());
            }
        }
        this.serialize(false, errors, false, true);
        this.m_rootFolder.checkMinOccurs(errors);
    }

    private void validateLocaleMaps(List errors) {
        try {
            GlobalConfigModel globalConfig = new GlobalConfigModel();
            FontsMappingModel fontsMapping = new FontsMappingModel();
            globalConfig.validate(errors);
            fontsMapping.validate(errors);
        }
        catch (DataManagerException e) {
            errors.add(e.getMessage());
        }
    }

    public void getSaveTasks(List<ICnfgTask> list) {
        this.createValidationTask(list);
        this.createCryptoTask(list);
        this.createCheckEncryptedDataTask(list);
        this.getCustomSaveTasks(list);
        this.createBackupTask(list);
        this.createSaveConfigTask(list);
        this.createSaveLocaleTask(list);
        this.createSaveAppSvrConfigTask(list);
        if (this.isInstalled("CM")) {
            CnfgServiceUtils.createCMUpgradeTask(list, "save");
        }
    }

    public ICnfgTask[] getSaveTasks() {
        ArrayList<ICnfgTask> list = new ArrayList<ICnfgTask>();
        this.getSaveTasks(list);
        ICnfgTask[] tasks = new ICnfgTask[list.size()];
        list.toArray(tasks);
        return tasks;
    }

    public ICnfgTask[] getExportTasks(File file) {
        ArrayList<ICnfgTask> list = new ArrayList<ICnfgTask>();
        this.createValidationTask(list);
        this.createExportConfigTask(list, file);
        ICnfgTask[] tasks = new ICnfgTask[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tasks[i] = list.get(i);
        }
        return tasks;
    }

    public ICnfgTask[] mergeTaskList(ICnfgTask[] firstList, ICnfgTask[] secondList) {
        if (firstList == null || firstList.length == 0) {
            return secondList;
        }
        if (secondList == null || secondList.length == 0) {
            return firstList;
        }
        int len = firstList.length + secondList.length;
        ICnfgTask[] taskList = new ICnfgTask[len];
        for (int i = 0; i < len; ++i) {
            taskList[i] = i < firstList.length ? firstList[i] : secondList[i - firstList.length];
        }
        return taskList;
    }

    private synchronized Document getAppSvrConfigDoc(String fileName) throws DataManagerException {
        Document appSvrDoc = null;
        try {
            SAXReader reader = new SAXReader();
            File appSvrFile = DataManager.getInstance().resolveEffectiveFilePath(fileName);
            if (!appSvrFile.exists()) {
                Object[] args = new Object[]{appSvrFile.getCanonicalFile()};
                CnfgLog.error(CnfgResource.getMessage("Message.loadTomcat.failed.filenotfound", args));
            }
            appSvrDoc = reader.read(appSvrFile);
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.ioexception", args));
        }
        catch (DocumentException e) {
            CnfgLog.error(e);
            Throwable t = e.getNestedException();
            Object[] args = new Object[]{t != null ? t.getLocalizedMessage() : e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.parseError", args));
        }
        catch (DataManagerException e) {
            CnfgLog.error(e);
        }
        return appSvrDoc;
    }

    private boolean appSvrIsDirty() {
        if (this.isTomcat()) {
            return this.checkCRNTomcatSettings();
        }
        if (this.isWLP()) {
            return this.m_wlp.checkSettings(this.m_cryptoDirty);
        }
        return false;
    }

    private boolean checkCRNTomcatSettings() {
        boolean bRetValue;
        block33: {
            bRetValue = false;
            if (this.isTomcat()) {
                if (this.isInstalled("DISP")) {
                    try {
                        String sConnectorName;
                        List httpElems;
                        int size;
                        Element serverElem;
                        int internalPortNumber = CnfgDataUtils.getBasePortNumber("internalDispatcher");
                        int externalPortNumber = CnfgDataUtils.getBasePortNumber("externalDispatcher");
                        if (this.m_tomcatDoc == null) {
                            this.m_tomcatDoc = this.getAppSvrConfigDoc("../tomcat/conf/server.xml");
                        }
                        if (null == (serverElem = this.m_tomcatDoc.getRootElement())) {
                            Object[] args = new Object[]{"<Server>"};
                            throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
                        }
                        Parameter shutdownPortParam = this.m_rootFolder.findParm("shutdownPort");
                        if (shutdownPortParam != null && !shutdownPortParam.getDisabled() && shutdownPortParam.getVisibility()) {
                            String sPortAttrValue = serverElem.attributeValue("port");
                            if (sPortAttrValue == null) {
                                return true;
                            }
                            String sShutdownPort = shutdownPortParam.getValue().toString();
                            if (!sPortAttrValue.equals(sShutdownPort)) {
                                return true;
                            }
                        } else {
                            String sMsg = "Unexpected error. The shutdown port was not found in the data model";
                            CnfgLog.error(sMsg);
                            throw new DataManagerException(sMsg);
                        }
                        Element serviceElem = (Element)serverElem.selectSingleNode("Service[@name='Catalina']");
                        if (null == serviceElem) {
                            Object[] args = new Object[]{"<Service name=\"Catalina\">"};
                            throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
                        }
                        Element engineElem = (Element)serviceElem.selectSingleNode("Engine [@name='Catalina']");
                        if (null == engineElem) {
                            Object[] args = new Object[]{"<Engine name=\"Catalina\">"};
                            throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
                        }
                        Element hostElem = (Element)engineElem.selectSingleNode("Host [@name='localhost']");
                        if (null == hostElem) {
                            Object[] args = new Object[]{"<Host name=\"localhost\">"};
                            throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
                        }
                        Element contextPathDispatchElem = (Element)hostElem.selectSingleNode("Context[@path='/p2pd']");
                        if (contextPathDispatchElem == null) {
                            return true;
                        }
                        Element contextPathDMNETElem = (Element)hostElem.selectSingleNode("Context[@path='/axis']");
                        if (contextPathDMNETElem == null && this.isInstalled("DMNETS") || contextPathDMNETElem != null && !this.isInstalled("DMNETS")) {
                            return true;
                        }
                        Parameter internalURIParam = this.m_rootFolder.findParm("internalDispatcher");
                        Parameter externalURIParam = this.m_rootFolder.findParm("externalDispatcher");
                        String sExternalURI = null;
                        String sInternalURI = null;
                        if (null == externalURIParam || externalURIParam.getDisabled() || !externalURIParam.getVisibility()) {
                            String sMsg = "Unexpected error. The external dispatcher URI was not found in the data model";
                            CnfgLog.error(sMsg);
                            throw new DataManagerException(sMsg);
                        }
                        sExternalURI = (String)externalURIParam.getValue();
                        if (null == internalURIParam || internalURIParam.getDisabled() || !internalURIParam.getVisibility()) {
                            String sMsg = "Unexpected error. The internal dispatcher URI was not found in the data model";
                            CnfgLog.error(sMsg);
                            throw new DataManagerException(sMsg);
                        }
                        sInternalURI = (String)internalURIParam.getValue();
                        Parameter dmnetURIParam = null;
                        String sDmnetURI = null;
                        boolean bDmnetCurSSL = false;
                        if (this.isInstalled("DMNETS")) {
                            dmnetURIParam = this.m_rootFolder.findParm("DSSOAPServerURI");
                            sDmnetURI = null;
                            if (null == dmnetURIParam || dmnetURIParam.getDisabled() || !dmnetURIParam.getVisibility()) {
                                String sMsg = "Unexpected error. The DMNET URI was not found in the data model";
                                CnfgLog.error(sMsg);
                                throw new DataManagerException(sMsg);
                            }
                            sDmnetURI = (String)dmnetURIParam.getValue();
                            if (dmnetURIParam != null) {
                                bDmnetCurSSL = sDmnetURI.startsWith("https://");
                            }
                        }
                        if (dmnetURIParam != null) {
                            int dmnetPortNumber = CnfgDataUtils.getBasePortNumber("DSSOAPServerURI");
                            if (externalPortNumber != dmnetPortNumber) {
                                return true;
                            }
                            if (bDmnetCurSSL != sExternalURI.startsWith("https://")) {
                                return true;
                            }
                        }
                        boolean bInternalCurSSL = sInternalURI.startsWith("https://");
                        boolean bExternalCurSSL = sExternalURI.startsWith("https://");
                        boolean bMatchingURIs = false;
                        if (bInternalCurSSL == bExternalCurSSL && internalPortNumber == externalPortNumber) {
                            bMatchingURIs = true;
                        }
                        if ((size = (httpElems = serviceElem.selectNodes(sConnectorName = "Connector")).size()) > 0) {
                            if (size > 1 && bMatchingURIs) {
                                return true;
                            }
                            if (size == 1 && !bMatchingURIs) {
                                return true;
                            }
                            Element httpConnectorElem = (Element)httpElems.get(0);
                            if (this.isURIMatchesConnector(httpConnectorElem, sInternalURI)) {
                                if (size >= 2) {
                                    httpConnectorElem = (Element)httpElems.get(1);
                                    return !this.isURIMatchesConnector(httpConnectorElem, sExternalURI);
                                }
                                break block33;
                            }
                            if (this.isURIMatchesConnector(httpConnectorElem, sExternalURI)) {
                                if (size >= 2) {
                                    httpConnectorElem = (Element)httpElems.get(1);
                                    return !this.isURIMatchesConnector(httpConnectorElem, sExternalURI);
                                }
                                return true;
                            }
                            if (size >= 2) {
                                httpConnectorElem = (Element)httpElems.get(1);
                                if (this.isURIMatchesConnector(httpConnectorElem, sInternalURI)) {
                                    httpConnectorElem = (Element)httpElems.get(0);
                                    return !this.isURIMatchesConnector(httpConnectorElem, sExternalURI);
                                }
                                return true;
                            }
                            return true;
                        }
                        Object[] args = new Object[]{"<Connector>"};
                        throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
                    }
                    catch (DataManagerException e) {
                        CnfgLog.error(e);
                        return bRetValue;
                    }
                }
                return this.checkDMNETTomcatSettings();
            }
        }
        return bRetValue;
    }

    private boolean checkDMNETTomcatSettings() {
        int dmnetPortNumber;
        boolean bRetValue = false;
        if (this.isInstalled("DMNETS") && (dmnetPortNumber = CnfgDataUtils.getBasePortNumber("DSSOAPServerURI")) > 0) {
            try {
                Element serverElem;
                if (this.m_tomcatDoc == null) {
                    this.m_tomcatDoc = this.getAppSvrConfigDoc("../tomcat/conf/server.xml");
                }
                if (null == (serverElem = this.m_tomcatDoc.getRootElement())) {
                    Object[] args = new Object[]{"<Server>"};
                    throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
                }
                Parameter shutdownPortParam = this.m_rootFolder.findParm("shutdownPort");
                if (shutdownPortParam != null && !shutdownPortParam.getDisabled() && shutdownPortParam.getVisibility()) {
                    String sPortAttrValue = serverElem.attributeValue("port");
                    if (sPortAttrValue == null) {
                        return true;
                    }
                    String sShutdownPort = shutdownPortParam.getValue().toString();
                    if (!sPortAttrValue.equals(sShutdownPort)) {
                        return true;
                    }
                } else {
                    String sMsg = "Unexpected error. The shutdown port was not found in the data model";
                    CnfgLog.error(sMsg);
                    throw new DataManagerException(sMsg);
                }
                Element serviceElem = (Element)serverElem.selectSingleNode("Service[@name='Catalina']");
                if (null == serviceElem) {
                    Object[] args = new Object[]{"<Service name=\"Catalina\">"};
                    throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
                }
                Element engineElem = (Element)serviceElem.selectSingleNode("Engine [@name='Catalina']");
                if (null == engineElem) {
                    Object[] args = new Object[]{"<Engine name=\"Catalina\">"};
                    throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
                }
                Element hostElem = (Element)engineElem.selectSingleNode("Host [@name='localhost']");
                if (null == hostElem) {
                    Object[] args = new Object[]{"<Host name=\"localhost\">"};
                    throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
                }
                Element contextPathDispatchElem = (Element)hostElem.selectSingleNode("Context[@path='/p2pd']");
                if (contextPathDispatchElem != null) {
                    return true;
                }
                Element contextPathDMNETElem = (Element)hostElem.selectSingleNode("Context[@path='/axis']");
                if (contextPathDMNETElem == null) {
                    return true;
                }
                Parameter dmnetURIParam = this.m_rootFolder.findParm("DSSOAPServerURI");
                String sDmnetURI = null;
                if (null == dmnetURIParam || dmnetURIParam.getDisabled() || !dmnetURIParam.getVisibility()) {
                    String sMsg = "Unexpected error. The DMNET URI was not found in the data model";
                    CnfgLog.error(sMsg);
                    throw new DataManagerException(sMsg);
                }
                sDmnetURI = (String)dmnetURIParam.getValue();
                String sConnectorName = "Connector";
                List httpElems = serviceElem.selectNodes(sConnectorName);
                int size = httpElems.size();
                if (size > 0) {
                    if (size > 1) {
                        return true;
                    }
                    Element httpConnectorElem = (Element)httpElems.get(0);
                    return !this.isURIMatchesConnector(httpConnectorElem, sDmnetURI);
                }
                Object[] args = new Object[]{"<Connector>"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
            }
            catch (DataManagerException e) {
                CnfgLog.error(e);
                return bRetValue;
            }
        }
        return bRetValue;
    }

    private boolean isURIMatchesConnector(Element elem, String sURI) {
        if (sURI == null) {
            return false;
        }
        Attribute portAttrib = elem.attribute("port");
        String sSavedPort = portAttrib.getValue();
        String sCurrentPort = this.getPortFromURI(sURI);
        if (sSavedPort != null && !sSavedPort.equals(sCurrentPort)) {
            return false;
        }
        Attribute secureAttr = elem.attribute("secure");
        Attribute schemeAttr = elem.attribute("scheme");
        boolean bCurSSL = sURI.startsWith("https://");
        if (null == secureAttr) {
            if (bCurSSL) {
                return false;
            }
            if (schemeAttr != null) {
                if (!bCurSSL && schemeAttr.getValue().equals("https")) {
                    return false;
                }
                if (bCurSSL && schemeAttr.getValue().equals("http")) {
                    return false;
                }
            } else if (bCurSSL) {
                return false;
            }
        } else {
            if (bCurSSL && secureAttr.getValue().equalsIgnoreCase("false")) {
                return false;
            }
            if (!bCurSSL && secureAttr.getValue().equalsIgnoreCase("true")) {
                return false;
            }
        }
        return true;
    }

    public List<ServiceFolder> getServiceFolders(boolean b) {
        if (this.m_lServiceFolders == null) {
            this.m_lServiceFolders = this.m_rootFolder == null ? new ArrayList<ServiceFolder>() : this.m_rootFolder.getServiceFolders(b);
        }
        return this.m_lServiceFolders;
    }

    private void resetServiceFolders() {
        this.m_lServiceFolders = null;
        this.getServiceFolders(true);
    }

    public void getAllServiceFoldersActions(String sAction, List tasklist, boolean bSaveConfig) {
        List<ServiceFolder> lServices = this.getServiceFolders(true);
        Folder cbsFolder = this.getCBS();
        for (int i = 0; i < lServices.size(); ++i) {
            CnfgActionOld svAction;
            ServiceFolder srvFolder = lServices.get(i);
            if (srvFolder == null || srvFolder == cbsFolder || srvFolder.getDisabled() || !srvFolder.getVisibility()) continue;
            ICnfgTask[] lTasks = null;
            if (srvFolder.isRunning() && (sAction.equals("stop") || sAction.equals("restart"))) {
                if (sAction.equals("stop")) {
                    CnfgActionOld svAction2 = srvFolder.findAction(sAction);
                    if (svAction2 != null) {
                        lTasks = srvFolder.createStopTasks(svAction2);
                    }
                } else {
                    lTasks = srvFolder.createRestartTasks(bSaveConfig);
                }
            } else if (!srvFolder.isRunning() && (sAction.equals("start") || sAction.equals("restart")) && (svAction = srvFolder.findAction("start")) != null) {
                lTasks = srvFolder.createStartTasks(svAction, bSaveConfig);
            }
            if (lTasks == null) continue;
            for (int j = 0; j < lTasks.length; ++j) {
                tasklist.add(lTasks[j]);
            }
            if (sAction.equals("stop")) continue;
            ServiceManager.removeFromRestartServicesList(srvFolder.getName());
        }
    }

    public void createValidationTask(List<ICnfgTask> list) {
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.task.validate");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Label.DialogSave.validationTask");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                ArrayList errors = new ArrayList();
                DataManager.this.validateConfiguration(errors);
                if (DataManager.this.isInstalled("CM")) {
                    DataManager.this.validateLocaleMaps(errors);
                }
                Iterator it = errors.iterator();
                while (it.hasNext()) {
                    feedback.showError((String)it.next());
                }
                return errors.size() <= 0;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
    }

    public void createCheckEncryptedDataTask(List<ICnfgTask> list) {
        if (this.m_bUseJCAM) {
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.checkEncryptedData");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Label.DialogSave.checkEncryptedDataTask");
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    IEncryptingSession es;
                    ArrayList errors = new ArrayList();
                    if (DataManager.this.m_useCrypto && (es = DataManager.getInstance().getCryptoEncryptingSession(true)) != null) {
                        DataManager.this.serialize(false, errors, false, true);
                        Iterator it = errors.iterator();
                        while (it.hasNext()) {
                            feedback.showError((String)it.next());
                        }
                    }
                    return errors.size() <= 0;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }
            });
        }
    }

    public void createCryptoTask(List<ICnfgTask> list) {
        if (this.m_bUseJCAM) {
            this.m_useCrypto = true;
            this.m_decryptCryptoPasswords = false;
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.crypto");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Label.DialogSave.cryptoTask");
                }

                @Override
                public boolean isMandatory() {
                    return DataManager.this.m_useCrypto;
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    try {
                        DataManager.this.generateCryptoKeys(feedback);
                        return true;
                    }
                    catch (DataManagerException e) {
                        CnfgLog.error(e);
                        DataManager.this.m_useCrypto = !feedback.promptForConfirmation(CnfgResource.getMessage("Message.crypto.continueInClearText"));
                        throw e;
                    }
                }
            });
        }
    }

    public void createBackupTask(List<ICnfgTask> list) {
        if (this.isDirty() || this.appSvrIsDirty()) {
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.backup");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Label.DialogSave.backupTask");
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    DataManager.this.backupConfigurationFiles();
                    return true;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }
            });
        }
    }

    public void getCustomSaveTasks(List<CnfgTask> list, ICnfgFeedback feedback) {
        ICCLConfiguration cclconfig = null;
        Object obj = new Object();
        ArrayList<String> errors = new ArrayList<String>();
        try {
            cclconfig = DataManager.getInstance().getICCLConfiguration(errors, obj);
        }
        catch (DataManagerException e) {
            e.printStackTrace();
        }
        List<CnfgActionCustomSave> saveActions = this.getRootFolder().getCustomSaveActions("");
        HashMap<String, ICnfgTest> initializedClasses = null;
        if (saveActions.size() > 0) {
            initializedClasses = new HashMap<String, ICnfgTest>();
            Iterator<CnfgActionCustomSave> it = saveActions.iterator();
            while (it.hasNext()) {
                ICnfgTask[] tasks;
                ICnfgTest saveInstance;
                boolean bAlreadyQueriedForTasks = false;
                CnfgActionCustomSave action = it.next();
                Class saveClass = DataManager.getInstance().getSaveClass(action);
                if (saveClass == null) {
                    action = DataManager.getInstance().findSaveAction(action.getRefID());
                    if (action == null) {
                        if (!CnfgLog.isDebugEnabled()) continue;
                        CnfgLog.debug("Could not locate test action with refid " + action.getRefID());
                        continue;
                    }
                    saveClass = DataManager.getInstance().getSaveClass(action);
                    if (saveClass == null) {
                        if (!CnfgLog.isDebugEnabled()) continue;
                        CnfgLog.debug("Could not load test class for action with refid " + action.getRefID());
                        continue;
                    }
                }
                if (null == (saveInstance = (ICnfgTest)initializedClasses.get(saveClass.getName()))) {
                    try {
                        saveInstance = (ICnfgTest)saveClass.newInstance();
                    }
                    catch (Throwable t) {
                        CnfgLog.error("An error was encountered when attempting to instantiate the test module for the '" + action.getProvider() + "'. Exception : " + t.getLocalizedMessage());
                        continue;
                    }
                    boolean initResult = false;
                    try {
                        initResult = saveInstance.initialize(cclconfig, feedback);
                    }
                    catch (Throwable t) {
                        CnfgLog.error("An error was encountered when attempting to initialize the test module for the '" + action.getProvider() + "'. Exception : " + t.getLocalizedMessage());
                        continue;
                    }
                    if (!initResult) continue;
                    initializedClasses.put(saveClass.getName(), saveInstance);
                } else {
                    bAlreadyQueriedForTasks = true;
                }
                if (bAlreadyQueriedForTasks || (tasks = saveInstance.getTasks("!", feedback)) == null) continue;
                for (int i = 0; i < tasks.length; ++i) {
                    CnfgTask t = new CnfgTask(tasks[i]);
                    t.setMandatory(false);
                    list.add(t);
                }
            }
        }
    }

    public void getCustomSaveTasks(List list) {
        ICCLConfiguration cclconfig = null;
        ArrayList<String> errors = new ArrayList<String>();
        try {
            cclconfig = DataManager.getInstance().getICCLConfiguration(errors, null);
        }
        catch (DataManagerException e) {
            CnfgLog.error("An error was encountered while getting a configuration instance.");
            CnfgLog.error(e);
            return;
        }
        List<CnfgActionCustomSave> saveActions = this.getRootFolder().getCustomSaveActions("");
        CnfgTestInitializationFeedback feedback = new CnfgTestInitializationFeedback();
        HashMap<String, ICnfgTest> initializedClasses = null;
        if (saveActions.size() > 0) {
            initializedClasses = new HashMap<String, ICnfgTest>();
            Iterator<CnfgActionCustomSave> it = saveActions.iterator();
            while (it.hasNext()) {
                ICnfgTask[] tasks;
                ICnfgTest saveInstance;
                boolean bAlreadyQueriedForTasks = false;
                CnfgActionCustomSave action = it.next();
                Class saveClass = DataManager.getInstance().getSaveClass(action);
                if (saveClass == null) {
                    action = DataManager.getInstance().findSaveAction(action.getRefID());
                    if (action == null) {
                        if (!CnfgLog.isDebugEnabled()) continue;
                        CnfgLog.debug("Could not locate save action with refid " + action.getRefID());
                        continue;
                    }
                    saveClass = DataManager.getInstance().getSaveClass(action);
                    if (saveClass == null) {
                        if (!CnfgLog.isDebugEnabled()) continue;
                        CnfgLog.debug("Could not load save class for action with refid " + action.getRefID());
                        continue;
                    }
                }
                if (null == (saveInstance = (ICnfgTest)initializedClasses.get(saveClass.getName()))) {
                    try {
                        saveInstance = (ICnfgTest)saveClass.newInstance();
                    }
                    catch (Throwable t) {
                        CnfgLog.error("An error was encountered when attempting to instantiate the test module for the '" + action.getProvider() + "'. Exception : " + t.getLocalizedMessage());
                        continue;
                    }
                    boolean initResult = false;
                    try {
                        initResult = saveInstance.initialize(cclconfig, (ICnfgFeedback)feedback);
                    }
                    catch (Throwable t) {
                        CnfgLog.error("An error was encountered when attempting to initialize the test module for the '" + action.getProvider() + "'. Exception : " + t.getLocalizedMessage());
                        continue;
                    }
                    if (!initResult) continue;
                    initializedClasses.put(saveClass.getName(), saveInstance);
                } else {
                    bAlreadyQueriedForTasks = true;
                }
                if (bAlreadyQueriedForTasks || (tasks = saveInstance.getTasks("", (ICnfgFeedback)feedback)) == null) continue;
                for (int i = 0; i < tasks.length; ++i) {
                    CnfgTask t = new CnfgTask(tasks[i]);
                    t.setMandatory(false);
                    list.add(t);
                }
            }
        }
    }

    public void createSaveConfigTask(List<ICnfgTask> list) {
        if (this.isConfigDirty()) {
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.saveconfig");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Label.DialogSave.parameterTask");
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    DataManager.this.saveStartupParameters(DataManager.this.m_useCrypto);
                    DataManager.this.saveInstallDataProps();
                    DataManager.this.setBTSVServicesName();
                    CnfgUtils.saveJavaInfo();
                    InputStream sStylesheet = this.getClass().getResourceAsStream("/config/Series7Namespaces.xslt");
                    String sOutputFileName = CCLConfigurationFactory.getInstance().resolveEffectivePath("../configuration/Series7Namespaces.xml");
                    XSLTransform.transform("../configuration/cogstartup.xml", sStylesheet, sOutputFileName);
                    return true;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }
            });
            if (ServiceManager.isRunning() && this.isCMEnabled()) {
                final boolean isMandatory = this.isForceSave();
                list.add(new CnfgTask(){

                    @Override
                    public String getLabel() {
                        return CnfgResource.getMessage("Message.task.saveconfig.populateaaa");
                    }

                    @Override
                    public String getDescription() {
                        return CnfgResource.getMessage("Label.DialogSave.populateAAATask");
                    }

                    @Override
                    public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                        String sMessage = CnfgResource.getMessage("Message.errorOnSave.populateaaa.succeed");
                        boolean res = DataManager.this.m_verifyConfig.populateAAASettings(DataManager.this.m_useCrypto);
                        if (!res) {
                            sMessage = CnfgResource.getMessage("Message.errorOnSave.populateaaa.fail");
                            feedback.showWarning(sMessage);
                            return false;
                        }
                        feedback.showInformational(sMessage);
                        return true;
                    }

                    @Override
                    public boolean isMandatory() {
                        return isMandatory;
                    }
                });
            }
        }
    }

    public void createExportConfigTask(List list, File file) {
        final File saveFile = file;
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.task.saveconfig");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Label.DialogSave.parameterTask");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                DataManager.this.initializeCAMFactory();
                DataManager.this.getCryptoEncryptingSession(true);
                DataManager.this.m_decryptCryptoPasswords = true;
                DataManager.this.saveStartupParametersFile(saveFile, false);
                return true;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
    }

    public void createSaveLocaleTask(List list) {
        if (this.isLocaleDocDirty()) {
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.savelocale");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Label.DialogSave.localeTask");
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    DataManager.this.saveLocaleMaps();
                    return true;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }
            });
        }
    }

    public boolean updateUpgradeFile(boolean bUpgradeIsGoingToOccur) {
        block25: {
            String sCBSDaemonFile;
            block24: {
                sCBSDaemonFile = null;
                try {
                    ICCLConfiguration icclconfig = CCLConfigurationFactory.createConfiguration();
                    icclconfig.init();
                    String sTempDir = icclconfig.getValue("temp", false);
                    if (sTempDir != null && sTempDir.length() != 0) {
                        sCBSDaemonFile = sTempDir.charAt(sTempDir.length() - 1) == File.separatorChar ? sTempDir + "cbsdaemonwait" : sTempDir + File.separatorChar + "cbsdaemonwait";
                        break block24;
                    }
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("DataManager::updateUpgradeFile() - The temp parameter is null or empty, sTempDir is " + sTempDir + ". The file was not updated.");
                    }
                    return bUpgradeIsGoingToOccur;
                }
                catch (CCLConfigurationException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("DataManager::updateUpgradeFile() - Unable to get the temp parameter, e is " + e.getMessage() + ". The file was not updated.");
                    }
                    return bUpgradeIsGoingToOccur;
                }
            }
            try {
                File f = DataManager.getInstance().resolveEffectiveFilePath(sCBSDaemonFile);
                if (bUpgradeIsGoingToOccur) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("DataManager::updateUpgradeFile() - An upgrade is going to occur. Create the file " + f.getCanonicalPath());
                    }
                    if (f.createNewFile()) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("DataManager::updateUpgradeFile() - The file didn't exist and was therefore created.");
                        }
                    } else if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("DataManager::updateUpgradeFile() - The file already exists.");
                    }
                } else {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("DataManager::updateUpgradeFile() - An upgrade is not going to occur. Delete the file " + f.getCanonicalPath());
                    }
                    if (f.exists()) {
                        if (f.delete()) {
                            if (CnfgLog.isDebugEnabled()) {
                                CnfgLog.debug("DataManager::updateUpgradeFile() - The file was successfully deleted.");
                            }
                        } else if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("DataManager::updateUpgradeFile() - The file was not deleted successfully.");
                        }
                    } else if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("DataManager::updateUpgradeFile() - The file doesn't exist. No-op");
                    }
                }
            }
            catch (DataManagerException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::updateUpgradeFile() - A DataManagerException occured : e is " + e.getMessage());
                }
            }
            catch (IOException e) {
                if (!CnfgLog.isDebugEnabled()) break block25;
                CnfgLog.debug("DataManager::updateUpgradeFile() - An IO exception occured : e is " + e.getMessage());
            }
        }
        return bUpgradeIsGoingToOccur;
    }

    public boolean isIPFUpgradeRequired() {
        boolean bIsUpgradeRequired = false;
        Integer iUpgradeOnNextStartup = (Integer)CnfgPreferences.getInstance().getProperty("UpgradeOnNextStartup", Integer.class);
        if (iUpgradeOnNextStartup != null) {
            bIsUpgradeRequired = iUpgradeOnNextStartup == 1 ? Boolean.TRUE : Boolean.FALSE;
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isIPFUpgradeRequired() - Found overriding property...returning " + bIsUpgradeRequired);
            }
            return bIsUpgradeRequired;
        }
        if (this.m_theIPFUpgradeMethod == null) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isIPFUpgradeRequired() - m_theIPFUpgradeMethod is null");
            }
            URL[] urls = new URL[2];
            try {
                urls[0] = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath("CognosIPFTest.jar")).toURI().toURL();
                urls[1] = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath("../bin")).toURI().toURL();
            }
            catch (MalformedURLException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::isIPFUpgradeRequired() - MalformedURLException e is " + e.getMessage());
                }
                return false;
            }
            Class<?> ipfClass = null;
            try {
                ipfClass = Class.forName("com.cognos.IPFTest.IPFUpgrade", true, this.getClassLoader(urls));
            }
            catch (ClassNotFoundException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::isIPFUpgradeRequired() - ClassNotFoundException e is " + e.getMessage());
                }
                return false;
            }
            try {
                Class[] parameterTypes = new Class[]{ICCLConfiguration.class};
                this.m_theIPFUpgradeMethod = ipfClass.getMethod("auditDatabasesRequireUpgrade", parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::isIPFUpgradeRequired() - NoSuchMethodException e is " + e.getMessage());
                }
                return false;
            }
            if (this.m_theIPFUpgradeMethod == null) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::isIPFUpgradeRequired() - method object is null.");
                }
                return false;
            }
        }
        ICCLConfiguration cclconfig = null;
        try {
            ArrayList<String> errors = new ArrayList<String>();
            cclconfig = DataManager.getInstance().getICCLConfiguration(errors, false, null);
            if (errors.size() > 0 || cclconfig == null) {
                Object[] msgArray = new Object[errors.size() + 1];
                msgArray[0] = CnfgResource.getMessage("Message.errorOnValidation.info");
                for (int i = 0; i < errors.size(); ++i) {
                    msgArray[i + 1] = errors.get(i);
                }
                CnfgLog.error("DataManager::isIPFUpgradeRequired() - Validation failed during ICCLConfig creation. This is not expected. Validation errors are : " + msgArray);
                return false;
            }
        }
        catch (DataManagerException e) {
            CnfgLog.error("DataManager::isIPFUpgradeRequired() - Validation failed during ICCLConfig creation. This is not expected." + e.getMessage());
            return false;
        }
        try {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isIPFUpgradeRequired() - Invoking theMethod " + this.m_theIPFUpgradeMethod.toString() + " now.");
            }
            Object[] objArray = new Object[]{cclconfig};
            bIsUpgradeRequired = (Boolean)this.m_theIPFUpgradeMethod.invoke(null, objArray);
        }
        catch (InvocationTargetException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isIPFUpgradeRequired() - InvocationTargetException e is " + e.getTargetException().getMessage());
                CnfgLog.debug(e);
            }
            return false;
        }
        catch (IllegalAccessException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isIPFUpgradeRequired() - IllegalAccessException e is " + e.getMessage());
            }
            return false;
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("DataManager::isIPFUpgradeRequired() - returning " + bIsUpgradeRequired);
        }
        return bIsUpgradeRequired;
    }

    public TestClassLoader getClassLoader(URL[] urls) {
        if (this.m_testClassLoader == null) {
            this.m_testClassLoader = new TestClassLoader(urls);
        } else {
            this.m_testClassLoader.addURLs(urls);
        }
        return this.m_testClassLoader;
    }

    public boolean isUpgradeRequired(ArrayList statistics) {
        boolean bIsUpgradeRequired = false;
        Integer iUpgradeOnNextStartup = (Integer)CnfgPreferences.getInstance().getProperty("UpgradeOnNextStartup", Integer.class);
        if (iUpgradeOnNextStartup != null) {
            bIsUpgradeRequired = iUpgradeOnNextStartup == 1 ? Boolean.TRUE : Boolean.FALSE;
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isUpgradeRequired() - Found overriding property...returning " + bIsUpgradeRequired);
            }
            return bIsUpgradeRequired;
        }
        if (this.m_theUpgradeMethod == null) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isUpgradeRequired() - m_theUpgradeMethod is null");
            }
            URL[] urls = new URL[2];
            try {
                urls[0] = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath("cmCnfgTest.jar")).toURL();
                urls[1] = new File(CCLConfigurationFactory.getInstance().resolveEffectivePath("../webapps/p2pd/WEB-INF/classes")).toURL();
            }
            catch (MalformedURLException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::isUpgradeRequired() - MalformedURLException e is " + e.getMessage());
                }
                return false;
            }
            Class<?> cmClass = null;
            try {
                cmClass = Class.forName("com.cognos.cm.configTest.CMUpgrade", true, this.getClassLoader(urls));
            }
            catch (ClassNotFoundException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::isUpgradeRequired() - ClassNotFoundException e is " + e.getMessage());
                }
                return false;
            }
            try {
                Class[] parameterTypes = new Class[]{ICCLConfiguration.class, List.class};
                this.m_theUpgradeMethod = cmClass.getMethod("upgradeRequired", parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::isUpgradeRequired() - NoSuchMethodException e is " + e.getMessage());
                }
                return false;
            }
            if (this.m_theUpgradeMethod == null) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::isUpgradeRequired() - method object is null.");
                }
                return false;
            }
        }
        ICCLConfiguration cclconfig = null;
        try {
            ArrayList<String> errors = new ArrayList<String>();
            cclconfig = DataManager.getInstance().getICCLConfiguration(errors, false, null);
            if (errors.size() > 0 || cclconfig == null) {
                Object[] msgArray = new Object[errors.size() + 1];
                msgArray[0] = CnfgResource.getMessage("Message.errorOnValidation.info");
                for (int i = 0; i < errors.size(); ++i) {
                    msgArray[i + 1] = errors.get(i);
                }
                CnfgLog.error("DataManager::isUpgradeRequired() - Validation failed during ICCLConfig creation. This is not expected. Validation errors are : " + msgArray);
                return false;
            }
        }
        catch (DataManagerException e) {
            CnfgLog.error("DataManager::isUpgradeRequired() - Validation failed during ICCLConfig creation. This is not expected." + e.getMessage());
            return false;
        }
        try {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isUpgradeRequired() - Invoking theMethod " + this.m_theUpgradeMethod.toString() + " now.");
            }
            Object[] objArray = new Object[]{cclconfig, statistics};
            bIsUpgradeRequired = (Boolean)this.m_theUpgradeMethod.invoke(null, objArray);
        }
        catch (InvocationTargetException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isUpgradeRequired() - InvocationTargetException e is " + e.getTargetException().getMessage());
                CnfgLog.debug(e);
            }
            return false;
        }
        catch (IllegalAccessException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager::isUpgradeRequired() - IllegalAccessException e is " + e.getMessage());
            }
            return false;
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("DataManager::isUpgradeRequired() - returning " + bIsUpgradeRequired);
        }
        return bIsUpgradeRequired;
    }

    public boolean getDoPromoptForCMUpgrade() {
        return this.m_bDoPromptForCMUpgrade;
    }

    public void addCMUpgradeTask(List list, String sSource) {
        list.add(new CnfgCMUpgradeTask(sSource));
    }

    private void updateUpgradeValue(Element parameterElement, String sValue) {
        Element valueElem = parameterElement.element(StartupProcessor.qnVALUE);
        if (valueElem != null) {
            valueElem.setText(sValue);
        } else {
            Element newValueElem = DocumentHelper.createElement((QName)this.m_qnValue);
            Namespace schemaInstNS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            QName qName = new QName("type", schemaInstNS);
            String qDataType = (String)nsToPrefixMap.get("http://www.w3.org/2001/XMLSchema") + ":" + "boolean";
            Attribute type_attrib = DocumentHelper.createAttribute((Element)newValueElem, (QName)qName, (String)qDataType);
            newValueElem.add(type_attrib);
            newValueElem.addText(sValue);
            parameterElement.add(newValueElem);
        }
    }

    public void createSaveAppSvrConfigTask(List list) {
        if (DataManager.getInstance().isInstalled("BV")) {
            this.createSaveMdmTomcatTask(list);
        } else if (DataManager.getInstance().isInstalled("PMPSVC")) {
            this.createSavePmpTomcatTask(list);
        } else if (this.isTomcat()) {
            this.createSaveTomcatTask(list);
        } else if (this.isWLP()) {
            this.createSaveWLPTask(list);
        }
    }

    private void createSaveWLPTask(List list) {
        if (this.appSvrIsDirty()) {
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.savewlp");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Label.DialogSave.wlpTask");
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    if (DataManager.this.m_wlp.settingsChanged()) {
                        DataManager.this.backupWLPConfigurationFiles(DataManager.this.m_wlp);
                        DataManager.this.m_wlp.saveSettings();
                    }
                    return true;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }
            });
        }
        this.updateWebXml(list);
    }

    public void createSaveTomcatTask(List list) {
        if (this.appSvrIsDirty()) {
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.savetomcat");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Label.DialogSave.tomcatTask");
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    DataManager.this.saveTomcat();
                    return true;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }
            });
        }
        this.updateWebXml(list);
    }

    protected boolean isWebXmlValid(boolean bIsCMPresentNow, InputStream webxmlStream) {
        block4: {
            Document webXMLDoc = null;
            try {
                Element webappElem;
                webXMLDoc = DataManager.getWebXMLDoc(webxmlStream);
                if (webXMLDoc != null && (webappElem = webXMLDoc.getRootElement()) != null) {
                    Element cmServletElem = (Element)webappElem.selectSingleNode("//*[local-name()='servlet']/*[local-name()='servlet-name' and text()='CMServlet']");
                    boolean hasCMInWebxml = cmServletElem != null;
                    return bIsCMPresentNow == hasCMInWebxml;
                }
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("isWebXmlValid() - Unable to find web.xml file or web.xml is not valid. Return false.");
                }
            }
            catch (Exception e) {
                if (!CnfgLog.isDebugEnabled()) break block4;
                CnfgLog.debug("isWebXmlValid() - An exception occurred: " + e.getMessage());
            }
        }
        return false;
    }

    private void updateWebXml(List list) {
        block4: {
            if (!this.isInstalled("DISP")) {
                return;
            }
            try {
                boolean bUpdateWebXML;
                final boolean bIsCMPresentNow = this.isInstalled("CM");
                boolean bl = bUpdateWebXML = !this.isWebXmlValid(bIsCMPresentNow, null);
                if ((bUpdateWebXML || this.needUpgradeWebXML) && this.getCBS() != null) {
                    File src = null;
                    final File finalDst = this.resolveEffectiveFilePath("../webapps/p2pd/WEB-INF/web.xml");
                    src = bIsCMPresentNow ? this.resolveEffectiveFilePath("../webapps/p2pd/WEB-INF/web.xml.withCM") : this.resolveEffectiveFilePath("../webapps/p2pd/WEB-INF/web.xml.noCM");
                    final File finalSrc = src;
                    list.add(new CnfgTask(){

                        @Override
                        public String getLabel() {
                            return CnfgResource.getMessage("Message.task.checkWebXML");
                        }

                        @Override
                        public String getDescription() {
                            return CnfgResource.getMessage("Message.task.checkWebXML");
                        }

                        @Override
                        public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                            if (!ServiceManager.isRunning()) {
                                if (bUpdateWebXML) {
                                    DataManager.this.needUpgradeWebXML = DataManager.updateAndCheckUpgradeWebXML(finalSrc, finalDst, bIsCMPresentNow);
                                }
                                CnfgLog.error("Need upgrade webxml : " + (DataManager.this.needUpgradeWebXML ? "true" : "false"));
                                if (DataManager.this.needUpgradeWebXML) {
                                    Document webXMLDoc = DataManager.getWebXMLDoc(null);
                                    CnfgDataUtils.upgradeWebXML(webXMLDoc);
                                    CnfgDataUtils.backupNUpdateFile(webXMLDoc.asXML(), FileName_WEBXML);
                                    DataManager.this.needUpgradeWebXML = false;
                                    DataManager.getInstance().setWLPServerDirtyFlag(false);
                                }
                                Object[] arg = new Object[]{finalDst.getAbsolutePath()};
                                feedback.showInformational(CnfgResource.getMessage("Message.task.checkWebXML.update", arg));
                            } else if (CnfgLog.isDebugEnabled()) {
                                CnfgLog.debug("Updating web.xml while the product is running can yield fatal results. Skipping the update.");
                            }
                            return true;
                        }

                        @Override
                        public boolean isMandatory() {
                            return true;
                        }
                    });
                }
            }
            catch (DataManagerException e) {
                if (!CnfgLog.isDebugEnabled()) break block4;
                CnfgLog.debug("An exception occurred. Skipping the web.xml update task. Exception is: " + e.getMessage());
            }
        }
    }

    private void createSaveMdmTomcatTask(List list) {
        list.add(new CnfgTask(){

            @Override
            public String getLabel() {
                return CnfgResource.getMessage("Message.task.savetomcat");
            }

            @Override
            public String getDescription() {
                return CnfgResource.getMessage("Label.DialogSave.tomcatTask");
            }

            @Override
            public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                DataManager.this.saveMdmTomcat();
                return true;
            }

            @Override
            public boolean isMandatory() {
                return true;
            }
        });
    }

    private boolean checkPMPServiceExist() {
        Folder pmpsFolder = this.m_rootFolder.findFolder("pmpService", true);
        return null != pmpsFolder && !pmpsFolder.getDisabled() && pmpsFolder.getVisibility();
    }

    private void createSavePmpTomcatTask(List list) {
        if (this.checkPMPServiceExist()) {
            list.add(new CnfgTask(){

                @Override
                public String getLabel() {
                    return CnfgResource.getMessage("Message.task.savetomcat");
                }

                @Override
                public String getDescription() {
                    return CnfgResource.getMessage("Label.DialogSave.tomcatTask");
                }

                @Override
                public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
                    DataManager.this.savePmpTomcat();
                    return true;
                }

                @Override
                public boolean isMandatory() {
                    return true;
                }
            });
        }
    }

    private void setBTSVServicesName() {
        m_sCRNServiceName = "";
        List<ServiceFolder> lServices = this.getServiceFolders(true);
        for (int i = 0; i < lServices.size(); ++i) {
            ServiceFolder srvFolder = lServices.get(i);
            if (!(srvFolder instanceof BootstrapServiceFolder)) continue;
            BootstrapServiceFolder btsvSrvFolder = (BootstrapServiceFolder)srvFolder;
            String sName = btsvSrvFolder.getNewServiceName();
            btsvSrvFolder.setCnfgServiceName(sName);
            if (!btsvSrvFolder.isThisCBS()) continue;
            m_sCRNServiceName = sName;
        }
    }

    private void saveInstallDataProps() throws DataManagerException {
        CnfgInstallDataProcessor.getInstance().saveConfigServerInfo();
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("Saved installData.properties file.");
        }
    }

    public String getCRNServiceName() {
        return m_sCRNServiceName;
    }

    public CnfgActionOld getBuiltinAction(String sActionName, Element description) {
        if (sActionName == null && sActionName.length() == 0) {
            return null;
        }
        CnfgActionOld action = null;
        action = sActionName.equalsIgnoreCase("save") ? new CnfgActionSave() : (sActionName.equalsIgnoreCase("checkservice") ? new CnfgActionCheckService() : (sActionName.equalsIgnoreCase("deletecrn") ? new CnfgActionDeleteCRN() : (sActionName.startsWith("service") ? new CnfgActionService() : (sActionName.equalsIgnoreCase("InstallEAR") ? new CnfgActionInstallEAR() : (sActionName.equalsIgnoreCase("UninstallCognos") ? new CnfgActionUninstallCognos() : (sActionName.equalsIgnoreCase("GenerateDB2DDL") ? new CnfgActionGenDB2DDL() : (sActionName.startsWith("verifycnfm") ? new CnfgActionVerifyCNFM() : (sActionName.equalsIgnoreCase("wizGenCrypto") ? new CnfgActionWizGenCrypto() : (sActionName.equalsIgnoreCase("wizJRE") ? new CnfgActionWizJRE() : new CnfgActionOld(){

            @Override
            public void load(Element elem) {
                this.loadCommon(elem);
            }

            @Override
            public ICnfgTask[] getTasks(ArrayList paramList, ICnfgFeedback feedback) {
                return null;
            }

            @Override
            public void undo(ArrayList errorList) {
            }
        })))))))));
        if (action != null) {
            ((CnfgActionOld)action).load(description);
        }
        return action;
    }

    private boolean isJapaneseEncoding(String encoding) {
        boolean retValue = false;
        if (encoding.equalsIgnoreCase("WINDOWS-31J")) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Should not save the configuration with " + encoding + " mime encoding. Defaulting to UTF-8.");
            }
            retValue = true;
        }
        return retValue;
    }

    private void saveLocaleMaps() throws DataManagerException {
        block26: {
            if (this.m_localeMaps == null && this.getUpgradedLocaleDoc() != null) {
                this.m_localeMaps = DocumentHelper.createDocument();
                this.getLocaleDoc(this.m_localeMaps);
            }
            if (this.m_localeMaps != null) {
                OutputStreamWriter osw = null;
                FileOutputStream fos = null;
                SmartXMLWriter writer = null;
                try {
                    File localeFile = DataManager.getInstance().resolveEffectiveFilePath("../configuration/coglocale.xml");
                    String javaEncoding = this.getEncoding();
                    String mimeEncoding = ToolkitResources.normalizeEncoding((String)javaEncoding);
                    if (mimeEncoding == null || mimeEncoding.length() == 0) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("Unable to map the Java encoding " + javaEncoding + " to a mime encoding. Defaulting to UTF-8.");
                        }
                        javaEncoding = "UTF8";
                        mimeEncoding = "UTF-8";
                    }
                    if (this.isJapaneseEncoding(mimeEncoding)) {
                        javaEncoding = "UTF8";
                        mimeEncoding = "UTF-8";
                    }
                    Charset charset = Charset.forName(javaEncoding);
                    CharsetEncoder encoder = charset.newEncoder();
                    if (charset.compareTo(Charset.forName("UTF8")) != 0) {
                        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    }
                    fos = new FileOutputStream(localeFile);
                    osw = new OutputStreamWriter((OutputStream)fos, encoder);
                    OutputFormat prettyformat = OutputFormat.createPrettyPrint();
                    prettyformat.setSuppressDeclaration(false);
                    prettyformat.setEncoding(mimeEncoding);
                    writer = new SmartXMLWriter(osw, prettyformat, true, "\tLicensed Materials - Property of IBM\n\tIBM Cognos Products: cnfg\n\t(C) Copyright IBM Corp. 2017\n\tUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n");
                    writer.write(this.m_localeMaps);
                    writer.close();
                    osw.close();
                }
                catch (FileNotFoundException e) {
                    CnfgLog.error(e);
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveLocale.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage);
                }
                catch (UnsupportedEncodingException e) {
                    CnfgLog.error(e);
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveLocale.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage);
                }
                catch (UnmappableCharacterException e) {
                    if (Charset.forName(this.getEncoding()).compareTo(Charset.forName("UTF8")) != 0) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug(e);
                            CnfgLog.debug("Saving the configuration in the native encoding failed, trying re-save in UTF-8");
                        }
                        this.setDefaultEncoding(false);
                        try {
                            fos.close();
                        }
                        catch (IOException ioe) {
                            CnfgLog.error(ioe);
                            String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveLocale.failed.notification")).append("\n").append(ioe.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                            throw new DataManagerException(sMessage);
                        }
                        this.saveLocaleMaps();
                        break block26;
                    }
                    CnfgLog.error(e);
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage);
                }
                catch (IOException e) {
                    CnfgLog.error(e);
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveLocale.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage);
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        CnfgLog.error(e);
                        String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveLocale.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                        throw new DataManagerException(sMessage);
                    }
                }
            }
        }
        this.setLocaleDocDirtyFlag(false, null);
        if (this.isRestartServicesDirty()) {
            ServiceManager.setDirty(this.getRestartServices());
            this.resetRestartServicesDirtyFlag();
        }
    }

    private void saveTomcat() throws DataManagerException {
        Object[] args;
        Parameter internalURI = this.m_rootFolder.findParm("internalDispatcher");
        Parameter externalURI = this.m_rootFolder.findParm("externalDispatcher");
        Parameter dmnetURI = this.m_rootFolder.findParm("DSSOAPServerURI");
        String sDmnetURI = null;
        String sInternalURI = null;
        String sExternalURI = null;
        String sLabelExternalURI = "";
        String sLabelDmnetURI = "";
        if (this.isInstalled("DISP")) {
            if (null == internalURI || internalURI.getDisabled() || !internalURI.getVisibility()) {
                String sMsg = "Unexpected error. The internal dispatcher URI was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
            sInternalURI = (String)internalURI.getValue();
            if (null != externalURI && !externalURI.getDisabled() && externalURI.getVisibility()) {
                sExternalURI = (String)externalURI.getValue();
                sLabelExternalURI = externalURI.getLabel();
            } else {
                String sMsg = "Unexpected error. The external dispatcher URI was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
        }
        if (this.isInstalled("DMNETS")) {
            if (null != dmnetURI && !dmnetURI.getDisabled() && dmnetURI.getVisibility()) {
                sDmnetURI = (String)dmnetURI.getValue();
                sLabelDmnetURI = dmnetURI.getLabel();
            } else {
                String sMsg = "Unexpected error. The DMNET URI was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
        }
        if (sDmnetURI == null && sInternalURI == null && sExternalURI == null) {
            return;
        }
        if (sExternalURI != null && sDmnetURI != null) {
            boolean bExternalSSL = sExternalURI.startsWith("https://");
            String sExternalPort = this.getPortFromURI(sExternalURI);
            boolean bDmnetSSL = sDmnetURI.startsWith("https://");
            String sDmnetPort = this.getPortFromURI(sDmnetURI);
            if (bDmnetSSL != bExternalSSL) {
                Object[] args2 = new Object[]{sLabelDmnetURI, sLabelExternalURI};
                throw new DataManagerException(CnfgResource.getMessage("Message.saveTomcat.failed.dmnet.different.ssl", args2));
            }
            if (!sDmnetPort.equals(sExternalPort)) {
                Object[] args3 = new Object[]{sDmnetPort, sLabelDmnetURI, sExternalPort, sLabelExternalURI};
                throw new DataManagerException(CnfgResource.getMessage("Message.saveTomcat.failed.dmnet.differentport", args3));
            }
        }
        try {
            Element serverElem;
            if (this.m_tomcatDoc == null) {
                this.m_tomcatDoc = this.getAppSvrConfigDoc("../tomcat/conf/server.xml");
            }
            if (null == (serverElem = this.m_tomcatDoc.getRootElement())) {
                args = new Object[]{"<Server>"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
            }
            Parameter p = this.m_rootFolder.findParm("shutdownPort");
            String sShutdownPort = null != p ? p.getValue().toString() : String.valueOf(9399);
            serverElem.addAttribute("port", sShutdownPort);
            serverElem.addAttribute("shutdown", "SHUTDOWN");
            Element serviceElem = (Element)serverElem.selectSingleNode("Service[@name='Catalina']");
            if (null == serviceElem) {
                Object[] args4 = new Object[]{"<Service name=\"Catalina\">"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args4));
            }
            Element engineElem = (Element)serviceElem.selectSingleNode("Engine [@name='Catalina']");
            if (null == engineElem) {
                Object[] args5 = new Object[]{"<Engine name=\"Catalina\">"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args5));
            }
            Element hostElem = (Element)engineElem.selectSingleNode("Host [@name='localhost']");
            if (null == hostElem) {
                Object[] args6 = new Object[]{"<Host name=\"localhost\">"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args6));
            }
            Element contextPathDispatchElem = (Element)hostElem.selectSingleNode("Context[@path='/p2pd']");
            if (contextPathDispatchElem == null && this.isInstalled("DISP")) {
                Element elemContext = DocumentHelper.createElement((String)"Context");
                elemContext.addAttribute("path", "/p2pd");
                elemContext.addAttribute("docBase", "p2pd");
                elemContext.addAttribute("debug", "0");
                elemContext.addAttribute("reloadable", "false");
                elemContext.addAttribute("crossContext", "true");
                Element elemLogger = DocumentHelper.createElement((String)"Logger");
                elemLogger.addAttribute("className", "org.apache.catalina.logger.FileLogger");
                elemLogger.addAttribute("directory", "../logs");
                elemLogger.addAttribute("prefix", "localhost_ds_log.");
                elemLogger.addAttribute("suffix", ".txt");
                elemLogger.addAttribute("timestamp", "true");
                Element elemEnv = DocumentHelper.createElement((String)"Environment");
                elemEnv.addAttribute("name", "maxExemptions");
                elemEnv.addAttribute("type", "java.lang.Integer");
                elemEnv.addAttribute("value", "15");
                elemContext.add(elemLogger);
                elemContext.add(elemEnv);
                hostElem.add(elemContext);
            } else if (contextPathDispatchElem != null && !this.isInstalled("DISP")) {
                hostElem.remove(contextPathDispatchElem);
            }
            Element contextPathDMNETElem = (Element)hostElem.selectSingleNode("Context[@path='/axis']");
            if (contextPathDMNETElem == null && this.isInstalled("DMNETS")) {
                Element elemContext = DocumentHelper.createElement((String)"Context");
                elemContext.addAttribute("path", "/axis");
                elemContext.addAttribute("docBase", "ds");
                elemContext.addAttribute("debug", "0");
                elemContext.addAttribute("reloadable", "false");
                Element elemLogger = DocumentHelper.createElement((String)"Logger");
                elemLogger.addAttribute("className", "org.apache.catalina.logger.FileLogger");
                elemLogger.addAttribute("directory", "../logs");
                elemLogger.addAttribute("prefix", "localhost_ds_log.");
                elemLogger.addAttribute("suffix", ".txt");
                elemLogger.addAttribute("timestamp", "true");
                elemContext.add(elemLogger);
                hostElem.add(elemContext);
            } else if (contextPathDMNETElem != null && !this.isInstalled("DMNETS")) {
                hostElem.remove(contextPathDMNETElem);
            }
            if (sInternalURI != null && sExternalURI != null) {
                this.addHTTPConnectors(serviceElem, sInternalURI, sExternalURI);
            } else if ((sInternalURI == null || sExternalURI == null) && sDmnetURI != null) {
                this.addHTTPConnectors(serviceElem, sDmnetURI);
            }
            File tomcatFile = DataManager.getInstance().resolveEffectiveFilePath("../tomcat/conf/server.xml");
            OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(tomcatFile));
            OutputFormat prettyPrintFormat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)osw, prettyPrintFormat);
            writer.write(this.m_tomcatDoc);
            writer.close();
            osw.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.ioexception", args));
        }
    }

    private void saveMdmTomcat() throws DataManagerException {
        try {
            if (this.m_tomcatDoc == null) {
                this.m_tomcatDoc = this.getAppSvrConfigDoc("../tomcat/conf/server.xml");
            }
            Parameter mdmUseSSL = this.m_rootFolder.findParm("mdmUseSSL");
            Boolean sMDMUseSSL = null;
            if (null == mdmUseSSL || mdmUseSSL.getDisabled() || !mdmUseSSL.getVisibility()) {
                String sMsg = "Unexpected error. The MDM_USE_SSL parameter was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
            sMDMUseSSL = new Boolean(mdmUseSSL.getValue().toString());
            Parameter mdmPort = this.m_rootFolder.findParm("mdmDefaultPort");
            String sMDMPort = null;
            if (null == mdmPort || mdmPort.getDisabled() || !mdmPort.getVisibility()) {
                String sMsg = "Unexpected error. The MDM startup port parameter was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
            sMDMPort = mdmPort.getValue().toString();
            Parameter mdmSSLPort = this.m_rootFolder.findParm("mdmSSLPort");
            String sMDMSSLPort = null;
            if (null == mdmSSLPort || mdmSSLPort.getDisabled() || !mdmSSLPort.getVisibility()) {
                String sMsg = "Unexpected error. The MDM SSL port parameter was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
            sMDMSSLPort = mdmSSLPort.getValue().toString();
            if (sMDMPort.equals(mdmSSLPort)) {
                Object[] args = new Object[]{sMDMPort};
                throw new DataManagerException(CnfgResource.getMessage("Message.saveTomcat.failed.identical.portnumber", args));
            }
            Element serverElem = this.m_tomcatDoc.getRootElement();
            if (null == serverElem) {
                Object[] args = new Object[]{"<Server>"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
            }
            Parameter p = this.m_rootFolder.findParm("mdmShutdownPort");
            String sShutdownPort = null != p ? p.getValue().toString() : String.valueOf(9489);
            serverElem.addAttribute("port", sShutdownPort);
            serverElem.addAttribute("shutdown", "SHUTDOWN");
            Element serviceElem = (Element)serverElem.selectSingleNode("Service[@name='Catalina']");
            if (null == serviceElem) {
                Object[] args = new Object[]{"<Service name=\"Catalina\">"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
            }
            if (sMDMUseSSL.booleanValue()) {
                this.addHTTPConnectors5(serviceElem, "http://localhost:" + sMDMPort + "/", "https://localhost:" + sMDMSSLPort + "/");
            } else {
                this.addHTTPConnectors5(serviceElem, "http://localhost:" + sMDMPort + "/");
            }
            File tomcatFile = DataManager.getInstance().resolveEffectiveFilePath("../tomcat/conf/server.xml");
            OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(tomcatFile));
            OutputFormat prettyPrintFormat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)osw, prettyPrintFormat);
            writer.write(this.m_tomcatDoc);
            writer.close();
            osw.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.ioexception", args));
        }
    }

    private void savePmpTomcat() throws DataManagerException {
        try {
            Element serverElem;
            if (this.m_tomcatDoc == null) {
                this.m_tomcatDoc = this.getAppSvrConfigDoc("../tomcat/conf/server.xml");
            }
            if (null == (serverElem = this.m_tomcatDoc.getRootElement())) {
                Object[] args = new Object[]{"<Server>"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
            }
            Parameter p = this.m_rootFolder.findParm("pmpShutdownPort");
            String sShutdownPort = null != p ? p.getValue().toString() : String.valueOf(9489);
            serverElem.addAttribute("port", sShutdownPort);
            serverElem.addAttribute("shutdown", "SHUTDOWN");
            Element serviceElem = (Element)serverElem.selectSingleNode("Service[@name='Catalina']");
            if (null == serviceElem) {
                Object[] args = new Object[]{"<Service name=\"Catalina\">"};
                throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.missingnode", args));
            }
            Parameter pmpGateURIParam = this.m_rootFolder.findParm("pmpGatewayURI");
            String pmpURI = null;
            if (null == pmpGateURIParam || pmpGateURIParam.getDisabled() || !pmpGateURIParam.getVisibility()) {
                String sMsg = "Unexpected error. The PMP gateway URI parameter was not found in the data model";
                CnfgLog.error(sMsg);
                throw new DataManagerException(sMsg);
            }
            pmpURI = pmpGateURIParam.getValue().toString();
            this.addHTTPConnector(serviceElem, pmpURI);
            File tomcatFile = DataManager.getInstance().resolveEffectiveFilePath("../tomcat/conf/server.xml");
            OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(tomcatFile));
            OutputFormat prettyPrintFormat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((Writer)osw, prettyPrintFormat);
            writer.write(this.m_tomcatDoc);
            writer.close();
            osw.close();
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new Object[]{e.getLocalizedMessage()};
            throw new DataManagerException(CnfgResource.getMessage("Message.loadTomcat.failed.ioexception", args));
        }
    }

    private void addHTTPConnectors(Element serviceElem, String sDmnetURI) {
        Attribute aAddressLocalhost;
        Element internalConnectorElem;
        boolean bDmnetSSL = sDmnetURI.startsWith("https://");
        String sConnectorNode = "Connector";
        List httpElems = serviceElem.selectNodes(sConnectorNode);
        int size = httpElems.size();
        Element externalConnectorElem = null;
        if (size > 0) {
            internalConnectorElem = (Element)httpElems.get(0);
            if (size > 1) {
                externalConnectorElem = (Element)httpElems.get(1);
            }
            for (int i = 2; i < size; ++i) {
                serviceElem.remove((Element)httpElems.get(i));
            }
        } else {
            internalConnectorElem = DocumentHelper.createElement((String)"Connector");
            serviceElem.add(internalConnectorElem);
        }
        this.updateConnector(internalConnectorElem, sDmnetURI, bDmnetSSL);
        if (externalConnectorElem != null) {
            serviceElem.remove(externalConnectorElem);
        }
        if (null != (aAddressLocalhost = internalConnectorElem.attribute("address"))) {
            internalConnectorElem.remove(aAddressLocalhost);
        }
    }

    private void addHTTPConnectors5(Element serviceElem, String mdmURI) {
        Element connectorElem;
        String sConnectorNode = "Connector";
        List httpElems = serviceElem.selectNodes(sConnectorNode);
        int size = httpElems.size();
        if (size > 0) {
            connectorElem = (Element)httpElems.get(0);
        } else {
            connectorElem = DocumentHelper.createElement((String)"Connector");
            serviceElem.add(connectorElem);
        }
        this.updateConnector(connectorElem, mdmURI, false);
        Attribute aRedirectPort = connectorElem.attribute("redirectPort");
        if (null != aRedirectPort) {
            connectorElem.remove(aRedirectPort);
        }
        for (int i = 1; i < size; ++i) {
            connectorElem = (Element)httpElems.get(i);
            serviceElem.remove(connectorElem);
        }
    }

    private void addHTTPConnector(Element serviceElem, String svrURI) {
        Attribute aAddressLocalhost;
        Element connectorElem;
        boolean bSSL = false;
        if (svrURI == null) {
            return;
        }
        bSSL = svrURI.startsWith("https://");
        String sConnectorNode = "Connector";
        List httpElems = serviceElem.selectNodes(sConnectorNode);
        int size = httpElems.size();
        if (size > 0) {
            connectorElem = (Element)httpElems.get(0);
        } else {
            connectorElem = DocumentHelper.createElement((String)"Connector");
            serviceElem.add(connectorElem);
        }
        this.updateConnector(connectorElem, svrURI, bSSL);
        Attribute aRedirectPort = connectorElem.attribute("redirectPort");
        if (null != aRedirectPort) {
            connectorElem.remove(aRedirectPort);
        }
        if (null != (aAddressLocalhost = connectorElem.attribute("address"))) {
            connectorElem.remove(aAddressLocalhost);
        }
        for (int i = 1; i < size; ++i) {
            connectorElem = (Element)httpElems.get(i);
            serviceElem.remove(connectorElem);
        }
    }

    private void addHTTPConnectors5(Element serviceElem, String mdmURI, String mdmSSLURI) {
        Element connectorElem;
        String sConnectorNode = "Connector";
        List httpElems = serviceElem.selectNodes(sConnectorNode);
        int size = httpElems.size();
        if (size > 0) {
            connectorElem = (Element)httpElems.get(0);
        } else {
            connectorElem = DocumentHelper.createElement((String)"Connector");
            serviceElem.add(connectorElem);
        }
        this.updateConnector(connectorElem, mdmURI, false);
        Attribute aRedirectPort = connectorElem.attribute("redirectPort");
        if (null != aRedirectPort) {
            connectorElem.remove(aRedirectPort);
        }
        if (size > 1) {
            connectorElem = (Element)httpElems.get(1);
        } else {
            connectorElem = DocumentHelper.createElement((String)"Connector");
            serviceElem.add(connectorElem);
        }
        this.updateConnector(connectorElem, mdmSSLURI, true);
        for (int i = 2; i < size; ++i) {
            connectorElem = (Element)httpElems.get(i);
            serviceElem.remove(connectorElem);
        }
    }

    private void addHTTPConnectors(Element serviceElem, String sInternalURI, String sExternalURI) throws DataManagerException {
        Element internalConnectorElem;
        boolean bInternalSSL = sInternalURI.startsWith("https://");
        String sInternalPort = this.getPortFromURI(sInternalURI);
        boolean bExternalSSL = sExternalURI.startsWith("https://");
        String sExternalPort = this.getPortFromURI(sExternalURI);
        boolean bNeedOneConnector = false;
        if (bInternalSSL == bExternalSSL) {
            if (sInternalPort.equals(sExternalPort)) {
                bNeedOneConnector = true;
            }
        } else if (sInternalPort.equals(sExternalPort)) {
            Object[] args = new Object[]{sInternalPort};
            throw new DataManagerException(CnfgResource.getMessage("Message.saveTomcat.failed.identical.portnumber", args));
        }
        String sConnectorNode = "Connector";
        List httpElems = serviceElem.selectNodes(sConnectorNode);
        int size = httpElems.size();
        Element externalConnectorElem = null;
        if (size > 0) {
            internalConnectorElem = (Element)httpElems.get(0);
            if (size > 1) {
                externalConnectorElem = (Element)httpElems.get(1);
            }
            for (int i = 2; i < size; ++i) {
                serviceElem.remove((Element)httpElems.get(i));
            }
        } else {
            internalConnectorElem = DocumentHelper.createElement((String)"Connector");
            serviceElem.add(internalConnectorElem);
        }
        this.updateConnector(internalConnectorElem, sInternalURI, bInternalSSL);
        if (!bNeedOneConnector) {
            if (externalConnectorElem == null) {
                externalConnectorElem = (Element)internalConnectorElem.clone();
                serviceElem.add(externalConnectorElem);
            }
            this.updateConnector(externalConnectorElem, sExternalURI, bExternalSSL);
            Attribute aRedirectPort = externalConnectorElem.attribute("redirectPort");
            if (null != aRedirectPort) {
                externalConnectorElem.remove(aRedirectPort);
            }
            internalConnectorElem.addAttribute("address", "localhost");
            internalConnectorElem.addAttribute("redirectPort", sExternalPort);
        } else {
            Attribute aRedirectPort;
            Attribute aAddressLocalhost;
            if (externalConnectorElem != null) {
                serviceElem.remove(externalConnectorElem);
            }
            if (null != (aAddressLocalhost = internalConnectorElem.attribute("address"))) {
                internalConnectorElem.remove(aAddressLocalhost);
            }
            if (null != (aRedirectPort = internalConnectorElem.attribute("redirectPort"))) {
                internalConnectorElem.remove(aRedirectPort);
            }
        }
    }

    private void updateConnector(Element connectorElem, String sURL, boolean secure) {
        Attribute minProcessorAttr;
        String sPort = this.getPortFromURI(sURL);
        Attribute maxProcessorAttr = connectorElem.attribute("maxProcessors");
        if (maxProcessorAttr == null) {
            connectorElem.addAttribute("maxProcessors", "500");
        }
        if ((minProcessorAttr = connectorElem.attribute("minProcessors")) == null) {
            connectorElem.addAttribute("minProcessors", "5");
        }
        connectorElem.addAttribute("enableLookups", "true");
        connectorElem.addAttribute("connectionTimeout", "60000");
        connectorElem.addAttribute("acceptCount", "500");
        connectorElem.addAttribute("debug", "0");
        connectorElem.addAttribute("useURIValidationHack", "false");
        connectorElem.addAttribute("disableUploadTimeout", "true");
        connectorElem.addAttribute("port", sPort);
        if (!secure) {
            Attribute secureAttr = connectorElem.attribute("secure");
            if (null != secureAttr) {
                connectorElem.remove(secureAttr);
            }
            if (null != (secureAttr = connectorElem.attribute("scheme"))) {
                connectorElem.remove(secureAttr);
            }
            if (null != (secureAttr = connectorElem.attribute("SSLEnabled"))) {
                connectorElem.remove(secureAttr);
            }
            if (null != (secureAttr = connectorElem.attribute("SSLImplementation"))) {
                connectorElem.remove(secureAttr);
            }
        } else {
            connectorElem.addAttribute("scheme", "https");
            connectorElem.addAttribute("secure", "true");
            connectorElem.addAttribute("SSLEnabled", "true");
            connectorElem.addAttribute("SSLImplementation", "com.cognos.accman.jcam.crypto.coyote.JSSEImplementation");
        }
    }

    private String getPortFromURI(String sURL) {
        int nextIdx = sURL.indexOf("://");
        int bracketIdx = sURL.indexOf("]", nextIdx += 3);
        int colonIdx = bracketIdx != -1 ? sURL.indexOf(":", bracketIdx) : sURL.indexOf(":", nextIdx);
        String sServer = sURL.substring(nextIdx, colonIdx);
        int separatorIdx = sURL.indexOf("/", nextIdx += sServer.length() + 1);
        return sURL.substring(nextIdx, separatorIdx);
    }

    public void addCnfgNodeInsertedListener(CnfgNodeInsertedListener dl) {
        this.m_lNodeInsertedListeners.add(dl);
    }

    public void removeCnfgNodeInsertedListener(CnfgNodeInsertedListener dl) {
        this.m_lNodeInsertedListeners.remove(dl);
    }

    public void fireNodeInserted(CnfgNodeInsertedEvent e) {
        for (int i = 0; i < this.m_lNodeInsertedListeners.size(); ++i) {
            CnfgNodeInsertedListener dl = this.m_lNodeInsertedListeners.get(i);
            dl.nodeInserted(e);
        }
    }

    public void addCnfgNodeDeletedListener(CnfgNodeDeletedListener dl) {
        this.m_lNodeDeletedListeners.add(dl);
    }

    public void removeCnfgNodeInsertedListener(CnfgNodeDeletedListener dl) {
        this.m_lNodeDeletedListeners.remove(dl);
    }

    public void fireNodeDeleted(CnfgNodeDeletedEvent e) {
        for (int i = 0; i < this.m_lNodeDeletedListeners.size(); ++i) {
            CnfgNodeDeletedListener dl = this.m_lNodeDeletedListeners.get(i);
            dl.nodeDeleted(e);
        }
    }

    public void fireNodeSwitch(CnfgNodeSwitchEvent e) {
        for (int i = 0; i < this.m_lNodeSwitchListeners.size(); ++i) {
            CnfgNodeSwitchListener dl = this.m_lNodeSwitchListeners.get(i);
            dl.nodeSwitch(e);
        }
    }

    public void addCnfgNodeSwitchListener(CnfgNodeSwitchListener sl) {
        this.m_lNodeSwitchListeners.add(sl);
    }

    public void addCnfgNodeRenamedListener(CnfgNodeRenamedListener dl) {
        this.m_lNodeRenamedListeners.add(dl);
    }

    public void removeCnfgNodeRenamedListener(CnfgNodeRenamedListener dl) {
        this.m_lNodeRenamedListeners.remove(dl);
    }

    public void fireNodeRenamed(CnfgNodeRenamedEvent e) {
        for (int i = 0; i < this.m_lNodeRenamedListeners.size(); ++i) {
            CnfgNodeRenamedListener dl = this.m_lNodeRenamedListeners.get(i);
            dl.nodeRenamed(e);
        }
    }

    public void addCnfgDataLoadedListener(CnfgDataListener dl) {
        this.m_lDataListeners.add(dl);
    }

    public void removeCnfgDataLoadedListener(CnfgDataListener dl) {
        this.m_lDataListeners.remove(dl);
    }

    protected void fireDataLoaded(CnfgDataEvent e) {
        for (int i = 0; i < this.m_lDataListeners.size(); ++i) {
            CnfgDataListener dl = this.m_lDataListeners.get(i);
            dl.dataLoaded(e);
        }
    }

    public void addCnfgValueChangedListener(CnfgValueChangedListener dl) {
        this.m_lValueChangedListeners.add(dl);
    }

    public void removeCnfgValueChangedListener(CnfgDataListener dl) {
        this.m_lValueChangedListeners.remove(dl);
    }

    public void fireValueChanged(CnfgValueChangedEvent e) {
        for (int i = 0; i < this.m_lValueChangedListeners.size(); ++i) {
            CnfgValueChangedListener dl = this.m_lValueChangedListeners.get(i);
            dl.valueChanged(e);
        }
    }

    public void addServiceFolderListener(CnfgServiceFolderChangedListener rsl) {
        this.m_lServiceFolderChangedListeners.add(rsl);
    }

    public void removeServiceFolderListener(CnfgServiceFolderChangedListener rsl) {
        this.m_lServiceFolderChangedListeners.remove(rsl);
    }

    public void fireServiceFolderChanged(CnfgServiceFolderChangedEvent e) {
        for (int i = 0; i < this.m_lServiceFolderChangedListeners.size(); ++i) {
            CnfgServiceFolderChangedListener rsl = this.m_lServiceFolderChangedListeners.get(i);
            rsl.serviceFolderChanged(e);
        }
    }

    @Override
    public void valueChanged(CnfgValueChangedEvent e) {
        this.updateDirtyFlags(e);
    }

    @Override
    public void nodeInserted(CnfgNodeInsertedEvent e) {
        this.updateDirtyFlags(e);
        this.resetServiceFolders();
    }

    @Override
    public void nodeDeleted(CnfgNodeDeletedEvent e) {
        this.updateDirtyFlags(e);
        this.resetServiceFolders();
        ServiceManager.removeListener(e.getSource());
    }

    @Override
    public void nodeSwitch(CnfgNodeSwitchEvent e) {
        this.updateDirtyFlags(e);
    }

    @Override
    public void nodeRenamed(CnfgNodeRenamedEvent e) {
        this.updateDirtyFlags(e);
        this.resetServiceFolders();
    }

    public Folder getCurrentSelection() {
        return this.m_currentSelection;
    }

    public void setCurrentSelection(Folder f) {
        if (!f.equals(this.m_currentSelection)) {
            this.m_currentSelection = f;
            CnfgSelectionEvent e = new CnfgSelectionEvent(this.m_currentSelection);
            this.fireSelectionChanged(e);
        }
    }

    public void addCnfgSelectionListener(CnfgSelectionListener dl) {
        this.m_lSelectionListeners.add(dl);
    }

    public void removeCnfgSelectionListener(CnfgSelectionListener dl) {
        this.m_lSelectionListeners.remove(dl);
    }

    protected void fireSelectionChanged(CnfgSelectionEvent e) {
        for (int i = 0; i < this.m_lSelectionListeners.size(); ++i) {
            CnfgSelectionListener dl = this.m_lSelectionListeners.get(i);
            dl.selectionChanged(e);
        }
    }

    public void addToRootFolder(Parameter toAdd) {
        this.m_rootFolder.addParameter(toAdd);
    }

    public Parameter findParm(String sName) {
        return this.m_rootFolder.findParm(sName);
    }

    public Parameter findParm(String sName, String context) {
        return this.m_rootFolder.findParm(sName, context);
    }

    public Parameter findWizardParm(String sSearchPath) {
        return this.m_rootFolder.findWizardParm(sSearchPath);
    }

    public Folder findFolder(String sName, boolean bRecurse) {
        if (this.m_rootFolder.getName().equals(sName)) {
            return this.m_rootFolder;
        }
        return this.m_rootFolder.findFolder(sName, bRecurse);
    }

    public boolean hasChildrenInstanceWithNameExclude(String sName, String sInstance, String excludeInstanceName) {
        return this.hasChildrenInstance(sName, sInstance, false, excludeInstanceName);
    }

    public boolean hasChildrenInstanceWithName(String sName, String sInstance) {
        return this.hasChildrenInstance(sName, sInstance, false, null);
    }

    public boolean hasChildrenInstanceWithValue(String sName, String sInstance) {
        return this.hasChildrenInstance(sName, sInstance, true, null);
    }

    public boolean hasChildrenInstance(String sName, String sTemplate, boolean isValue, String excludeInstanceName) {
        Folder parentF;
        boolean bFound = false;
        if (sName != null && sName.length() > 0 && null != (parentF = this.findFolder(sName, true)) && !parentF.getDisabled() && parentF.getVisibility()) {
            List<Folder> folders = parentF.getFolders();
            for (int i = 0; i < folders.size(); ++i) {
                Folder f = folders.get(i);
                Object type = null;
                type = isValue ? f.getTemplatedParameter().getValue() : f.getTemplatedParameter().getName();
                if (type == null || !type.equals(sTemplate) || excludeInstanceName != null && (excludeInstanceName == null || f.getName().equalsIgnoreCase(excludeInstanceName))) continue;
                bFound = true;
                break;
            }
        }
        return bFound;
    }

    public Folder getRootFolder() {
        return this.m_rootFolder;
    }

    public Parameter findParam(String paramName) {
        if (this.m_rootFolder != null) {
            return this.m_rootFolder.findParm(paramName);
        }
        return null;
    }

    public Folder findComplexFolder(String sName, boolean bRecurse) {
        if (this.m_rootFolder.getName().equals(sName) && this.m_rootFolder.getOpaque()) {
            return this.m_rootFolder;
        }
        return this.m_rootFolder.findComplexFolder(sName, bRecurse);
    }

    public CnfgActionTest findTestAction(String refID) {
        if (refID == null) {
            return null;
        }
        List<CnfgActionTest> list = this.m_rootFolder.getTestActions(refID);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CnfgActionCustomSave findSaveAction(String refID) {
        if (refID == null) {
            return null;
        }
        List<CnfgActionCustomSave> list = this.m_rootFolder.getCustomSaveActions(refID);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Element getLocaleMapsElement() throws DataManagerException {
        Element rootElement;
        if (this.m_localeMaps == null) {
            this.m_localeMaps = DocumentHelper.createDocument();
            this.getLocaleDoc(this.m_localeMaps);
        }
        if ((rootElement = this.m_localeMaps.getRootElement()).getName().equals("localeConfiguration")) {
            return rootElement;
        }
        String sMessage = new StringBuffer(CnfgResource.getMessage("Message.loadLocale.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadLocale.failed.explanation.fileformat")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
        throw new DataManagerException(sMessage);
    }

    protected synchronized IEncryptingSession getCryptoEncryptingSession(boolean bEncrypt) throws DataManagerException {
        if (null == this.m_es) {
            if (!bEncrypt) {
                return null;
            }
            try {
                if (null == this.m_cf) {
                    throw new Error("This code wasn't meant to initialize m_cf.");
                }
                this.m_es = this.m_cf.createEncryptingSession();
            }
            catch (CAMCryptoException e) {
                CnfgLog.error(e);
                throw new DataManagerException(e.getLocalizedMessage());
            }
        }
        return this.m_es;
    }

    protected synchronized ISystemProtectionSession getCryptoSystemSession() throws DataManagerException {
        if (null == this.m_sps) {
            try {
                ICAMFactory cf = Creator.createCAMFactory();
                this.m_sps = cf.createSystemProtectionSession();
            }
            catch (CAMCryptoException e) {
                CnfgLog.error(e);
                throw new DataManagerException(e.getLocalizedMessage());
            }
        }
        return this.m_sps;
    }

    public synchronized void initializeCAMFactory() throws CAMCryptoException, DataManagerException {
        if (null == this.m_cf || this.m_cryptoDirty) {
            this.m_cf = Creator.createCAMFactory();
            String s = this.getCryptoConfig(false);
            this.m_cf.initialize(s);
            this.m_es = this.m_cf.createEncryptingSession();
        }
    }

    public void setLocaleDocument(Document newLocaleDoc) {
        this.setLocaleDocDirtyFlag(true, this.getAllServices());
        this.m_localeMaps = newLocaleDoc;
    }

    public boolean getDecryptCryptoPasswords() {
        return this.m_decryptCryptoPasswords;
    }

    protected void setDecryptCryptoPasswords(boolean val) {
        this.m_decryptCryptoPasswords = val;
    }

    private void getLocaleDoc(Document localedoc) throws DataManagerException {
        try {
            Element rootElement;
            Document doc = this.getUpgradedLocaleDoc();
            if (doc == null) {
                ICCLConfiguration CCLCFGAPI = CCLConfigurationFactory.getInstance();
                File configFile = new File(CCLCFGAPI.resolveEffectivePath("../configuration/coglocale.xml"));
                if (!configFile.exists()) {
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.loadLocale.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadLocale.failed.explanation.notfound")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
                    throw new DataManagerException(sMessage);
                }
                SAXReader reader = new SAXReader();
                doc = reader.read(configFile);
            }
            if ((rootElement = doc.getRootElement()) != null) {
                rootElement.detach();
                localedoc.setRootElement(rootElement);
                return;
            }
            String sMessage = new StringBuffer(CnfgResource.getMessage("Message.loadLocale.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.loadLocale.failed.explanation.parsing")).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
            throw new DataManagerException(sMessage);
        }
        catch (DocumentException e) {
            CnfgLog.error(e);
            String sMessage = new StringBuffer(CnfgResource.getMessage("Message.loadLocale.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.loadConfig.failed.resolution")).toString();
            throw new DataManagerException(sMessage);
        }
    }

    private void updateDirtyFlags(EventObject event) {
        Object source;
        Folder currFolder = null;
        ArrayList<String> lRestartCRN = null;
        if (event != null && (source = event.getSource()) != null) {
            if (Folder.class.isInstance(source)) {
                currFolder = (Folder)source;
                lRestartCRN = currFolder.getRestartServicesList();
            } else if (Parameter.class.isInstance(source)) {
                Parameter param = (Parameter)source;
                currFolder = param.getParent();
                lRestartCRN = param.getRestartServicesList();
            }
        }
        this.setConfigDirtyFlag(true, lRestartCRN);
        Folder changedFolder = currFolder;
        if (!this.m_cryptoDirty) {
            if (currFolder != null && currFolder.getName().equals("environment")) {
                this.m_cryptoDirty = true;
                return;
            }
            while (currFolder != null && currFolder.getParent() != null) {
                if (currFolder.getName().equals("CRYPTO")) {
                    this.m_cryptoDirty = true;
                    return;
                }
                currFolder = currFolder.getParent();
            }
        }
        this.updateAAADirtyFlag(changedFolder);
    }

    private void updateAAADirtyFlag(Folder currFolder) {
        if (!this.m_bAAADirty) {
            while (currFolder != null && currFolder.getParent() != null) {
                CnfgLog.debug("updateAAADirtyFlag - current folder name: " + currFolder.getName());
                if (currFolder.getName().equals("AAA")) {
                    this.m_bAAADirty = true;
                    CnfgLog.info("updateAAADirtyFlag - set AAA is dirty.");
                    return;
                }
                currFolder = currFolder.getParent();
            }
        }
    }

    public void initializeCAMFactoryFromDisk() {
        if (null == this.m_cf) {
            try {
                this.m_cf = Creator.createCAMFactory();
                this.m_cf.initialize("<initializeDocument><serviceID>CNFG</serviceID></initializeDocument>".getBytes());
                this.m_es = this.m_cf.createEncryptingSession();
            }
            catch (Throwable e) {
                CnfgLog.error(e.getMessage());
            }
            return;
        }
    }

    public void addGlobalConfigFolders(Folder folder) {
        this.m_lGlobalConfigFolders.add(folder);
    }

    public List<Folder> getGlobalConfigFolders() {
        return this.m_lGlobalConfigFolders;
    }

    public Element serializeToQueryResult(List<String> errors, boolean bIncludeGlobalConfig) throws DataManagerException {
        this.m_rootFolder.checkMinOccurs(errors);
        if (errors.size() > 0) {
            return null;
        }
        Element configRootElem = this.serialize(false, errors, false, true);
        if (errors.size() > 0) {
            return null;
        }
        Document docElem = DocumentHelper.createDocument();
        Element root_elem = docElem.addElement("queryResult");
        root_elem.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root_elem.addNamespace("cfg", "http://developer.cognos.com/schemas/configparams/XMLSchema/1/");
        root_elem.addNamespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
        Element itemElem = root_elem.addElement("item");
        Iterator iElements = configRootElem.elementIterator();
        while (iElements.hasNext()) {
            Element paramElem = (Element)iElements.next();
            this.addParamToQueryResultItem(paramElem, itemElem);
        }
        if (bIncludeGlobalConfig) {
            Element globalRootElement;
            if (this.m_localeMaps == null && this.getUpgradedLocaleDoc() != null) {
                this.m_localeMaps = DocumentHelper.createDocument();
                this.getLocaleDoc(this.m_localeMaps);
            }
            if (this.m_localeMaps != null && (globalRootElement = this.m_localeMaps.getRootElement()).getName().equals("localeConfiguration")) {
                Iterator iglobalElements = globalRootElement.elementIterator();
                while (iglobalElements.hasNext()) {
                    Element gElem = (Element)iglobalElements.next();
                    String ename = gElem.getName();
                    if (ename.equalsIgnoreCase("parameter")) {
                        this.addParamToQueryResultItem(gElem, itemElem);
                        continue;
                    }
                    List childElem = gElem.elements();
                    if (childElem.size() == 0) continue;
                    Element newElem = itemElem.addElement(ename);
                    Element newVal = newElem.addElement("value");
                    for (int i = 0; i < childElem.size(); ++i) {
                        Element item = (Element)childElem.get(i);
                        String sID = item.attributeValue("id");
                        if (sID != null) {
                            if (sID.length() <= 0) continue;
                            Element newItem = newVal.addElement("item");
                            newItem.setText(sID);
                            continue;
                        }
                        String sKey = item.attributeValue("key");
                        String sValue = item.attributeValue("value");
                        if (sKey == null || sKey.length() <= 0 || sValue == null || sValue.length() <= 0) continue;
                        Element newItem = newVal.addElement("item");
                        Element newItemKey = newItem.addElement("key");
                        newItemKey.setText(sKey);
                        Element newItemValue = newItem.addElement("value");
                        newItemValue.setText(sValue);
                    }
                }
            }
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("serializeToQueryResult - succeed.");
        }
        return root_elem;
    }

    private void addParamToQueryResultItem(Element origElem, Element itemElem) {
        String ename = origElem.attributeValue("name");
        String opaque = origElem.attributeValue("opaque");
        Element newElem = itemElem.addElement(ename);
        if (opaque != null && opaque.equals("true")) {
            newElem.addAttribute("opaque", "true");
        } else {
            newElem.addAttribute("opaque", "false");
        }
        for (int i = 0; i < origElem.attributeCount(); ++i) {
            Attribute atr = origElem.attribute(i);
            if (atr.getName().equals("name")) continue;
            newElem.addAttribute(atr.getName(), atr.getText());
        }
        Element origVal = (Element)origElem.elements().get(0);
        Element newVal = newElem.addElement("value");
        String xsiType = "xsi:type";
        Namespace schemaInstNS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        QName qName = new QName("type", schemaInstNS);
        newVal.addAttribute(xsiType, origVal.attributeValue(qName));
        if (opaque != null && opaque.equals("true")) {
            List lElem = origVal.elements();
            for (int i = 0; i < lElem.size(); ++i) {
                Element item = (Element)((Element)lElem.get(i)).clone();
                newVal.add(item);
            }
        } else {
            newVal.setText(origVal.getText());
        }
    }

    public ICCLConfiguration getICCLConfiguration(List<String> errors, boolean bIncludeGlobalConfig, Object overwriteObj) throws DataManagerException {
        ICCLConfiguration cfg = CCLConfigurationFactory.createConfiguration();
        try {
            Element configRootElem = this.serializeToQueryResult(errors, bIncludeGlobalConfig);
            if (errors.size() > 0 || configRootElem == null) {
                return null;
            }
            if (overwriteObj != null && Parameter.class.isAssignableFrom(overwriteObj.getClass())) {
                Element item_elem;
                Parameter paramObj = (Parameter)overwriteObj;
                String sParamName = paramObj.getName();
                Object oValue = paramObj.getValue();
                if (sParamName != null && sParamName.length() > 0 && oValue != null && (item_elem = configRootElem.element("item")) != null) {
                    Element param_elem = item_elem.element(sParamName);
                    if (param_elem != null) {
                        Element value_elem = param_elem.element("value");
                        if (value_elem != null) {
                            value_elem.setText(oValue.toString());
                        }
                    } else {
                        Element temp_root_elem = DocumentHelper.createElement((String)"temproot");
                        paramObj.serialize(temp_root_elem, false, errors, false, true);
                        Element org_elem = temp_root_elem.element("parameter");
                        this.addParamToQueryResultItem(org_elem, item_elem);
                    }
                }
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("After overwrite the parameter '" + sParamName + "', initialize ICCLConfiguration.\n");
                }
            }
            cfg.init(configRootElem);
        }
        catch (CCLConfigurationException e) {
            CnfgLog.error("Could not init ICCLConfiguration object.");
            CnfgLog.error(e);
            throw new DataManagerException(e.getLocalizedMessage());
        }
        catch (DataManagerException e) {
            CnfgLog.error("Could not serialize the configuration.");
            CnfgLog.error(e);
            throw new DataManagerException(e.getLocalizedMessage());
        }
        return cfg;
    }

    public ICCLConfiguration getICCLConfiguration(List<String> errors) throws DataManagerException {
        return this.getICCLConfiguration(errors, true, null);
    }

    public ICCLConfiguration getICCLConfiguration(List<String> errors, Object overwriteObj) throws DataManagerException {
        return this.getICCLConfiguration(errors, true, overwriteObj);
    }

    public static ICCLConfiguration validateConfiguration(ITaskCollector taskCollector, Object obj, boolean bShowErrorDialog) {
        ICCLConfiguration cclconfig = null;
        try {
            ArrayList<String> errors = new ArrayList<String>();
            cclconfig = DataManager.getInstance().getICCLConfiguration(errors, obj);
            if (errors.size() > 0 || cclconfig == null) {
                StringBuffer sb = new StringBuffer();
                sb.append(CnfgResource.getMessage("Message.errorOnValidation.info"));
                for (int i = 0; i < errors.size(); ++i) {
                    sb.append(errors.get(i));
                }
                if (bShowErrorDialog) {
                    taskCollector.error(new TaskCollectorException(10, sb.toString()));
                }
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager - validateConfiguration() return an error:  " + sb.toString());
                }
                return null;
            }
        }
        catch (DataManagerException e) {
            if (bShowErrorDialog) {
                taskCollector.error(new TaskCollectorException(1, (Throwable)e));
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("DataManager - validateConfiguration() return an error:  " + e.getMessage());
            }
            return null;
        }
        return cclconfig;
    }

    public static String buildPath(Object obj) {
        if (Folder.class.isAssignableFrom(obj.getClass())) {
            return DataManager.buildFolderPath((Folder)obj);
        }
        if (Parameter.class.isAssignableFrom(obj.getClass())) {
            return DataManager.buildParamFolderPath((Parameter)obj);
        }
        if (Option.class.isAssignableFrom(obj.getClass())) {
            return DataManager.buildOptionFolderPath((Option)obj);
        }
        return null;
    }

    private static String buildOptionFolderPath(Option p) {
        if (null == p.getParent()) {
            return "null";
        }
        if (null != p.getParent().getParent()) {
            return DataManager.buildFolderPath(p.getParent()) + "/" + p.getName();
        }
        return p.getName();
    }

    private static String buildFolderPath(Folder f) {
        if (null == f.getParent()) {
            return "null";
        }
        if (null != f.getParent().getParent()) {
            StringBuilder path = new StringBuilder(DataManager.buildFolderPath(f.getParent()));
            if (f.isInstanceFolder()) {
                path.append("/");
                path.append(f.getTemplatedParameter().getName());
                String pathSection = f.getName();
                if (pathSection != null) {
                    path.append("/");
                    path.append(pathSection);
                }
            } else {
                String pathSection = f.getName();
                if (pathSection != null) {
                    path.append("/");
                    path.append(pathSection);
                }
            }
            return path.toString();
        }
        return f.getName();
    }

    private static String buildParamFolderPath(Parameter p) {
        if (null == p.getParent()) {
            return "null";
        }
        if (null != p.getParent().getParent()) {
            return DataManager.buildFolderPath(p.getParent()) + "/" + p.getName();
        }
        return p.getName();
    }

    public Boolean getIsCNFMCheckingDisabled() {
        return this.m_bIsCNFMCheckingDisabled;
    }

    public void setIsCNFMCheckingViaTestActionEnabled(boolean isCNFMCheckingViaTestActionEnabled) {
        this.m_bIsCNFMCheckingViaTestActionEnabled = isCNFMCheckingViaTestActionEnabled;
    }

    public boolean getIsCNFMCheckingViaTestActionEnabled() {
        return this.m_bIsCNFMCheckingViaTestActionEnabled;
    }

    public void loadStartupFile(String filePath) {
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("loading crnstartup.xml from " + (filePath.equals("-") ? "stdin" : filePath));
        }
        InputStream in = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            in = filePath.equals("-") ? System.in : new FileInputStream(filePath);
            byte[] buffer = new byte[4096];
            int size = 0;
            while ((size = in.read(buffer, 0, 4096)) != -1) {
                baos.write(buffer, 0, size);
            }
            baos.flush();
            baos.close();
            in.close();
            this.m_bCogStartupXML = baos.toByteArray();
        }
        catch (IOException e) {
            CnfgLog.error("An error was encountered when attempting to read the cogstartup.xml file '" + filePath + "'. Exception : " + e.getLocalizedMessage());
            this.m_bCogStartupXML = null;
        }
    }

    public InputStream getStartupInputStream() {
        if (this.m_bCogStartupXML != null) {
            return new ByteArrayInputStream(this.m_bCogStartupXML);
        }
        InputStream in = null;
        ICCLConfiguration CCLCFGAPI = CCLConfigurationFactory.getInstance();
        File f = new File(CCLCFGAPI.resolveEffectivePath("../configuration/cogstartup.xml"));
        if (f.exists()) {
            try {
                in = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                in = null;
            }
        } else {
            in = this.getClass().getResourceAsStream("../configuration/cogstartup.xml");
        }
        return in;
    }

    public void setSSLProtocolsChanged(boolean bChanged) {
        if (this.m_wlp != null) {
            this.m_wlp.setSSLProtocoChanged(bChanged);
        }
    }

    public boolean shouldSkipBackup() {
        return this.m_bSkipBackup;
    }

    public void setSkipBackup(boolean skipBackup) {
        this.m_bSkipBackup = skipBackup;
    }

    public static void setRespectEnvVar(boolean bRespectEnvVars) {
        m_respectEnv = bRespectEnvVars;
    }

    public void setCryptoDirtyFlag(boolean dirty) {
        this.m_cryptoDirty = dirty;
    }

    public boolean getCryptoDirtyFlag() {
        return this.m_cryptoDirty;
    }

    public void setAAADirtyFlag(boolean dirty) {
        this.m_bAAADirty = dirty;
    }

    public boolean isAAADirty() {
        return this.m_bAAADirty;
    }

    public WLPConfiguration getWLPInst() {
        return this.m_wlp;
    }

    public void initRESTClient() {
        RESTClientFactory.getInstance().startup("config-service");
    }

    public void setRootFolder(Folder rootFolder) {
        this.m_rootFolder = rootFolder;
    }

    static {
        m_uiDocsLoaded = false;
        FileName_WEBXML = "../webapps/p2pd/WEB-INF/web.xml";
        m_respectEnv = false;
        nsToPrefixMap.put("http://www.w3.org/2001/XMLSchema", "xsd");
        nsToPrefixMap.put("http://developer.cognos.com/schemas/configparams/XMLSchema/1/", "cfg");
    }

    public static interface ITaskCollector {
        public void startTaskCollecting();

        public void endTaskCollecting();

        public void error(TaskCollectorException var1);
    }

    private class CnfgCMUpgradeTask
    extends CnfgTask {
        String m_sSource;

        CnfgCMUpgradeTask(String sSource) {
            this.m_sSource = sSource;
        }

        @Override
        public String getLabel() {
            return CnfgResource.getMessage("Message.task.CMUpgrade");
        }

        @Override
        public String getDescription() {
            return CnfgResource.getMessage("Message.task.CMUpgrade");
        }

        @Override
        public boolean run(Object[] args, ICnfgFeedback feedback) throws Exception {
            ArrayList statistics = new ArrayList();
            boolean isCMUpgrRequired = DataManager.this.isUpgradeRequired(statistics);
            boolean isIPFUpgrRequired = DataManager.this.isIPFUpgradeRequired();
            if (!isCMUpgrRequired && !isIPFUpgrRequired) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("DataManager::createCMUpgradeTask() - CM upgrade calls says that upgrade is not required.");
                }
                DataManager.this.updateUpgradeFile(false);
                return true;
            }
            DataManager.this.updateUpgradeFile(true);
            if (isIPFUpgrRequired) {
                String sResponse = feedback.prompt("<prompt name=\"com.cognos.crconfig.DialogIPFUpgrade\"><parameters><parameter name=\"source\" type=\"xsd:string\" default=\"save\"><value>" + this.m_sSource + "</value></parameter>" + "<parameter name=\"doPromptAgain\" type=\"xsd:boolean\"><value>" + DataManager.this.m_bDoPromptForIPFUpgrade.toString() + "</value></parameter>" + "</parameters>" + "</prompt>");
                Element root = null;
                try {
                    root = DocumentHelper.parseText((String)sResponse).getRootElement();
                }
                catch (DocumentException e) {
                    CnfgLog.error("DataManager::createCMUpgradeTask() - unable to parse the return value, e is " + e.getMessage());
                    feedback.showError("An unexpected error occurred: " + e.getMessage());
                    return false;
                }
                if (root.getName().equalsIgnoreCase("fail")) {
                    feedback.showInformational(CnfgResource.getMessage("Message.task.CMUpgrade.opcancelled"));
                    return false;
                }
                Element parameters = root.element("parameters");
                if (parameters != null) {
                    Iterator it = parameters.elementIterator("parameter");
                    while (it.hasNext()) {
                        String sValue;
                        Element elemValue;
                        Element elemParam = (Element)it.next();
                        String sName = elemParam.attributeValue("name");
                        if (sName == null || sName.length() == 0 || (elemValue = elemParam.element("value")) == null || (sValue = elemValue.getText()) == null || sValue.length() == 0 || !sName.equals("doPromptAgain")) continue;
                        DataManager.this.m_bDoPromptForIPFUpgrade = new Boolean(sValue);
                    }
                }
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgCMUpgradeTask::run() - Reading prompt() response for IPF...");
                    CnfgLog.debug("doPromptAgain is " + DataManager.this.m_bDoPromptForIPFUpgrade.toString());
                }
            }
            if (isCMUpgrRequired) {
                Object obj;
                StringBuffer sFormattedStats = new StringBuffer();
                for (String element : statistics) {
                    sFormattedStats.append("<statistic>").append(element).append("</statistic>");
                }
                Parameter doReportSpecUpgradeParameter = DataManager.this.findParm("doReportSpecUpgrade");
                Boolean bReportSpecUpgradeParameterOriginal = null;
                if (doReportSpecUpgradeParameter != null && (obj = doReportSpecUpgradeParameter.getValue()) != null && obj.getClass() == Boolean.class) {
                    bReportSpecUpgradeParameterOriginal = (Boolean)obj;
                    DataManager.this.m_bDoReportSpecUpgrade = (Boolean)obj;
                }
                String sResponse = feedback.prompt("<prompt name=\"com.cognos.crconfig.DialogCMUpgrade\"><statistics>" + sFormattedStats.toString() + "</statistics>" + "<parameters>" + "<parameter name=\"source\" type=\"xsd:string\" default=\"save\"><value>" + this.m_sSource + "</value></parameter>" + "<parameter name=\"doReportSpecUpgrade\" type=\"xsd:boolean\"><value>" + DataManager.this.m_bDoReportSpecUpgrade.toString() + "</value></parameter>" + "<parameter name=\"doPromptAgain\" type=\"xsd:boolean\"><value>" + DataManager.this.m_bDoPromptForCMUpgrade.toString() + "</value></parameter>" + "</parameters>" + "</prompt>");
                Element root = null;
                try {
                    root = DocumentHelper.parseText((String)sResponse).getRootElement();
                }
                catch (DocumentException e) {
                    CnfgLog.error("DataManager::createCMUpgradeTask() - unable to parse the return value, e is " + e.getMessage());
                    feedback.showError("An unexpected error occurred: " + e.getMessage());
                    return false;
                }
                if (root.getName().equalsIgnoreCase("fail")) {
                    feedback.showInformational(CnfgResource.getMessage("Message.task.CMUpgrade.opcancelled"));
                    return false;
                }
                Element parameters = root.element("parameters");
                if (parameters != null) {
                    Iterator it = parameters.elementIterator("parameter");
                    while (it.hasNext()) {
                        String sValue;
                        Element elemValue;
                        Element elemParam = (Element)it.next();
                        String sName = elemParam.attributeValue("name");
                        if (sName == null || sName.length() == 0 || (elemValue = elemParam.element("value")) == null || (sValue = elemValue.getText()) == null || sValue.length() == 0) continue;
                        if (sName.equals("doReportSpecUpgrade")) {
                            DataManager.this.m_bDoReportSpecUpgrade = new Boolean(sValue);
                            continue;
                        }
                        if (!sName.equals("doPromptAgain")) continue;
                        DataManager.this.m_bDoPromptForCMUpgrade = new Boolean(sValue);
                    }
                }
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("CnfgCMUpgradeTask::run() - Reading prompt() response for CM...");
                    CnfgLog.debug("doReportSpecUpgrade is " + DataManager.this.m_bDoReportSpecUpgrade.toString());
                    CnfgLog.debug("doPromptAgain is " + DataManager.this.m_bDoPromptForCMUpgrade.toString());
                }
                File startupFile = DataManager.this.resolveEffectiveFilePath("../configuration/cogstartup.xml");
                BufferedInputStream startupFileStream = new BufferedInputStream(new FileInputStream(startupFile));
                SAXReader reader = new SAXReader();
                Document dom = reader.read((InputStream)startupFileStream);
                Element rootElement = dom.getRootElement();
                boolean bFoundRSUpgradeParm = false;
                if (null != rootElement && rootElement.getName().equals("parameters") && rootElement.getNamespace().equals((Object)StartupProcessor.nsCRN)) {
                    List parameterList = rootElement.elements(StartupProcessor.qnPARAMETER);
                    for (Element parameterElement : parameterList) {
                        String parameterName;
                        if (null == parameterElement || !parameterElement.getNamespace().equals((Object)StartupProcessor.nsCRN) || null == (parameterName = parameterElement.attributeValue("name")) || !parameterName.equals("doReportSpecUpgrade")) continue;
                        DataManager.this.updateUpgradeValue(parameterElement, DataManager.this.m_bDoReportSpecUpgrade.toString());
                        bFoundRSUpgradeParm = true;
                        break;
                    }
                    if (!bFoundRSUpgradeParm) {
                        Element parameterElem = DocumentHelper.createElement((QName)DataManager.this.m_qnParam);
                        Attribute nameAttr = DocumentHelper.createAttribute((Element)parameterElem, (String)"name", (String)"doReportSpecUpgrade");
                        parameterElem.add(nameAttr);
                        DataManager.this.updateUpgradeValue(parameterElem, DataManager.this.m_bDoReportSpecUpgrade.toString());
                        rootElement.add(parameterElem);
                    }
                }
                try {
                    DataManager.this.writeDoc(dom, startupFile, null);
                }
                catch (DataManagerException dme) {
                    CnfgLog.error("DataManager::createCMUpgradeTask() - unable to serialize the prompt responses, e is " + dme.getMessage());
                    feedback.showError("An unexpected error occurred: " + dme.getMessage());
                    return false;
                }
                if (doReportSpecUpgradeParameter != null && bReportSpecUpgradeParameterOriginal != null && !bReportSpecUpgradeParameterOriginal.equals(DataManager.this.m_bDoReportSpecUpgrade)) {
                    boolean b = DataManager.getInstance().isConfigDirty();
                    doReportSpecUpgradeParameter.setValue(DataManager.this.m_bDoReportSpecUpgrade);
                    DataManager.getInstance().setConfigDirtyFlag(b);
                }
            }
            return true;
        }

        @Override
        public boolean isMandatory() {
            return true;
        }
    }

    class SmartXMLWriter
    extends XMLWriter {
        boolean m_wrapComments;
        String m_headerComment;

        SmartXMLWriter(Writer os, OutputFormat of, boolean wrapComments, String headerComment) {
            super(os, of);
            this.m_wrapComments = wrapComments;
            this.m_headerComment = headerComment;
        }

        protected void writeElement(Element arg0) throws IOException {
            if (arg0.isRootElement() && this.m_headerComment != null) {
                this.writer.write("<!-- ");
                this.writer.write(this.m_headerComment);
                this.writer.write(" -->");
            }
            super.writeElement(arg0);
        }

        protected void writeComment(String arg0) throws IOException {
            this.println();
            this.indent();
            this.writer.write("<!-- ");
            if (this.m_wrapComments) {
                StringBuffer sb = new StringBuffer();
                StringTokenizer tokens = new StringTokenizer(arg0, " ");
                while (tokens.hasMoreTokens()) {
                    String szWord = tokens.nextToken().trim();
                    if (sb.length() > 80) {
                        this.writer.write(sb.toString());
                        this.println();
                        this.indent();
                        this.writer.write("     ");
                        sb = new StringBuffer();
                    }
                    sb.append(szWord);
                    sb.append(" ");
                }
                this.writer.write(sb.toString());
            } else {
                this.writer.write(arg0);
            }
            this.writer.write(" -->");
        }
    }

    class WizardContent {
        String m_sName;
        String m_sLabel;
        String m_sStyle;
        String m_sMode;
        String m_sHelpFileName;
        String m_sPanelClassName;
        List<WizardData> m_lWizardPagesList;
        boolean m_bHasWizParams = false;

        WizardContent(String name, String label, String style, List<WizardData> lWizardPages, boolean hasWizParams, String sHelpFileName) {
            this.m_sName = name;
            this.m_sLabel = label;
            this.m_sStyle = style;
            this.m_sHelpFileName = sHelpFileName;
            this.m_lWizardPagesList = lWizardPages;
            this.m_bHasWizParams = hasWizParams;
            this.m_sMode = "";
            this.m_sPanelClassName = "";
        }

        public List<WizardData> getWizardList() {
            return this.m_lWizardPagesList;
        }

        public String getWizardLabel() {
            return this.m_sLabel;
        }

        public String getWizardHelpFileName() {
            return this.m_sHelpFileName;
        }

        public String getWizardStyle() {
            return this.m_sStyle;
        }

        public boolean hasParams() {
            return this.m_bHasWizParams;
        }

        public void setWizMode(String mode) {
            this.m_sMode = mode;
        }

        public void setPanelClass(String panelName) {
            this.m_sPanelClassName = panelName;
        }

        public String getPanelClass() {
            return this.m_sPanelClassName;
        }

        public boolean isContextualWizard() {
            return this.m_sMode != null && this.m_sMode.equalsIgnoreCase("config_context");
        }
    }

    public class TestClassLoader
    extends URLClassLoader {
        public TestClassLoader(URL[] urls) {
            super(urls);
        }

        public void addURLs(URL[] urls) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                this.addURL(url);
            }
        }
    }
}

