/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.ExternalProcessException;
import com.cognos.crconfig.data.Parameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class ExternalProcess {
    private String m_sProcessName;
    private String[] m_argsArray;
    private StringBuffer m_sbInputMsg = new StringBuffer();
    private StringBuffer m_sbErrorMsg = new StringBuffer();
    private Integer m_maxTries;
    private Integer m_waitInterval;
    public static final int SUCCESS = 0;
    public static final int FAILED = -1;

    public ExternalProcess(String sProcessName, String[] args) {
        Integer iWaitInterval = (Integer)CnfgPreferences.getInstance().getProperty("ExternalProcessWaitInterval", "500", Integer.class);
        Integer iMaxTries = (Integer)CnfgPreferences.getInstance().getProperty("ExternalProcessMaxTries", "3600", Integer.class);
        this.commonInit(sProcessName, args, iWaitInterval, iMaxTries);
    }

    public ExternalProcess(String sProcessName, String[] args, Integer iWaitInterval, Integer iMaxTries) {
        if (CnfgUtils.isWindowsPlatform()) {
            String[] procArgs = new String[args.length + 4];
            procArgs[0] = "cmd";
            procArgs[1] = "/c";
            procArgs[2] = "\"";
            int idx = 2;
            String[] stringArray = args;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String arg;
                procArgs[idx + 1] = arg = stringArray[i];
                ++idx;
            }
            procArgs[idx + 1] = "\"";
            this.commonInit(procArgs[0], procArgs, iWaitInterval, iMaxTries);
        } else {
            this.commonInit(sProcessName, args, iWaitInterval, iMaxTries);
        }
    }

    private void commonInit(String sProcessName, String[] args, Integer iWaitInterval, Integer iMaxTries) {
        this.m_sProcessName = sProcessName;
        this.m_argsArray = args;
        this.m_waitInterval = iWaitInterval;
        this.m_maxTries = iMaxTries;
    }

    public static String[] resolveArguments(HashMap<?, ?> arguments, ArrayList<?> paramList, HashMap<?, ?> valueMap, String context) {
        String[] argsArray = null;
        ArrayList<String> argsList = new ArrayList<String>();
        for (int index = 0; index < arguments.size(); ++index) {
            Integer iIndex = new Integer(index);
            Object[] arg = (Object[])arguments.get(iIndex);
            if (((String)arg[0]).length() > 0) {
                argsList.add((String)arg[0]);
                continue;
            }
            String sReference = (String)arg[1];
            if (sReference.length() == 0) continue;
            Parameter p = null;
            for (int j = 0; j < paramList.size(); ++j) {
                Parameter param = (Parameter)paramList.get(j);
                if (!param.getName().equals(sReference)) continue;
                p = param;
                break;
            }
            if (p == null) {
                p = context != null && context.length() > 0 ? DataManager.getInstance().findParm(sReference, context) : DataManager.getInstance().findParm(sReference);
            }
            if (p == null) continue;
            Object oValue = p.getValue();
            String sValue = oValue == null ? "" : oValue.toString();
            HashMap map = (HashMap)valueMap.get(iIndex);
            if (map != null) {
                String sMappedValue = (String)map.get(sValue);
                sValue = sMappedValue != null ? sMappedValue : "";
            }
            argsList.add(sValue);
        }
        argsArray = new String[argsList.size() + 1];
        for (int i = 0; i < argsList.size(); ++i) {
            argsArray[i + 1] = (String)argsList.get(i);
        }
        return argsArray;
    }

    private boolean readFromStream(InputStream input, StringBuffer msgBuffer) throws IOException {
        byte[] b = new byte[1024];
        boolean result = false;
        while (input.available() > 0) {
            int r = input.read(b);
            if (r <= 0) continue;
            String str = new String(b, 0, r);
            msgBuffer.append(str);
            result = true;
        }
        return result;
    }

    public int executeExternalProcess() throws ExternalProcessException, InterruptedException {
        return this.executeExternalProcess(CnfgUtils.getEnv());
    }

    public int executeExternalProcess(String[] env) throws ExternalProcessException, InterruptedException {
        Process process = null;
        int retVal = 0;
        try {
            this.m_argsArray[0] = this.m_sProcessName;
            process = Runtime.getRuntime().exec(this.m_argsArray, env);
            if (CnfgLog.isDebugEnabled()) {
                StringBuffer cmdLine = new StringBuffer(1024);
                for (int j = 0; j < this.m_argsArray.length; ++j) {
                    if (-1 != this.m_argsArray[j].indexOf(32)) {
                        cmdLine.append('\"').append(this.m_argsArray[j]).append('\"');
                    } else {
                        cmdLine.append(this.m_argsArray[j]);
                    }
                    if (j >= this.m_argsArray.length - 1) continue;
                    cmdLine.append(" ");
                }
                CnfgLog.debug("Process (" + process.toString() + ") executing : " + cmdLine + ". maxTries = " + this.m_maxTries + ". waitInterval = " + this.m_waitInterval + " ms.");
            }
            InputStream input = process.getInputStream();
            InputStream error = process.getErrorStream();
            boolean alive = true;
            boolean incrementTries = false;
            int tries = 0;
            while (alive && tries < this.m_maxTries) {
                block41: {
                    try {
                        retVal = process.exitValue();
                        alive = false;
                    }
                    catch (IllegalThreadStateException e) {
                        if (!CnfgLog.isDebugEnabled()) break block41;
                        CnfgLog.debug("No response from the process (" + process.toString() + ") , so keep polling. This is attempt # " + tries);
                    }
                }
                incrementTries = false;
                if (input.available() > 0) {
                    if (this.readFromStream(input, this.m_sbInputMsg)) {
                        tries = 0;
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("Received output from stdout from the process (" + process.toString() + "). Resetting the tries.");
                        }
                    }
                } else {
                    incrementTries = true;
                }
                if (error.available() > 0) {
                    if (this.readFromStream(error, this.m_sbErrorMsg)) {
                        tries = 0;
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("Received output from stderr from the process (" + process.toString() + "). Resetting the tries.");
                        }
                    }
                } else {
                    incrementTries = true;
                }
                if (incrementTries) {
                    ++tries;
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("No activity on stdout or stderr from the process (" + process.toString() + "). Incrementing tries.");
                    }
                }
                if (!alive) {
                    if (!CnfgLog.isDebugEnabled()) break;
                    CnfgLog.debug("Process (" + process.toString() + ") is done, retval = " + retVal + ", number of tries = " + tries);
                    break;
                }
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("Sleeping " + this.m_waitInterval.longValue() + ". Process: " + process.toString());
                }
                Thread.sleep(this.m_waitInterval.longValue());
            }
            if (tries >= this.m_maxTries) {
                Object[] args = new String[]{this.m_sProcessName};
                String sMessage = CnfgResource.getMessage("Message.extps.timeout.notification", args);
                CnfgLog.error(sMessage);
                throw new ExternalProcessException(sMessage);
            }
        }
        catch (InterruptedException ie) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug(ie);
            }
            if (process != null) {
                process.destroy();
            }
            throw ie;
        }
        catch (IOException e) {
            CnfgLog.error(e);
            Object[] args = new String[]{this.m_sProcessName, e.getLocalizedMessage()};
            String sMessage = CnfgResource.getMessage("Message.extps.ioexception.notification", args);
            throw new ExternalProcessException(sMessage, e);
        }
        finally {
            block45: {
                if (null != process) {
                    block44: {
                        block43: {
                            try {
                                process.getOutputStream().close();
                            }
                            catch (IOException e) {
                                if (!CnfgLog.isDebugEnabled()) break block43;
                                CnfgLog.debug("Exception occurred while closing input stream of Process (" + process.toString() + ").");
                            }
                        }
                        try {
                            process.getInputStream().close();
                        }
                        catch (IOException e) {
                            if (!CnfgLog.isDebugEnabled()) break block44;
                            CnfgLog.debug("Exception occurred while closing output stream of Process (" + process.toString() + ").");
                        }
                    }
                    try {
                        process.getErrorStream().close();
                    }
                    catch (IOException e) {
                        if (!CnfgLog.isDebugEnabled()) break block45;
                        CnfgLog.debug("Exception occurred while closing error stream of Process (" + process.toString() + ").");
                    }
                }
            }
        }
        return retVal;
    }

    public String getErrorMsg() {
        return this.m_sbInputMsg.toString() + this.m_sbErrorMsg.toString();
    }
}

