/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.StringParameter;

public class FileURIParameter
extends StringParameter {
    public FileURIParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    @Override
    public boolean validate(String sValue) {
        boolean bRetValue = false;
        if (super.validate(sValue)) {
            String sFileURIFormat;
            if (sValue.length() == 0) {
                bRetValue = true;
            } else if (sValue.length() >= 7 && (sFileURIFormat = sValue.substring(0, 7)).compareToIgnoreCase("file://") == 0) {
                bRetValue = true;
            }
        } else {
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.info"));
            return bRetValue;
        }
        if (!bRetValue) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("FileURIParameter::validate(" + sValue + "), is not an acceptable FileURI.");
            }
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.uri.fileFormatInvalid"));
        }
        return bRetValue;
    }
}

