/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.Container;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Option;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.service.BootstrapServiceFolder;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Comment;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;

public class Folder
extends Container {
    protected String m_icon = null;
    private boolean m_bOpaque;
    private boolean m_bGlobal = false;

    public Folder() {
    }

    public Folder(String s) {
        this.m_sLabel = s;
    }

    public String getIcon() {
        if (this.m_icon == null) {
            this.m_icon = this.isInstanceFolder() ? "resource" : (this.getOpaque() ? "component" : "group");
        }
        return this.m_icon;
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        String sOpaque;
        boolean bSuccess = super.load(parentFolder, elem);
        if (!bSuccess) {
            return false;
        }
        this.m_sName = elem.attributeValue("name", "");
        if (this.m_parentFolder != null) {
            this.m_bOpaque = this.m_parentFolder.getOpaque();
        }
        if ((sOpaque = elem.attributeValue("opaque", "false")).equalsIgnoreCase("true")) {
            this.m_bOpaque = true;
        }
        this.loadCommon(this, elem);
        List lFolderElems = elem.elements("section");
        for (int j = 0; j < lFolderElems.size(); ++j) {
            Folder folder;
            Element child_f_elem = (Element)lFolderElems.get(j);
            String sMode = child_f_elem.attributeValue("mode", "");
            String sServiceName = child_f_elem.attributeValue("service", "");
            if (sServiceName.length() > 0) {
                String unregOnDelete = child_f_elem.attributeValue("unregisterOnDelete", "");
                String sServiceType = child_f_elem.attributeValue("serviceType", "");
                folder = sServiceType != null && sServiceType.equalsIgnoreCase("CBS") ? new BootstrapServiceFolder(sServiceName, Boolean.parseBoolean(unregOnDelete), "") : new ServiceFolder(sServiceName, Boolean.parseBoolean(unregOnDelete));
            } else {
                folder = new Folder();
            }
            if (!folder.load(this, child_f_elem)) continue;
            if (sMode.equalsIgnoreCase("global")) {
                folder.m_bGlobal = true;
                DataManager.getInstance().addGlobalConfigFolders(folder);
            } else {
                this.m_lFolders.add(folder);
            }
            if (!(folder instanceof ServiceFolder) || folder.getDisabled()) continue;
            ServiceManager.addListener((ServiceFolder)folder);
        }
        if (0 == this.countFolders(true) + this.countParameters(true) + this.countTemplatedParameters(true)) {
            this.setVisibility(false);
        }
        return this.m_lFolders.size() != 0 || this.m_lParms.size() != 0 || this.m_lTParms.size() != 0;
    }

    public void setParameters(List<Parameter> list) {
        this.m_lParms = list;
        for (int j = 0; j < this.m_lParms.size(); ++j) {
            Parameter p1 = (Parameter)this.m_lParms.get(j);
            p1.setParent(this);
        }
    }

    public void addParameter(Parameter toAdd) {
        for (int i = 0; i < this.m_lParms.size(); ++i) {
            Parameter current = (Parameter)this.m_lParms.get(i);
            if (!current.getName().equalsIgnoreCase(toAdd.getName()) || !current.getDataType().equals(toAdd.getDataType())) continue;
            this.m_lParms.remove(i);
            this.m_lParms.add(i, toAdd);
            return;
        }
        this.m_lParms.add(toAdd);
    }

    public void setTParameters(ArrayList<TemplatedParameter> list) {
        this.m_lTParms = list;
        for (int j = 0; j < this.m_lTParms.size(); ++j) {
            TemplatedParameter tp = (TemplatedParameter)this.m_lTParms.get(j);
            tp.setParent(this);
        }
    }

    public Parameter findWizardParm(String sSearchPath) {
        String currentPath = null;
        String subPath = null;
        String sName = null;
        int firstSlash = sSearchPath.indexOf("/");
        if (firstSlash != -1) {
            if (!sSearchPath.startsWith("//") && !(currentPath = sSearchPath.substring(0, firstSlash)).equals(this.getName())) {
                return null;
            }
            int doubleSlash = sSearchPath.indexOf("//", firstSlash);
            if (doubleSlash != -1) {
                sName = sSearchPath.substring(doubleSlash + 2);
                subPath = doubleSlash == 0 ? sSearchPath : (firstSlash == doubleSlash ? sSearchPath.substring(firstSlash) : sSearchPath.substring(firstSlash + 1));
            }
        } else {
            sName = sSearchPath;
            subPath = sSearchPath;
        }
        for (int j = 0; j < this.m_lParms.size(); ++j) {
            Parameter p1 = (Parameter)this.m_lParms.get(j);
            if (!p1.getName().equals(sName)) continue;
            return p1;
        }
        TemplatedParameter tp = this.findTParm(sName);
        if (tp != null) {
            return tp;
        }
        for (int k = 0; k < this.m_lFolders.size(); ++k) {
            Folder f = (Folder)this.m_lFolders.get(k);
            Parameter p2 = f.findWizardParm(subPath);
            if (p2 == null) continue;
            return p2;
        }
        return null;
    }

    public Parameter findParm(String sName) {
        for (int j = 0; j < this.m_lParms.size(); ++j) {
            Parameter p1 = (Parameter)this.m_lParms.get(j);
            if (!p1.getName().equals(sName)) continue;
            return p1;
        }
        for (int k = 0; k < this.m_lFolders.size(); ++k) {
            Folder f = (Folder)this.m_lFolders.get(k);
            Parameter p2 = f.findParm(sName);
            if (p2 == null || !p2.getName().equals(sName)) continue;
            return p2;
        }
        return null;
    }

    public Parameter findParm(String sName, String context) {
        for (int j = 0; j < this.m_lParms.size(); ++j) {
            Parameter p1 = (Parameter)this.m_lParms.get(j);
            if (!p1.getName().equals(sName) || !this.getName().equals(context)) continue;
            return p1;
        }
        for (int k = 0; k < this.m_lFolders.size(); ++k) {
            Folder f = (Folder)this.m_lFolders.get(k);
            Parameter p2 = f.findParm(sName, context);
            if (p2 == null || !p2.getName().equals(sName)) continue;
            return p2;
        }
        return null;
    }

    public Parameter findParm(Parameter p) {
        if (null != p) {
            return this.findParm(p.getName());
        }
        return null;
    }

    public TemplatedParameter findTParm(String sName) {
        for (int n = 0; n < this.m_lTParms.size(); ++n) {
            TemplatedParameter tp = (TemplatedParameter)this.m_lTParms.get(n);
            if (!tp.getName().equals(sName)) continue;
            return tp;
        }
        return null;
    }

    public Folder findFolder(String sName, boolean bRecurse) {
        Folder f;
        int i;
        for (i = 0; i < this.m_lFolders.size(); ++i) {
            f = (Folder)this.m_lFolders.get(i);
            if (!f.getName().equals(sName)) continue;
            return f;
        }
        if (bRecurse) {
            for (i = 0; i < this.m_lFolders.size(); ++i) {
                f = (Folder)this.m_lFolders.get(i);
                Folder foundFolder = f.findFolder(sName, bRecurse);
                if (foundFolder == null) continue;
                return foundFolder;
            }
        }
        return null;
    }

    public List<ServiceFolder> getServiceFolders(boolean bRecurse) {
        ArrayList<ServiceFolder> list = new ArrayList<ServiceFolder>();
        for (Folder f : this.m_lFolders) {
            if (!(f instanceof ServiceFolder)) continue;
            list.add((ServiceFolder)f);
        }
        if (bRecurse) {
            for (Folder f : this.m_lFolders) {
                List<ServiceFolder> children = f.getServiceFolders(bRecurse);
                list.addAll(children);
            }
        }
        return list;
    }

    public Folder findComplexFolder(String sName, boolean bRecurse) {
        Folder f;
        int i;
        for (i = 0; i < this.m_lFolders.size(); ++i) {
            f = (Folder)this.m_lFolders.get(i);
            if (!f.getName().equals(sName) || !f.getOpaque()) continue;
            return f;
        }
        if (bRecurse) {
            for (i = 0; i < this.m_lFolders.size(); ++i) {
                f = (Folder)this.m_lFolders.get(i);
                Folder foundFolder = f.findComplexFolder(sName, bRecurse);
                if (foundFolder == null) continue;
                return foundFolder;
            }
        }
        return null;
    }

    public boolean getOpaque() {
        return this.m_bOpaque;
    }

    public void checkMinOccurs(List<String> errors) throws DataManagerException {
        int i;
        if (this.hasTemplates()) {
            for (i = 0; i < this.m_lTParms.size(); ++i) {
                TemplatedParameter tp = (TemplatedParameter)this.m_lTParms.get(i);
                if (tp.getDisabled() || !tp.getVisibility()) continue;
                Hashtable<Option, Integer> currentCountByOption = new Hashtable<Option, Integer>();
                int totalCount = 0;
                for (int j = 0; j < tp.getOptions().size(); ++j) {
                    Option option = tp.getOptions().get(j);
                    if (option.getDisabled() && !option.getVisibility()) continue;
                    Integer currentCount = this.numInstanceFolders(option.getName());
                    currentCountByOption.put(option, currentCount);
                    totalCount += currentCount.intValue();
                }
                Integer parmMnO = tp.getParameter().getMinOccurs();
                if (parmMnO != -1 && totalCount < parmMnO) {
                    Object[] args = new Object[]{parmMnO, tp.getLabel(), this.getLabel()};
                    String sMessage = CnfgResource.getMessage("Message.errorOnSave.minOccursParameter.resolution", args);
                    if (errors != null) {
                        errors.add(sMessage);
                    } else {
                        throw new DataManagerException(sMessage);
                    }
                }
                Set s = currentCountByOption.keySet();
                for (Option opt : s) {
                    Integer optionMin = opt.getMinOccurs();
                    if (optionMin == -1) continue;
                    Integer currCount = (Integer)currentCountByOption.get(opt);
                    if (optionMin <= currCount) continue;
                    Object[] args = new Object[]{optionMin, tp.getLabel(), opt.getLabel(), this.getLabel()};
                    String sMessage = CnfgResource.getMessage("Message.errorOnSave.minOccursInstance.resolution", args);
                    if (errors != null) {
                        errors.add(sMessage);
                        continue;
                    }
                    throw new DataManagerException(sMessage);
                }
            }
        }
        for (i = 0; i < this.m_lFolders.size(); ++i) {
            Folder f = (Folder)this.m_lFolders.get(i);
            if (f.getDisabled() || !f.getVisibility()) continue;
            f.checkMinOccurs(errors);
        }
    }

    public TemplatedParameter getTemplatedParameter() {
        for (int j = 0; j < this.m_lParms.size(); ++j) {
            if (((Parameter)this.m_lParms.get(j)).getClass() != TemplatedParameter.class) continue;
            return (TemplatedParameter)this.m_lParms.get(j);
        }
        return null;
    }

    public boolean isInstanceFolder() {
        return this.getTemplatedParameter() != null;
    }

    public boolean hasTemplates() {
        return !this.m_lTParms.isEmpty();
    }

    public List<TemplatedParameter> getAvailableTemplates() {
        ArrayList<TemplatedParameter> al = new ArrayList<TemplatedParameter>();
        for (int i = 0; i < this.m_lTParms.size(); ++i) {
            List<Option> options;
            TemplatedParameter tp = (TemplatedParameter)this.m_lTParms.get(i);
            if (null == tp || tp.getDisabled() || !tp.getVisibility() || (options = tp.getAvailableOptions(true)).isEmpty()) continue;
            al.add(tp);
        }
        return al;
    }

    public Integer numInstanceFolders(String type) {
        int count = 0;
        for (int k = 0; k < this.m_lFolders.size(); ++k) {
            TemplatedParameter tp;
            Folder f = (Folder)this.m_lFolders.get(k);
            if (null == f || f.getDisabled() || !f.getVisibility() || (tp = f.getTemplatedParameter()) == null || tp.getDisabled() || !tp.getVisibility() || !tp.getValue().toString().equals(type)) continue;
            ++count;
        }
        return new Integer(count);
    }

    public boolean remove(Folder childFolder) {
        for (int k = 0; k < this.m_lFolders.size(); ++k) {
            Folder f = (Folder)this.m_lFolders.get(k);
            if (!f.getName().equals(childFolder.getName())) continue;
            this.m_lFolders.remove(childFolder);
            return true;
        }
        return false;
    }

    public void addFolder(Folder childFolder) {
        for (int k = 0; k < this.m_lFolders.size(); ++k) {
            Folder f = (Folder)this.m_lFolders.get(k);
            if (!f.getName().equals(childFolder.getName())) continue;
            return;
        }
        this.m_lFolders.add(childFolder);
    }

    public void setToDefault() {
        for (Parameter p : this.m_lParms) {
            p.setToDefault();
        }
        for (Folder f : this.m_lFolders) {
            f.setToDefault();
        }
        CnfgValueChangedEvent vce = new CnfgValueChangedEvent(this);
        DataManager.getInstance().fireValueChanged(vce);
    }

    public boolean hasResetableToDefault() {
        boolean hasResetableToDefault = false;
        for (Parameter p : this.m_lParms) {
            hasResetableToDefault |= p.hasDefault() && !p.isDefault();
        }
        for (Folder f : this.m_lFolders) {
            hasResetableToDefault |= f.hasResetableToDefault();
        }
        return hasResetableToDefault;
    }

    public Folder addInstanceFolder(TemplatedParameter tp, String sOptionValue, String sInstName, String sInstLabel) {
        Folder newFolder = null;
        Option option = tp.getOption(sOptionValue);
        if (option != null) {
            ArrayList<String> tmpList;
            if (tp.isServiceFolder(option)) {
                newFolder = tp.getServiceType().equalsIgnoreCase("CBS") ? new BootstrapServiceFolder(tp.getServiceName(), tp.getUnregisterOnDelete(), option.getName()) : new ServiceFolder(tp.getServiceName(), tp.getUnregisterOnDelete());
                ServiceManager.addListener((ServiceFolder)newFolder);
                DataManager.getInstance().addCnfgNodeRenamedListener((ServiceFolder)newFolder);
            } else {
                newFolder = new Folder();
            }
            newFolder.setName(sInstName);
            newFolder.setLabel(sInstLabel);
            newFolder.setDesc(option.getDesc());
            newFolder.setHelp(option.getHelp());
            newFolder.setDoclink(option.getDocLink());
            newFolder.setParent(this);
            List<Parameter> parms = tp.cloneParms(sOptionValue);
            newFolder.setParameters(parms);
            ArrayList<TemplatedParameter> tplist = option.cloneTParms();
            newFolder.setTParameters(tplist);
            if (tp.getParameter() != null && (tmpList = tp.getParameter().getRestartServicesList()) != null && tmpList.size() > 0) {
                ArrayList<String> lRestartServices = new ArrayList<String>();
                lRestartServices.addAll(tmpList);
                newFolder.setRestartServicesList(lRestartServices);
            }
            ArrayList<CnfgActionOld> lActions = new ArrayList<CnfgActionOld>();
            if (option.getActions().size() > 0) {
                ArrayList<CnfgActionOld> list = option.getActions();
                Iterator<CnfgActionOld> i = list.iterator();
                CnfgActionOld newAction = null;
                while (i.hasNext()) {
                    CnfgActionOld action = i.next();
                    try {
                        newAction = (CnfgActionOld)action.clone();
                    }
                    catch (CloneNotSupportedException cnse) {
                        newAction = action;
                    }
                    newAction.setContext(sInstName);
                    lActions.add(newAction);
                }
            }
            if (tp.getActions().size() > 0) {
                lActions.addAll(tp.getActions());
            }
            newFolder.setActions(lActions);
            newFolder.m_testActions = option.m_testActions;
            if (newFolder instanceof ServiceFolder) {
                ((ServiceFolder)newFolder).findRunningActions();
            }
            newFolder.setDisabled(tp.getDisabled() || option.getDisabled());
            newFolder.setVisibility(tp.getVisibility() || option.getVisibility());
            this.m_lFolders.add(newFolder);
        }
        return newFolder;
    }

    public void resetActionContext() {
        ArrayList<CnfgActionOld> list = this.getActions();
        if (list.size() > 0) {
            for (CnfgActionOld action : list) {
                String name = this.getName();
                action.setContext(name);
            }
        }
    }

    @Override
    public void serialize(Element current_element, boolean bEncrypt, List errors, boolean bIncludeDoc, boolean excludeDisabledAndInvisibleItems) throws DataManagerException {
        if (!this.getDisabled() && this.getVisibility() || !excludeDisabledAndInvisibleItems) {
            Attribute disabledAttr;
            Comment comment;
            StringBuffer sb;
            Element next_element = null;
            TemplatedParameter tp = this.getTemplatedParameter();
            if (tp == null) {
                if (!this.getOpaque()) {
                    next_element = current_element;
                } else {
                    Element parameter_elem = DocumentHelper.createElement((QName)DataManager.getInstance().m_qnParam);
                    Attribute name_attrib = DocumentHelper.createAttribute((Element)parameter_elem, (String)"name", (String)this.getName());
                    parameter_elem.add(name_attrib);
                    Attribute opaque_attrib = DocumentHelper.createAttribute((Element)parameter_elem, (String)"opaque", (String)"true");
                    parameter_elem.add(opaque_attrib);
                    Element value_elem = DocumentHelper.createElement((QName)DataManager.getInstance().m_qnValue);
                    parameter_elem.add(value_elem);
                    if (bIncludeDoc && null != this.m_sDesc) {
                        sb = new StringBuffer();
                        if (CnfgUtils.escapeXMLComment(sb.append(this.m_sName).append(": ").append(this.m_sDesc))) {
                            sb.append(" ").append(CnfgResource.getMessage("Message.saveConfig.modifiedXMLComment"));
                        }
                        comment = DocumentHelper.createComment((String)sb.toString());
                        current_element.add(comment);
                    }
                    if (bIncludeDoc && null != this.m_sHelp) {
                        sb = new StringBuffer();
                        if (CnfgUtils.escapeXMLComment(sb.append(this.m_sHelp))) {
                            sb.append(" ").append(CnfgResource.getMessage("Message.saveConfig.modifiedXMLComment"));
                        }
                        comment = DocumentHelper.createComment((String)sb.toString());
                        current_element.add(comment);
                    }
                    if (this.getDisabled()) {
                        disabledAttr = DocumentHelper.createAttribute((Element)parameter_elem, (String)"disabled", (String)"true");
                        parameter_elem.add(disabledAttr);
                    }
                    current_element.add(parameter_elem);
                    next_element = value_elem;
                }
            } else {
                Comment comment2;
                StringBuffer sb2;
                String sXpathStmt = "*[local-name()='instances' and namespace-uri()='" + DataManager.getInstance().m_nsCfg.getURI() + "' and @" + "name" + "='" + tp.getName() + "']";
                Node foundNode = current_element.selectSingleNode(sXpathStmt);
                Element instances_elem = null;
                if (foundNode == null) {
                    instances_elem = DocumentHelper.createElement((QName)DataManager.getInstance().m_qnInstances);
                    Attribute att_instances_name = DocumentHelper.createAttribute((Element)instances_elem, (String)"name", (String)tp.getName());
                    instances_elem.add(att_instances_name);
                    if (bIncludeDoc && null != tp.getDesc()) {
                        sb = new StringBuffer();
                        if (CnfgUtils.escapeXMLComment(sb.append(tp.getName()).append(": ").append(tp.getDesc()))) {
                            sb.append(" ").append(CnfgResource.getMessage("Message.saveConfig.modifiedXMLComment"));
                        }
                        comment = DocumentHelper.createComment((String)sb.toString());
                        current_element.add(comment);
                    }
                    if (bIncludeDoc && null != tp.getHelp()) {
                        sb = new StringBuffer();
                        if (CnfgUtils.escapeXMLComment(sb.append(tp.getHelp()))) {
                            sb.append(" ").append(CnfgResource.getMessage("Message.saveConfig.modifiedXMLComment"));
                        }
                        comment = DocumentHelper.createComment((String)sb.toString());
                        current_element.add(comment);
                    }
                    if (tp.getDisabled()) {
                        disabledAttr = DocumentHelper.createAttribute((Element)instances_elem, (String)"disabled", (String)"true");
                        instances_elem.add(disabledAttr);
                    }
                    current_element.add(instances_elem);
                } else {
                    instances_elem = (Element)foundNode;
                }
                Element instance_elem = DocumentHelper.createElement((QName)DataManager.getInstance().m_qnInstance);
                Attribute att_label = DocumentHelper.createAttribute((Element)instance_elem, (String)"name", (String)this.getName());
                instance_elem.add(att_label);
                Attribute att_class = DocumentHelper.createAttribute((Element)instance_elem, (String)"class", (String)tp.getValue().toString());
                instance_elem.add(att_class);
                if (bIncludeDoc && null != this.m_sDesc) {
                    sb2 = new StringBuffer();
                    if (CnfgUtils.escapeXMLComment(sb2.append(this.m_sName).append(": ").append(this.m_sDesc))) {
                        sb2.append(" ").append(CnfgResource.getMessage("Message.saveConfig.modifiedXMLComment"));
                    }
                    comment2 = DocumentHelper.createComment((String)sb2.toString());
                    instances_elem.add(comment2);
                }
                if (bIncludeDoc && null != this.m_sHelp) {
                    sb2 = new StringBuffer();
                    if (CnfgUtils.escapeXMLComment(sb2.append(this.m_sHelp))) {
                        sb2.append(" ").append(CnfgResource.getMessage("Message.saveConfig.modifiedXMLComment"));
                    }
                    comment2 = DocumentHelper.createComment((String)sb2.toString());
                    instances_elem.add(comment2);
                }
                if (this.getDisabled()) {
                    Attribute disabledAttr2 = DocumentHelper.createAttribute((Element)instance_elem, (String)"disabled", (String)"true");
                    instance_elem.add(disabledAttr2);
                }
                instances_elem.add(instance_elem);
                next_element = instance_elem;
            }
            for (int j = 0; j < this.m_lParms.size(); ++j) {
                Parameter parameter = (Parameter)this.m_lParms.get(j);
                parameter.serialize(next_element, bEncrypt, errors, bIncludeDoc, excludeDisabledAndInvisibleItems);
            }
            for (int k = 0; k < this.m_lFolders.size(); ++k) {
                Folder childFolder = (Folder)this.m_lFolders.get(k);
                childFolder.serialize(next_element, bEncrypt, errors, bIncludeDoc, excludeDisabledAndInvisibleItems);
            }
        }
    }

    public boolean isGlobal() {
        return this.m_bGlobal;
    }
}

