/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.HostPortParameter;
import com.cognos.crconfig.data.URLParameter;

public class HostPortInstanceParameter
extends HostPortParameter {
    public HostPortInstanceParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    @Override
    public boolean validate(String sValue) {
        int slashIdx = sValue.indexOf("\\");
        if (slashIdx == -1) {
            if (!super.validate(sValue)) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.instanceNameMissing"));
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.hostInstanceName"));
                return false;
            }
        } else if (super.validateString(sValue)) {
            String sServer = sValue.substring(0, slashIdx);
            if (!URLParameter.validateServer(sServer)) {
                Object[] args = new Object[]{sServer};
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.server", args));
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.hostInstanceName"));
                return false;
            }
            int nextIdx = sServer.length() + 1;
            String sInstName = sValue.substring(nextIdx, sValue.length());
            if (!this.validateInstName(sInstName)) {
                Object[] args = new Object[]{sInstName};
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.instanceNameInvalid", args));
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.hostInstanceName"));
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean validateFirstLetter(String sValue) {
        char c = sValue.charAt(0);
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '&' || c == '_' || c == '#') {
            return true;
        }
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("HostPortInstanceParameter::validateLabel(" + sValue + "), '" + c + "' is not an acceptable first <letter>.");
        }
        return false;
    }

    private static boolean validateReservedWords(String sValue) {
        if (sValue.compareToIgnoreCase("default") == 0 || sValue.compareToIgnoreCase("MSSQLServer") == 0) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("HostPortInstanceParameter::validateFirstLetter(" + sValue + "), is not an acceptable Instance Name.");
            }
            return false;
        }
        return true;
    }

    private static boolean validateRestLetters(String sValue) {
        int iLength = sValue.length();
        for (int i = 1; i < iLength; ++i) {
            char c = sValue.charAt(i);
            if (c == '!' || c == ',' || c == '@' || c == ':' || c == '\\' || c == ' ') {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("HostPortInstanceParameter::validateRestLetter(" + sValue + "), '" + c + "' is not an acceptable character.");
                }
                return false;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '$' || c == '#' || c == '_' || !CnfgLog.isDebugEnabled()) continue;
            CnfgLog.debug("HostPortInstanceParameter::validateRestLetter(" + sValue + "), '" + c + "' is not an acceptable character.");
            return false;
        }
        return true;
    }

    public boolean validateInstName(String sInstName) {
        if (sInstName == null || sInstName.length() < 1 || sInstName.length() > 16) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("HostPortInstanceParameter::validateInstName(" + sInstName + "), length is invalid.");
            }
            Object[] args = new Object[]{sInstName};
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.instanceNameInvalid.length", args));
            return false;
        }
        if (HostPortInstanceParameter.validateReservedWords(sInstName)) {
            if (HostPortInstanceParameter.validateFirstLetter(sInstName)) {
                if (HostPortInstanceParameter.validateRestLetters(sInstName)) {
                    return true;
                }
                Object[] args = new Object[]{sInstName};
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.instanceNameInvalid.character", args));
                return false;
            }
            Object[] args = new Object[]{sInstName};
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.instanceNameInvalid.firstLetter", args));
            return false;
        }
        Object[] args = new Object[]{sInstName};
        this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.instanceNameInvalid.reservedWord", args));
        return false;
    }
}

