/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.StringParameter;
import com.cognos.crconfig.data.URLParameter;

public class HostPortParameter
extends StringParameter {
    public HostPortParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    @Override
    public boolean validate(String sValue) {
        if (this.validateString(sValue)) {
            if (!this.isMandatory() && sValue.trim().length() == 0) {
                return true;
            }
            int colonIdx = sValue.lastIndexOf(58);
            if (colonIdx == -1) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.portMissing"));
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.hostPort"));
                return false;
            }
            String sServer = sValue.substring(0, colonIdx);
            if (!URLParameter.validateServer(sServer)) {
                Object[] args = new Object[]{sServer};
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.server", args));
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.hostPort"));
                return false;
            }
            int nextIdx = sServer.length() + 1;
            String sPort = sValue.substring(nextIdx, sValue.length());
            if (!URLParameter.validatePort(sPort)) {
                Object[] args = new Object[]{sPort};
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.portInvalid", args));
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.hostPort"));
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean validateString(String sValue) {
        return super.validate(sValue);
    }

    @Override
    public boolean setValue(Object value) {
        value = value.toString().trim();
        return super.setValue(value);
    }
}

