/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import java.math.BigInteger;
import org.dom4j.Element;

public class IntegerParameter
extends Parameter {
    protected BigInteger m_minInclusive;
    protected BigInteger m_maxInclusive;
    protected BigInteger m_minExclusive;
    protected BigInteger m_maxExclusive;
    private BigInteger m_dtMnVal;
    private BigInteger m_dtMxVal;

    public IntegerParameter(String namespace, String dataType, BigInteger dtMnVal, BigInteger dtMxVal) {
        super(namespace, dataType);
        if (dtMnVal != null) {
            this.m_dtMnVal = dtMnVal;
        }
        if (dtMxVal != null) {
            this.m_dtMxVal = dtMxVal;
        }
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        block29: {
            boolean bSuccess = super.load(parentFolder, elem);
            if (!bSuccess) {
                return false;
            }
            String sMinIncl = elem.attributeValue("minInclusive", "");
            String sMinExcl = elem.attributeValue("minExclusive", "");
            if (sMinIncl.length() != 0) {
                try {
                    this.m_minInclusive = new BigInteger(sMinIncl);
                }
                catch (NumberFormatException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                    this.m_minInclusive = this.m_dtMnVal;
                }
                if (this.m_dtMnVal != null && this.m_dtMxVal != null && (this.m_minInclusive.compareTo(this.m_dtMnVal) < 0 || this.m_minInclusive.compareTo(this.m_dtMxVal) > 0)) {
                    this.m_minInclusive = this.m_dtMnVal;
                }
            } else if (sMinExcl.length() != 0) {
                try {
                    this.m_minExclusive = new BigInteger(sMinExcl);
                }
                catch (NumberFormatException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                    this.m_minExclusive = this.m_dtMnVal;
                }
                if (this.m_dtMnVal != null && this.m_dtMxVal != null && (this.m_minExclusive.compareTo(this.m_dtMnVal) < 0 || this.m_minExclusive.compareTo(this.m_dtMxVal) > 0)) {
                    this.m_minExclusive = this.m_dtMnVal;
                }
            } else {
                this.m_minInclusive = this.m_dtMnVal;
            }
            String sMaxIncl = elem.attributeValue("maxInclusive", "");
            String sMaxExcl = elem.attributeValue("maxExclusive", "");
            if (sMaxIncl.length() != 0) {
                try {
                    this.m_maxInclusive = new BigInteger(sMaxIncl);
                }
                catch (NumberFormatException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                    this.m_maxInclusive = this.m_dtMxVal;
                }
                if (this.m_dtMnVal != null && this.m_dtMxVal != null && (this.m_maxInclusive.compareTo(this.m_dtMnVal) < 0 || this.m_maxInclusive.compareTo(this.m_dtMxVal) > 0)) {
                    this.m_maxInclusive = this.m_dtMxVal;
                }
            } else if (sMaxExcl.length() != 0) {
                try {
                    this.m_maxExclusive = new BigInteger(sMaxExcl);
                }
                catch (NumberFormatException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                    this.m_maxExclusive = this.m_dtMxVal;
                }
                if (this.m_dtMnVal != null && this.m_dtMxVal != null && (this.m_maxExclusive.compareTo(this.m_dtMnVal) < 0 || this.m_maxExclusive.compareTo(this.m_dtMxVal) > 0)) {
                    this.m_maxExclusive = this.m_dtMxVal;
                }
            } else {
                this.m_maxInclusive = this.m_dtMxVal;
            }
            try {
                String sDefaultValue = elem.attributeValue("default", "");
                if (sDefaultValue.length() != 0) {
                    this.m_defaultValue = new BigInteger(sDefaultValue);
                    if (!this.validate(this.m_defaultValue.toString())) {
                        this.m_defaultValue = null;
                    }
                }
            }
            catch (NumberFormatException e) {
                if (!CnfgLog.isDebugEnabled()) break block29;
                CnfgLog.debug(e);
            }
        }
        return true;
    }

    @Override
    public boolean setValue(Object value) {
        this.clearErrorMsg();
        BigInteger biValue = null;
        String sValue = null;
        if (value.getClass() == String.class || value.getClass() == Integer.class) {
            sValue = value.toString().trim();
            try {
                biValue = new BigInteger(sValue);
            }
            catch (NumberFormatException e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("IntegerParameter::setValue - input value is : '" + sValue + "'.  Exception : " + e);
                }
                Object[] args = new Object[]{this.getMin(), this.getMax()};
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.range", args));
                this.m_sBadValue = sValue;
                return false;
            }
        } else if (value.getClass() == BigInteger.class) {
            sValue = value.toString();
            biValue = (BigInteger)value;
        } else {
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.dataType"));
            this.m_sBadValue = value.toString();
            return false;
        }
        if (this.validate(sValue)) {
            this.m_currentValue = biValue;
            return super.setValue(value);
        }
        this.m_sBadValue = sValue;
        return false;
    }

    @Override
    public boolean validate(String value) {
        boolean bRetVal = true;
        BigInteger biValue = new BigInteger(value);
        if (biValue.compareTo(this.getMax()) > 0 || biValue.compareTo(this.getMin()) < 0) {
            Object[] args = new Object[]{this.getMin(), this.getMax()};
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.range", args));
            bRetVal = false;
        }
        if (bRetVal) {
            bRetVal = super.validate(value);
        }
        return bRetVal;
    }

    public BigInteger getMinIncl() {
        return this.m_minInclusive;
    }

    public BigInteger getMinExcl() {
        return this.m_minExclusive;
    }

    public BigInteger getMaxIncl() {
        return this.m_maxInclusive;
    }

    public BigInteger getMaxExcl() {
        return this.m_maxExclusive;
    }

    public BigInteger getMin() {
        if (this.m_minInclusive != null) {
            return this.m_minInclusive;
        }
        if (this.m_minExclusive != null) {
            return this.m_minExclusive;
        }
        if (this.m_dtMnVal != null) {
            return this.m_dtMnVal;
        }
        return BigInteger.ZERO;
    }

    public BigInteger getMax() {
        if (this.m_maxInclusive != null) {
            return this.m_maxInclusive;
        }
        if (this.m_maxExclusive != null) {
            return this.m_maxExclusive;
        }
        if (this.m_dtMxVal != null) {
            return this.m_dtMxVal;
        }
        return BigInteger.valueOf(Long.MAX_VALUE);
    }
}

