/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.URLPathParameter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class LocalURLParameter
extends URLPathParameter {
    public static boolean isLocalURL(String sURL) {
        return CnfgDataUtils.validateServerNameAsLocal(LocalURLParameter.getServer(sURL));
    }

    public LocalURLParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    public static String getFullyQualifiedHostName() throws UnknownHostException {
        String hostName = "localhost";
        InetAddress localhost = InetAddress.getLocalHost();
        hostName = localhost.getCanonicalHostName();
        return hostName;
    }

    @Override
    public boolean validate(String sValue) {
        if (!super.validate(sValue)) {
            return false;
        }
        String sServer = LocalURLParameter.getServer(sValue);
        if (sServer == null) {
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.server.local"));
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.server.local.info"));
        }
        if (!CnfgDataUtils.validateServerNameAsLocal(sServer)) {
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.server.local"));
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.server.local.info"));
            return false;
        }
        return true;
    }

    private static String getServer(String sURI) {
        int nextIdx = sURI.indexOf("://") + 3;
        boolean isIPv6 = sURI.charAt(nextIdx) == '[';
        int endIdx = -1;
        if (isIPv6) {
            endIdx = sURI.indexOf("]", nextIdx);
            if (endIdx == -1) {
                return null;
            }
            ++nextIdx;
        } else {
            endIdx = sURI.indexOf(":", nextIdx);
        }
        String sServer = null;
        sServer = isIPv6 ? sURI.substring(nextIdx - 1, endIdx + 1) : sURI.substring(nextIdx, endIdx);
        return sServer;
    }
}

