/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.data.BooleanParameter;
import com.cognos.crconfig.data.Container;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.TemplatedParameter;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class Option
extends Container {
    protected Integer m_minOccurs;
    protected Integer m_maxOccurs;
    private String m_sGroupName = null;
    private boolean m_bGroupOption = false;
    protected String m_sGroupLabel;
    protected String m_sGroupVisibleOn;

    public Option() {
        this.setGroupOption(false);
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        boolean bSuccess = super.load(parentFolder, elem);
        if (!bSuccess) {
            return false;
        }
        this.m_sName = elem.attributeValue("value", "");
        if (this.m_sName != null && this.m_sName.equalsIgnoreCase("Derby")) {
            return false;
        }
        String sGroupName = elem.attributeValue("groupName", "");
        if (sGroupName.length() == 0) {
            this.setGroupName(null);
            this.m_sGroupLabel = "";
        } else {
            this.setGroupName(sGroupName);
            this.m_sGroupLabel = CnfgUIDocResource.getMessage(elem.attributeValue("groupLabel", sGroupName), this.m_sMsgBase);
        }
        String sGroupVisibleOn = elem.attributeValue("groupVisibleOn", "");
        if (sGroupVisibleOn.length() == 0) {
            this.setGroupVisibleOn(null);
        } else {
            this.setGroupVisibleOn(sGroupVisibleOn);
        }
        String sMinOccurs = elem.attributeValue("minOccurs", "");
        boolean bMinInvalid = false;
        if (sMinOccurs.length() != 0) {
            if (sMinOccurs.compareTo("unbounded") == 0) {
                this.m_minOccurs = new Integer(-1);
            } else {
                try {
                    this.m_minOccurs = new Integer(sMinOccurs);
                    if (this.m_minOccurs < 0) {
                        bMinInvalid = true;
                    }
                }
                catch (NumberFormatException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                    bMinInvalid = true;
                }
            }
        } else {
            bMinInvalid = true;
        }
        if (bMinInvalid) {
            this.m_minOccurs = new Integer(1);
        }
        boolean bMaxInvalid = false;
        String sMaxOccurs = elem.attributeValue("maxOccurs", "");
        if (sMaxOccurs.length() != 0) {
            if (sMaxOccurs.compareTo("unbounded") == 0) {
                this.m_maxOccurs = new Integer(-1);
            } else {
                try {
                    this.m_maxOccurs = new Integer(sMaxOccurs);
                    if (this.m_maxOccurs < 0) {
                        bMaxInvalid = true;
                    }
                }
                catch (NumberFormatException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                    bMaxInvalid = true;
                }
            }
        } else {
            bMaxInvalid = true;
        }
        if (bMaxInvalid) {
            this.m_maxOccurs = new Integer(1);
        }
        if (this.m_minOccurs == -1 && this.m_maxOccurs != -1) {
            this.m_minOccurs = new Integer(1);
            this.m_maxOccurs = new Integer(1);
        }
        if (this.m_minOccurs != -1 && this.m_maxOccurs != -1 && (this.m_minOccurs > this.m_maxOccurs || this.m_minOccurs == 0 && this.m_maxOccurs == 0)) {
            this.m_minOccurs = new Integer(1);
            this.m_maxOccurs = new Integer(1);
        }
        this.loadCommon(parentFolder, elem);
        return this.m_lFolders.size() != 0 || this.m_lParms.size() != 0 || this.m_lTParms.size() != 0;
    }

    public ArrayList<TemplatedParameter> cloneTParms() {
        ArrayList<TemplatedParameter> al = new ArrayList<TemplatedParameter>();
        for (int i = 0; i < this.m_lTParms.size(); ++i) {
            TemplatedParameter tp = (TemplatedParameter)this.m_lTParms.get(i);
            TemplatedParameter newTp = (TemplatedParameter)tp.clone();
            al.add(newTp);
        }
        return al;
    }

    public Integer getMaxOccurs() {
        return this.m_maxOccurs;
    }

    public Integer getMinOccurs() {
        return this.m_minOccurs;
    }

    @Override
    public void serialize(Element element, boolean encrypt, List errors, boolean bIncludeDoc, boolean excludeDisabledAndInvisibleItems) throws DataManagerException {
    }

    public void setGroupName(String groupName) {
        this.m_sGroupName = groupName;
    }

    public String getGroupVisibleOn() {
        return this.m_sGroupVisibleOn;
    }

    public void setGroupVisibleOn(String sGroupVisibleOn) {
        this.m_sGroupVisibleOn = sGroupVisibleOn;
    }

    public String getGroupName() {
        return this.m_sGroupName;
    }

    public String getGroupLabel() {
        return this.m_sGroupLabel;
    }

    public boolean isGroupOption() {
        return this.m_bGroupOption;
    }

    public void setGroupOption(boolean isGroup) {
        this.m_bGroupOption = isGroup;
    }

    public boolean isOptionVisible() {
        Object paramVal;
        Parameter param;
        if (this.m_sGroupVisibleOn != null && this.m_sGroupVisibleOn.length() > 0 && (param = DataManager.getInstance().findParam(this.m_sGroupVisibleOn)) != null && BooleanParameter.class.isInstance(param) && (paramVal = param.getValue()) != null) {
            return (Boolean)paramVal;
        }
        return true;
    }
}

