/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUIDocResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.AbstractData;
import com.cognos.crconfig.data.CnfgActionCustomSave;
import com.cognos.crconfig.data.CnfgActionExternalProcess;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgActionTest;
import com.cognos.crconfig.data.CnfgValueChangedEvent;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.crypto.IEncryptingSession;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Attribute;
import org.dom4j.Comment;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public abstract class Parameter
extends AbstractData
implements Cloneable {
    protected boolean m_bLocal = false;
    protected Object m_currentValue;
    protected Object m_defaultValue;
    protected String m_encryptedValue;
    protected String m_sBadValue;
    protected Map m_values;
    protected Set<Parameter> m_sortedValues;
    private boolean m_bMandatory;
    private boolean m_bEncrypted;
    private String m_sUnits;
    private Integer m_minOccurs;
    private Integer m_maxOccurs;
    private boolean m_isTemplate;
    private boolean m_isReadOnly;
    private Integer m_Order;
    protected List<String> m_lastErrorMsg = new ArrayList<String>();
    private boolean hasWarnings = false;
    private String m_namespace;
    private String m_dataType;
    private boolean m_bIsActionParam = false;
    protected boolean m_bFireValueChanged = true;
    String m_elemType = "";
    boolean m_bIsElementParameter = false;
    boolean m_isExternalParameter = false;

    public Parameter() {
    }

    public Parameter(String namespace, String dataType) {
        this.m_namespace = namespace;
        this.m_dataType = dataType;
    }

    public final List<CnfgActionTest> getTestActions() {
        if (this.getDisabled()) {
            List<CnfgActionTest> tests = Collections.emptyList();
            return tests;
        }
        return this.m_lTestActions;
    }

    public final List<CnfgActionTest> getParamTestActions(String refID) {
        ArrayList<CnfgActionTest> tests = new ArrayList<CnfgActionTest>();
        for (CnfgActionTest element : this.m_lTestActions) {
            if (!element.getID().equals(refID)) continue;
            tests.add(element);
        }
        return tests;
    }

    public final List<CnfgActionCustomSave> getParamCustomSaveActions(String refID) {
        ArrayList<CnfgActionCustomSave> saveActions = new ArrayList<CnfgActionCustomSave>();
        for (CnfgActionCustomSave element : this.m_lCustomSaveActions) {
            if (!element.getID().equals(refID)) continue;
            saveActions.add(element);
        }
        return saveActions;
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        String sActionParam;
        String invokeMethodAttr;
        Element valueElement;
        String sEncrypted;
        String sMandatory;
        this.m_parentFolder = parentFolder;
        this.m_sName = elem.attributeValue("name");
        this.m_sDocLink = elem.attributeValue("doclink", "");
        String sDependencies = elem.attributeValue("dependency", "");
        boolean disabled = !DataManager.getInstance().isInstalled(sDependencies) || null != this.m_parentFolder && this.m_parentFolder.getDisabled();
        this.setDisabled(disabled);
        List actionElems = elem.elements("action");
        for (int i = 0; i < actionElems.size(); ++i) {
            Element actionElem = (Element)actionElems.get(i);
            CnfgActionOld action = null;
            String sType = actionElem.attributeValue("type", "externalprocess");
            String sDepends = actionElem.attributeValue("dependency", "");
            if (DataManager.getInstance().isInstalled(sDepends)) {
                if (sType.compareToIgnoreCase("externalprocess") == 0) {
                    action = new CnfgActionExternalProcess();
                    ((CnfgActionOld)action).load(actionElem);
                } else {
                    if (sType.compareToIgnoreCase("cnfg") != 0) continue;
                    String sName = actionElem.attributeValue("name");
                    action = DataManager.getInstance().getBuiltinAction(sName, actionElem);
                    if (null != sName && sName.equalsIgnoreCase("test")) {
                        this.m_lTestActions.add(new CnfgActionTest(actionElem, DataManager.buildPath(this)));
                    } else if (null != sName && sName.equalsIgnoreCase("save")) {
                        this.m_lCustomSaveActions.add(new CnfgActionCustomSave(actionElem));
                    }
                }
            }
            if (action == null) continue;
            this.m_lActions.add(action);
        }
        boolean bIsVisible = true;
        String sViewList = elem.attributeValue("viewList", "");
        if (sViewList.length() == 0) {
            if (this.m_parentFolder != null) {
                bIsVisible = this.m_parentFolder.getVisibility();
            }
        } else {
            bIsVisible = DataManager.getInstance().isInCurrentView(sViewList);
        }
        this.setVisibility(bIsVisible);
        String sReadOnly = elem.attributeValue("readOnly", "false");
        if (sReadOnly.equalsIgnoreCase("true")) {
            this.setReadOnly(true);
        } else {
            this.setReadOnly(false);
        }
        String sExternal = elem.attributeValue("external", "false");
        if (sExternal.equalsIgnoreCase("true")) {
            this.setIsExternal(true);
        }
        if ((sMandatory = elem.attributeValue("mandatory", "false")).equalsIgnoreCase("true")) {
            this.m_bMandatory = true;
        }
        if ((sEncrypted = elem.attributeValue("encrypted", "false")).equalsIgnoreCase("true")) {
            this.m_bEncrypted = true;
            DataManager.getInstance().foundEncryptable(this, parentFolder);
        }
        String sRestartOnChange = elem.attributeValue("restartOnChange", "CBS");
        this.setRestartServicesList(DataManager.getInstance().getRestartServicesList(sRestartOnChange));
        String sUnits = elem.attributeValue("units", null);
        if (sUnits != null) {
            this.m_sUnits = sUnits;
        }
        String sMinOccurs = elem.attributeValue("minOccurs", "");
        boolean bMinInvalid = false;
        if (sMinOccurs.length() != 0) {
            if (sMinOccurs.equals("unbounded")) {
                this.m_minOccurs = new Integer(-1);
            } else {
                try {
                    this.m_minOccurs = new Integer(sMinOccurs);
                    if (this.m_minOccurs < 0) {
                        bMinInvalid = true;
                    }
                }
                catch (NumberFormatException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                    bMinInvalid = true;
                }
            }
        } else {
            bMinInvalid = true;
        }
        if (bMinInvalid) {
            this.m_minOccurs = new Integer(1);
        }
        boolean bMaxInvalid = false;
        String sMaxOccurs = elem.attributeValue("maxOccurs", "");
        if (sMaxOccurs.length() != 0) {
            if (sMaxOccurs.equals("unbounded")) {
                this.m_maxOccurs = new Integer(-1);
            } else {
                try {
                    this.m_maxOccurs = new Integer(sMaxOccurs);
                    if (this.m_maxOccurs < 0) {
                        bMaxInvalid = true;
                    }
                }
                catch (NumberFormatException e) {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug(e);
                    }
                    bMaxInvalid = true;
                }
            }
        } else {
            bMaxInvalid = true;
        }
        if (bMaxInvalid) {
            this.m_maxOccurs = new Integer(1);
        }
        if (this.m_minOccurs == -1 && this.m_maxOccurs != -1) {
            this.m_minOccurs = new Integer(1);
            this.m_maxOccurs = new Integer(1);
        }
        if (this.m_minOccurs != -1 && this.m_maxOccurs != -1 && (this.m_minOccurs > this.m_maxOccurs || this.m_minOccurs == 0 && this.m_maxOccurs == 0)) {
            this.m_minOccurs = new Integer(1);
            this.m_maxOccurs = new Integer(1);
        }
        this.m_sMsgBase = elem.attributeValue("msgBase", "");
        if (this.m_sMsgBase.length() == 0 && this.m_parentFolder != null && this.m_parentFolder.m_sMsgBase != null && this.m_parentFolder.m_sMsgBase.length() != 0) {
            this.m_sMsgBase = this.m_parentFolder.m_sMsgBase;
        }
        CnfgUIDocResource.setResourceBundle(this.m_sMsgBase);
        this.m_sLabel = CnfgUIDocResource.getMessage(elem.attributeValue("label", ""), this.m_sMsgBase);
        this.m_sDesc = CnfgUIDocResource.getMessage(elem.attributeValue("description", ""), this.m_sMsgBase);
        this.m_sHelp = CnfgUIDocResource.getMessage(elem.attributeValue("help", ""), this.m_sMsgBase);
        String sItemType = elem.attributeValue("arrayType", "");
        if (sItemType.length() != 0) {
            int idx = sItemType.indexOf(":");
            if (idx == -1) {
                return false;
            }
            String sPrefix = sItemType.substring(0, idx);
            Namespace ns = elem.getNamespaceForPrefix(sPrefix);
            if (ns == null) {
                return false;
            }
            if (!ns.getURI().equals("http://www.w3.org/2001/XMLSchema") && !ns.getURI().equals("http://developer.cognos.com/schemas/configparams/XMLSchema/1/")) {
                return false;
            }
            this.m_elemType = sItemType;
            String sType = this.m_elemType.substring(idx + 1, this.m_elemType.length());
            if (sType.equals("parameterType")) {
                this.m_bIsElementParameter = true;
            }
        }
        if ((valueElement = this.callInvokeMethod(invokeMethodAttr = elem.attributeValue("invokeMethod"), elem)) != null) {
            if (elem.elements("enum").size() > 0) {
                elem.clearContent();
            }
            this.addValueElems(valueElement, elem);
        }
        String sEnumMsgBase = null;
        Iterator itEnum = elem.elementIterator("enum");
        while (itEnum.hasNext()) {
            Element e = (Element)itEnum.next();
            String sEnumDependencies = e.attributeValue("dependency", "");
            if (!DataManager.getInstance().isInstalled(sEnumDependencies)) continue;
            if (this.m_values == null) {
                this.m_values = new HashMap();
                if (this.getDataType().compareToIgnoreCase("sortedArray") == 0 || this.getDataType().compareToIgnoreCase("array") == 0) {
                    this.m_sortedValues = new TreeSet<Parameter>(new MyOrderComparator());
                }
            }
            if (!this.isValidEnum(e)) continue;
            String sValue = e.attributeValue("value");
            sEnumMsgBase = elem.attributeValue("msgBase", "");
            if (sEnumMsgBase.length() == 0 && this.m_sMsgBase != null && this.m_sMsgBase.length() != 0) {
                sEnumMsgBase = this.m_sMsgBase;
            }
            String sTitle = null;
            sTitle = e.attributeValue("useLabel") != null && e.attributeValue("useLabel").equalsIgnoreCase("false") ? e.attributeValue("label") : CnfgUIDocResource.getMessage(e.attributeValue("label", ""), sEnumMsgBase);
            if (sValue == null || sTitle == null) continue;
            this.m_values.put(sValue, sTitle);
            if (this.getDataType().compareToIgnoreCase("sortedArray") != 0 && this.getDataType().compareToIgnoreCase("array") != 0) continue;
            Parameter p = this.createParamElement(this.m_elemType);
            p.setName(this.getName());
            p.setFireValueChanged(false);
            p.setLabel(sTitle);
            p.setValue(sValue);
            String sOrder = e.attributeValue("order");
            if (sOrder != null) {
                p.setOrder(new Integer(sOrder));
            }
            this.m_sortedValues.add(p);
        }
        if (this.m_values != null && this.m_values.size() == 0) {
            this.m_values = null;
            this.m_sortedValues = null;
        }
        String sDefaultValue = elem.attributeValue("default", "");
        if (this.isMandatory() && sDefaultValue.length() == 0) {
            this.m_sBadValue = new String();
        }
        if ((sActionParam = elem.attributeValue("action", "false")).equalsIgnoreCase("true")) {
            this.m_bIsActionParam = true;
        }
        return true;
    }

    protected Element callInvokeMethod(String invokeMethodAttr, Element elem) {
        if (invokeMethodAttr != null && invokeMethodAttr != "") {
            try {
                Element parentElement = elem.getParent();
                if (parentElement != null) {
                    String methodName;
                    Class<?> className;
                    String providerName = parentElement.attributeValue("value");
                    int position = invokeMethodAttr.lastIndexOf(".");
                    if (position != -1 && (className = Class.forName(invokeMethodAttr.substring(0, position))) != null && (methodName = invokeMethodAttr.substring(position + 1)) != null) {
                        Method methodToInvoke = className.getMethod(methodName, String.class, Locale.class);
                        Locale locale = CnfgResource.getLocale();
                        Element valueElement = (Element)methodToInvoke.invoke(null, providerName, locale);
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("parameter::callInvokeMethod()=> " + invokeMethodAttr + " method returned: " + valueElement.asXML());
                        }
                        return valueElement;
                    }
                }
            }
            catch (Exception e) {
                CnfgLog.error(e);
            }
        }
        return null;
    }

    protected void addValueElems(Element valueElement, Element resultElem) {
        List enumElements = valueElement.elements();
        for (int i = 0; i < enumElements.size(); ++i) {
            Element enumElement = (Element)enumElements.get(i);
            Element clonedElement = (Element)enumElement.clone();
            resultElem.add(clonedElement);
        }
    }

    private boolean isValidEnum(Element e) {
        boolean isValid = true;
        String sExcludePlat = e.attributeValue("excludePlatform");
        if (sExcludePlat != null && !sExcludePlat.isEmpty()) {
            isValid = !CnfgUtils.matchPlatform(sExcludePlat);
        }
        return isValid;
    }

    public Parameter createParamElement(String sType) {
        if (sType == null) {
            sType = "";
        }
        String sPrefix = "";
        int idx = sType.indexOf(":");
        if (idx >= 0) {
            sPrefix = sType.substring(0, idx);
        }
        return this.createParamElement(sType, sPrefix);
    }

    public Parameter createParamElement(String sType, String sPrefix) {
        Parameter p = DataManager.getInstance().createParameter(null, sType, sPrefix);
        return p;
    }

    public String getElemType() {
        return this.m_elemType;
    }

    public String getUnits() {
        return this.m_sUnits;
    }

    public boolean isEncrypted() {
        return this.m_bEncrypted;
    }

    public void setEncrypted(boolean b) {
        this.m_bEncrypted = b;
    }

    public String getBadValue() {
        return this.m_sBadValue;
    }

    public boolean isMandatory() {
        return this.m_bMandatory;
    }

    public boolean isTemplate() {
        return this.m_isTemplate;
    }

    public void setIsTemplate(boolean b) {
        this.m_isTemplate = b;
    }

    public Integer getMaxOccurs() {
        return this.m_maxOccurs;
    }

    public Integer getMinOccurs() {
        return this.m_minOccurs;
    }

    public Integer getOrder() {
        return this.m_Order;
    }

    public void setOrder(Integer order) {
        this.m_Order = order;
    }

    public void setFireValueChanged(boolean bFire) {
        this.m_bFireValueChanged = bFire;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            CnfgLog.error(e);
            throw new InternalError(e.toString());
        }
    }

    public boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    public void setReadOnly(boolean b) {
        this.m_isReadOnly = b;
    }

    protected void addErrorMsg(String msg) {
        this.m_lastErrorMsg.add(msg);
    }

    public List<String> getErrorMsg() {
        return this.m_lastErrorMsg;
    }

    public String getErrorMsgString() {
        String sMsg = "";
        for (int i = 0; i < this.m_lastErrorMsg.size(); ++i) {
            String str = this.m_lastErrorMsg.get(i);
            if (sMsg.length() != 0) {
                sMsg = sMsg + "\n";
            }
            sMsg = sMsg + str;
        }
        return sMsg;
    }

    public void clearErrorMsg() {
        this.m_lastErrorMsg = new ArrayList<String>();
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getDataType() {
        return this.m_dataType;
    }

    public boolean isBadValue() {
        return this.m_sBadValue != null;
    }

    public Object getValue() {
        if (this.m_sBadValue != null) {
            return this.m_sBadValue;
        }
        if (this.m_currentValue == null) {
            if (this.hasDefault()) {
                return this.m_defaultValue;
            }
            return null;
        }
        return this.m_currentValue;
    }

    public Map getValues() {
        return this.m_values;
    }

    public Set<Parameter> getAvailableValues() {
        return this.m_sortedValues;
    }

    public String getDisplayValue() {
        Object oValue = this.getValue();
        if (oValue != null) {
            StringBuffer sRetValue = new StringBuffer(64);
            if (this.m_values != null && oValue.toString().length() >= 0) {
                Object valueInList = this.m_values.get(oValue);
                if (valueInList != null) {
                    sRetValue.append(valueInList.toString());
                } else {
                    sRetValue.append(oValue.toString());
                }
            } else {
                sRetValue.append(oValue.toString());
            }
            return sRetValue.toString();
        }
        return null;
    }

    public boolean setValue(Object value) {
        this.m_sBadValue = null;
        this.m_encryptedValue = null;
        if (this.m_bFireValueChanged) {
            CnfgValueChangedEvent vce = new CnfgValueChangedEvent(this);
            DataManager.getInstance().fireValueChanged(vce);
        }
        return true;
    }

    public boolean setValue(Element value_elem) {
        this.clearErrorMsg();
        if (this.isEncrypted()) {
            String sEncrypted = value_elem.attributeValue("encrypted");
            if (sEncrypted != null && sEncrypted.equals("true")) {
                this.m_encryptedValue = value_elem.getText();
                if (this.m_sBadValue != null && this.m_encryptedValue.length() > 0) {
                    this.m_sBadValue = null;
                }
                this.m_currentValue = null;
                return true;
            }
            if (!this.getDisabled()) {
                DataManager.getInstance().setConfigDirtyFlag(true, this.getRestartServicesList());
            }
            return this.setValue(value_elem.getText());
        }
        return this.setValue(value_elem.getText());
    }

    public boolean validate(String value) {
        if (this.isMandatory() && value.length() == 0) {
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.mandatory"));
            return false;
        }
        return true;
    }

    public void write(Element value_elem, boolean bEncrypt, List<String> errors) throws DataManagerException {
        Element text_elem;
        if (!this.getDisabled() && this.getVisibility() && this.isBadValue()) {
            Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
            if (errors != null) {
                String sMessage = CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args);
                errors.add(sMessage);
            } else {
                StringBuffer sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args));
                throw new DataManagerException(sMessage.toString());
            }
        }
        String sValue = null;
        boolean bIsEncrypted = false;
        if (this.m_encryptedValue != null) {
            if (bEncrypt) {
                sValue = this.m_encryptedValue;
                bIsEncrypted = true;
            } else if (this.isEncrypted()) {
                DataManager.getInstance().initializeCAMFactoryFromDisk();
                IEncryptingSession es = DataManager.getInstance().getCryptoEncryptingSession(bEncrypt);
                if (es != null) {
                    try {
                        if (DataManager.getInstance().doNotNeedDecryptCredentials()) {
                            sValue = this.m_encryptedValue;
                        }
                        byte[] decodedBuffer = es.decode(this.m_encryptedValue);
                        byte[] utf8Buffer = es.decryptData(decodedBuffer);
                        sValue = new String(utf8Buffer, "UTF-8");
                    }
                    catch (Throwable e) {
                        CnfgLog.error(e);
                        this.m_sBadValue = sValue = new String();
                        Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
                        if (errors != null) {
                            String sMessage = e.getLocalizedMessage() + "\n" + CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args);
                            errors.add(sMessage);
                        }
                        StringBuffer sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args));
                        throw new DataManagerException(sMessage.toString());
                    }
                } else {
                    sValue = this.m_encryptedValue;
                    bIsEncrypted = true;
                }
            }
        } else {
            Object oValue = this.getValue();
            String string = sValue = oValue == null ? "" : oValue.toString();
            if (bEncrypt && !this.getDisabled() && this.isEncrypted()) {
                DataManager.getInstance().initializeCAMFactoryFromDisk();
                IEncryptingSession es = DataManager.getInstance().getCryptoEncryptingSession(bEncrypt);
                if (es != null) {
                    try {
                        byte[] utf8Buffer = sValue.getBytes("UTF-8");
                        byte[] buffer = es.encryptData(utf8Buffer);
                        sValue = es.encode(buffer);
                    }
                    catch (UnsupportedEncodingException e) {
                        CnfgLog.error(e);
                        if (errors != null) {
                            errors.add(e.getLocalizedMessage());
                        }
                        throw new DataManagerException(e.getLocalizedMessage());
                    }
                    catch (CAMCryptoException e) {
                        CnfgLog.error(e);
                        if (errors != null) {
                            errors.add(e.getLocalizedMessage());
                        }
                        throw new DataManagerException(e.getLocalizedMessage());
                    }
                    this.m_encryptedValue = sValue;
                    bIsEncrypted = true;
                }
            }
        }
        if (bIsEncrypted) {
            value_elem.addAttribute("encrypted", "true");
        }
        if ((text_elem = value_elem.addText(sValue)) == null) {
            throw new DataManagerException(CnfgResource.getMessage("Message.errorOutOfMemory"));
        }
    }

    public void setToDefault() {
        if (this.hasDefault() && !this.isReadOnly()) {
            this.setValue(this.m_defaultValue);
        }
    }

    public boolean hasDefault() {
        return this.m_defaultValue != null;
    }

    public boolean isDefault() {
        if (this.hasDefault()) {
            Object currentValue = this.getValue();
            if (currentValue == null) {
                return true;
            }
            return currentValue.toString().equals(this.m_defaultValue.toString());
        }
        return false;
    }

    public void setDefault(Object value) {
        this.m_defaultValue = value;
    }

    void setMinOccurs(int val) {
        this.m_minOccurs = new Integer(val);
    }

    public void setMandatory(boolean isMandatory) {
        this.m_bMandatory = isMandatory;
    }

    @Override
    public void serialize(Element element, boolean bEncrypt, List errors, boolean bIncludeDoc, boolean excludeDisabledAndInvisibleItems) throws DataManagerException {
        boolean bIsVisible;
        if (this.isExternal()) {
            return;
        }
        boolean bl = bIsVisible = this.isLocal() ? true : this.getVisibility();
        if ((!this.getDisabled() && bIsVisible || !excludeDisabledAndInvisibleItems) && this.getClass() != TemplatedParameter.class) {
            Comment comment;
            StringBuffer sb;
            Element parameter_elem = DocumentHelper.createElement((QName)DataManager.getInstance().m_qnParam);
            Attribute name_attrib = DocumentHelper.createAttribute((Element)parameter_elem, (String)"name", (String)this.m_sName);
            parameter_elem.add(name_attrib);
            Element value_elem = DocumentHelper.createElement((QName)DataManager.getInstance().m_qnValue);
            Namespace schemaInstNS = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            QName qName = new QName("type", schemaInstNS);
            String qDataType = (String)DataManager.nsToPrefixMap.get(this.getNamespace()) + ":" + this.getDataType();
            Attribute type_attrib = DocumentHelper.createAttribute((Element)value_elem, (QName)qName, (String)qDataType);
            value_elem.add(type_attrib);
            parameter_elem.add(value_elem);
            this.write(value_elem, bEncrypt, errors);
            if (bIncludeDoc && null != this.m_sDesc) {
                sb = new StringBuffer();
                if (CnfgUtils.escapeXMLComment(sb.append(this.m_sName).append(": ").append(this.m_sDesc))) {
                    sb.append(" ").append(CnfgResource.getMessage("Message.saveConfig.modifiedXMLComment"));
                }
                comment = DocumentHelper.createComment((String)sb.toString());
                element.add(comment);
            }
            if (bIncludeDoc && null != this.m_sHelp) {
                sb = new StringBuffer();
                if (CnfgUtils.escapeXMLComment(sb.append(this.m_sHelp))) {
                    sb.append(" ").append(CnfgResource.getMessage("Message.saveConfig.modifiedXMLComment"));
                }
                comment = DocumentHelper.createComment((String)sb.toString());
                element.add(comment);
            }
            if (this.getDisabled()) {
                Attribute disabledAttr = DocumentHelper.createAttribute((Element)parameter_elem, (String)"disabled", (String)"true");
                parameter_elem.add(disabledAttr);
            }
            element.add(parameter_elem);
        }
    }

    public String getDecryptedValue() {
        try {
            String sValue;
            Element temp_elem = DocumentHelper.createElement((String)"TEMP");
            ArrayList<String> errors = new ArrayList<String>();
            DataManager.getInstance().setDecryptCryptoPasswords(true);
            this.write(temp_elem, false, errors);
            DataManager.getInstance().setDecryptCryptoPasswords(false);
            if (errors.size() == 0 && (sValue = temp_elem.getText()) != null) {
                return sValue;
            }
        }
        catch (DataManagerException e) {
            CnfgLog.error(e.getMessage());
            DataManager.getInstance().setDecryptCryptoPasswords(false);
        }
        catch (Throwable e) {
            CnfgLog.error(e.getMessage());
            DataManager.getInstance().setDecryptCryptoPasswords(false);
        }
        return null;
    }

    public boolean isEqual(Object value) {
        Object originalValue = this.getValue();
        if (originalValue != null && String.class.isInstance(value)) {
            return value.equals(originalValue.toString());
        }
        return false;
    }

    public String getEncryptedValue() {
        return this.m_encryptedValue;
    }

    public void setEncryptedValue(String val) {
        this.m_encryptedValue = val;
    }

    public boolean isActionParam() {
        return this.m_bIsActionParam;
    }

    public boolean isLocal() {
        return this.m_bLocal;
    }

    public void setLocal(boolean toSet) {
        this.m_bLocal = toSet;
    }

    public void setIsExternal(boolean bExternal) {
        this.m_isExternalParameter = bExternal;
    }

    public boolean isExternal() {
        return this.m_isExternalParameter;
    }

    protected class MyOrderComparator
    implements Comparator {
        protected MyOrderComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            Parameter param1 = (Parameter)obj1;
            Parameter param2 = (Parameter)obj2;
            if (param1.getOrder() == null || param2.getOrder() == null) {
                return 1;
            }
            if (param1.getOrder() < param2.getOrder()) {
                return -1;
            }
            if (param1.getOrder() > param2.getOrder()) {
                return 1;
            }
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof MyOrderComparator;
        }
    }
}

