/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.StringParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class PathParameter
extends StringParameter {
    private boolean m_bIsFilePath;
    private boolean m_bFileExists;
    private List<String> m_lFileFilterExt = new ArrayList<String>();
    private String m_sFileFilterDesc = null;

    public PathParameter(String namespace, String dataType) {
        super(namespace, dataType);
        this.m_bIsFilePath = dataType.equals("filePath");
    }

    public List<String> getFileFilterExtList() {
        return this.m_lFileFilterExt;
    }

    public String getFileFilterDesc() {
        if (this.m_sFileFilterDesc == null || this.m_sFileFilterDesc.length() == 0) {
            StringBuffer desc = new StringBuffer();
            for (int i = 0; i < this.m_lFileFilterExt.size(); ++i) {
                String sExt = this.m_lFileFilterExt.get(i);
                if (i == 0) {
                    desc.append("*.").append(sExt);
                    continue;
                }
                desc.append(";*.").append(sExt);
            }
            return desc.toString();
        }
        return this.m_sFileFilterDesc;
    }

    public void setFileFilterExt(List<String> lExts, String desc) {
        this.m_lFileFilterExt = lExts;
        this.m_sFileFilterDesc = desc;
    }

    public boolean hasFilter() {
        return this.m_lFileFilterExt != null && this.m_lFileFilterExt.size() > 0;
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        String sPathRequired;
        boolean bSuccess = super.load(parentFolder, elem);
        if (!bSuccess) {
            return false;
        }
        String sFileExists = elem.attributeValue("pathExists", "false");
        if (sFileExists.equalsIgnoreCase("true")) {
            this.m_bFileExists = true;
        }
        if ((sPathRequired = elem.attributeValue("pathRequired", "false")).equalsIgnoreCase("true")) {
            DataManager.getInstance().getVerifyConfig().registerRequiredFolderParameter(this);
        }
        return true;
    }

    @Override
    public boolean validate(String sValue) {
        if (!CnfgUtils.isValidPath(sValue)) {
            Object[] args = new Object[]{CnfgUtils.getInvalidChars()};
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.invalidChars", args));
            return false;
        }
        if (!super.validate(sValue)) {
            return false;
        }
        if (this.hasToExist()) {
            String sResolvedPath = CCLConfigurationFactory.getInstance().resolveEffectivePath(sValue);
            File curFile = new File(sResolvedPath);
            if (this.isFilePath() && !curFile.isFile()) {
                Object[] args = new Object[]{sResolvedPath};
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnEditPath.filenotexist.notification", args));
                return false;
            }
            if (this.isFolderPath() && !curFile.isDirectory()) {
                Object[] args = new Object[]{sResolvedPath};
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnEditPath.pathnotexist.notification", args));
                return false;
            }
        }
        return true;
    }

    private boolean hasToExist() {
        return this.m_bFileExists;
    }

    @Override
    public boolean setValue(Object value) {
        this.clearErrorMsg();
        String sValue = value.toString();
        if (this.validate(sValue)) {
            return super.setValue(sValue);
        }
        this.m_sBadValue = sValue;
        return false;
    }

    public boolean isFilePath() {
        return this.m_bIsFilePath;
    }

    public boolean isFolderPath() {
        return !this.m_bIsFilePath;
    }

    public void setFilePath(boolean isFilePath) {
        this.m_bIsFilePath = isFilePath;
    }
}

