/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.URLParameter;
import com.cognos.crconfig.data.URLPathParameter;

public class RelativeOrAbsoluteURIParameter
extends URLParameter {
    public RelativeOrAbsoluteURIParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    @Override
    public boolean validate(String sValue) {
        boolean bRetAbsolute = false;
        boolean bRetRelative = false;
        boolean bRetValue = false;
        if (sValue.length() == 0) {
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.mandatory"));
            return false;
        }
        int nextIdx = sValue.indexOf("://");
        if (nextIdx == -1) {
            if (!sValue.startsWith("/")) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("AbsoluteOrRelativeURLParameter::validate(" + sValue + "), should start with '/'");
                }
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.relativeURI.firstCharError"));
                return false;
            }
            if (sValue.endsWith("/")) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("AbsoluteOrRelativeURLParameter::validate(" + sValue + "), can't end with '/'");
                }
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.relativeURI.lastCharError"));
                return false;
            }
            if (!URLPathParameter.validateRest(sValue.substring(1, sValue.length()))) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("AbsoluteOrRelativeURLParameter::validate(" + sValue + "), length is invalid or contains empty, spaces or non-ascii chars.");
                }
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.relativeURI.restInvalid"));
                return false;
            }
            bRetRelative = true;
        } else {
            bRetAbsolute = super.validate(sValue);
            if (!bRetAbsolute) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.absoluteURI.error"));
                return false;
            }
        }
        if (bRetAbsolute || bRetRelative) {
            bRetValue = true;
        }
        return bRetValue;
    }
}

