/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.service.CnfgServiceFolderChangedEvent;
import com.cognos.crconfig.data.service.ServiceFolder;
import com.cognos.crconfig.data.service.ServiceManager;

public class RootFolder
extends Folder
implements ServiceManager.ServiceManagerListener {
    private Integer m_isRunning = null;
    private int m_runningServ = 0;
    private int m_stoppedServ = 0;
    private final String LABEL_NOT_INSTALLED = CnfgResource.getMessage("Label.ServiceManagerNotInstalled");

    @Override
    public String getLabel() {
        return this.LABEL_NOT_INSTALLED;
    }

    @Override
    public String getIcon() {
        if (this.m_icon == null) {
            this.m_icon = "root";
        }
        return this.m_icon;
    }

    public void checkServiceStatus(Folder cf) throws InterruptedException {
        for (int i = 0; i < cf.getFolders().size(); ++i) {
            Folder f = cf.getFolders().get(i);
            if (f instanceof ServiceFolder && !f.getDisabled()) {
                if (((ServiceFolder)f).isRunning()) {
                    ++this.m_runningServ;
                } else {
                    ++this.m_stoppedServ;
                }
            }
            this.checkServiceStatus(f);
        }
    }

    @Override
    public void serviceStatusChecking(String msg) throws InterruptedException {
        if (msg == null || msg.length() == 0) {
            return;
        }
        this.m_runningServ = 0;
        this.m_stoppedServ = 0;
        if (DataManager.getInstance().isBTSVInstalled() || ServiceManager.hasOtherServicesInstalled()) {
            this.checkServiceStatus(this);
        }
        this.serviceFolderStatusChanged();
    }

    public void serviceFolderStatusChanged() {
        this.m_icon = DataManager.getInstance().isBTSVInstalled() || ServiceManager.hasOtherServicesInstalled() ? (this.m_runningServ == 0 && this.m_stoppedServ == 0 ? "root" : (this.m_runningServ > 0 && this.m_stoppedServ > 0 ? "root_mixed" : (this.m_runningServ > 0 && this.m_stoppedServ == 0 ? "root_start" : (this.m_runningServ == 0 && this.m_stoppedServ > 0 ? "root_stop" : "root")))) : "root";
        CnfgServiceFolderChangedEvent e = new CnfgServiceFolderChangedEvent(this);
        DataManager.getInstance().fireServiceFolderChanged(e);
    }
}

