/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgPreferences;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.CnfgUtils;
import com.cognos.crconfig.data.ArrayParameter;
import com.cognos.crconfig.data.BooleanParameter;
import com.cognos.crconfig.data.CnfgDataUtils;
import com.cognos.crconfig.data.Constants;
import com.cognos.crconfig.data.CredentialParameter;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.StartupFileException;
import com.cognos.crconfig.data.StringParameter;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.service.ServiceManager;
import com.ibm.icu.util.TimeZone;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class StartupProcessor
extends Constants {
    private static Properties timeZonesMapping = null;
    private static boolean bCryptoConfigChanged = true;
    protected static final Namespace nsCRN;
    protected static final QName qnPARAMETERS;
    protected static final QName qnPARAMETER;
    protected static final QName qnVALUE;
    private static final QName qnINSTANCES;
    private static final QName qnINSTANCE;
    private static final String CFG_ARRAY_NS = "cfg:array";
    private static final String CFG_SORTEDARRAY_NS = "cfg:sortedArray";

    public static void getStartupParameters() throws StartupFileException, DataManagerException {
        String sFontsDir;
        Parameter fontPaths;
        Parameter timeZoneID;
        String curvalue;
        StringParameter rsvpExecModeParam;
        Object value;
        ArrayParameter cipherList;
        Set<Parameter> curValues;
        Parameter cipherParam;
        Parameter digestAlgorithm;
        Object value2;
        DataManager dm = DataManager.getInstance();
        ICCLConfiguration CCLCFGAPI = CCLConfigurationFactory.getInstance();
        try {
            Element rootElement;
            InputStream startupFileStream = dm.getStartupInputStream();
            try {
                BufferedReader xmlDeclReader = new BufferedReader(new InputStreamReader(startupFileStream, "ISO-8859-1"));
                String xmlDecl = xmlDeclReader.readLine().toLowerCase();
                int pos = xmlDecl.indexOf(" encoding=\"");
                if (0 <= pos) {
                    String encValue = xmlDecl.substring(pos + 11);
                    if (null != encValue && (encValue.startsWith("utf8\"") || encValue.startsWith("utf-8\""))) {
                        if (CnfgLog.isDebugEnabled()) {
                            CnfgLog.debug("StartupProcessor::getStartupParameters() - The encoding is UTF-8.");
                        }
                        dm.setDefaultEncoding(false);
                    }
                } else {
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("StartupProcessor::getStartupParameters() - When there's no encoding attribute, the parser assumes UTF-8.");
                    }
                    dm.setDefaultEncoding(false);
                }
                boolean isEncrypted = false;
                String xmlstr = xmlDeclReader.readLine();
                while (xmlstr != null) {
                    int index = xmlstr.indexOf("encrypted=\"true\"");
                    if (index != -1) {
                        isEncrypted = true;
                        break;
                    }
                    xmlstr = xmlDeclReader.readLine();
                }
                if (isEncrypted) {
                    dm.setSkipBackup(false);
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("The original cogstartup.xml file is encrypted.");
                    }
                } else {
                    dm.setSkipBackup(true);
                    if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("The original cogstartup.xml file is clear text. Don't back it up.");
                    }
                }
            }
            catch (Exception e) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("StartupProcessor::getStartupParameters() - An exception occured, " + e.getMessage() + ", the parser assumes UTF-8.");
                }
                dm.setDefaultEncoding(false);
            }
            Document dom = dm.getUpgradedStartupDoc();
            if (dom == null) {
                startupFileStream = dm.getStartupInputStream();
                SAXReader reader = new SAXReader();
                dom = reader.read(startupFileStream);
            }
            if (null != (rootElement = dom.getRootElement()) && rootElement.getName().equals("parameters") && rootElement.getNamespace().equals((Object)nsCRN)) {
                List parameterList = rootElement.elements(qnPARAMETER);
                for (Element parameterElement : parameterList) {
                    Element valueElement;
                    Parameter p;
                    String parameterName;
                    if (null == parameterElement || !parameterElement.getName().equals("parameter") || !parameterElement.getNamespace().equals((Object)nsCRN) || null == (parameterName = parameterElement.attributeValue("name"))) continue;
                    String disabledAttr = parameterElement.attributeValue("disabled");
                    boolean disabled = null != disabledAttr && disabledAttr.equalsIgnoreCase("true");
                    disabledAttr = null;
                    String parameterOpaque = parameterElement.attributeValue("opaque");
                    Element elem = parameterElement.element("value");
                    String parameterArray = elem.attributeValue("type");
                    if (parameterArray != null && (parameterArray.equalsIgnoreCase(CFG_ARRAY_NS) || parameterArray.equalsIgnoreCase(CFG_SORTEDARRAY_NS))) {
                        p = dm.findParm(parameterName);
                        if (null == p) continue;
                        if (disabled != p.getDisabled()) {
                            DataManager.getInstance().setConfigDirtyFlag(true, p.getRestartServicesList());
                        }
                        if (null == (valueElement = parameterElement.element(qnVALUE))) continue;
                        p.setValue(valueElement);
                        continue;
                    }
                    if (null != parameterOpaque && parameterOpaque.equalsIgnoreCase("true")) {
                        Folder f = dm.findComplexFolder(parameterName, true);
                        if (null == f) continue;
                        if (disabled != f.getDisabled()) {
                            dm.setConfigDirtyFlag(true, f.getRestartServicesList());
                        }
                        if (null == (valueElement = parameterElement.element(qnVALUE))) continue;
                        boolean isCrypto = parameterName.equals("CRYPTO");
                        StartupProcessor.readOpaqueFolder(valueElement, f, isCrypto);
                        continue;
                    }
                    p = dm.findParm(parameterName);
                    if (null == p) continue;
                    if (disabled != p.getDisabled()) {
                        DataManager.getInstance().setConfigDirtyFlag(true, p.getRestartServicesList());
                    }
                    if (null == (valueElement = parameterElement.element(qnVALUE))) continue;
                    p.setValue(valueElement);
                }
            }
        }
        catch (NoClassDefFoundError e) {
            CnfgLog.error(e);
            throw new StartupFileException(CnfgResource.getMessage("Message.configurationlib.unabletoload.explanation"));
        }
        catch (DocumentException de) {
            CnfgLog.error(de);
            throw new StartupFileException(CnfgResource.getMessage("Message.loadConfig.invalidFormatStartup.explanation"));
        }
        if (!dm.m_cryptoDirty && bCryptoConfigChanged) {
            dm.setCryptoDirtyFlag(true);
        }
        dm.addCnfgValueChangedListener(dm);
        dm.addCnfgNodeInsertedListener(dm);
        dm.addCnfgNodeDeletedListener(dm);
        dm.addCnfgNodeRenamedListener(dm);
        dm.addCnfgNodeSwitchListener(dm);
        Parameter serverLocale = dm.findParm("serverLocale");
        if (!(null == serverLocale || serverLocale.getDisabled() || (value2 = serverLocale.getValue()) != null && value2.toString().length() != 0)) {
            try {
                String locale = CnfgPreferences.getInstance().getProperty("language");
                serverLocale.setValue(CCLCFGAPI.normalizeLocale(locale));
            }
            catch (CCLConfigurationException e) {
                CnfgLog.error(e);
                serverLocale.setValue("en");
            }
            catch (MissingResourceException e) {
                CnfgLog.error(e);
                serverLocale.setValue("en");
            }
        }
        if (null != (digestAlgorithm = dm.findParm("digestAlgorithm")) && !digestAlgorithm.getDisabled() && !digestAlgorithm.getValues().containsKey(digestAlgorithm.getValue())) {
            digestAlgorithm.setToDefault();
        }
        if (!(null == (cipherParam = dm.findParm("cognosCryptoCiphersuite")) || cipherParam.getDisabled() || (curValues = (cipherList = (ArrayParameter)cipherParam).getCurrentValues()) != null && curValues.size() != 0)) {
            cipherList.setDefaultValue();
        }
        StartupProcessor.populateHostNameParameter();
        Parameter rsvpExecModeP = dm.findParm("rsvpExecutionMode");
        if (null != rsvpExecModeP && !rsvpExecModeP.getDisabled() && (value = (rsvpExecModeParam = (StringParameter)rsvpExecModeP).getValue()) != null && !rsvpExecModeParam.validate(curvalue = value.toString())) {
            CnfgLog.error("rsvpExecutionMode - current value is not valid: " + curvalue);
            Map values = rsvpExecModeParam.getValues();
            if (values != null && values.size() > 0) {
                Iterator it = values.entrySet().iterator();
                String prevalue = (String)it.next().getKey();
                rsvpExecModeParam.setValue(prevalue != null ? prevalue : "");
                CnfgLog.error("rsvpExecutionMode - reset value to : " + prevalue);
            }
        }
        if (null != (timeZoneID = dm.findParm("serverTimeZoneID")) && !timeZoneID.getDisabled()) {
            value = timeZoneID.getValue();
            if (value == null || value.toString().length() == 0) {
                StartupProcessor.setToDefaultTimeZone(timeZoneID);
            } else {
                String curtzid = value.toString();
                String newtzid = StartupProcessor.getEquivalentID(curtzid);
                if (!timeZoneID.validate(newtzid)) {
                    StartupProcessor.setToDefaultTimeZone(timeZoneID);
                } else if (!curtzid.equals(newtzid)) {
                    timeZoneID.setValue(newtzid);
                }
            }
        }
        if (!CnfgUtils.isInternalSetup() && null != (fontPaths = dm.findParm("fontPaths")) && !fontPaths.getDisabled() && fontPaths.getVisibility() && (sFontsDir = SystemFontsDirectoryFinder.getSystemFontsDirectory()) != null) {
            StringBuffer sbNewValue = new StringBuffer();
            String sValue = (String)fontPaths.getValue();
            if (sValue != null) {
                if (sValue.indexOf(sFontsDir) == -1) {
                    sbNewValue.append(sValue);
                    if (!sValue.endsWith(";")) {
                        sbNewValue.append(";");
                    }
                    sbNewValue.append(sFontsDir);
                    fontPaths.setValue(sbNewValue.toString());
                    fontPaths.setDefault(sbNewValue.toString());
                } else {
                    fontPaths.setDefault(sValue);
                }
            } else {
                sbNewValue.append(sFontsDir);
                fontPaths.setValue(sbNewValue.toString());
                fontPaths.setDefault(sbNewValue.toString());
            }
        }
        ServiceManager.resetName();
    }

    protected static void populateHostNameParameter() {
        Parameter pFQDNHostName = DataManager.getInstance().findParm("hostName");
        CnfgDataUtils.setHostName(pFQDNHostName, null);
        Parameter pHostName = DataManager.getInstance().findParm("webServiceHostName");
        CnfgDataUtils.setLocalHostName(pHostName, false);
    }

    private static void loadTimeZonesMapping() {
        if (timeZonesMapping == null) {
            timeZonesMapping = new Properties();
            InputStream tzmapIS = StartupProcessor.class.getResourceAsStream("/config/i18n_2_icu4j_map.properties");
            if (tzmapIS != null) {
                try {
                    timeZonesMapping.load(tzmapIS);
                    tzmapIS.close();
                    return;
                }
                catch (IOException e) {
                    timeZonesMapping = new Properties();
                }
            }
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("Unable to load timezone mapping: /config/i18n_2_icu4j_map.properties");
            }
        }
    }

    private static String getEquivalentID(String oldtzID) {
        String newid;
        StartupProcessor.loadTimeZonesMapping();
        if (timeZonesMapping != null && (newid = (String)timeZonesMapping.get(oldtzID)) != null && newid.length() > 0) {
            return newid;
        }
        return oldtzID;
    }

    public static void setToDefaultTimeZone(Parameter timeZoneID) {
        String sysTZ = StartupProcessor.getSystemTimeZoneID();
        if (sysTZ != null && timeZoneID.validate(sysTZ)) {
            timeZoneID.setValue(sysTZ);
        } else {
            StartupProcessor.setToGMTTimeZone(timeZoneID);
        }
    }

    private static String getSystemTimeZoneID() {
        TimeZone curTz = TimeZone.getDefault();
        String curTzID = curTz.getID();
        if (CnfgLog.isDebugEnabled()) {
            CnfgLog.debug("Detected System Time Zone ID: '" + curTzID + "'");
        }
        return curTzID;
    }

    public static void setToGMTTimeZone(Parameter timeZoneID) {
        String gmtid;
        TimeZone gmttz = TimeZone.getTimeZone((String)"Europe/London");
        if (gmttz != null && gmttz.getID() != null && timeZoneID.validate(gmtid = gmttz.getID())) {
            timeZoneID.setValue(gmtid);
            return;
        }
        String[] GMTids = TimeZone.getAvailableIDs((int)0);
        String firstValidGMTID = null;
        for (String tz0 : GMTids) {
            String validid = TimeZone.getCanonicalID((String)tz0);
            if (validid == null || !timeZoneID.validate(validid)) continue;
            if (firstValidGMTID == null) {
                firstValidGMTID = validid;
            }
            if (!validid.startsWith("Europe")) continue;
            timeZoneID.setValue(validid);
            return;
        }
        timeZoneID.setValue(firstValidGMTID);
    }

    private static void readOpaqueFolder(Element valueElement, Folder currentFolder, boolean isCrypto) {
        boolean bl;
        Element value_elem;
        QName qnCred;
        Namespace ns;
        Element eCredentialValue;
        Folder dbFolder;
        TemplatedParameter tp;
        ArrayList<TemplatedParameter> lTP;
        String sCredentialUser;
        String sCredentialPass;
        String sCredentialName;
        String sDataBaseName;
        List parameterList = valueElement.elements(qnPARAMETER);
        for (Element parameterElement : parameterList) {
            Element curValueElement;
            String disabledAttr;
            String parameterName;
            if (null == parameterElement || null == (parameterName = parameterElement.attributeValue("name"))) continue;
            if (isCrypto && parameterName.equals("JVMTrustStorePassword")) {
                bCryptoConfigChanged = false;
            }
            boolean disabled = null != (disabledAttr = parameterElement.attributeValue("disabled")) && disabledAttr.equalsIgnoreCase("true");
            disabledAttr = null;
            String parameterOpaque = parameterElement.attributeValue("opaque");
            Element elem = parameterElement.element("value");
            String parameterType = elem.attributeValue("type");
            if (null != parameterOpaque && parameterOpaque.equalsIgnoreCase("true") && parameterType == null) {
                Element folderValueElement;
                Folder f = DataManager.getInstance().findComplexFolder(parameterName, true);
                if (null == f) continue;
                if (disabled != f.getDisabled()) {
                    DataManager.getInstance().setConfigDirtyFlag(true, f.getRestartServicesList());
                }
                if (null == (folderValueElement = parameterElement.element(qnVALUE))) continue;
                StartupProcessor.readOpaqueFolder(folderValueElement, f, false);
                continue;
            }
            Parameter p = currentFolder.findParm(parameterName);
            if (null == p) continue;
            if (disabled != p.getDisabled()) {
                DataManager.getInstance().setConfigDirtyFlag(true, p.getRestartServicesList());
            }
            if (null == (curValueElement = parameterElement.element(qnVALUE))) continue;
            p.setValue(curValueElement);
        }
        parameterList = null;
        List instancesList = valueElement.elements(qnINSTANCES);
        for (Element instancesElement : instancesList) {
            if (null == instancesElement) continue;
            StartupProcessor.readInstances(instancesElement, currentFolder);
        }
        String javaVersion = (String)CnfgPreferences.getInstance().getProperty("JavaVersion", String.class);
        if (currentFolder.getName().equals("NC") && instancesList.size() == 0 && currentFolder.getVisibility() && !DataManager.getInstance().isInstalled("CM") && !currentFolder.getDisabled() && currentFolder.getOpaque() && javaVersion == null) {
            String sDataBaseClass = "DB2";
            String sFolderName = CnfgResource.getMessage("Label.Folder.Notification.Default.Database");
            String sDataBaseValue = "cm";
            sDataBaseName = "name";
            sCredentialName = "user";
            sCredentialPass = "";
            sCredentialUser = "";
            lTP = currentFolder.getTParameters();
            tp = lTP.get(0);
            if ((tp == null || tp != null && !tp.getName().equals("database")) && CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("readOpaqueFolder: Could not set Credential for NC element. tp null or not a database.");
            }
            dbFolder = currentFolder.addInstanceFolder(tp, sDataBaseClass, sFolderName, sFolderName);
            for (Parameter param : dbFolder.getParameters()) {
                if (null != param && param.getName().equals(sDataBaseName)) {
                    param.setValue(sDataBaseValue);
                    continue;
                }
                if (null == param || !param.getName().equals(sCredentialName)) continue;
                eCredentialValue = CredentialParameter.buildCredentials(sCredentialUser, sCredentialPass);
                if (eCredentialValue != null) {
                    ns = DocumentHelper.createNamespace((String)"", (String)"crn");
                    qnCred = DocumentHelper.createQName((String)"value", (Namespace)ns);
                    value_elem = DocumentHelper.createElement((QName)qnCred);
                    if (value_elem != null) {
                        value_elem.add(eCredentialValue);
                        bl = param.setValue(value_elem);
                        continue;
                    }
                    if (!CnfgLog.isDebugEnabled()) continue;
                    CnfgLog.debug("readOpaqueFolder: Could not set Credential for NC element. value_elem is null.");
                    continue;
                }
                if (!CnfgLog.isDebugEnabled()) continue;
                CnfgLog.debug("readOpaqueFolder: Could not set Credential for NC element. eCredentialValue is null.");
            }
        }
        if (currentFolder.getName().equals("AAA")) {
            List<Folder> lFolders;
            boolean isBVInstalled = DataManager.getInstance().isInstalled("BV");
            boolean isPMPInstalled = DataManager.getInstance().isInstalled("PMPSVC");
            if ((isBVInstalled || isPMPInstalled) && currentFolder.getVisibility() && !currentFolder.getDisabled() && currentFolder.getOpaque() && javaVersion == null && (lFolders = currentFolder.getFolders()) != null && lFolders.size() > 0) {
                Folder instance = lFolders.get(0);
                currentFolder.remove(instance);
                if (isBVInstalled) {
                    instance.setName("IBM Cognos Business Viewpoint");
                    instance.setLabel("IBM Cognos Business Viewpoint");
                }
                List<Parameter> lParams = instance.getParameters();
                for (Parameter param : lParams) {
                    if (!param.getName().equals("disableCM")) continue;
                    BooleanParameter boolParam = (BooleanParameter)param;
                    boolParam.setValue("true");
                }
                currentFolder.addFolder(instance);
            }
        }
        if (currentFolder.getName().equals("mdmDB") && instancesList.size() == 0 && currentFolder.getVisibility() && !currentFolder.getDisabled() && currentFolder.getOpaque() && javaVersion == null) {
            String sDataBaseClass = "DB2";
            String sFolderName = "Database";
            String sDataBaseValue = "bv";
            sDataBaseName = "name";
            sCredentialName = "user";
            sCredentialPass = "";
            sCredentialUser = "";
            lTP = currentFolder.getTParameters();
            tp = lTP.get(0);
            if ((tp == null || tp != null && !tp.getName().equals("database")) && CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("readOpaqueFolder: Could not set Credential for mdmDB element. tp null or not a database.");
            }
            dbFolder = currentFolder.addInstanceFolder(tp, sDataBaseClass, sFolderName, sFolderName);
            for (Parameter param : dbFolder.getParameters()) {
                if (null != param && param.getName().equals(sDataBaseName)) {
                    param.setValue(sDataBaseValue);
                    continue;
                }
                if (null == param || !param.getName().equals(sCredentialName)) continue;
                eCredentialValue = CredentialParameter.buildCredentials(sCredentialUser, sCredentialPass);
                if (eCredentialValue != null) {
                    ns = DocumentHelper.createNamespace((String)"", (String)"crn");
                    qnCred = DocumentHelper.createQName((String)"value", (Namespace)ns);
                    value_elem = DocumentHelper.createElement((QName)qnCred);
                    if (value_elem != null) {
                        value_elem.add(eCredentialValue);
                        bl = param.setValue(value_elem);
                        continue;
                    }
                    if (!CnfgLog.isDebugEnabled()) continue;
                    CnfgLog.debug("readOpaqueFolder: Could not set Credential for mdmDB element. value_elem is null.");
                    continue;
                }
                if (!CnfgLog.isDebugEnabled()) continue;
                CnfgLog.debug("readOpaqueFolder: Could not set Credential for mdmDB element. eCredentialValue is null.");
            }
        }
    }

    private static void readInstances(Element instancesElement, Folder currentFolder) {
        String instancesName;
        if (null != instancesElement && null != currentFolder && null != (instancesName = instancesElement.attributeValue("name"))) {
            List instanceList = instancesElement.elements(qnINSTANCE);
            Iterator instanceListIt = instanceList.iterator();
            while (instanceListIt.hasNext()) {
                Folder f;
                Element instanceElement = (Element)instanceListIt.next();
                if (null == instanceElement) continue;
                String instanceLabel = instanceElement.attributeValue("name");
                String instanceClass = instanceElement.attributeValue("class");
                if (instanceClass.compareToIgnoreCase("Derby") == 0) {
                    if (DataManager.getInstance().isInstalled("CCD")) {
                        if (instanceListIt.hasNext()) {
                            instanceListIt.next();
                        }
                    } else if (instanceListIt.hasNext() && null != (instanceElement = (Element)instanceListIt.next())) {
                        instanceLabel = instanceElement.attributeValue("name");
                        instanceClass = instanceElement.attributeValue("class");
                    }
                }
                if ((f = currentFolder.findFolder(instanceLabel, false)) != null) continue;
                String instancesDisabledAttr = instancesElement.attributeValue("disabled");
                boolean instancesDisabled = null != instancesDisabledAttr && instancesDisabledAttr.equalsIgnoreCase("true");
                instancesDisabledAttr = null;
                TemplatedParameter tp = currentFolder.findTParm(instancesName);
                if (tp == null) continue;
                if (instancesDisabled != tp.getDisabled()) {
                    DataManager.getInstance().setConfigDirtyFlag(true, tp.getRestartServicesList());
                }
                if (!tp.hasRoom(instanceClass)) continue;
                Folder newFolder = currentFolder.addInstanceFolder(tp, instanceClass, instanceLabel, instanceLabel);
                String instanceDisabledAttr = instanceElement.attributeValue("disabled");
                boolean instanceDisabled = null != instanceDisabledAttr && instanceDisabledAttr.equalsIgnoreCase("true");
                instanceDisabledAttr = null;
                if (instanceDisabled != newFolder.getDisabled()) {
                    DataManager.getInstance().setConfigDirtyFlag(true, tp.getRestartServicesList());
                }
                List parameterList = instanceElement.elements(qnPARAMETER);
                for (Element parameterElement : parameterList) {
                    String parameterName;
                    if (null == parameterElement || null == (parameterName = parameterElement.attributeValue("name"))) continue;
                    for (Parameter param : newFolder.getParameters()) {
                        Element valueElement;
                        if (null == param || !param.getName().equals(parameterName) || null == (valueElement = parameterElement.element(qnVALUE))) continue;
                        param.setValue(valueElement);
                    }
                }
                parameterList = null;
                List nestedInstancesList = instanceElement.elements("instances");
                for (Element nestedInstancesElement : nestedInstancesList) {
                    if (null == nestedInstancesElement) continue;
                    StartupProcessor.readInstances(nestedInstancesElement, newFolder);
                }
            }
        }
    }

    static {
        System.loadLibrary("cogconfig_jni");
        nsCRN = new Namespace("crn", "http://developer.cognos.com/schemas/crconfig/1/");
        qnPARAMETERS = new QName("parameters", nsCRN);
        qnPARAMETER = new QName("parameter", nsCRN);
        qnVALUE = new QName("value", nsCRN);
        qnINSTANCES = new QName("instances", nsCRN);
        qnINSTANCE = new QName("instance", nsCRN);
    }

    static class SystemFontsDirectoryFinder {
        SystemFontsDirectoryFinder() {
        }

        public static native String getSystemFontsDirectory();
    }
}

