/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Parameter;
import org.dom4j.Element;

public class StringParameter
extends Parameter {
    protected Integer m_inTotalLen;
    protected Integer m_inMnLen;
    protected Integer m_inMxLen;

    public StringParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        boolean bSuccess = super.load(parentFolder, elem);
        if (!bSuccess) {
            return false;
        }
        String sLength = elem.attributeValue("length", "");
        if (sLength.length() != 0) {
            this.m_inTotalLen = new Integer(sLength);
        } else {
            String sMaxLength;
            String sMinLength = elem.attributeValue("minLength", "");
            if (sMinLength.length() != 0) {
                this.m_inMnLen = new Integer(sMinLength);
            }
            if ((sMaxLength = elem.attributeValue("maxLength", "")).length() != 0) {
                this.m_inMxLen = new Integer(sMaxLength);
            }
            if (this.m_inMnLen != null && this.m_inMxLen != null && this.m_inMnLen.compareTo(this.m_inMxLen) > 0) {
                this.m_inMnLen = null;
                this.m_inMxLen = null;
            }
        }
        String sDefaultValue = elem.attributeValue("default", "");
        if (this.validate(sDefaultValue)) {
            this.m_defaultValue = this.m_values != null && this.m_values.size() > 0 && sDefaultValue.length() > 0 && !this.m_values.containsKey(sDefaultValue) ? this.m_values.keySet().toArray()[0] : sDefaultValue;
        } else {
            this.m_defaultValue = null;
            this.m_sBadValue = sDefaultValue;
        }
        return true;
    }

    @Override
    public boolean setValue(Object value) {
        this.clearErrorMsg();
        String sValue = value.toString();
        if (this.validate(sValue)) {
            this.m_currentValue = sValue;
            return super.setValue(value);
        }
        this.m_sBadValue = sValue;
        return false;
    }

    @Override
    public boolean validate(String value) {
        Object[] args;
        boolean bRetVal = true;
        if (this.m_inTotalLen != null && value.length() != this.m_inTotalLen.intValue()) {
            args = new Object[]{this.m_inTotalLen};
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.totalLength", args));
            bRetVal = false;
        }
        if (this.m_inMnLen != null && value.length() < this.m_inMnLen) {
            args = new Object[]{this.m_inMnLen};
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.minLength", args));
            bRetVal = false;
        }
        if (this.m_inMxLen != null && value.length() > this.m_inMxLen) {
            args = new Object[]{this.m_inMxLen};
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.maxLength", args));
            bRetVal = false;
        }
        if (bRetVal) {
            bRetVal = super.validate(value);
        }
        if (bRetVal) {
            if (!this.isMandatory() && value.length() == 0) {
                return true;
            }
            if (this.m_values != null) {
                if (this.m_values.containsKey(value)) {
                    return true;
                }
                bRetVal = false;
            }
        }
        return bRetVal;
    }

    @Override
    public boolean isDefault() {
        if (this.isEncrypted()) {
            return true;
        }
        return super.isDefault();
    }
}

