/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class SuperParameter {
    public static final String cnfg_env_prefix = "IBMCA_CNFG_";
    public static final String cnfg_envvar_prefix = "IBMCA_ENVVAR_";
    private static final String cnfg_env_name_ssl = "httpssl";
    private Map<String, String> m_envCnfgParms = new HashMap<String, String>();
    private static String httpProtocolPrefix = "http://";
    private Properties m_envVarsProperties = new Properties();
    static ArrayList<String> m_supportedCogstartupParms = new ArrayList();
    static ArrayList<String> m_supportedURLParms = new ArrayList();
    static ArrayList<String> m_supportedArrayParms = new ArrayList();
    static ArrayList<String> m_supportedSpecialParms = new ArrayList();

    public Properties getEnvVarsProperties() {
        return this.m_envVarsProperties;
    }

    public SuperParameter() {
        this.setup();
    }

    public void setup() {
        this.setCnfgParms();
        this.setHTTPPrefix();
    }

    public static ArrayList<String> getSupportedList() {
        ArrayList<String> list = new ArrayList<String>(m_supportedCogstartupParms.size() + m_supportedURLParms.size() + m_supportedArrayParms.size() + m_supportedSpecialParms.size());
        list.addAll(m_supportedCogstartupParms);
        list.addAll(m_supportedURLParms);
        list.addAll(m_supportedArrayParms);
        list.addAll(m_supportedSpecialParms);
        return list;
    }

    public Map<String, String> getEnvConfiguredParms() {
        return this.m_envCnfgParms;
    }

    public void setHTTPPrefix() {
        String sHttpProtocol = this.find(cnfg_env_name_ssl);
        if (sHttpProtocol != null && sHttpProtocol.equals("1")) {
            httpProtocolPrefix = "https://";
        }
    }

    public static boolean isURLParm(String parmName) {
        return m_supportedURLParms.contains(parmName);
    }

    public static boolean isArrayParm(String parmName) {
        return m_supportedArrayParms.contains(parmName);
    }

    private void setCnfgParms() {
        Map<String, String> enParms = this.getSystemEnv();
        if (enParms != null) {
            for (String key : enParms.keySet()) {
                if (key.startsWith(cnfg_env_prefix)) {
                    String mcfParmName = key.substring(cnfg_env_prefix.length());
                    if (!this.isSupported(mcfParmName)) continue;
                    this.m_envCnfgParms.put(mcfParmName, enParms.get(key).trim());
                    continue;
                }
                if (!key.startsWith(cnfg_envvar_prefix)) continue;
                String envVarName = key.substring(cnfg_envvar_prefix.length());
                this.addCBSEnvVar(envVarName, enParms.get(key).trim());
            }
        }
    }

    protected void addCBSEnvVar(String key, String value) {
        if (key != null && !key.isEmpty()) {
            this.m_envVarsProperties.put(key, value);
        }
    }

    protected Map<String, String> getSystemEnv() {
        return System.getenv();
    }

    private boolean isSupported(String key) {
        return SuperParameter.getSupportedList().contains(key);
    }

    public String find(String name) {
        String sRet = null;
        if (this.m_envCnfgParms.containsKey(name)) {
            sRet = this.m_envCnfgParms.get(name);
        }
        return sRet;
    }

    public Object getValue(String name, Object origValue) {
        if (!this.m_envCnfgParms.containsKey(name)) {
            return null;
        }
        String valueFromEnv = this.m_envCnfgParms.get(name);
        return this.getMCFValue(name, valueFromEnv, origValue);
    }

    private Object getMCFValue(String name, String valueFromEnv, Object origValue) {
        Object mcfValue = valueFromEnv;
        if (SuperParameter.isURLParm(name)) {
            mcfValue = this.getURLValue(valueFromEnv, origValue);
        } else if (SuperParameter.isArrayParm(name)) {
            mcfValue = this.getArrayValue(valueFromEnv, origValue);
        }
        return mcfValue;
    }

    private Object getURLValue(String valueFromEnv, Object origValue) {
        return SuperParameter.getURLFullPath(valueFromEnv, origValue);
    }

    private Object getArrayValue(String valueFromEnv, Object origValue) {
        ArrayList<Parameter> ret = new ArrayList<Parameter>();
        if (origValue != null) {
            String[] cmURIs;
            String origStr = origValue.toString();
            if (origStr.endsWith("...")) {
                origStr = origStr.substring(0, origStr.length() - 3);
            }
            for (String s : cmURIs = valueFromEnv.split(";")) {
                String fullURI = SuperParameter.getURLFullPath(s, origStr);
                if (fullURI == null) continue;
                Parameter p = DataManager.getInstance().createParameter(null, "xsd:anyURI", "xsd");
                p.setValue(fullURI);
                ret.add(p);
            }
        }
        return ret;
    }

    private static String getURLFullPath(String valueFromEnv, Object origValue) {
        int afterPort;
        int pos1;
        if (StringUtils.isBlank((String)valueFromEnv)) {
            return null;
        }
        valueFromEnv = valueFromEnv.trim();
        String sRet = null;
        if (origValue != null && (pos1 = (sRet = origValue.toString()).indexOf("//")) != -1 && (afterPort = sRet.substring(pos1 + 2).indexOf(47)) != -1) {
            StringBuffer buf = new StringBuffer(httpProtocolPrefix);
            buf.append(valueFromEnv);
            buf.append(sRet.substring(pos1 + 2 + afterPort));
            sRet = buf.toString();
        }
        return sRet;
    }

    static {
        m_supportedCogstartupParms.add("serverTimeZoneID");
        m_supportedCogstartupParms.add("serverLocale");
        m_supportedCogstartupParms.add("deploymentPath");
        m_supportedCogstartupParms.add("data");
        m_supportedCogstartupParms.add("temp");
        m_supportedCogstartupParms.add("encryptTemporaryFiles");
        m_supportedCogstartupParms.add("jmxPort");
        m_supportedCogstartupParms.add("rsvpExecutionMode");
        m_supportedCogstartupParms.add("hostName");
        m_supportedCogstartupParms.add("networkConfiguration");
        m_supportedCogstartupParms.add("gatewayNamespace");
        m_supportedCogstartupParms.add("configGroupName");
        m_supportedCogstartupParms.add("configGroupContactPort");
        m_supportedCogstartupParms.add("configGroupContactHost");
        m_supportedCogstartupParms.add("configGroupMemberSyncPort");
        m_supportedCogstartupParms.add("configGroupMemberCoordinationPort");
        m_supportedCogstartupParms.add("configGroupMemberHost");
        m_supportedCogstartupParms.add("webServiceHostName");
        m_supportedCogstartupParms.add("webServicePort");
        m_supportedCogstartupParms.add("enableWebServiceSSL");
        m_supportedCogstartupParms.add("sanDNSName");
        m_supportedCogstartupParms.add("sanIPAddress");
        m_supportedCogstartupParms.add("sanEmail");
        m_supportedURLParms.add("internalDispatcher");
        m_supportedURLParms.add("externalDispatcher");
        m_supportedURLParms.add("sdk");
        m_supportedURLParms.add("gateway");
        m_supportedArrayParms.add("contentManagers");
        m_supportedSpecialParms.add(cnfg_env_name_ssl);
    }
}

