/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.DataManagerException;
import com.cognos.crconfig.data.StringParameter;
import com.cognos.crconfig.data.crypto.ISystemProtectionSession;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SystemPasswordParameter
extends StringParameter {
    public SystemPasswordParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    public void write(Element value_elem, boolean bEncrypt, List errors) throws DataManagerException {
        if (this.m_currentValue == null && this.m_encryptedValue == null) {
            this.m_currentValue = "";
        }
        if (this.m_currentValue != null) {
            if (bEncrypt && !this.getDisabled()) {
                DataManager.getInstance().initializeCAMFactoryFromDisk();
                ISystemProtectionSession sps = DataManager.getInstance().getCryptoSystemSession();
                if (sps != null) {
                    String cr = this.m_currentValue.toString();
                    try {
                        byte[] utf8Buffer = cr.getBytes("UTF-8");
                        byte[] encryptedBuffer = sps.encryptData(utf8Buffer);
                        this.m_encryptedValue = sps.encode(encryptedBuffer);
                        this.m_currentValue = null;
                    }
                    catch (Throwable e) {
                        CnfgLog.error(e);
                        Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
                        if (errors != null) {
                            String sMessage = new StringBuffer(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args)).toString();
                            errors.add(sMessage);
                            bEncrypt = false;
                        }
                        String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args)).toString();
                        throw new DataManagerException(sMessage);
                    }
                } else {
                    bEncrypt = false;
                }
            }
        } else if (this.m_encryptedValue != null && !bEncrypt) {
            if (DataManager.getInstance().getDecryptCryptoPasswords()) {
                try {
                    DataManager.getInstance().initializeCAMFactoryFromDisk();
                    ISystemProtectionSession sps = DataManager.getInstance().getCryptoSystemSession();
                    byte[] decodedBuffer = sps.decode(this.m_encryptedValue);
                    byte[] sDecryptedValue = sps.decryptData(decodedBuffer);
                    String strXML = new String(sDecryptedValue, "UTF-8");
                    value_elem.setText(strXML);
                    return;
                }
                catch (Throwable e) {
                    CnfgLog.error(e);
                    this.m_sBadValue = new String();
                    Object[] args = new Object[]{this.getLabel(), this.getParent().getLabel()};
                    if (errors != null) {
                        String sMessage = new StringBuffer(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args)).toString();
                        errors.add(sMessage);
                        return;
                    }
                    String sMessage = new StringBuffer(CnfgResource.getMessage("Message.saveConfig.failed.notification")).append("\n").append(e.getLocalizedMessage()).append("\n").append(CnfgResource.getMessage("Message.errorOnSave.badvalue.resolution", args)).toString();
                    throw new DataManagerException(sMessage);
                }
            }
            bEncrypt = true;
        }
        super.write(value_elem, bEncrypt, errors);
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    public String getPart() {
        try {
            String sValue;
            Element temp_elem = DocumentHelper.createElement((String)"TEMP");
            ArrayList errors = new ArrayList();
            DataManager.getInstance().setDecryptCryptoPasswords(true);
            this.write(temp_elem, false, (List)errors);
            DataManager.getInstance().setDecryptCryptoPasswords(false);
            if (errors.size() == 0 && (sValue = temp_elem.getText()) != null) {
                return sValue;
            }
        }
        catch (DataManagerException e) {
            CnfgLog.error(e.getMessage());
            DataManager.getInstance().setDecryptCryptoPasswords(false);
        }
        catch (Throwable e) {
            CnfgLog.error(e.getMessage());
            DataManager.getInstance().setDecryptCryptoPasswords(false);
        }
        return null;
    }

    @Override
    public boolean isEqual(Object value) {
        String originalValue = null;
        if (this.m_encryptedValue != null) {
            originalValue = this.getPart();
            if (originalValue != null && String.class.isInstance(value)) {
                return value.equals(originalValue.toString());
            }
        } else {
            return super.isEqual(value);
        }
        return false;
    }
}

