/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.CnfgActionCustomSave;
import com.cognos.crconfig.data.CnfgActionExternalProcess;
import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.CnfgActionTest;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.Option;
import com.cognos.crconfig.data.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class TemplatedParameter
extends Parameter
implements Cloneable {
    Parameter m_parameter;
    String m_sServiceName;
    boolean m_bUnregisterOnDelete;
    String m_sServiceType;
    private List<Option> m_lOptions = new ArrayList<Option>();

    @Override
    public boolean getDisabled() {
        return null != this.m_parameter ? this.m_parameter.getDisabled() : false;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (null != this.m_parameter) {
            this.m_parameter.setDisabled(disabled);
        }
    }

    @Override
    public void setVisibility(boolean visibility) {
        if (null != this.m_parameter) {
            this.m_parameter.setVisibility(visibility);
        }
    }

    @Override
    public boolean getVisibility() {
        return null != this.m_parameter ? this.m_parameter.getVisibility() : true;
    }

    public TemplatedParameter(Parameter p) {
        this.m_parameter = p;
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        this.m_parentFolder = parentFolder;
        this.m_sServiceName = elem.attributeValue("service", "");
        this.m_sServiceType = elem.attributeValue("serviceType", "");
        String unregOnDelete = elem.attributeValue("unregisterOnDelete", "");
        this.m_bUnregisterOnDelete = Boolean.parseBoolean(unregOnDelete);
        List actionElems = elem.elements("action");
        for (int i = 0; i < actionElems.size(); ++i) {
            Element actionElem = (Element)actionElems.get(i);
            CnfgActionOld action = null;
            String sType = actionElem.attributeValue("type", "externalprocess");
            String sDepends = actionElem.attributeValue("dependency", "");
            if (DataManager.getInstance().isInstalled(sDepends)) {
                if (sType.compareToIgnoreCase("externalprocess") == 0) {
                    action = new CnfgActionExternalProcess();
                    ((CnfgActionOld)action).load(actionElem);
                } else {
                    if (sType.compareToIgnoreCase("cnfg") != 0) continue;
                    String sName = actionElem.attributeValue("name");
                    action = DataManager.getInstance().getBuiltinAction(sName, actionElem);
                }
            }
            if (action == null) continue;
            this.m_lActions.add(action);
        }
        List lOptionElems = elem.elements("option");
        for (int i = 0; i < lOptionElems.size(); ++i) {
            Option option = new Option();
            Element option_elem = (Element)lOptionElems.get(i);
            if (!option.load(this.m_parentFolder, option_elem)) continue;
            this.m_lOptions.add(option);
        }
        return true;
    }

    @Override
    public String getLabel() {
        return this.m_parameter.getLabel();
    }

    public String getFormattedLabel() {
        return CnfgResource.getMessage("Label.Type");
    }

    @Override
    public String getDisplayValue() {
        Option option;
        Object oValue = this.m_parameter.getValue();
        if (oValue != null && (option = this.getOption(oValue.toString())) != null) {
            return option.getLabel();
        }
        return null;
    }

    public Parameter getParameter() {
        return this.m_parameter;
    }

    @Override
    public Object getValue() {
        return this.m_parameter.getValue();
    }

    @Override
    public boolean hasDefault() {
        return false;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public void setToDefault() {
    }

    @Override
    public boolean setValue(Object value) {
        return this.m_parameter.setValue(value);
    }

    @Override
    public boolean validate(String value) {
        return this.m_parameter.validate(value);
    }

    @Override
    public String getDesc() {
        return this.m_parameter.m_sDesc;
    }

    @Override
    public String getHelp() {
        return this.m_parameter.m_sHelp;
    }

    @Override
    public String getName() {
        return this.m_parameter.getName();
    }

    @Override
    public boolean isEncrypted() {
        return this.m_parameter.isEncrypted();
    }

    @Override
    public boolean isEqual(Object value) {
        return false;
    }

    @Override
    public boolean isMandatory() {
        return this.m_parameter.isMandatory();
    }

    @Override
    public String toString() {
        return this.m_parameter.getLabel();
    }

    @Override
    public Object clone() {
        Object obj = super.clone();
        this.m_parameter = (Parameter)this.m_parameter.clone();
        return obj;
    }

    public List<Parameter> cloneParms(String sOptionValue) {
        ArrayList<Parameter> al = new ArrayList<Parameter>();
        if (sOptionValue != null) {
            TemplatedParameter me = (TemplatedParameter)this.clone();
            me.setReadOnly(true);
            me.setValue(sOptionValue);
            al.add(me);
            for (int i = 0; i < this.m_lOptions.size(); ++i) {
                Option opt = this.m_lOptions.get(i);
                if (!opt.getName().equals(sOptionValue)) continue;
                List<Parameter> optParms = opt.getParameters();
                for (int j = 0; j < optParms.size(); ++j) {
                    Parameter p = optParms.get(j);
                    Parameter newP = (Parameter)p.clone();
                    al.add(newP);
                }
            }
        }
        return al;
    }

    public Option getOption(String sOptionValue) {
        if (sOptionValue != null) {
            for (int i = 0; i < this.m_lOptions.size(); ++i) {
                Option opt = this.m_lOptions.get(i);
                if (!opt.getName().equals(sOptionValue)) continue;
                return opt;
            }
        }
        return null;
    }

    public boolean hasRoom(String sInstanceType) {
        if (sInstanceType != null) {
            List<Option> al = this.getAvailableOptions(false);
            for (int i = 0; i < al.size(); ++i) {
                Option option = al.get(i);
                if (!option.getName().equals(sInstanceType)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Option> getAvailableOptions(boolean excludeDisabled) {
        ArrayList<Option> al = new ArrayList<Option>();
        Folder parentFolder = this.getParent();
        HashMap<Option, Integer> currentCountByOption = new HashMap<Option, Integer>();
        int totalCount = 0;
        for (Option option : this.m_lOptions) {
            if (null == option || excludeDisabled && (option.getDisabled() || !option.getVisibility())) continue;
            Integer currentCount = parentFolder.numInstanceFolders(option.getName());
            currentCountByOption.put(option, currentCount);
            totalCount += currentCount.intValue();
        }
        Integer parmMxO = this.m_parameter.getMaxOccurs();
        if (parmMxO != -1 && totalCount >= parmMxO) {
            return al;
        }
        Set s = currentCountByOption.keySet();
        for (Option opt : s) {
            Integer optionMax = opt.getMaxOccurs();
            if (optionMax == -1) {
                al.add(opt);
                continue;
            }
            Integer currCount = (Integer)currentCountByOption.get(opt);
            if (optionMax <= currCount) continue;
            al.add(opt);
        }
        return al;
    }

    public List<Option> getOptions() {
        return this.m_lOptions;
    }

    public final List<CnfgActionTest> getTestActions(String refID) {
        ArrayList<CnfgActionTest> tests = new ArrayList<CnfgActionTest>();
        for (Option element : this.m_lOptions) {
            tests.addAll(element.getTestActions(refID));
        }
        return tests;
    }

    public final List<CnfgActionCustomSave> getCustomSaveActions(String refID) {
        ArrayList<CnfgActionCustomSave> saveActions = new ArrayList<CnfgActionCustomSave>();
        for (Option element : this.m_lOptions) {
            saveActions.addAll(element.getCustomSaveActions(refID));
        }
        return saveActions;
    }

    public String getServiceType() {
        return this.m_sServiceType != null ? this.m_sServiceType : "";
    }

    public boolean isServiceFolder(Option option) {
        boolean bIsService = false;
        if (this.m_sServiceName != null && this.m_sServiceName.length() > 0 && this.getOptions().contains(option)) {
            boolean bFoundStart = false;
            boolean bFoundStop = false;
            boolean bFoundIsRunning = false;
            ArrayList<CnfgActionOld> actions = option.getActions();
            for (CnfgActionOld action : actions) {
                if (action.getName().equalsIgnoreCase("start")) {
                    bFoundStart = true;
                    continue;
                }
                if (action.getName().equalsIgnoreCase("stop")) {
                    bFoundStop = true;
                    continue;
                }
                if (!action.getName().equalsIgnoreCase("isRunning")) continue;
                bFoundIsRunning = true;
            }
            bIsService = bFoundStart && bFoundStop && bFoundIsRunning;
        }
        return bIsService;
    }

    public String getServiceName() {
        return this.m_sServiceName;
    }

    public boolean getUnregisterOnDelete() {
        return this.m_bUnregisterOnDelete;
    }
}

