/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.StringParameter;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimeZoneParameter
extends StringParameter {
    public TimeZoneParameter(String namespace, String dataType) {
        super(namespace, dataType);
        this.loadTimeZones();
    }

    @Override
    public boolean validate(String sValue) {
        boolean bRetVal = super.validate(sValue);
        if (!bRetVal) {
            return bRetVal;
        }
        if (!this.isMandatory() && sValue.length() == 0) {
            return true;
        }
        if (this.m_values != null && this.m_values.containsKey(sValue)) {
            return true;
        }
        this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.notInList"));
        return false;
    }

    private boolean loadTimeZones() {
        try {
            this.m_values = this.getTimeZones(CnfgResource.getLocale().toString());
        }
        catch (Exception e) {
            CnfgLog.error(e);
            return false;
        }
        return true;
    }

    protected Map<String, String> getTimeZones(String localeId) throws Exception {
        ULocale locale = new ULocale(localeId);
        ArrayList<TimeZone> tzList = this.getCanonicalTimeZones();
        int size = tzList.size();
        HashMap<String, String> timezoneMap = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            TimeZone tz = tzList.get(i);
            if (tz == null) continue;
            timezoneMap.put(tz.getID(), this.getTimeZoneDisplayName(tz, locale));
        }
        return timezoneMap;
    }

    private String getTimeZoneDisplayName(TimeZone tz, ULocale locale) {
        return "(" + tz.getDisplayName(false, 5, locale) + ") " + tz.getDisplayName(false, 7, locale);
    }

    private void sortTimeZoneListByOffset(List<TimeZone> tzList) throws Exception {
        try {
            Collections.sort(tzList, new Comparator<TimeZone>(){

                @Override
                public int compare(TimeZone tz1, TimeZone tz2) {
                    int offset2;
                    int offset1 = tz1.getRawOffset();
                    if (offset1 > (offset2 = tz2.getRawOffset())) {
                        return 1;
                    }
                    if (offset1 < offset2) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        catch (Exception e) {
            CnfgLog.error("Unable to sort time zone list.");
            throw e;
        }
    }

    private ArrayList<TimeZone> getCanonicalTimeZones() throws Exception {
        Set idlist = TimeZone.getAvailableIDs((TimeZone.SystemTimeZoneType)TimeZone.SystemTimeZoneType.CANONICAL, null, null);
        ArrayList<TimeZone> tzList = new ArrayList<TimeZone>();
        for (String id : idlist) {
            String region;
            TimeZone tz = TimeZone.getTimeZone((String)id);
            if (tz == null || (region = TimeZone.getRegion((String)tz.getID())) == null || region.equals("001")) continue;
            tzList.add(tz);
        }
        this.sortTimeZoneListByOffset(tzList);
        return tzList;
    }
}

