/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.CnfgLog;
import com.cognos.crconfig.CnfgResource;
import com.cognos.crconfig.data.Folder;
import com.cognos.crconfig.data.StringParameter;
import org.dom4j.Element;

public class URLParameter
extends StringParameter {
    protected static final String HTTP = "http";
    protected static final String HTTPS = "https";
    String m_sPath;

    public URLParameter(String namespace, String dataType) {
        super(namespace, dataType);
    }

    @Override
    public boolean load(Folder parentFolder, Element elem) {
        boolean bSuccess = super.load(parentFolder, elem);
        if (!bSuccess) {
            return false;
        }
        this.m_sPath = elem.attributeValue("path");
        if (!URLParameter.validateRest(this.m_sPath, this.isPathRequired())) {
            this.m_sPath = null;
        }
        return true;
    }

    protected boolean isPathRequired() {
        return false;
    }

    protected boolean isPortRequired() {
        return true;
    }

    @Override
    public boolean validate(String sValue) {
        String sServer;
        if (!super.validate(sValue)) {
            return false;
        }
        boolean bSkipPortChecking = false;
        if (!this.isMandatory() && sValue.length() == 0) {
            return true;
        }
        String sContextErrMsg = null;
        if (this.m_sPath != null) {
            Object[] args = new Object[]{this.m_sPath};
            sContextErrMsg = CnfgResource.getMessage("Message.errorOnValidation.url2", args);
        } else {
            sContextErrMsg = CnfgResource.getMessage("Message.errorOnValidation.url");
        }
        int nextIdx = sValue.indexOf("://");
        if (nextIdx == -1) {
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.specifierMissing"));
            this.addErrorMsg(sContextErrMsg);
            return false;
        }
        String sProtocol = sValue.substring(0, nextIdx);
        if (sProtocol.compareTo(HTTP) != 0 && sProtocol.compareTo(HTTPS) != 0) {
            Object[] args = new Object[]{sProtocol};
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.protocol", args));
            this.addErrorMsg(sContextErrMsg);
            return false;
        }
        boolean isIPv6 = sValue.charAt(nextIdx += 3) == '[';
        int endIdx = sValue.length();
        if (isIPv6) {
            endIdx = sValue.indexOf("]", nextIdx);
            if (endIdx == -1) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.portMissing"));
                this.addErrorMsg(sContextErrMsg);
                return false;
            }
            ++endIdx;
            endIdx = sValue.indexOf(":", endIdx);
        } else {
            endIdx = sValue.indexOf(":", nextIdx);
        }
        if (endIdx == -1) {
            if (this.isPortRequired()) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.portMissing"));
                this.addErrorMsg(sContextErrMsg);
                return false;
            }
            int pathSep = sValue.indexOf("/", nextIdx);
            endIdx = pathSep == -1 ? sValue.length() : pathSep;
            bSkipPortChecking = true;
        }
        if (!URLParameter.validateServer(sServer = sValue.substring(nextIdx, endIdx))) {
            Object[] args = new Object[]{sServer};
            this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.server", args));
            this.addErrorMsg(sContextErrMsg);
            return false;
        }
        nextIdx = !bSkipPortChecking ? (nextIdx += sServer.length() + 1) : endIdx;
        int separatorIdx = sValue.indexOf("/", nextIdx);
        if (separatorIdx == -1) {
            if (this.isPathRequired()) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.path"));
                this.addErrorMsg(sContextErrMsg);
                return false;
            }
            separatorIdx = sValue.length();
        }
        if (!bSkipPortChecking) {
            String sPort = sValue.substring(nextIdx, separatorIdx);
            if (!URLParameter.validatePort(sPort)) {
                Object[] args = new Object[]{sPort};
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.portInvalid", args));
                this.addErrorMsg(sContextErrMsg);
                if (CnfgLog.isDebugEnabled() && !this.getName().equals("returnUrl")) {
                    CnfgLog.debug("URLParameter::validate(" + sValue + ") for parameter '" + this.getName() + "' , the port '" + sPort + "' is not valid.");
                }
                return false;
            }
            nextIdx += sPort.length() + 1;
        }
        if (this.m_sPath != null) {
            separatorIdx = sValue.indexOf("/", nextIdx);
            if (separatorIdx == -1) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.contextroot"));
                this.addErrorMsg(sContextErrMsg);
                return false;
            }
            String sContextRoot = sValue.substring(nextIdx, separatorIdx);
            if (!URLParameter.validateRest(sContextRoot, this.isPathRequired())) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.contextroot2"));
                this.addErrorMsg(sContextErrMsg);
                return false;
            }
            String sPath = sValue.substring(nextIdx += sContextRoot.length() + 1, sValue.length());
            if (!this.m_sPath.equals(sPath)) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.path"));
                this.addErrorMsg(sContextErrMsg);
                return false;
            }
        } else {
            String sRest = null;
            sRest = nextIdx >= sValue.length() ? "" : sValue.substring(nextIdx, sValue.length());
            if (!URLParameter.validateRest(sRest, this.isPathRequired())) {
                this.addErrorMsg(CnfgResource.getMessage("Message.errorOnValidation.url.path"));
                this.addErrorMsg(sContextErrMsg);
                return false;
            }
        }
        return true;
    }

    public static boolean validateServer(String sServer) {
        if (sServer == null || sServer.length() == 0) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateServer(" + sServer + "), length is invalid.");
            }
            return false;
        }
        int iNumOfSection = 0;
        int iNumOfDigSection = 0;
        boolean bIsLastValid = false;
        int ipTotal = 0;
        int startIdx = 0;
        int zoneIdx = -1;
        boolean isIPv6 = sServer.charAt(0) == '[';
        String ipGroupSeparator = null;
        String ipZoneSeparator = null;
        int iMaxNumOfSections = 0;
        int iMinNumOfSections = 0;
        if (isIPv6) {
            ipGroupSeparator = ":";
            ipZoneSeparator = "%";
            iMaxNumOfSections = 9;
            iMinNumOfSections = 3;
            ++startIdx;
        } else {
            ipGroupSeparator = ".";
            iMaxNumOfSections = 4;
            iMinNumOfSections = 4;
        }
        int endIdx = sServer.indexOf(ipGroupSeparator, startIdx);
        if (!isIPv6) {
            boolean isHostname = false;
            if (endIdx >= 0) {
                isHostname = URLParameter.isHostname(sServer.substring(startIdx, endIdx));
            }
            if (endIdx == -1 || isHostname) {
                if (endIdx == -1) {
                    endIdx = sServer.length();
                }
                return URLParameter.validateDomainLabel(sServer.substring(startIdx, endIdx));
            }
        }
        if (isIPv6) {
            zoneIdx = sServer.indexOf(ipZoneSeparator, startIdx);
        }
        while (true) {
            int dottedValue = -1;
            if (isIPv6) {
                if (sServer.length() == endIdx) {
                    if (sServer.indexOf(46, startIdx) > 0) {
                        if (!URLParameter.validateServer(sServer.substring(startIdx, endIdx - 1))) {
                            return false;
                        }
                        dottedValue = 1;
                    } else if (zoneIdx == -1) {
                        dottedValue = startIdx == endIdx - 1 ? 0 : URLParameter.validateIPv6Decimal(sServer.substring(startIdx, endIdx - 1));
                    } else if (zoneIdx < endIdx - 2) {
                        dottedValue = 0;
                    } else if (CnfgLog.isDebugEnabled()) {
                        CnfgLog.debug("Zone id separator found but no zone id.");
                        return false;
                    }
                } else {
                    dottedValue = startIdx == endIdx || endIdx < 0 ? 0 : URLParameter.validateIPv6Decimal(sServer.substring(startIdx, endIdx));
                }
            } else {
                dottedValue = URLParameter.validateIPv4Decimal(sServer.substring(startIdx, endIdx));
            }
            if (dottedValue == -1) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug(sServer.substring(startIdx, endIdx) + " is not a valid IP dotted pair (0-255).  Continue processing.");
                }
                if (endIdx == sServer.length() || endIdx == sServer.length() - 1) {
                    if (!URLParameter.validateLabel(sServer.substring(startIdx, endIdx))) {
                        return false;
                    }
                    bIsLastValid = true;
                } else if (!URLParameter.validateDomainLabel(sServer.substring(startIdx, endIdx))) {
                    return false;
                }
            } else {
                ++iNumOfDigSection;
                ipTotal += dottedValue;
                bIsLastValid = false;
            }
            ++iNumOfSection;
            if (endIdx == sServer.length()) break;
            if (endIdx + 1 == sServer.length() && !isIPv6) {
                ++iNumOfSection;
                break;
            }
            startIdx = endIdx + 1;
            if ((endIdx = sServer.indexOf(ipGroupSeparator, startIdx)) == -1 && isIPv6) {
                endIdx = sServer.indexOf(ipZoneSeparator, startIdx);
            }
            if (endIdx != -1) continue;
            endIdx = sServer.length();
        }
        if (iNumOfSection <= iMaxNumOfSections && iNumOfSection >= iMinNumOfSections && iNumOfSection == iNumOfDigSection && ipTotal > 0) {
            return true;
        }
        if (!bIsLastValid) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("this is a hostname, but the last section is not a <toplabel>, i.e. start with letter");
            }
            return false;
        }
        return true;
    }

    private static boolean isHostname(String serverName) {
        for (int charIndex = 0; charIndex < serverName.length(); ++charIndex) {
            if (charIndex <= 3 && Character.isDigit(serverName.charAt(charIndex))) continue;
            return true;
        }
        return false;
    }

    private static boolean validateDomainLabel(String sValue) {
        if (sValue == null || sValue.length() < 1 || sValue.length() > 255) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateDomainLabel(" + sValue + "), a label's length must be between 1 - 255");
            }
            return false;
        }
        int iLength = sValue.length();
        for (int i = 0; i < iLength; ++i) {
            char c = sValue.charAt(i);
            if (i == 0 || i == iLength - 1) {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("URLParameter::validateDomainLabel(" + sValue + "), '" + c + "' is not a <let-dig>.");
                }
                return false;
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateDomainLabel(" + sValue + "), '" + c + "' is not a <let-dig-hyp-und>.");
            }
            return false;
        }
        return true;
    }

    private static boolean validateLabel(String sValue) {
        if (sValue == null || sValue.length() < 1 || sValue.length() > 255) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateLabel(" + sValue + "), a label's length must be between 1 - 255");
            }
            return false;
        }
        int iLength = sValue.length();
        for (int i = 0; i < iLength; ++i) {
            char c = sValue.charAt(i);
            if (i == 0) {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("URLParameter::validateLabel(" + sValue + "), '" + c + "' is not a <letter>.");
                }
                return false;
            }
            if (i == iLength - 1) {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("URLParameter::validateLabel(" + sValue + "), '" + c + "' is not a <let-dig>.");
                }
                return false;
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateLabel(" + sValue + "), '" + c + "' is not a <let-dig>.");
            }
            return false;
        }
        return true;
    }

    private static short validateIPv4Decimal(String sValue) {
        Short nValue;
        if (sValue == null || sValue.length() < 1) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateIPv4Decimal(" + sValue + "), length is invalid.");
            }
            return -1;
        }
        try {
            nValue = new Short(sValue);
            if (nValue < 0 || nValue > 255) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("URLParameter::validateIPv4Decimal(" + sValue + "), '" + nValue + "' is not a <0-255>.");
                }
                return -1;
            }
        }
        catch (NumberFormatException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateIPv4Decimal(" + sValue + "), '" + sValue + "' is not a numerical value");
                CnfgLog.debug(e);
            }
            return -1;
        }
        return nValue;
    }

    private static int validateIPv6Decimal(String sValue) {
        Integer nValue;
        if (sValue == null || sValue.length() < 1) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateIPv6Decimal(" + sValue + "), length is invalid.");
            }
            return -1;
        }
        try {
            nValue = Integer.decode("0x" + sValue);
            if (nValue < 0 || nValue > 65535) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("URLParameter::validateIPv6Decimal(" + sValue + "), '" + nValue + "' is not a <0-ffff>.");
                }
                return -1;
            }
        }
        catch (NumberFormatException e) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateIPv6Decimal(" + sValue + "), '" + sValue + "' is not a numerical value");
                CnfgLog.debug(e);
            }
            return -1;
        }
        return nValue;
    }

    public static boolean validatePort(String sPort) {
        if (sPort == null || sPort.length() < 1) {
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validatePort(" + sPort + "), length is invalid.");
            }
            return false;
        }
        try {
            Integer iPort = new Integer(sPort);
            if (iPort < 1 || iPort > 65535) {
                if (CnfgLog.isDebugEnabled()) {
                    CnfgLog.debug("URLParameter::validatePort(" + sPort + "), '" + iPort + "' is not a <1-65535>.");
                }
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean validateRest(String value) {
        return URLParameter.validateRest(value, true);
    }

    public static boolean validateRest(String sValue, boolean pathRequired) {
        if (sValue == null || sValue.isEmpty() && pathRequired) {
            return false;
        }
        int iLength = sValue.length();
        for (int i = 0; i < iLength; ++i) {
            char c = sValue.charAt(i);
            if (c >= '!' && c <= '~') continue;
            if (CnfgLog.isDebugEnabled()) {
                CnfgLog.debug("URLParameter::validateRest(" + sValue + "), '" + c + "', empty, spaces and non-ascii chars is invalid.");
            }
            return false;
        }
        return true;
    }
}

