/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.crconfig.data;

import com.cognos.crconfig.data.CnfgActionOld;
import com.cognos.crconfig.data.DataManager;
import com.cognos.crconfig.data.Option;
import com.cognos.crconfig.data.Parameter;
import com.cognos.crconfig.data.TemplatedParameter;
import com.cognos.crconfig.data.WizardPageData;
import com.cognos.crconfig.data.WizardTemplatedParameterData;
import java.util.ArrayList;
import org.dom4j.Element;

public class WizardActionTarget {
    private String m_sType;
    private String m_sActionName;
    private String m_sComplexPageName;
    private String m_sGroupName;
    private String m_sPageName;
    private String m_sTemplatedParameterName;
    private String m_sOptionValue;
    private String m_sSectionName;
    private Element m_actionElem;

    public WizardActionTarget(Element elem, boolean isAction) {
        if (isAction) {
            this.m_actionElem = elem;
            this.m_sType = elem.attributeValue("type", "");
            this.m_sActionName = elem.attributeValue("name", "");
        } else {
            this.m_sType = elem.attributeValue("type", "");
            this.m_sComplexPageName = elem.attributeValue("complexPage", "");
            this.m_sGroupName = elem.attributeValue("group", "");
            this.m_sPageName = elem.attributeValue("page", "");
            this.m_sTemplatedParameterName = elem.attributeValue("templParam", "");
            this.m_sOptionValue = elem.attributeValue("option", "");
            this.m_sSectionName = elem.attributeValue("section", "");
        }
    }

    public void findActionTargets(ArrayList targetList, ArrayList targetOptionList) {
        CnfgActionOld action;
        if (this.m_sType.equals("wizard")) {
            if (this.m_sTemplatedParameterName.length() == 0) {
                return;
            }
            WizardPageData wPage = DataManager.getInstance().findWizardPage(this.m_sComplexPageName, this.m_sGroupName, this.m_sPageName);
            if (wPage != null) {
                ArrayList tParamList = wPage.getWizardTParamList();
                for (int i = 0; i < tParamList.size(); ++i) {
                    TemplatedParameter tParam;
                    WizardTemplatedParameterData tp = (WizardTemplatedParameterData)tParamList.get(i);
                    Parameter param = tp.getParam();
                    if (param == null || !TemplatedParameter.class.isInstance(param) || (tParam = (TemplatedParameter)param).getParameter() == null || !tParam.getParameter().getName().equals(this.m_sTemplatedParameterName)) continue;
                    this.addActionTarget(targetList, targetOptionList, tp.getInstancesList(), tParam);
                    this.addActionTarget(targetList, targetOptionList, tp.getNewInstancesList(), tParam);
                }
            }
        } else if (this.m_sType.equals("cnfg") && this.m_sActionName != null && this.m_sActionName.length() > 0 && (action = DataManager.getInstance().getBuiltinAction(this.m_sActionName, this.m_actionElem)) != null) {
            targetList.add(action);
        }
    }

    private void addActionTarget(ArrayList targetList, ArrayList targetOptionList, ArrayList instList, TemplatedParameter param) {
        for (int i = 0; i < instList.size(); ++i) {
            Option op;
            WizardPageData wp = (WizardPageData)instList.get(i);
            if (this.m_sOptionValue.length() != 0) {
                if (!wp.getInstType().equals(this.m_sOptionValue) || (op = param.getOption(this.m_sOptionValue)) == null) continue;
                targetOptionList.add(op);
                targetList.add(wp);
                continue;
            }
            op = param.getOption(wp.getInstType());
            if (op == null) continue;
            targetOptionList.add(op);
            targetList.add(wp);
        }
    }
}

